$(document).ready(function () {
    $('#slcProveedor').select2();

    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});

    $(".soloNumeros").attr("extras",".");
    $(".number").numeric();
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".txtFechas").mask("99-99-9999");

    $(".number").keypress(function(event){
        var text = $(this).val();
        if ((text.indexOf('.') != -1) && (text.substring(text.indexOf('.')).length > 2) && (event.which != 0 && event.which != 8) &&   ($(this)[0].selectionStart >= text.length - 2)) {
            event.preventDefault();
        }
    });
    
    //Validacion del formulario
    $("#form_agregar_registros").validate({
        ignore: "",
        rules: {
            txtCodigo: {required: true},
            txtFecha_inicio: {required: true},
            txtSaldo_inicial: {required:true},
           
            txtFecha_fin: {required:true},
            txtCuota_mensual: {required:true},
            slc_servicio: {required:true,min:1},
            slcProveedor: {required:true,min:1}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html('Campo requerido');
            //verificarfecha(txtFecha_inicio,txtFecha_fin);
        },
        submitHandler: function (form){
            if ( !validarPeriodo($("#txtFecha_inicio").val(), $("#txtFecha_fin").val()) ) {
                crear_alerta('error', 'Contrato por proveedor.', 'Verifique el período de las fechas.');
                $("#tab_general").addClass("clasecss");
                $("#tab_general").trigger('click');
		        $("#toTopHover").trigger("click");
                $("#txtFecha_fin").addClass('error');
                $("#txtFecha_fin_error").text("Verifique las fechas del período");
                return false;
            }

            if ( $("#codigo").val() == 1 ){
                $("#txtCodigo").focus();
                crear_alerta('error', 'Contrato por proveedor.', 'Código esta repetido.');      
                return false;
            }

            form.submit();
        }
    });

    $(".btn-success").click(function(){
         event.preventDefault();
         $("#btnGuardar").val($(this).val());
         get_codigo_contrato( $("#txtCodigo").val() );
    });

    function get_codigo_contrato(codigoNew){
         $.ajax({
            url: urlj + 'modulo_compras/procesos/get_codigo_contrato',
            data:{codigoNew:codigoNew},
            type: 'POST',
            dataType: 'json',
            success: function(data){
                if ( data == null ){
                    $("#codigo").val("0");    
                    $( "#form_agregar_registros" ).submit();    
                } else {
                    $("#codigo").val("1");
                    crear_alerta('error', 'Contrato por proveedor.', 'Código esta repetido.');
                    $("#txtCodigo").val(""); 
                    $("#txtCodigo").focus();      
                    $( "#form_editar_registros" ).submit();     
                }
            }
        });    
    }


});

$("#slc_servicio").select2({
          placeholder:'Buscar servicio',
          minimumInputLength: 3,
          ajax: {
              url:urlj+'modulo_compras/procesos/consultar_articulos/servicio',
              dataType: 'json',
              type: 'POST',
              delay: 250,
              data: function (articulo) {
                return {
                    articulo: articulo
                };
              },
              results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.art_id,
                        'text': item.art_nombre
                    });
                });
                return {
                    results: myResults
                };	
            } 
            
          }
});  




//////////////////////////////////////////////////
//Subir archivo 
/////////////////////////////////////////////////
//Anexo por documento
   //Carpeta de Anexos
    var anx = 0;
    var folder_anx_temp= 'anexo_contrato';
    var ruta_anx = urlj+'inicio/guardar_gral/'+folder_anx_temp; 
    new FUload('btnAnexo', ruta_anx, {
        start: function (file) {
            wait.start();
        },
        sucess: function (data) {
            wait.close();

            if ($.trim(data) !== "") {

                var a_exten = $.trim(data).split('.');

                var exten = "." + a_exten[(a_exten.length - 1)];
                // verifica existencia del mismo documento en la carpeta.
                var preview = "<tr id='preview" + anx + "' style='display:none;' class='preview_documento'>";
                if (a_exten[(a_exten.length - 1)] === 'png' || a_exten[(a_exten.length - 1)] === 'jpg' || a_exten[(a_exten.length - 1)] === 'jpeg' || a_exten[(a_exten.length - 1)] === 'pdf') {
                    preview += "<td><a  title=\"Ver Anexo\" class='ver_en_modal fancybox-buttons' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                } else {
                    preview += "<td><a target='_blank' title=\"Ver Anexo\" class='' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                }

                preview += "<img id='pre" + anx + "' src='' width='88' height='88' class='imagen_documento'></a></td>";
                preview += "<td><input maxlength='75' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc[]' value='" + $.trim(data).replace(exten, '') + "'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc" + anx + "'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                //preview+="<td><input maxlength='50' readonly='readonly' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc"+i+"' value='"+$.trim(data).replace(exten,'')+"'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc"+i+"'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                preview += "<td style='vertical-align:middle !important; width:30px !important;'><img  style='display:none;' src='" + urlj + "media/editar_documento.png" + "' title='Editar' value='titulo_doc" + anx + "' class='editar_documento'/></td>";
                preview += "<td style='background:#E1E7F0!important;'><a href=\"javascript: void(0);\" title=\"Eliminar Anexo\" class='eliminar_imagen' id='delete" + anx + "' custom='' custom_id=''><img class='quitar_documento' src='" + urlj + "media/eliminar_documento.png" + "' title='Eliminar documento'></a></div>";
                preview += "<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></td></tr>";

                $("#previews").append(preview).show(300);
                $("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></div>");
                $("#preview" + anx).fadeIn(400);

                //document.getElementById('pre'+i).src=base+"media/imagenes/sistema/pdf.png";
                document.getElementById('pre' + anx).src = urlj + "media/imagenes/sistema/" + a_exten[(a_exten.length - 1)] + ".png";
                document.getElementById('ruta' + anx).value = $.trim(data);
                document.getElementById('delete' + anx).custom = $.trim(data);
                document.getElementById('delete' + anx).custom_id = i;
                valor = document.getElementById('pre' + anx).src;

                // $('input[name=titulo_doc'+i+']').focus();
                // nombre_doc=$('input[name=titulo_doc'+i+']').val();

                anx++;
                $(".eliminar_imagen, .verAnexo").tooltip();
            } else { //el formato es incorrecto
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });
    
    $(".eliminar_imagen").live("click", function (event) {
        event.preventDefault();

        url = this.custom;
        id_key = this.custom_id;
        id = this.id;
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/' + folder_anx_temp,
            data: {url: url},
            success: function (data) {
                $("#ruta" + id_key).val("");
                $("#" + id).parent().parent().remove().delay(300);
            }
        });
    });

    
    $('#boton_siguiente').live('click',function(event){
	    event.preventDefault();
        if (!(validar_tabs(1)) ){
            $("#tab_anexos").trigger('click');
		}
	});

    $('#boton_atras').live('click',function(event){
	    event.preventDefault();
        if (!(validar_tabs(0)) ){
            $("#tab_general").trigger('click');
		}
	});

    function validar_tabs(regresar){
        if ($('#txtCodigo').val() == '' || $('#txtFecha_inicio').val() == '' || $('#txtSaldo_inicial').val() == '' || $('#txtFecha_fin').val() == '' || $('#txtCuota_mensual').val() == '' || $('#slc_servicio').val() < 1 | $('#slcProveedor').val() < 1){
            if(regresar==1){
                $("#form_agregar_registros").valid();
                $("#tab_general").addClass("clasecss");
                $("#tab_general").trigger('click');
		        $("#toTopHover").trigger("click");
		        return true;
            }
        }else {
            $("#tab_general").removeClass("clasecss");
        }
	}

    $('#btnGuardar').live('click',function(event){
        if ((validar_tabs(1)) ){
            crear_alerta("error","Contrato por proveedor.","Se deben completar los campos requeridos");
		}
	});

    $('#mytab ').click(function(){
	    validar_tabs(0);
	});

      $("#txtCuota_mensual , #txtFecha_inicio, #txtFecha_fin").blur(function(event){
        var fechainicio = $('#txtFecha_inicio').val();
        var fechafin = $('#txtFecha_fin').val();
        var montomensual = $('#txtCuota_mensual').val();

        /*fechainicio = fechainicio.split('-');
        fechafin = fechafin.split('-');

        fechainicio = fechainicio[2] + '-' + fechainicio[1] + '-' + '1' + ' 00:00:00';
        fechafin = fechafin[2] + '-' + fechafin[1] + '-' + '12' + ' 00:00:00';*/

                 $.ajax({
            url: urlj + 'modulo_compras/procesos/rango_meses',
            data:{
                fechainicio: fechainicio,
                fechafin: fechafin
            },
            type: 'POST',
            dataType: 'json',
            success: function(data){

            $('#txtSaldo_inicial').val(data.toFixed(0) * montomensual);

            }
        });  

        /*fechainicio = Date.parse(fechainicio);
        fechafin = Date.parse(fechafin);

        diaz = fechafin - fechainicio;
        var diferencia = (diaz / (1000 * 60 * 60 * 24))/30;*/

       //console.log(diferencia.toFixed(0));
/*        console.log(diaz);
        return false;*/

        //$('#txtSaldo_inicial').val(diferencia.toFixed(0) * montomensual);

    });