$(document).ready(function () {
    //window.gSateliteWhite.jsSelect();   
    $("select").select2({placeholder:"Seleccione una opción"});
    $(".datePicker").mask('99-99-9999');
    $(".datePicker").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });


    $("#btnConsultar").click(function () {

        var estado      = $("#slcEstado").val();
        var fecha_ini   = $("#txtFechaIni").val();
        var fecha_fin   = $("#txtFechaFin").val();
        var tipo        = $("#slcTipo").val();
        var slc_sucursal= $("#slc_sucursal").val();

        if (fecha_ini != '' && fecha_fin != '') {
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Aprobaciones', 'Verifique el periodo de las fechas.');
                return false;
            }
        }

        $("#dv_contenedor_tareas").hide('slide', {
            direction: 'right'
        },
        400, function () {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('modulo_compras/inicio/tareas_pendientes/1'),
                data: {estado: estado, fecha_ini: fecha_ini, fecha_fin: fecha_fin,tipo:tipo,slc_sucursal:slc_sucursal},
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    var oTabla = $("#tblTareas").dataTable();

                    oTabla.fnDestroy();
                    $("#tbContenedorTareas").html(result);

                    $("#dv_contenedor_tareas").show("slide", {
                        direction: 'left'
                    }, 500);
                    aplidarDataTable('tblTareas');
                }
            });
        }
        );
    });

    $("#btnConsultar").click();

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width:'100%',
            closeBtn: true
        });
    });

    $('#detalles').tooltip();
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        },
        "aaSorting": []
    });
}