$(document).ready(function () {

    window.gSateliteWhite.jsSelect();

    $('select option[value=0]').val('');

    $("#crear").hover(function () {
        $("#tipo_btn").val(1);
    });

    $("#crear_v").hover(function () {
        $("#tipo_btn").val(2);
    });


    $("#obli_check").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#obligatorio").val(1);
            } else {
                $("#obligatorio").val(0);
            }
        }
    });

    $("#area_check").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#area").val(1);
            } else {
                $("#area").val(0);
            }
        }
    });

        $("#firma_check").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#firma_check").val('1');
                $("#titulo_firma").removeAttr('style');
            } else {
                $("#firma_check").val('0');
                $("#titulo_firma").attr('style','display : none;');
            }
        }
    });

    $('#orden_paso').focusout(function () {
        var val = $(this).val();
        var flujo = $("#flujo").val();
        var paso = ($('#paso').val() == '' || $('#paso').val() == null) ? '' : $('#paso').val();
        if (val != '') {
            $.ajax({
                url: urlj + 'inventario/configuracion/validar_orden_paso',
                data: {paso: paso, orden: val, flujo: flujo},
                type: 'POST',
                dataType: 'json',
                success: function (data) {
                    if (data.existe == 1) {
                        $('#orden_paso').val('');
                        crear_alerta('error', 'Paso de flujo de trabajo', 'El número de orden ya existe');
                    }
                }
            });
        }
    });

    $("#frm_paso").submit(function () {
        var orden_paso = $("#orden_paso").val();
        var siguiente_paso = $("#siguiente_paso").val();

        if (orden_paso != '') {
            if (orden_paso == siguiente_paso) {
                crear_alerta('error', 'Paso de flujo de trabajo', 'El número siguiente debe ser distinto');
                $('#siguiente_paso').val('');
                return false;
            }
        }

        return true;
    });

    $("#frm_paso").validate({
        ignore: "",
        rules: {
            nombre_paso: {required: true},
            orden_paso: {required: true},
            siguiente_paso: {required: true},
            obligatorio: {required: true},
            area: {required: true},
            descripcion_paso: {required: true},
            estado: {required: true},
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            var nombre = $("#nombre_paso").val();
            var flujo = $("#flujo").val();
            var paso = ($("#paso").val() != null) ? $("#paso").val() : '';
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('inventario/configuracion/validar_nombre_paso'),
                data: {nombre: nombre, paso: paso, flujo: flujo},
                dataType: 'json',
                success: function (data) {
                    if (data.existe == 1) {
                        $('#nombre_flujo').val('');
                        crear_alerta('error', 'Pasos por flujo', 'El nombre del paso ya existe');
                    } else {
                        form.submit();
                        //console.log(data);
                    }
                }
            });
        }
    });

});