$(document).ready(function () {
    window.gSateliteWhite.jsSelect();

    $('select option[value=0]').val('');

    $("#crear").hover(function () {
        $("#tipo_btn").val(1);
    });

    $("#crear_v").hover(function () {
        $("#tipo_btn").val(2);
    });

    // $(".eliminar").live('click',function(){
    // 	event.preventDefault();
    // 	var anexo = $(this).attr('href');
    // 	alerta_confirm(anexo,'Alerta de confirmación','¿Seguro que quieres eliminar esta solicitud?');
    // });


    $("#frm_flujo").validate({
        ignore: "",
        rules: {
            nombre_flujo: {required: true},
            descripcion_flujo: {required: true},
            estado: {required: true},
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            var nombre = $("#nombre_flujo").val();
            var flujo = ($("#flujo").val() != null) ? $("#flujo").val() : '';
            console.log(flujo);
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('inventario/configuracion/validar_nombre_flujo'),
                data: {nombre: nombre, flujo: flujo},
                dataType: 'json',
                success: function (data) {
                    if (data.existe == 1) {
                        $('#nombre_flujo').val('');
                        crear_alerta('error', 'Flujo de trabajo', 'El nombre de flujo ya existe');
                    } else {
                        form.submit();
                        //console.log(data);
                    }
                }
            });
        }
    });

    /*Filtrar Grid*/
    //$("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder', "dd-mm-yyyy");
    $("input[name^='fecha']").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });

    $("#fecha_ini, #fecha_fin").change(function (event) {
        jQuery.validator.addMethod("fecha_ini_fin", function (value, element, params) {
            ini = $(params[0]).val();
            fin = $(params[1]).val();
            return this.optional(element) || (ini <= fin);

        }, jQuery.validator.format("Verifique las fechas del periodo."));

        jQuery.validator.addMethod("fecha", function (value, element) {
            // dd/mm/yyyy
            var re = /^\d{1,2}\-\d{1,2}\-\d{4}$/;
            // valid if optional and empty OR if it passes the regex test
            return (this.optional(element) && value == "") || re.test(value);
        }, jQuery.validator.format("Verifique las fechas del periodo.")
                );
    });


    $('#frm_solicitud').validate({
        ignore: null, ignore: 'input[type="hidden"]',
        rules: {
            fecha_ini: {required: true, fecha: true},
            fecha_fin: {required: true, fecha_ini_fin: ["input[name='fecha_ini']", "input[name='fecha_fin']"]},
        },
        errorPlacement: function (error, element) {
            if ($(element).is("select")) {
                $(element).next().append(error);
            } else {
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {
            wait.start();
            $("#contenedor_index").hide("slide", {
                direction: 'right'
            }, 400, function () { //despues de ocultar div enviar el ajax
                $.ajax({
                    type: 'post',
                    url: window.gSateliteWhite.baseUrl('procesos/gestion_ticket/1'),
                    data: $("#frm_solicitud").serialize(),
                    success: function (data) {
                        $("#consulta_table").html(data);
                        wait.close();
                        $("#contenedor_index").show("slide", {
                            direction: 'left'
                        }, 500);
                    }
                });
            });
        }
    });
});