$(document).ready(function () {

    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder:"Seleccione una opción"});
    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var personeria = $("#slcPersoneria").val();
        var actividad = $("#slcActividadEco").val();

        personeria = (personeria == null) ? '' : personeria;
        actividad = (actividad == null) ? '' : actividad;


        $("#dv_contenedor_proveedores").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('modulo_compras/catalogos/proveedores/1'),
                        data: {personeria: personeria, actividad: actividad, modulo_url:$("#modulo_url").val(), ruta_permisos_op:ruta_permisos_op},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            var oTabla = $("#tblProveedores").dataTable();

                            oTabla.fnDestroy();
                            $("#tbContenedorProveedores").html(result);

                            $("#dv_contenedor_proveedores").show("slide", {
                                direction: 'left'
                            }, 500);
                            aplidarDataTable('tblProveedores');
                        }
                    });
                }
        );
    });

    $(document).on('click','.eliminar_proveedor_x',function(event){
        event.preventDefault();
        id_eliminar = $(this).attr('eliminar_id');
        alerta_confirm_ajax(eliminar_proveedor,id_eliminar,'Alerta Confirmacion','¿Éstas seguro de Eliminar este Proveedor?');
    });

    function eliminar_proveedor(id){
        $.ajax({
            dataType: 'json',
            type: 'post',
            url: window.gSateliteWhite.baseUrl('modulo_compras/catalogos/validar_eliminar_prv'),
            data: {id_proveedor_x: id},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                if (data.procede == 1) {
                    crear_alerta('success','Eliminar Proveedor','El Proveedor fue eliminado.');
                    $('#btnConsultar').trigger('click');
                }else{
                     crear_alerta('error','Eliminar Proveedor','El proveedor seleccionado, no puede ser eliminado ya que hay registros que dependen de el.');
                }
                wait.close();
            }
        });
    }


});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
