jQuery(document).ready(function($) {

	$("#form_caja_chica").validate({
        ignore: "",
        rules: {
            'nombre'         	: {required: true},
            'empleado'          : {required: true, min: 1}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').text('Campo requerido');
        },
        submitHandler: function (form) {
        	wait.start();
            form.submit();
        }
    });

	$('select').select2();

    $("#sobregirar").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#hsobregirar").val(1);
            } else {
                $("#hsobregirar").val(0);

            }
        }
    });

    $("#cuenta_contable_tbl").select2({
        placeholder: "Buscar Cuenta Contable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'utm/cuentas/get_cuentas_contables_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cuenta) {
                return {
                    cuenta: cuenta
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cuenta,
                        'text': item.cuenta_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    $("body").on("click", "#add_cuenta_caja", function(){
    	var contador = parseInt($("#cuenta_contable_contador").val());
    	var cuenta_contable = $("#cuenta_contable_tbl").val();//debe 461 haber 446
    	var cuenta_contable_text = $("#cuenta_contable_tbl").next().text().trim();
    	var tipo_cuenta = $("#tipo_cuenta_tbl").val();
    	var tipo_cuenta_text = $("#tipo_cuenta_tbl option:selected").text().trim();
        var tipo_proceso = $("#tipo_proceso").val();
        var tipo_proceso_text = $("#tipo_proceso option:selected").text();
    	validar_campo_repetido();
        var key = cuenta_contable + '_' + tipo_proceso;
    	if(validar_campo_repetido("#table_cuenta_caja", ".cuenta_validar", key)){
            crear_alerta("info", "Aviso", 'El registro ya existe.');
            return false;
        }
        if(cuenta_contable > 0 && tipo_cuenta > 0 && tipo_proceso > 0){
            caja_conf = '<input type="hidden" class="cuenta_validar" value="' + key + '"><input type="hidden" name="cuenta_caja_nuevo[]" value="">';
            caj_cuenta_contable = '<input type="hidden" id="cuenta_contable_' + contador + '" name="cuenta_contable[]" value="' + cuenta_contable + '"><label style="padding: 6px 4px;">' + cuenta_contable_text + '</label>';
            caj_tipo_cuenta =  '<input type="hidden" id="tipo_cuenta' + contador + '" name="tipo_cuenta[]" value="' + tipo_cuenta + '"><label style="padding: 6px 4px;">' + tipo_cuenta_text + '</label>';
            proc_tipo_cuenta = '<input type="hidden" name="proceso_caja[]" value="' + tipo_proceso + '"><label>' + tipo_proceso_text + '</label>';
            eliminar = '<a class="btn btn-danger minia-icon-trashcan white remover_tr action" title="Eliminar" style="margin-right: 5px;cursor:pointer;font-size:13px;">Eliminar</a>';
            caj_acciones = eliminar;
            $("#table_cuenta_caja").DataTable().fnDestroy();
            $("#body_cuenta_caja").append('<tr id="tr_ingresos'+contador+'" class="tr_ingresos">'+
                '<td width="30%">' + caja_conf + caj_cuenta_contable + '</td>'+
                '<td width="30%">' + caj_tipo_cuenta + '</td>' +
                '<td width="20%">' + proc_tipo_cuenta + '</td>' +
                '<td width="20%" style="text-align: center;">'+caj_acciones+'</td></tr>');
            aplicarDataTable("#table_cuenta_caja");
            $("#cuenta_contable_tbl").select2('data', null);
            $("#tipo_cuenta_tbl option").removeAttr('selected');
            $("#tipo_cuenta_tbl").select2();
            $("#tipo_proceso option").removeAttr('selected');
            $("#tipo_proceso").select2();
            contador += 1;
            $("#cuenta_contable_contador").val(contador);
        } else{
            if(!(cuenta_contable > 0)){
                $("#cuenta_contable_tbl_error").text('Campo requerido.');
            }
            if (!(tipo_proceso > 0)) {
                $("#tipo_proceso_error").text('Campo requerido.');
            }
            if(!(tipo_cuenta > 0)){
                $("#tipo_cuenta_tbl_error").text('Campo requerido.');
            }
        }

    })

    function aplicarDataTable(idTabla) {
	    $(idTabla).dataTable({
	        "bPaginate": false,
	        "bInfo": false,
	        "bSort": false,
	        "bFilter": false,
	    });
	}

	aplicarDataTable("#table_cuenta_caja");

	function validar_campo_repetido(padre, campo, valor){
        var validar_unico = false;
        var validacion = $(padre + ' tr input'+campo+'[value="'+valor+'"]').length;
        if(validacion != 0){
            validar_unico = true;
        }
        return validar_unico;
    }

    $(".remover_tr").live('click', function(){ //elimina el componente agregado
        var tr = $(this).closest('tr');
        var body = $(this).closest('tbody');
        var tabla = $(this).closest('table').attr('id');
        $('#'+tabla).dataTable().fnDestroy();
        tr.remove();
        aplicarDataTable('#'+tabla);
    })

});//fin de document ready