$(document).ready(function() {
    //gSateliteWhite.jsSelect();

    $('select').select2({ placeholder: 'Seleccione una opción' });
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    /*Busqueda*/
    $("#btnConsultar").click(function() {
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if (fecha_ini != '' && fecha_fin != '') {
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Avisos', 'Verifique el período de las fechas.');
                return false;
            }
        }

        $("#dv_contenedor_avisos").hide('slide', {
                direction: 'right'
            },
            400,
            function() {
                $.ajax({
                    type: 'post',
                    url: window.gSateliteWhite.baseUrl('modulo_avisos/procesos/avisos/1'),
                    data: { fecha_ini: fecha_ini, fecha_fin: fecha_fin },
                    beforeSend: function() {
                        wait.start();
                    },
                    success: function(result) {
                        wait.close();
                        var oTabla = $("#tblAvisos").dataTable();

                        oTabla.fnDestroy();
                        $("#tbContenedorAvisos").html(result);

                        $("#dv_contenedor_avisos").show("slide", {
                            direction: 'left'
                        }, 500);
                        aplidarDataTable('tblAvisos');
                    }
                });
            }
        );
    });


    $(".ver-accion-modal").live('click', function(event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            width: '100%',
            closeBtn: true,
            height: '100%'
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function(oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}