jQuery(document).ready(function($) {
	$("select").select2();
    var listado = $("#listado_emp").val();
    $("#tipo_planilla").select2({placeholder: 'Seleccione un tipo de planilla'});
    $("#planilla").select2({placeholder: 'Seleccione un tipo de planilla'});
    $("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
    $("input[name^='fecha']").tooltip();
    $(".accion_botones").hide();
  
    // Consultar un boton Normal
    $("#consultar_submit").on('click', function(){
        if( $("#fecha_desde").val() =='' || $("#fecha_hasta").val() == '' || $("#planilla").val()==0 || $("#planilla").val()==null){
            crear_alerta("info","Aviso","Campos con * son requeridos");
        } else {
            wait.start();
            $("#consultar_submit").attr('disabled', 'disabled');
            $(".accion_botones").hide('slow');
            //despues de ocultar div enviar el ajax
            $("#contenedor_consulta").hide("slide", { direction: 'right' }, 400, function() {
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url:  window.gSateliteWhite.baseUrl('marcacion/procesos/get_marcaciones'),
                    data: {
                        'area': $("#area").val(),
                        'empleado': $("#empleado").val(),                        
                        'desde':$("#fecha_desde").val(),
                        'hasta':$("#fecha_hasta").val()
                    },
                    success: function (data) {
                        $("#fecha_desde_hidden").val($("#fecha_desde").val());
                        $("#fecha_hasta_hidden").val($("#fecha_hasta").val());
                        $("#contenedor_consulta").html(data.resultado); // Este es el bueno.
                        if($("#aplica").val()==0) {
                            $(".accion").hide();
                        }

                        wait.close();
                        $("#consultar_submit").removeAttr('disabled'); 
                        if($("#consulta_marcaciones").dataTable().fnSettings().aoData.length != 0){
                            $(".accion_botones").show('slow');
                        }

                        $("#contenedor_consulta").show("slide", { direction: 'left' }, 500);
                        $("#consulta_marcaciones").dataTable().css('margin-top','1.5%');
                    }
                });
            });
        }
    });

    $("#area").change(function(event) {
        $("#contenedor_empleado").fadeOut();
        var area = $(this).val();
        if(area > 0) {
            $.ajax({
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('marcacion/procesos/cargar_select_empleados_area'),
                type: 'post',
                data: {
                    'id': $("#area").val()
                },
                success: function(data) {
                    $("#contenedor_empleado").html(data.empleados_select);
                    $("#empleado").select2();
                }
            });
        } else {
            $("#empleado").html(listado); 
            $("#empleado").select2();
        }
        $("#contenedor_empleado").show('slow');
    });    


///////////////////////
// //VALIDACION VALIDATE
//  $('#form_procesar_marcacion').validate({

//        ignore: null, ignore: 'input[type="hidden"]',
//         rules: {
//           planilla:{required:true},
//         } ,
//         errorPlacement: function (error, element) {
//          if($(element).is("select")){ $(element).next().append(error); }
//          else { 
//            error.insertAfter(element);
//           }
//         },
//         messages: {
//           validacion_det_horario : { required:'Favor ingresar detalles de horario'}
//         }, 
//         submitHandler: function(form){
//            console.log( $(form).serialize() );
//             wait.start();
//        $("#consultar_submit").attr('disabled', 'disabled');
//        $(".accion_botones").hide('slow');
//        $("#contenedor_consulta").hide("slide", { 
//         direction: 'right'
//       }, 400, function() { //despues de ocultar div enviar el ajax
//         $.ajax({
//           type: 'POST',
//           dataType: 'json',
//           url:  window.gSateliteWhite.baseUrl('marcacion/procesos/get_marcaciones'),
//           data: {
//                  'desde':$("#fecha_desde").val(),
//                  'hasta':$("#fecha_hasta").val()
//                },
//           success: function (data) {
//             $("#fecha_desde_hidden").val($("#fecha_desde").val());
//             $("#fecha_hasta_hidden").val($("#fecha_hasta").val());
            
//             $("#contenedor_consulta").html(data.resultado); // Este es el bueno.
//             if($("#aplica").val()==0)
//             {
//               $(".accion").hide();
//             }

//                   wait.close();
//                  $("#consultar_submit").removeAttr('disabled'); 
//                  $(".accion_botones").show('slow');
//                  $("#contenedor_consulta").show("slide", {
//                   direction: 'left'
//                 }, 500);
//                  $("#consulta_marcaciones").dataTable();
//                }
//              });
//       });

//         } 
//     }); 

    $("#tipo_planilla").change(function(){
        var tpl = $("#tipo_planilla").val();
        if (tpl != "") {
            $.ajax({
                dataType: 'json',
                type: 'post',
                url: urlj+'marcacion/procesos/obtener_periodo_planilla',
                data:{
                    t_planilla: tpl
                },
                success:function(data){
                    $("#planilla").html(data.drop);
                    $("#planilla").select2({placeholder: 'Seleccione'});
                }
            });
        }else{
            $("#planilla").html('<option value=""></option>');
            $("#planilla").select2({placeholder: 'Seleccione un tipo de planilla'});
        }
    });

    $('#procesar').on('click', function(e) {
        e.preventDefault();
        $('#tipo').val('1');

        // Obtener los input hidden de datatable
        var data = {};
        var table = $('#consulta_marcaciones').dataTable(); 

        // ITERAR SOBRE TODAS LAS FILAS (incluyendo las no visibles)
        table.$('tr').each(function() {
            $(this).find('input, select, textarea').each(function() {
                var name = $(this).attr('name');
                if (!name) return;

                var cleanName = name.replace(/\[\]$/, '').replace(/\[\d+\]$/, '');
                var value = $(this).val();

                // Forzar que siempre sea array
                if (data[cleanName] === undefined) {
                    data[cleanName] = [value];
                } else {
                    if (!Array.isArray(data[cleanName])) {
                        data[cleanName] = [data[cleanName]];
                    }
                    data[cleanName].push(value);
                }                
            });
        });
        
        // Obtener los campos del formulario
        var array = $('#formulario_temporal').serializeArray();
        
        array.forEach(function(item) {
            // LIMPIAR EL NOMBRE removiendo los corchetes []
            var cleanName = item.name.replace(/\[\]$/, '');
            
            if (data[cleanName]) {
                // Si el nombre ya existe, convierte en array
                if (!Array.isArray(data[cleanName])) {
                    data[cleanName] = [data[cleanName]];
                }
                data[cleanName].push(item.value);
            } else {
                data[cleanName] = item.value;
            }
        });

        // Obtener id_marcaciones_agrupadas
        var idGroupRaw = $('input[name="id_marcaciones_agrupadas"]').val();
        var idGroup = JSON.parse(idGroupRaw);

        // Guárdalo como objeto global
        data["id_marcaciones_agrupadas"] = idGroup;        
        
        var json = JSON.stringify(data);
        
        // Validar tamaño
        var jsonSize = new Blob([json]).size / 1024 / 1024; // MB
            console.log('Tamaño JSON:', jsonSize.toFixed(2), 'MB');
            console.log('Campos procesados:', Object.keys(data).length);
        
        if (jsonSize > 7) {
            crear_alerta('error', 'Data', 'Datos demasiado grandes: ' + jsonSize.toFixed(2) + ' MB');
            return false;
        }
        
        // Deshabilitar botón
        $('#procesar').prop('disabled', true);
        $('#jsonData').val(json);
        $('#form_procesar_marcacion').submit();
    });        

});