$(document).ready(function($) {

    $(".fechas").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".fechas").mask("99-99-9999");
    $(".fechas").attr('placeholder',"dd-mm-yyyy");
    $(".fechas").tooltip();
    $("#accion_botones").hide();
    $("#fecha_desde,#fecha_hasta").change(function(event) {  validar_fecha_inicio_fin('fecha_desde','fecha_hasta'); });

    $("#consultar_submit").click(function() {
        var fecha_desde = $("#fecha_desde").val();
        var fecha_hasta = $("#fecha_hasta").val();
        $("#accion_botones").hide();                
        if(fecha_desde != '' && fecha_hasta != ''){            
            $.ajax({
                dataType: 'text',
                type: 'POST',
                dataType: 'json',
                url: urlj + 'marcacion/consultas/llegadas_tardias2/1',
                data: {
                    fecha_ini: fecha_desde, 
                    fecha_fin: fecha_hasta,
                    tipo_rpte: ""
                },              
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#contenedor_consulta").html(data.tabla);
                    $("#fecha_ini").val(fecha_desde);
                    $("#fecha_fin").val(fecha_hasta);
                    aplicarDataTable('detalles');
                    if (data.registros > 0) {
                        $("#accion_botones").show();
                    }
                    wait.close();            
                },
                error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
                }                      
            });
        }else{ 
            crear_alerta('error', 'Campos requeridos', 'Campos con asterisco son requeridos');
        }                
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}