$(document).ready(function($) {
    $(".fechas").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true,
        changeYear: true
    });
    $(".fechas").mask("99-99-9999");
    $(".fechas").attr('placeholder', "dd-mm-yyyy");
    $(".fechas").tooltip();
    $("#accion_botones").hide();

    $(document).on('change', '.fechas', function(){
        if ($("#fecha_desde").val() != "" && $("#fecha_hasta").val() != "") {
            fecha_valida($("#fecha_desde").val(), $("#fecha_hasta").val());
        }
    })

    $("#consultar_submit").click(function() {
        var fecha_desde = $("#fecha_desde").val();
        var fecha_hasta = $("#fecha_hasta").val();
        $("#accion_botones").hide();
        if(fecha_desde != '' && fecha_hasta != ''){
            if (fecha_valida(fecha_desde, fecha_hasta)) {
                $.ajax({
                    dataType: 'text',
                    type: 'POST',
                    dataType: 'json',
                    url: urlj + 'marcacion/consultas/llegadas_tardias/1',
                    data: {
                        fecha_ini: fecha_desde,
                        fecha_fin: fecha_hasta,
                        tipo_rpte: ""
                    },              
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (data) {
                        $("#contenedor_consulta").html(data.tabla);
                        $("#fecha_ini").val(fecha_desde);
                        $("#fecha_fin").val(fecha_hasta);
                        aplicarDataTable('detalles');
                        if (data.registros > 0) {
                            $("#accion_botones").show();
                        }
                        wait.close();
                    }
                });
            }            
        }else{ 
            crear_alerta('error', 'Campos requeridos', 'Campos con asterisco son requeridos');
        }                
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function fecha_valida(fecha_ini, fecha_fin) {
    var start = fecha_ini.split("-").reverse().join("-");
    var final = fecha_fin.split("-").reverse().join("-");
    // var ftest = start.split("-");
    // var finmesfecha = new Date(ftest[0], ftest[1], 1, 0,0,0);
    // if (Date.parse(final) >= Date.parse(finmesfecha)) {
    //     crear_alerta('error', 'Deben ser fechas del mismo mes', '');
    //     return false;
    // }    
    if (Date.parse(start) > Date.parse(final)) {
        crear_alerta('error', 'Verifique las fechas del período', '');
        return false;
    } else {
        return true;
    }    
}