$(document).ready(function($) {

    $(".fechas").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".fechas").mask("99-99-9999");
    $(".fechas, #ctdad_eventos").tooltip();
    $("#accion_botones, #btn_grafics").hide();


    $("#consultar_submit").click(function() {
        var fecha_desde = $("#fecha_desde").val();
        var fecha_hasta = $("#fecha_hasta").val();
        var ctdad_evnts = $("#ctdad_eventos").val();
        $("#accion_botones, #btn_grafics").hide();                
        if(fecha_desde != '' && fecha_hasta != ''){            
            $.ajax({
                dataType: 'text',
                type: 'POST',
                dataType: 'json',
                url: urlj + 'marcacion/consultas/incidencia_marca/1',
                data: {
                    fecha_ini: fecha_desde, 
                    fecha_fin: fecha_hasta,
                    ctdad_evn: ctdad_evnts,
                    tipo_rpte: ""
                },              
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#contenedor_consulta").html(data.tabla);
                    $("#fecha_ini").val(fecha_desde);
                    $("#fecha_fin").val(fecha_hasta);
                    $("#ctdad_evn").val(ctdad_evnts);
                    aplicarDataTable('detalles');
                    if (data.registros > 0) {
                        $("#accion_botones").show();
                        if (ctdad_evnts > 0) {
                            $("#btn_grafics").show('slow');
                        }
                    }
                    wait.close();            
                }                       
            });
        }else{ 
            crear_alerta('error', 'Campos requeridos', 'Campos con asterisco son requeridos');
        }                
    });

    $("#ver_grafica").live('click',function(event){
        event.preventDefault(); 
        var fecha_desde = $("#fecha_ini").val();
        var fecha_hasta = $("#fecha_fin").val();
        var ctdad_evnts = $("#ctdad_evn").val();
        var url = urlj + 'marcacion/consultas/grafico_llegadas_tarde/' + fecha_desde + '/' + fecha_hasta + '/' + ctdad_evnts;
        $.fancybox({
            'href': url,
            'width' : '1200',
            'height' : '800',
            'autoscale' : true,
            'transitionin' : 'none',
            'transitionOut' : 'none',
            'type' : 'iframe',
            'openEffect' : 'elastic',
            'closeEffect' : 'elastic'
        });
    });
    

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}