$(document).ready(function() {
    $("select").select2();

    $(".datePicker").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'dd-mm-yy'
    });
    $( ".datePicker" ).mask("99-99-9999");


    $('#slc_tipo').on('change', function (e) {
        tipo = $("#slc_tipo").val();
        if(tipo == "1"){
            $("#fecha_final").hide();
        } else {
            $("#fecha_final").show();
        }
    });

    $('#fecha_inicio').on('change', function (e) {
        tipo = $('#slc_tipo').val();
        if ($(this).val() != "") {
            newdate = changeDate($(this).val());
            $("#fecha_inicio_hidden").val(newdate);
            if (tipo == 1) {
                $("#fecha_fin_hidden").val(newdate);
            } else {
                if ($('#fecha_fin').val() != "") {
                    validar_fechas($('#fecha_inicio').val(), $('#fecha_fin').val());
                }
            }
        } else {
            $("#fecha_inicio_hidden").val("");
            if (tipo == 1) {
                $("#fecha_fin_hidden").val("");
            }
        }
    });

    $('#fecha_fin').on('change', function (e) {
        if ($(this).val() != "") {
            newdate = changeDate($(this).val());
            $("#fecha_fin_hidden").val(newdate);
            if ($('#fecha_inicio').val() != "") {
                validar_fechas($('#fecha_inicio').val(), $('#fecha_fin').val());
            }
        } else {
            $("#fecha_fin_hidden").val("");
        }
    });

    $("#dias_feriados").validate({
		ignore:"",
		rules: {
			fecha_inicio: { required:true},
			tipo: { required:true},
			nombre: { required:true},
		}, 
		ignore: ".select2-container",
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			$('#'+nombre+'_error').html(error);
			$('#'+nombre+'_error').text('Campo requerido');
		},
		submitHandler: function(form) {
            if (validar_fechas($('#fecha_inicio').val(), $('#fecha_fin').val())) {
                form.submit();
            }
		}
	});
    
    $('.enviar_formulario').live('click',function(event){
        if($('#fecha_inicio').val() == ""){
            $('#fecha_inicio_error').text('Campo requerido');
            $('#fecha_inicio').addClass('error');
        }

        if($('#nombre').val() == ""){
            $('#nombre_error').text('Campo requerido');
            $('#nombre').addClass('error');
        }

        if($('#descripcion_desde').val() == ""){
            $('#descripcion_desde_error').text('Campo requerido');
            $('#descripcion_desde').addClass('error');
        }

        if(!$('#slc_tipo').val()){
            $('#slc_tipo_error').text('Campo requerido');
            $('#slc_tipos').addClass('error');
        }
	})

});



function changeDate(date) {
    var fecha = date.split("-").reverse().join("-");
    // var d=new Date(date.split("-").reverse().join("-"));
    // var mm=d.getMonth()+1;
    // var yy=new Date().getFullYear();
    // tipo = $("#slc_tipo").val();
    // if(tipo == "1"){
    //     var dd=d.getDate()+1;
    // } else {
    //     var dd=d.getDate()+1;
    // }
    // var fecha = yy+"-"+mm+"-"+dd;
    return fecha;
}

function validar_fechas(fecha_ini, fecha_fin) {
    var start = fecha_ini.split("-").reverse().join("-");
    var final = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(start) > Date.parse(final)) {
        crear_alerta('error', 'Verifique las fechas ingresadas', '');
        return false;
    } else {
        return true;
    }    
}