jQuery(document).ready(function($) {
    var listado = $("#listado_emp").val();
	$("select").select2();
    $("input[name^='fecha']").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
    $("input[name^='fecha']").tooltip();
    $(".accion_botones").hide();

    $("#area").change(function(event) {
        $("#contenedor_empleado").fadeOut();
        var area = $(this).val();
        if(area > 0) {
            $.ajax({
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('marcacion/procesos/cargar_select_empleados_area'),
                type: 'post',
                data: {
                    'id': $("#area").val()
                },
                success: function(data) {
                    $("#contenedor_empleado").html(data.empleados_select);
                    valor=$("#empleado option:first").val();         
                    if (valor == '') {  
                        $("#empleado").prepend('<option value="todos">Todos los empleados</option>'); 
                        $("#empleado option[value='']").remove();
                        $("#empleado").prepend('<option value=""></option>');
                        $("#empleado option[value='']").attr("selected", "selected");
                        $("#empleado").select2();
                    }
                    $("#empleado").select2();
                }
            });
        } else {
            $("#empleado").html(listado); 
            // $("#contenedor_empleado").html('<select name="empleado" placeholder="Seleccione" id="empleado" style="width:100%;" class="nostyle" ><option value=""></option></select>'); 
            $("#empleado").select2();
        }
        $("#contenedor_empleado").show('slow');
    });


    //VALIDACION VALIDATE
    $('#form_detalle_turno').validate({
        ignore: null, ignore: 'input[type="hidden"]',
        rules: {
            area: {required:false},
            fecha_desde:      {required:true},
            fecha_hasta:      {required:true}
        } ,
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').html(error)
        },
        messages: {
            validacion_det_horario : { required:'Favor ingresar detalles de horario'}
        }, 
        submitHandler: function(form){
            console.log( $(form).serialize() );
            if (!validarPeriodo($("#fecha_desde").val(), $("#fecha_hasta").val())) {
                crear_alerta('error', 'Marcaciones', 'Verifique el período de las fechas.');
                return false;
            }
            wait.start();
            $(".accion_botones").hide('slow');
            $("#contenedor_consulta").hide("slide", { 
                direction: 'right'
            }, 400, function() { //despues de ocultar div enviar el ajax
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url:  window.gSateliteWhite.baseUrl('marcacion/consultas/get_marcaciones'),
                    data: {
                        'area':$("#area").val(),
                        'empleado':$("#empleado").val(),
                        'desde':$("#fecha_desde").val(),
                        'hasta':$("#fecha_hasta").val(),
                        'tipo':$("#tipo2").val()
                    },
                    success: function (data) {
                        $("#area_hidden").val($("#area").val());
                        $("#empleado_hidden").val($("#empleado").val());
                        $("#fecha_desde_hidden").val($("#fecha_desde").val());
                        $("#fecha_hasta_hidden").val($("#fecha_hasta").val());            
                        $("#contenedor_consulta").html(data.resultado); // Este es el bueno.  
                        if($("#aplica").val()==0){
                            $(".accion").hide();
                        }
                        wait.close();
                        if($("#consulta_marcaciones").dataTable().fnSettings().aoData.length != 0){
                            $(".accion_botones").show('slow');
                        }
                        $("#contenedor_consulta").show("slide", {
                            direction: 'left'
                        }, 500);
                        $("#consulta_marcaciones").dataTable();
                        $('#consulta_marcaciones').css('margin-top','3px');
                    }
                });
            });
        } 
    });


    $("body").on('click', ".ver_accion_modal", function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            maxWidth: 800,
            maxHeight: 550,
            fitToView: false,
            width: '75%',
            height: '75%',
            autoSize: false,
            closeBtn: true
        });
    });


});