var pathArray = window.location.pathname.split( '/' ); 
var urlj=url_base_proyecto; 
$(document).ready(function($) {
    var listado = $("#listado_emp").val();
	$("select").select2();
    $(".fechas").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true, 
        changeYear: true}
        );
    $(".fechas").mask("99-99-9999");
    $(".fechas").attr('placeholder',"dd-mm-yyyy");
    $(".fechas").tooltip();


    $("#area").change(function(event) {
        $("#contenedor_empleado").fadeOut();
        var area = $(this).val();
        if(area > 0) {
            $.ajax({
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('marcacion/procesos/cargar_select_empleados_area'),
                type: 'post',
                data: {
                    'id': $("#area").val()
                },
                success: function(data) {
                    $("#contenedor_empleado").html(data.empleados_select);
                    $("#empleado").select2();
                }
            });
        } else {
            $("#empleado").html(listado); 
            $("#empleado").select2();
        }
        $("#contenedor_empleado").show('slow');
    });


    $('#form_detalle_turno').validate({
        ignore: null, ignore: 'input[type="hidden"]',
        rules: {
            fecha_desde: {required:true},
            fecha_hasta: {required:true}
        } ,
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').html(error)
        },
        messages: {
            validacion_det_horario : { required:'Favor ingresar detalles de horario'}
        }, 
        submitHandler: function(form){
            if (!validarPeriodo($("#fecha_desde").val(), $("#fecha_hasta").val())) {
                crear_alerta('error', 'Marcaciones', 'Verifique el período de las fechas.');
                return false;
            }
            $("#contenedor_consulta").hide("slide", {direction: 'right'}, 300, function() {
                $.ajax({
                    type: 'POST',
                    // dataType: 'json',
                    url:  urlj + 'marcacion/procesos/confirmar_marcacion',
                    data: {
                        area: $("#area").val(),
                        empleado: $("#empleado").val(),
                        desde: $("#fecha_desde").val(),
                        hasta: $("#fecha_hasta").val()
                    },
                    beforeSend: function () {            
                        wait.start();
                    },
                    success: function (data) {
                        $("#contenedor_consulta").html(data);
                        $("#contenedor_consulta").show("slide", {direction: 'left'}, 500);
                        $("#consulta_marcaciones").dataTable();
                        wait.close();          
                    }
                });//ajax
            });//slide
        } //submit
    }); //validate

    $('.edicion').live('click',function(event){
        var id = $(this).data("id");
        $("#edit_"+id).hide();
        $("#dlte_"+id).hide();
        $("#lb_f_inn_"+id).hide();
        $("#lb_h_inn_"+id).hide();
        $("#lb_f_out_"+id).hide();
        $("#lb_h_out_"+id).hide();
        $('.horarios').timeEntry({
            show24Hours: true, 
            showSeconds: true,
            spinnerIncDecOnly: true,
            spinnerImage: ''
        });
        $("#tr_"+id+" .dias").datepicker({
            dateFormat: 'dd-mm-yy',
            changeMonth: true, 
            changeYear: true}
            );
        $(".dias").mask("99-99-9999");
        $("#mar_f_inn_"+id).show();
        $("#mar_f_out_"+id).show();
        $("#mar_h_inn_"+id).show();
        $("#mar_h_out_"+id).show();
        $("#save_"+id).show();
    });

    $('.guardado').live('click',function(event){
        var id = $(this).data("id"); 
        var fec_in = $("#mar_f_inn_"+id).val();
        var fec_in_org = $("#org_f_inn_"+id).val();
        var fec_ou = $("#mar_f_out_"+id).val();
        var fec_ou_org = $("#org_f_out_"+id).val();
        var hor_in = $("#mar_h_inn_"+id).val();
        var hor_in_org = $("#org_h_inn_"+id).val();
        var hor_ou = $("#mar_h_out_"+id).val();
        var hor_ou_org = $("#org_h_out_"+id).val();
        if (fec_in != "" && fec_ou != "" && hor_in != "" && hor_ou != "") {
            var fn1 = new Date(fec_in);
            var fo1 = new Date(fec_in_org);
            var fn2 = new Date(fec_ou);
            var fo2 = new Date(fec_ou_org);
            var same_f_ent = fn1.getTime() === fo1.getTime();
            var same_f_sal = fn2.getTime() === fo2.getTime();
            var same_h_ent = (Date.parse('01/01/2000 '+hor_in) === Date.parse('01/01/2000 '+hor_in_org));
            var same_h_sal = (Date.parse('01/01/2000 '+hor_ou) === Date.parse('01/01/2000 '+hor_ou_org));
            if (same_f_ent && same_f_sal && same_h_ent && same_h_sal) {
                $("#mar_f_inn_"+id).hide();
                $("#mar_f_out_"+id).hide();
                $("#mar_h_inn_"+id).hide();
                $("#mar_h_out_"+id).hide();
                $("#lb_f_inn_"+id).show();
                $("#lb_h_inn_"+id).show();
                $("#lb_f_out_"+id).show();
                $("#lb_h_out_"+id).show();
                $("#save_"+id).hide();
                $("#dlte_"+id).show();
                $("#edit_"+id).show();
            } else {
                var mar_id = $("#mar_id_"+id).val();
                $("#contenedor_consulta").hide("slide", {direction: 'right'}, 300, function() {
                    $.ajax({
                        type: 'POST',
                        url:  urlj + 'marcacion/procesos/confirmar_marcacion/' + mar_id,
                        data: {
                            area: $("#area").val(),
                            empleado: $("#empleado").val(),
                            desde: $("#fecha_desde").val(),
                            hasta: $("#fecha_hasta").val(),
                            fec_inn: fec_in,
                            fec_out: fec_ou, 
                            hor_inn: hor_in,
                            hor_out: hor_ou
                        },
                        beforeSend: function () {
                            wait.start('Procesando los cambios');
                        },
                        success: function (data) {
                            $("#contenedor_consulta").html(data);
                            $("#contenedor_consulta").show("slide", {direction: 'left'}, 500);
                            $("#consulta_marcaciones").dataTable();
                            wait.close();
                        }
                    });
                });
            }
        } else {
            $("#mar_f_inn_"+id).hide();
            $("#mar_f_out_"+id).hide();
            $("#mar_h_inn_"+id).hide();
            $("#mar_h_out_"+id).hide();
            $("#mar_f_inn_"+id).val(fec_in_org);
            $("#mar_f_out_"+id).val(fec_ou_org);
            $("#mar_h_inn_"+id).val(hor_in_org);
            $("#mar_h_out_"+id).val(hor_ou_org);
            $("#save_"+id).hide();
            $("#dlte_"+id).show();
            $("#edit_"+id).show();
            $("#lb_f_inn_"+id).show();
            $("#lb_h_inn_"+id).show();
            $("#lb_f_out_"+id).show();
            $("#lb_h_out_"+id).show();
            crear_alerta('info', 'Atención', 'Algunos campos están vacios, No se aplicarán cambios.');
        }        
    });

    $('.borrado').live('click',function(event){
        var id = $(this).data("id");
        var mar_id = $("#mar_id_"+id).val();
        alerta_confirm_ajax(borrar_reg, mar_id, 'Alerta de Confirmación', '¿Ésta seguro de eliminar este registro?<br>Esta acción no se puede revertir');
    });
        

});//doc.ready

function borrar_reg(mar_id) {
    $("#contenedor_consulta").hide("slide", {direction: 'right'}, 300, function() {
        $.ajax({
            type: 'POST',
            url:  urlj + 'marcacion/procesos/eliminar_proc_marc/' + mar_id,
            data: {
                area: $("#area").val(),
                empleado: $("#empleado").val(),
                desde: $("#fecha_desde").val(),
                hasta: $("#fecha_hasta").val()
            },
            beforeSend: function () {
                wait.start('Procesando los cambios');
            },
            success: function (data) {
                $("#contenedor_consulta").html(data);
                $("#contenedor_consulta").show("slide", {direction: 'left'}, 500);
                $("#consulta_marcaciones").dataTable();
                wait.close();
            }
        });
    });
}
    