var separators = ["-", "/"];
jQuery(document).ready(function($) {
   //$("#form_carga_marcacion").validate();
	$(".ayuda").click(function(event) {
		html=$("#div_ayuda").html();
		$.fancybox(html,{title:'FORMATO TXT REQUERIDO PARA SER PROCESADO'});
	});
   //  papa = $(".eliminar_padre").parent();
   // papa.remove();
});


window.async
function validateTxt() {
	totalValidRows = 0;
	totalInvalidRows = 0;
	//console.log(inputfile.files[0]);
	const content = document.querySelector('.content');
	if (inputfile.files[0]) {
		const file = inputfile.files[0];
		if(file.name.includes('.txt')){
			readTxt(file);
		}else{
			crear_alerta('error', 'Tipo de archivo', 'Verifique que el archivo seleccionado se de tipo texto.');
		}
	}else{
		crear_alerta('error', 'No encontrado', 'Seleccione el archivo que desea cargar.');
	}
}

function cancelarMarcaciones(){
	if (confirm('Confirma que desea cancelar el proceso actual?')) {
		//console.log(window.location.href);
		let url = window.location.href;
		window.location.href = url;
	}
}

function leftcero_remove(str){
    for(char of str){
	    if (char == '0') {
	        str = str.replace('0','');
	    }else{
		    break;
	    }
    }
    return str;
}

function readTxt(file) {
	const reader = new FileReader();
	let arraytb = [];
	if(reader.result == ''){
		crear_alerta('error', 'Tipo de archivo', 'El archivo se encuentra vacio.');
	}else{
		reader.addEventListener("load", () => {
			let x = reader.result;
			let totalRows = 0;
			let result = x.split(/\n/).map(function(e) {
				totalRows++;
				let obj = {}; 
				let spl = e.split(', ');
				for (let i = 0; i < spl.length; i++) {
					obj['c'+i] = spl[i].trim();
					if (('c'+i) == "c1") {
						obj.c1b = leftcero_remove(spl[i].trim());
					}
					if (('c'+i) == "c2") {
						let arraydate = obj.c2.split(" ");
						obj.c3 = arraydate[0];
						obj.c4 = arraydate[1];
					}
				}
				arraytb.push(obj);
			});
			//console.log(arraytb);
			let norepeats = filtrarNorepetidosPorCodigo(arraytb);
			//console.log(norepeats);
			let grupos = agruparPorFecha_porCodigo(norepeats, arraytb);
			//console.log(grupos);
			let grupospares = filtrarGruposPares(grupos);
			let listaprevia = unirGruposPares(grupospares);
			//console.log(listaprevia);
			validateData(listaprevia);
			totalrows.innerHTML = 'Total encontrados: <b>'+totalRows+'</b>, ';
	  	}, false);
		if (file) {
		 	reader.readAsText(file);
		}
	}
}

var list = [];
async function validateData(tb) {
	//Cambiar formato como entrdas y salidas, y en el backend que compruebe si la horas de entrada y salida estan dentro del rango del horario del id empleado
	wait.start();
	let url = window.location.base_url+'marcacion/procesos/cargar_marcacion_txt/validar';	
	let res = await fetch(url, {
		method: 'POST', mode: 'no-cors', cache: 'no-cache',
		headers: {'Content-Type': 'application/json'}, body: JSON.stringify(tb)
	});
	if (res) {
		list = await res.json();
		createTable();
		wait.close();
	}else{
		return 'Error: ${res.status}';
	}
}

var totalValidRows = 0;
var totalInvalidRows = 0;
function createTable() {
	//console.log(list);
	let table = '';
	contenedor.innerHTML = '';
	for (let i = 0; i < list.length; i++) {
		if (list[i].emp_id != null) {
			totalValidRows++;
			table += `
	      	<tr>
					<td>${list[i].c0}</td>
					<td>${list[i].c1}</td>
					<td>${list[i].nombre+' '+list[i].apellido}</td>
					<td>${list[i].c3}</td>
					<td>${list[i].c4}</td>
				</tr>
			`;
		}else{
			totalInvalidRows++;
			table += `
	      	<tr>
					<td colspan="5">Empleada/o No encontrado, (${list[i].c1})</td>
				</tr>
			`;
		}
	}
	contenedor.innerHTML = table;
	contenedor_botones.style.display = 'block';
	totalvalidrows.innerHTML = 'Validos: <b>'+totalValidRows+'</b>.';
	totalinvalidrows.innerHTML = 'Invalidos: <b>'+totalInvalidRows+'</b>.';
}

function filtrarNorepetidosPorCodigo(rows) {
   let norepeat = []; 
   for (let i = 0; i < rows.length; i++) {
      let data = norepeat.find(function(ele) {
         if (ele.c1 != null) {
            let date1 = new Date(ele.c3);
            let date2 = new Date(rows[i].c3);
            return /*ele.c0 === rows[i].c0 && */ele.c1 === rows[i].c1 && date1.valueOf() == date2.valueOf();
         }
      });
      if (!data) {
         norepeat.push(rows[i]);
      }
   }
   return norepeat;
}

// Arreglo de elementos no repetidos por sucursal, empleado y fecha;
function filtrarNorepetidos(rows) {
   let norepeat = []; 
   for (let i = 0; i < rows.length; i++) {
      let data = norepeat.find(function(ele) {
         if (ele.emp_id != null) {
            let date1 = new Date(ele.c3);
            let date2 = new Date(rows[i].c3);
            return /*ele.c0 === rows[i].c0 && */ele.c1 === rows[i].c1 && date1.valueOf() == date2.valueOf();
         }
      });
      if (!data) {
         norepeat.push(rows[i]);
      }
   }
   return norepeat;
}

function filtrarGruposPares(grupos) {
	let result = [];
	for(x of grupos){
		if(x.length%2 == 0){
			result.push(x);
		}
	}
	return result;
}

function unirGruposPares(grupospares){
	let result = [];
	for(grupo of grupospares){
		for(row of grupo){
			result.push(row);
		}
	}
	return result;
}

function filterObjectPorCodigo(obj, lista) {
	let result = [];
	for (let i = 0; i < lista.length; i++) {
		if (lista[i].c1 != null && typeof obj.c3 != 'undefined') {
			let fecha1 = obj.c3.split(new RegExp(separators.join('|'), 'g')).reverse().join('-');
			let fecha2 = lista[i].c3.split(new RegExp(separators.join('|'), 'g')).reverse().join('-');
			let date1 = new Date(fecha1);
			let date2 = new Date(fecha2);
			if (lista[i].c1 == obj.c1 && date1.valueOf() == date2.valueOf()) {
				result.push(lista[i]);
			}
		}
		// if (lista[i].c1 != null) {
		// 	let date1 = new Date(obj.c3);
		// 	let date2 = new Date(lista[i].c3);
		// 	if (/*list[i].c0 == obj.c0 && */lista[i].c1 == obj.c1 && date1.valueOf() == date2.valueOf()) {
		// 		result.push(lista[i]);
		// 	}
		// }
	}
	return result;
}

function agruparPorFecha_porCodigo(arraynorepeat, lista) {
	let grupos = [];
	for(x of arraynorepeat){
		let array = filterObjectPorCodigo(x, lista);
		grupos.push(array);
	}
	return grupos;
}

function filterObject(obj) {
	let result = [];
	for (let i = 0; i < list.length; i++) {
		if (list[i].emp_id != null) {
			let fecha1 = obj.c3.split(new RegExp(separators.join('|'), 'g')).reverse().join('-');
			let fecha2 = list[i].c3.split(new RegExp(separators.join('|'), 'g')).reverse().join('-');
			let date1 = new Date(fecha1);
			let date2 = new Date(fecha2);
			if (/*list[i].c0 == obj.c0 && */list[i].c1 == obj.c1 && date1.valueOf() == date2.valueOf()) {
				result.push(list[i]);
			}
		}
	}
	return result;
}

function agruparPorFecha_codigo(arraynorepeat) {
   let grupos = [];
   for(x of arraynorepeat){
      let array = filterObject(x);
      grupos.push(array);
   }
   return grupos;
}

function construirMarcaciones(grupos) {
   let marcaciones = [];
   for (let i = 0; i < grupos.length; i++) {
      let grupotemp = grupos[i];
      let marca = { sucursal: null, emp_cod: null, emp_id: null, fecha_entrada: null, fecha_salida: null, hora_entrada: null, hora_salida: null };
      for (let j = 0; j < grupotemp.length; j++) {
         if (j == 0) {
           /* marca.sucursal = grupotemp[j].c0;*/
            marca.emp_cod = grupotemp[j].c1;
            marca.emp_id = grupotemp[j].emp_id;
            marca.fecha_entrada = grupotemp[j].c3;
            marca.hora_entrada = grupotemp[j].c4;
         }
         if (j == grupotemp.length-1) {
            marca.fecha_salida = grupotemp[j].c3;
            marca.hora_salida = grupotemp[j].c4;
         }
      }
      marcaciones.push(marca);
   }
   return marcaciones;
}

function formatearMarcaciones() {
   let norepeats = filtrarNorepetidos(list);
   //console.log(norepeats);
   let grupos = agruparPorFecha_codigo(norepeats);
   //console.log(grupos);
   let marcaciones = construirMarcaciones(grupos);
   //console.log(marcaciones);
	guardarMarcaciones(marcaciones);
}

async function guardarMarcaciones(data) {
	if (confirm('Confirma que desea guardar los datos? Nota: Solo se guardaran las marcaciones válidas.')) {
	   wait.start();
		//let url = 'http://localhost/erp/marcacion/procesos/cargar_marcacion_txt/guardar';
		let url = window.location.base_url+'marcacion/procesos/guardar_marcaciones_txt';
	   let res = await fetch(url, {
	               method: 'POST', mode: 'no-cors', cache: 'no-cache',
	               headers: {'Content-Type': 'application/json'}, body: JSON.stringify(data)});
	   if (res) {
	   	//console.log(await res.text());
	   	list = await res.json();
	   	list.totalInvalidRows = totalInvalidRows;
	   	list.totalValidRows = totalValidRows;
	   	sessionStorage.informeMarcaciones = JSON.stringify(list);
	   	window.location.href = window.location.base_url+'marcacion/procesos/cargar_marcacion_txt/informe';
	   }else{
	       return 'Error: ${res.status}';
	   }
	}
}

