var pathArray = window.location.pathname.split('/');
var urlj = url_base_proyecto;
var usa_sectores = $("#usar_sectores").val();
$(document).ready(function () {

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        maxDate: 'Hoy'
    });

    $(".seleccion").select2();
    $(".numerico").numeric();
    $("#producto_art").attr('disabled', true); 
    $(".production").hide();
    var existencias_minimas = 0;

    //Remueve el option Sin registros
    $(".seleccion").each(function () {
        if ($(this).children().eq(1).text() == "Sin Registros") {
            $(this).children().eq(1).remove();
        }
    });

    $("#producto_art").select2({
        placeholder: "Buscar Producto", 
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/gestion_productos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                if (usa_sectores > 0 && !($("#sector_sxb1").val() > 0)) {
                    crear_alerta('error','Información Requerida','Por favor, especifique el sector de origen');
                    return false;
                }
                return {
                    producto: producto,
                    bodega: $("#bodega_bod").val(),
                    sector: $("#sector_sxb1").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#frm-traslado_producto").validate({
        ignore: "",
        rules: {
            bodega_bod: {required: true, min: 1},
            bodega_bod2: {required: true, min: 1},
            //sucursal_suc: {required: true, min: 1},
            //sucursal_suc2: {required: true, min: 1},
            traslado_tip: {required: true, min: 1},
            fec_traslado: {required: true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').text('Campo requerido');
            wait.close();
            ajustar_border();
        },
        submitHandler: function (form) {
            var productos_empaquetados = validar_paquetes();
            if (productos_empaquetados == true){
                form.submit();
            }   else {
                wait.close();
                crear_alerta("error", "Alerta", "Hay productos sin empaquetar.");
            }
        }
    });

    $("#traslado_tip").change(function(){
        if($(this).val() != ''){
            var autoriza = $(this).find('option:selected').data('autoriza');
            $("#txtAutoriza").val(autoriza);
        } else{
            $("#txtAutoriza").val(0);
        }
    });

    $('#guardar').live('click', function (event) {
        $("#redireccion").val(0);
    });

    $('#guardar_volver').live('click', function (event) {
        $("#redireccion").val(1);
    });

    // Envía el formulario
    $('.enviar_formulario').live('click', function (event) {
        var detalle_productos = $("#body_productos_dee").find("tr").length;
        if (detalle_productos != 0 && $("#frm-traslado_producto").valid() != false) {
            if (usa_sectores > 0) {
                valid_bodegas_sectores = ($("#bodega_bod").val() == $("#bodega_bod2").val() && !($("#sector_sxb2").val() > 0)) ? false : true;
                texto_mensaje = 'Debe especificar el sector de destino.' 
            } else {
                valid_bodegas_sectores = ($("#bodega_bod").val() != $("#bodega_bod2").val()) ? true : false;
                texto_mensaje = 'Las bodegas no pueden ser iguales.'
            }
            if (!valid_bodegas_sectores) {
                wait.close();
                $.pnotify({
                    type: 'error',
                    title: 'Aviso',
                    text: texto_mensaje,
                    icon: 'ui-icon ui-icon-info white',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
            } else {
                if ($("#requisicion_rxi").val() == "") {
                    $("#frm-traslado_producto").submit();
                } else {
                    if (validar_requisicion()) {
                        $("#frm-traslado_producto").submit();
                    }
                }
            }
        } else {
            if (!$("#frm-traslado_producto").valid()) {
                wait.close();
                crear_alerta("error", "Alerta", "Campos con * requeridos");
            } else if (detalle_productos == 0) {
                wait.close();
                $.pnotify({
                    type: 'error',
                    title: 'Aviso',
                    text: 'Debe agregar al menos un detalle.',
                    icon: 'ui-icon ui-icon-info white',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
            }
        }
    });

    $("#sucursal_suc").change(function () {
        var suc_id = $(this).val();        
        if(suc_id > 0){
            cargar_bodegar(suc_id, '');
            if ($("#requisicion_rxi").val() == "") {
                if ($("#body_productos_dee").find('tr').length > 0) {
                    eliminar_grid($(this).val(), 'sucursal_suc');
                }
                $("#select_sucursal_suc").val($(this).val());
            } else {
                $('.id_art_rxi').each(function () {
                    var id_art = $(this).val();
                    $("#cantidad_req_" + id_art).val(0);
                    $("#cantidad_req_" + id_art).next().text(0);
                });
            }
        }else{
            $.ajax({
                url: urlj + 'inventario/gestion_productos/ajax_bodegaxusuario',
                type: 'POST',
                dataType: 'text',                
                success: function (data) {
                    if ($.trim(data) != "") {
                        $("#bodega_bod").html(data);
                        $("#bodega_bod").select2();
                    }
                }
            });
        }        
    });

    $("#sucursal_suc2").change(function () {
        var suc_id = $(this).val();
        if(suc_id > 0){
            cargar_bodegar(suc_id, '2');
            if ($("#requisicion_rxi").val() == "") {
                if ($("#body_productos_dee").find('tr').length > 0) {
                    eliminar_grid($(this).val(), 'sucursal_suc2');
                }
                $("#select_sucursal_suc2").val($(this).val());
            }
        }else{
            $.ajax({
                url: urlj + 'inventario/gestion_productos/ajax_bodegaxusuario',
                type: 'POST',
                dataType: 'text',                
                success: function (data) {
                    if ($.trim(data) != "") {
                        $("#bodega_bod2").html(data);
                        $("#bodega_bod2").select2();
                    }
                }
            });
        }   
    });

    var cargar_bodegar = function (sucursal, select, requisicion = 0) {
        if ($.trim(sucursal) != "") {
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_bodegaxsucursal',
                type: 'POST',
                dataType: 'json',
                data: {sucursal: sucursal},
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $("#bodega_bod" + select).html(data.resp);
                        $("#bodega_bod" + select).select2();
                        if ($("#requisicion_rxi").val() == "") {
                            $("#sector_sxb" + select).html('<option value=""></option>');
                            $("#sector_sxb" + select).select2();
                        }
                        if (requisicion != 0) {
                            $("#bodega_bod").val(requisicion);
                            $("#bodega_bod").select2();
                            $("#bodega_select").val(requisicion);
                            $("#bodega_bod").trigger('change');
                            $("#bodega_bod, #sector_sxb2").select2("disable");
                            // $("#bodega_bod").select2("disable");  /////////////////////////// *****
                        }
                    } else {
                        $("#bodega_bod" + select).html('<option value=""></option>');
                        $("#bodega_bod" + select).select2();
                        $("#sector_sxb" + select).html('<option value=""></option>');
                        $("#sector_sxb" + select).select2();
                    }
                }
            });
        } else {
            $("#bodega_bod" + select).html('<option value=""></option>');
            $("#bodega_bod" + select).select2();
            $("#producto_art").html("<option value=''></option>");
            $("#producto_art").select2();
        }
    }/////////////////////////////////////////////////////////////////////////

    var cargar_sector = function (bod, sector) {
        if ($.trim(bod) != "") {
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_sector_bodega',
                type: 'POST',
                dataType: 'json',
                data: {bodega: bod},
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        ////////////////// *****
                        if($("#requisicion_rxi").val()<=0){
                            $("#sector_sxb" + sector).html(data.resp);
                            $("#sector_sxb" + sector).select2();
                        }
                        ////////////////// *****
                    } else {
                        ////////////////// *****
                        if($("#requisicion_rxi").val()<=0){
                            $("#sector_sxb" + sector).html('<option value=""></option>');
                            $("#sector_sxb" + sector).select2();
                        }
                        ////////////////// *****
                    }
                }
            });
        }
    }

    $('#bodega_bod2').change(function () {
        if ($.trim($(this).val()) != "") {
            bod = $(this).val();
            cargar_sector(bod, 2);
            if ($("#requisicion_rxi").val() == "") {
                if ($("#body_productos_dee").find('tr').length > 0) {
                    eliminar_grid($(this).val(), 'bodega_bod2');
                }
                $("#select_bodega_bod2").val($(this).val());
            }
        }else{
            if($("#requisicion_rxi").val()<=0){
                $("#sector_sxb2").html("<option value=''></option>");
                $("#sector_sxb2").select2();
            }

        }

    });

    function eliminar_grid(bodega, select) {
        if (bodega != $("#select_" + select).val()) {
            var arreglo = [bodega, select];
            alerta_confirm_ajax(borrar_grid2, arreglo, "Alerta confirmación", "Si cambia de bodega, se eliminaran los productos agregados.<br> ¿Éstas seguro que quieres cambiar de bodega?");
        }
        $('#' + select + ' option[value=' + $("#select_" + select).val() + ']').attr('selected', 'selected');
        $('#' + select).select2();
    }

    $('#bodega_bod').change(function () {
        if ($.trim($(this).val()) != "") {
            // Habilita el select ajax de busqueda de producto
            if ($("#requisicion_rxi").val() > 0) {
                $("#producto_art").attr('disabled', true);
            } else {
                $("#producto_art").attr('disabled', false);    
            }
            limpiarproducto();
            $("#producto_art").select2('data', null);
            if ($("#requisicion_rxi").val() == "") {
                if ($("#body_productos_dee").find('tr').length > 0) {
                    eliminar_grid($(this).val(), 'bodega_bod');
                }
                $("#select_bodega_bod").val($(this).val());
            } else {
                if ($(this).val() != $("#bodega_bod2").val()) {
                    $('.id_art_rxi').each(function () {
                        var id_art       = $(this).closest('tr'); //se cambio el $(this).val(); por el tr completo
                        var cantidad_cva = id_art.find("#rxi_mep" + $(this).val()).attr("cva");
                        var nombre       = id_art.find("#rxi_mep" + $(this).val()).parent().text();
                        var id_conv      = id_art.find("#rxi_mep" + $(this).val()).val();
                        var cantidad     = $(this).closest("tr").find(".validar_cantidad").attr("cant_def");
                        cargar_cantidades_rxi(id_art, cantidad, nombre, id_conv, cantidad_cva);
                    });
                    verificar_productos();
                } else {
                    $("#bodega_bod option").removeAttr("selected");
                    $("#bodega_bod").select2();
                    $.pnotify({
                        type: 'error',
                        title: 'Aviso',
                        text: 'Las bodegas no pueden ser iguales.',
                        icon: 'ui-icon ui-icon-info white',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }
            }
            bod = $(this).val();
            if ($("#requisicion_rxi").val() == "") {
                cargar_sector(bod, 1);
                cargar_producto();
            }
        } else {
            $("#sector_sxb1").html("<option value=''></option>");
            $("#sector_sxb1").select2();
            $("#producto_art").attr('disabled', true);
            $("#producto_art").select2('disable');
            limpiarproducto();
        }
    });    

    $('#sector_sxb1').change(function () {
        cargar_producto();        
    });

    function cargar_cantidades_rxi(art_id, cantidad, nombre, id_conv, cantidad_cva) {
        if($("#bodega_select").val()>0){
            bodega = $("#bodega_select").val();
        }else{
            bodega = $("#bodega_bod").val();
        }
        var articulo = art_id.find('.id_art_rxi').val();
        if ($.trim(bodega) != "") {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                // async: false,
                url: urlj + 'inventario/gestion_productos/get_cantidad_producto',
                data: {bodega: bodega, producto: articulo},
                beforeSend:function(){
                    wait.start();
                },
                success: function (data) {
                    // console.log(data);
                    //valor de la unidad de medida por defecto
                    var minimo = data.minimo;
                    var maximo = data.maximo;
                    var cva = data.cva;
                    //nombre de la unidad de medida por defecto
                    var nombre_cva = data.nombre_cva;
                    //cantidad existente en bodega
                    var cantidad_existente = data.cantidad;
                    cantidad_maxima = cantidad_existente;
                    //texto a mostrar al usuario para visualizar las cantidades en bodega
                    var texto_cantidad = cantidad_existente;
                    // Se verifica que se envie un dato
                    var cantidad_medida = cantidad * ( cva / cantidad_cva);
                    // console.log("ID que se le asigna " + id_conv);
                    // console.log("ID que se obtiene " + data.id_conv);
                    if (cantidad_existente != 0) {
                        //Se verifica que la unidad de medida registrada no sea igual a la defecto
                        //para realizar la conversión.
                        if (id_conv != data.id_conv){
                            /************************************************************/
                            var codigo_medida = get_codigo_cva(articulo, id_conv);
                            var obj = jQuery.parseJSON(codigo_medida);
                            var nombre2 = obj.nombre;
                            var codigo = obj.codigo;
                            var medida = obj.conversion;
                            var defecto = obj.defecto;
                            var defecto_nom = obj.defecto_nom;
                            cantidad_medida = cantidad * (medida / defecto);
                            /* var cantidad_maxima_conver = cantidad_maxima / (medida / defecto);
                                var conversion_def = (medida / defecto);
                                var decimales = ((cantidad_maxima_conver - parseInt(cantidad_maxima_conver)) * medida);
                                var decimal = "";
                                if (conversion_def != 1) {
                                    decimal = decimales.toFixed(0) + " " + defecto_nom;
                                }                               
                                var mostrar_saldo = number_format(cantidad_maxima_conver, $("#decimales").val(), ".", "") + " " + nombre + " " + decimal;
                            */
                            //convierte la unidad de medida
                            var cantidad_conversion = cantidad / cva;
                            // var cantidad_convertida = cantidad_existente / cantidad_conversion;
                            var cantidad_convertida = cantidad_existente * (defecto / medida);
                            //separa los decimales de la cantidad en bodega
                            var decimales = cantidad_convertida - parseInt(cantidad_convertida);
                            //convierte los decimales sobrantes en la unidad
                            var unidad_sobrante = decimales * medida;
                            //muestra las cantidades en bodega convertidos
                            texto_cantidad = parseInt(cantidad_convertida) + " " + nombre + " " + unidad_sobrante.toFixed(0) + " " + nombre_cva;
                        }
                    }
                    minimo = (minimo != "") ? minimo : 0;
                    if((cantidad_existente - cantidad) < minimo){
                        art_id.css('background-color','#f18383');
                        art_id.data('revision','1');
                        existencias_minimas = 1;
                    }
                    // $("#cantidad_req_" + articulo).closest('tr').css('background-color','#f18383');
                    art_id.find("#cantidad_req_" + articulo).val(cantidad_existente);
                    art_id.find("#cantidad_req_" + articulo).next().text(texto_cantidad);
                    art_id.find("#dee_conv" + articulo).val(cantidad_medida);
                    art_id.data('estado','1');
                },
                complete: function(){
                    wait.close();
                }
            });
        } else {
            art_id.find("#cantidad_req_" + articulo).val(0);
            art_id.find("#cantidad_req_" + articulo).next().text(0);
        }
    }

    function verificar_productos(){
        setTimeout(function(){
            var contador = 0;
            var existencias = 0;
            $("#body_productos_dee tr").each(function(){
                var revision = typeof $(this).data("revision") !== 'undefined' ?   $(this).data("revision") : 0;
                var estado = typeof $(this).data("estado") !== 'undefined' ?   $(this).data("estado") : 0;
                if(estado == 1){
                    contador++;
                }
                if(revision == 1){
                    existencias = 1;
                }
            })
            if(contador == $("#body_productos_dee tr").length){
                if(existencias == 1){
                    crear_alerta("error", "Alerta", "Producto con existencias mínimas");
                }
            } else{
                verificar_productos();
            }
        }, 500);
    }    

    function borrar_grid2(valores) {
        var valor = valores[0];
        var select = valores[1];
        $("#select_" + select).val(valor);
        $('#' + select + ' option[value=' + $("#select_" + select).val() + ']').attr('selected', 'selected');
        $('#' + select).select2();
        if (select == "bodega_bod") {
            cargar_sector(valor);
            cargar_producto();
        } else {
            $("#producto_art").html("<option value=''></option>");
            $("#medida_cva").html("<option value=''></option>");
            $("#producto_art, #medida_cva").select2();
        }

        if (select == "sucursal_suc") {
            cargar_bodegar($("#" + select).val(), '');
        } else if (select == "sucursal_suc2") {
            cargar_bodegar($("#" + select).val(), '2');
        }

        $("#body_productos_dee").find("tr").remove();
        $("#div_mostrar").css('display', 'none');
    }

    function borrar_grid(valor) {
        $("#select_bodega").val(valor);
        $('#bodega_bod option[value=' + $("#select_bodega").val() + ']').attr('selected', 'selected');
        $('#bodega_bod').select2();
        cargar_sector(valor);
        cargar_producto();
        $("#body_productos_dee").find("tr").remove();
        $("#div_mostrar").css('display', 'none');
    }//////////////////////////////**************************************************************

    /*======================================================================================================================================
     =											FILTRA LAS CARACTERISTICA PADRE/HIJO
     ========================================================================================================================================
     */
    var cargar_producto = function () {
        categoria_tia = $("select[id='categoria_tia']").last().val();
        bodega = $("#bodega_bod").val();
        sector = $("#sector_sxb1").val();
        $("#codigos").text('');
        $("#show_code").hide();
        if ($.trim(categoria_tia) != "") {
            $("#producto_art + .select2-container ").hide();
            $("#producto_art").select2('data', null);
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/obtener_productos_tia',
                data: {categoria: categoria_tia, tipo: 2, bodega: bodega, sector: sector},
                success: function (data) {
                    producto = data.producto;
                    $("#dtg_producto").html(producto);
                    $("#dtg_producto").show();
                    $("#dtg_producto").select2('destroy').select2();
                    $("#medida_cva").html("<option value=''></option>");
                    $("#medida_cva").select2('destroy').select2();
                    $('.dinamic').each(function (index, el) {
                        $(this).attr('nid', index);
                    });
                    if(data.bodega==1){
                        crear_alerta('info', 'Cargar productos', 'Debe seleccionar una bodega.');
                    }
                }
            });
        } else {
            wait.start();
            $("#producto_art + .select2-container").show();
            $("#medida_cva").html("<option value=''></option>");
            $("#dtg_producto").select2('destroy');
            $("#dtg_producto").hide();
            $("#dtg_producto option:selected").removeAttr('selected');
            wait.close();
        }
    }/////////////////////////////////////////////// NO HAY CAMBIO YA QUE EL SELECT DE LA CATEGORIA ESTA HIDDEN

    $("#categoria_tia").live('change', function () {
        menor = Number($(this).attr('nid')) + 2;
        $("#codigos").text('');
        $("#show_code").hide();
        $(".dinamic").each(function (index, el) {
            if ($(el).attr('nid') > menor) {
                $(el).parent('div').siblings('label').remove();
                $(el).siblings('select').remove();
                $(el).parent('div').parent('div').parent('div').parent('div').remove();
                $(el).remove();
            }
        });
        $(".plus:last").remove();
        $(this).next().append('<button class="btn plus">+</button>');
        ajustar_border();
        cargar_producto();
    });

    $(".plus").live('click', function (event) {
        event.preventDefault();
        $("#codigos").text('');
        $("#show_code").hide();
        categoria_tia = $("select[id='categoria_tia']").last().val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/obtener_productos_tia',
            data: {categoria: categoria_tia},
            success: function (data) {
                categoria = data.categoria;
                producto = data.producto;
                n_cat = data.cat_hijo;

                $i = 0;
                $(".plus").last().remove();
                if (n_cat == 1) {
                    numero = $('#div-categorias select').last().length + 1;

                    linea = $("#div-categorias").append('<div class="form-row row-fluid">'
                            + '<div class="span12">'
                            + '<div class="row-fluid">'
                            + '<label class="span4">Categoria:</label>'
                            + '<div class="span7 controls">'
                            + '<select id="categoria_tia" class="nostyle seleccion dinamic" name="filtro" style="width:100%" placeholder="Seleccione" onclick="ajustar_border();"></select>'
                            + '</div></div></div></div>');
                    linea2 = $('select[id="categoria_tia"]').last().html();
                    nueva = linea2.replace(/#/g, numero);
                    $('#div-categorias').append(nueva);
                    $('select[id="categoria_tia"]').last().html(categoria);
                    $('select[id="categoria_tia"]').last().select2();
                    //$("#producto_art").html(producto);
                } else {
                    //$("#producto_art").html(producto);
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se encontraron mas dependencias.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }

                $('.dinamic').each(function (index, el) {
                    $(this).attr('nid', index);
                });
                ajustar_border();
            }
        });
    });

    $("#slcLote").change(function(event) {
        lote = $("#slcLote").val();
        $("#lblCodigo").text(lote);
        
        if ( $("#bodega_bod").val() != ""  && $("#producto_art").val() != ""){
            get_productos_empaquetados($("#bodega_bod").val(), $("#producto_art").val(), $("#slcLote").val(), 2);
        } else {
            $("#txt_correlativo_lote").val("");
        }
    });

    /*====================================================================================================================================
     =											FILTRAR DEFECTO
     ======================================================================================================================================
     */

    $('#producto_art, #dtg_producto').change(function () {
        art = $(this).val();
        bodega = $("#bodega_bod").val();
        $("#producto_art").val(art);
        if ($.trim(art) != "") {
            //UNIDAD DE MEDIDA
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_medida_defecto',
                type: 'POST',
                dataType: 'json',
                data: {producto: art},
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $('#medida_cva_error').html('');
                        $("#medida_cva").html(data.resp);
                        $("#medida_cva").select2();
                    } else {
                        $("#medida_cva").html('<option value=""></option>');
                        $("#medida_cva").select2();
                    }
                }
            });
            // SI ES PARA PRODUCCION
            $.ajax({
                url: urlj + 'inventario/gestion_productos/ValidarProduccion',
                type: 'POST',
                dataType: 'json',
                data: {producto: art},
                success: function (data) {
                    var produccion =  data[0].art_produccion;             
                    if (produccion== 1) {
                        $(".production").show();
                        $("#slcProdest").val('');
                    } else {
                        $(".production").hide();
                        $("#slcProdest").val('');
                    }
                }
            });
            //CODIGOS ADICIONALES
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_codigos_pro',
                type: 'POST',
                dataType: 'json',
                data: {producto: art, bodega: bodega},
                success: function (data) {
                    if ($.trim(data) != "") {
                        $("#codigos").text(data.mostrar);
                        $("#hdnexistencia").val(data.existencia);
                        $("#slcLote").html(data.lotes);
                        $("#slcLote").select2();
                        if($.trim(data.mostrar) != ""){
                            $("#show_code").show();
                        }else{
                            $("#show_code").hide();
                        }
                        $("#txt_aplica_empaque").val(data.aplica_empaque);
                        if ( data.aplica_empaque > 0){
                            var cantidad_defecto = $("#cantidad_dee").data("cantidaddefecto");
                            $("#cantidad_dee").val(cantidad_defecto);
                        }else {
                            $("#cantidad_dee").val("");
                        }    
                    } else {
                        $("#txt_aplica_empaque").val('');
                        $("#codigos").text('');
                        $("#show_code").hide();
                        $("#hdnexistencia").val();
                        $("#cantidad_dee").val("");
                    }
                    ajustar_border();
                }
            });
        } else {
            $("#medida_cva").html('<option value=""></option>');
            $("#medida_cva").select2();
            $("#codigos").text('');
            $("#show_code").hide();
        }
        if ( $("#bodega_bod").val() != ""  && $("#producto_art").val() != ""){
            get_productos_empaquetados($("#bodega_bod").val(), $("#producto_art").val(), $("#slcLote").val(), 2);
        } else {
            $("#txt_correlativo_lote").val("");
        }
        ajustar_border();
    });

    /*====================================================================================================================================
     =												AGREGAR REQUISICION
     ======================================================================================================================================
     */

    $("#requisicion_rxi").change(function (event) {
        rxi = $(this).val();
        if ($.trim(rxi) != "") {
            $("#accion_grid").css("display", "none");
            $("#sector_sxb1, #categoria_tia, #producto_art, #medida_cva, #slcLote, #slcProdest, #producto_art").select2("disable");
            $("#cantidad_dee").attr("readonly", true)
           
            $("#body_productos_dee").html("");
            // existencias_minimas = 0;

            $.ajax({
                url: urlj + 'inventario/gestion_productos/cargar_requisicion/'+rxi+'/1',
                type: 'POST',
                dataType: 'json',
                data: {requisicion_rxi: rxi},
                beforeSend:function(){
                    wait.start();
                },
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $("#body_productos_dee").append(data.resp);
                        $("#div_mostrar").fadeIn(300);
                        cargar_bodegar(data.sucursal_id, '2', data.bodega);
                        $("#sucursal_suc").val(data.sucursal_id);
                        $("#sucursal_suc").select2();
                        $("#sucursal_suc, #sector_sxb1").select2("disable");
                        $('.id_art_rxi').each(function () {
                            var id_art       = $(this).closest('tr');
                            var cantidad_cva = id_art.find("#rxi_mep" + $(this).val()).attr("cva");
                            var nombre       = id_art.find("#rxi_mep" + $(this).val()).parent().text();
                            var id_conv      = id_art.find("#rxi_mep" + $(this).val()).val();
                            var cantidad     = $(this).closest("tr").find(".validar_cantidad").attr("cant_def");
                            // $("#seleccion"+id_art).select2();
                            // $("#lote"+id_art).select2();
                            cargar_cantidades_rxi(id_art, cantidad, nombre, id_conv, cantidad_cva);
                        })
                        verificar_productos();
                        $("#body_productos_dee select").select2();
                    }
                },
                complete: function(){
                    // console.log(existencias_minimas);
                    wait.close();
                }
            });
        } else {
            $("#accion_grid").css("display", "");
            $("#sector_sxb1, #categoria_tia, #producto_art, #medida_cva, #sucursal_suc, #bodega_bod2, #sector_sxb2").select2("enable");
            $("#cantidad_dee").attr("readonly", false)
            $("#add_producto_dee").css("display", "")
            $("#div_mostrar").css('display', 'none');
            $("#body_productos_dee").html("");
        }
    })

    $(".validar_cantidad").live('keypress, blur, change', function () {
        var tr = $(this).closest('tr');
        art_id = $(this).attr("id");
        cantidad = parseFloat($(this).val());  // 45
        cantidad_defecto = parseFloat($(this).attr("cant_def")); // 45
        var conversion_valor = $("#rxi_mep"+art_id).attr('cva');
        var cantidad_convertida = parseFloat(cantidad) * parseFloat(conversion_valor);
        var cantidad_convertida_defecto = parseFloat(cantidad_defecto) * parseFloat(conversion_valor);
        var cantidad_cva = $("#rxi_mep" + art_id).attr("cva");  // 1
        cantidad_maxima = parseFloat($("#cantidad_req_" + art_id).val() / cantidad_cva); /* 90/1 */
        if (!(cantidad <= cantidad_maxima) || !(cantidad <= cantidad_defecto)) {
            if ($("#bodega_bod").val() == "") {
                if (cantidad_defecto > cantidad_maxima) {
                    $(this).val(cantidad_maxima);
                }
                $.pnotify({
                    type: 'info',
                    title: 'Aviso',
                    text: 'No se a seleccionado la bodega.',
                    icon: 'ui-icon ui-icon-info',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
            } else {
                mensaje = 'La cantidad solicitada excede las existencias.';
                if (!(cantidad <= cantidad_defecto)) {
                    $(this).val(cantidad_defecto);
                    mensaje = 'La cantidad solicitada excede la peticion.'
                }
                if ((!(cantidad <= cantidad_maxima))) {
                    $(this).val(cantidad_maxima);
                }
                $.pnotify({
                    type: 'info',
                    title: 'Aviso',
                    text: mensaje,
                    icon: 'ui-icon ui-icon-info',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
            }
        } else {
            $("#dee_conv" + art_id).val(cantidad_convertida);
        }
    });

    $(".select_lote").live('change', function () {
        var cantidad_req = 0;
        var cantidad_req_def = 0;
        var id = $(this).attr('valor');
        var valor =$("#lote"+id).val();
        if(valor!=''){
            art_id = id;
            var cantidad_defecto = parseFloat($("#"+id).attr("cant_def"));
            var cantidad = $("#rxi_mep" + art_id).attr("cva");
            var max = $("#lote"+id+" option:selected").data('cant');
            var cantidad_maxima = parseFloat(max / cantidad);
            var decimal = $("#decimales").val();
            if (!(cantidad <= cantidad_maxima)) {
                cantidad_req = 1;
                $('#'+id).val(cantidad_maxima.toFixed(decimal));
            } else if (!(cantidad <= cantidad_defecto)) {
                cantidad_req_def = 1;
                $('#'+id).val(cantidad_defecto.toFixed(decimal));
            }
            if (cantidad_req == 1) {
                $.pnotify({
                    type: 'info',
                    title: 'Aviso',
                    text: 'La cantidad solicitada excede las existencias.',
                    icon: 'ui-icon ui-icon-info',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
                return false;
            }
            if (cantidad_req_def == 1) {
                $.pnotify({
                    type: 'info',
                    title: 'Aviso',
                    text: 'La cantidad solicitada excede la peticion.',
                    icon: 'ui-icon ui-icon-info',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
                return false;
            }
            return true;            
        }       
    });  

    function validar_requisicion() {
        var cantidad_req = 0;
        var cantidad_req_def = 0;
        $('.validar_cantidad').each(function () {
            art_id = $(this).attr("id");
            cantidad_sol = parseFloat($(this).val());
            cantidad_defecto = parseFloat($(this).attr("cant_def"));
            var cantidad = $("#rxi_mep" + art_id).attr("cva");
            var decimal = $("#decimales").val();

            if($("#lote"+art_id).val()!=''){
                disponible = $("#lote"+art_id+ " option:selected").data('cant');
            }else{
                disponible = $("#cantidad_req_" + art_id).val();
            }
            
            cantidad_maxima = parseFloat(disponible / cantidad);

            if (!(cantidad_sol <= cantidad_maxima)) {
                $('#'+art_id).val(cantidad_maxima.toFixed(decimal));
                cantidad_req = 1;
            } else if (!(cantidad_sol <= cantidad_defecto)) {
                $('#'+art_id).val(cantidad_defecto.toFixed(decimal));
                cantidad_req_def = 1;
            }
        });
        if (cantidad_req == 1) {
            $.pnotify({
                type: 'info',
                title: 'Aviso',
                text: 'La cantidad solicitada excede las existencias.',
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
            return false;
        }
        if (cantidad_req_def == 1) {
            $.pnotify({
                type: 'info',
                title: 'Aviso',
                text: 'La cantidad solicitada excede la peticion.',
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
            return false;
        }
        return true;
    }
    /*====================================================================================================================================
     =											AGREGA LOS CAMPOS A LA GRID
     ======================================================================================================================================
     */

    function get_codigo_cva(art_id, cva_id) {
        var respuesta = $.ajax({
            url: urlj + 'inventario/gestion_productos/get_codigo_cva',
            type: 'POST',
            async: false,
            dataType: 'json',
            data: {producto: art_id, medida: cva_id},
            success: function (data) {
                return data;
            }
        }).responseText;
        return respuesta;
    }

    function get_sectores(bod_id, sxb_id) {
        var respuesta = $.ajax({
            url: urlj + 'inventario/gestion_productos/cargar_sector_traslado_selected',
            type: 'POST',
            async: false,
            dataType: 'json',
            data: {bodega: bod_id, sector: sxb_id},
            success: function (data) {
                return data;
            }
        }).responseText;
        return respuesta;
    }

    $('#add_producto_dee').live('click', function (event) {
        event.preventDefault();
        if($("#dtg_producto").val()>0){ 
            var producto_art = $("#dtg_producto").val().trim();
            var producto_art_select = $("#dtg_producto option:selected").text();
            var cantidad_maxima =  $("#dtg_producto option:selected").attr("cant");
        }else{
            var producto_art = $("#producto_art").val();
            var producto_art_select = $("#producto_art").next('div').text();
            var cantidad_maxima =  $("#hdnexistencia").val();
        }
        var cantidad_lote   = $("#txt_correlativo_lote").val();
        var aplica_empaque  = $("#txt_aplica_empaque").val();
        var lote            = ($("#slcLote").val() > 0) ? $("#slcLote").val() : 0;
        var cant_lote       = $("#slcLote option:selected").data('cant');
        var medida_cva      = $("#medida_cva").val().trim();
        var medida_cva_select = $("#medida_cva option:selected").text();
        var cantidad_dee = $("#cantidad_dee").val();
        var sector_uno = $("#sector_sxb1").val();
        var sector_dos = $("#sector_sxb2").val();
        var bodega_bod = $("#bodega_bod").val();
        var bodega_bod2 = $("#bodega_bod2").val();
        var text_producto_dest = $.trim($("#slcProdest").next('div').text());
        var producto_dest = $.trim($("#slcProdest").val());
        ///var precio_dee = $("#precio_dee").val();
        //var fecha_dee = $("#fecha_dee").val();
        //variables para el mensaje
        var mensaje = "";   
        var type_msg = "";
        var validado_sector = true;
        if (usa_sectores > 0) {
            validado_sector = (sector_uno > 0 && sector_dos > 0) ? true : false;
        }
        if (producto_art != "" && medida_cva != "" && cantidad_dee != "" && bodega_bod2 != "" && validado_sector) {
            type_msg = "error";
            valid_bodegas_sectores = false;
            if (usa_sectores > 0) {
                valid_bodegas_sectores = (bodega_bod == bodega_bod2 && sector_uno == sector_dos) ? false : true;
            } else {
                valid_bodegas_sectores = (bodega_bod != bodega_bod2) ? true : false;
            }
            if ( valid_bodegas_sectores ) {
                if (cantidad_dee > 0) {
                    if (($("#producto_art" + producto_art + lote).length <= 0)) {
                        var sectores_sxb = get_sectores(bodega_bod2, sector_dos);
                        var obj_sxb = jQuery.parseJSON(sectores_sxb);
                        var select_sxb = obj_sxb.resp;

                        var codigo_medida = get_codigo_cva(producto_art, medida_cva);
                        var obj = jQuery.parseJSON(codigo_medida);
                        var nombre = obj.nombre;
                        var codigo = obj.codigo;
                        var medida = obj.conversion;
                        var defecto = obj.defecto;
                        var defecto_nom = obj.defecto_nom;
                        var cantidad_medida = cantidad_dee * (medida / defecto);
                        var cantidad_maxima_conver = cantidad_maxima / (medida / defecto);
                        var conversion_def = (medida / defecto);
                        var decimales = ((cantidad_maxima_conver - parseInt(cantidad_maxima_conver)) * medida);
                        var decimal = "";
                        if (conversion_def != 1) {
                            decimal = decimales.toFixed(0) + " " + defecto_nom;
                        }
                        var mostrar_saldo = number_format(cantidad_maxima_conver, $("#decimales").val(), ".", "") + " " + medida_cva_select + " " + decimal;

                        if ( (cantidad_medida <= cantidad_maxima && lote == 0) || (lote != 0 && cantidad_medida <= cant_lote)) {
                            id_correlativo = $("#contador_producto_dee").val(); //crear un id unico para anexos de documentos
                            id_producto_art = '<input type="hidden" id="producto_art' + producto_art + lote + '" name="producto_art[]" value="' + producto_art + '" />';
                            codigo_lote = '<input type="hidden" name="codigo_lote[]" value="' + lote + '" />';
                            id_medida_cva = '<input type="hidden" name="medida_cva[]" value="' + medida_cva + '" />';
                            id_cantidad_maxima = '<input type="hidden" name="cantidad_maxima[]" value="' + cantidad_maxima + '" />';
                            id_cantidad_dee = '<input class="txt_cantidad_enviar" type="hidden" id="detalle_cantidad_'+producto_art+'" name="cantidad_dee[]" value="' + cantidad_medida + '" />';
                            if($.trim(producto_dest) == ''){
                                producto_dest = producto_art;
                                text_producto_dest = codigo+' - '+nombre;
                            }

                            id_producto_dest = '<input type="hidden" name="producto_destino[]" value="' + producto_dest + '" />';
                            //id_precio_dee = '<input type="hidden" name="precio_dee[]" value="'+precio_dee+'" />';
                            //id_costo_total = '<input type="hidden" class="costos_produc" name="costo_total[]" value="'+costo_total+'" />';
                            //id_fecha_dee = '<input type="hidden" name="fecha_dee[]" value="'+fecha_dee+'" />';
                            // original eliminar = '<a id="del_doc" valor="' + id_correlativo + '" thead="div_mostrar" tbody="body_productos_dee" class="btn btn-danger btn-mini minia-icon-trashcan white">Eliminar</a>';

                            eliminar = '<a id="del_doc" style="margin-right: 12px;font-size:15px;cursor:pointer;" valor="' + id_correlativo + '" thead="div_mostrar" tbody="body_productos_dee">';
                            eliminar += '<span class="icon16 icomoon-icon-remove"></span>Eliminar';
                            eliminar += '</a>';

                            empaque = '<a  class="fancy_empaque" id="empaque_'+producto_art+'" style="margin-right: 12px;font-size:15px;cursor:pointer;" href="#div_empaque"  data-articulo="' + producto_art + '" >';
                            empaque += '<span class="icon16 icomoon-icon-box"></span>Empaque';
                            empaque += '</a>'; 

                            var acciones_drop = '';
                            acciones_drop += '<div class="tools">';
                            acciones_drop +=    '<div class="btn-group">';
                            acciones_drop +=        '<button type="button" class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>';
                            acciones_drop +=        '<button type="button" class="btn dropdown-toggle" data-toggle="dropdown">';
                            acciones_drop +=            '<span class="caret"></span>';
                            acciones_drop +=        '</button>';
                            acciones_drop +=        '<ul class="dropdown-menu">';

                            //drakefo
                            if ( aplica_empaque == 1){
                                acciones_drop +=            '<li style="text-align:left;"> ';
                                acciones_drop +=                empaque;
                                acciones_drop +=            '</li>';
                                var tabla_empaque = cantidad_lote;
                                cantidad_detalle = '<label id="lbl_detalle_cantidad_'+producto_art+'">0.00 ('+ number_format(cantidad_dee,$("#decimales").val(), ".", "")+')</label>';
                            } else{
                                cantidad_detalle = '<label id="lbl_detalle_cantidad_'+producto_art+'">'+ number_format(cantidad_dee,$("#decimales").val(), ".", "")+'</label>';    
                            }

                            acciones_drop +=            '<li style="text-align:left;"> ';
                            acciones_drop +=                eliminar;
                            acciones_drop +=            '</li>';
                            acciones_drop +=        '</ul>';
                            acciones_drop +=    '</div>';
                            acciones_drop += '</div>';

                            var td_first = codigo + tabla_empaque;
                            //siempre llegaba tabla_empaque como undefined, ais que hacemos split para eliminar si en dado caso viene indefinido
                            td_first = td_first.split("undefined");
                            
                            var hdn_sctr_sale = (usa_sectores > 0) ? '<input type="hidden" name="sxb_salida[]" id="sxbsalida' + producto_art + lote + '" value="' + sector_uno + '">' : '';
                            var hidder_sector = (usa_sectores > 0) ? '<input type="hidden" name="sector_sxb[]" id="sectorsxb' + producto_art + lote + '" value="' + sector_dos + '"></td>' : '</td>' ;
                            var fila = '<tr id="filadiv_mostrar' + id_correlativo + '" data-producto="'+ producto_art +'">';
                            fila += '<td>' + td_first[0] +'</td>';
                            fila += '<td>' + id_producto_art + nombre + '</td>';
                            // fila += '<td>' + id_producto_art + hdn_sctr_sale + nombre + '</td>';  /////////////////////////////////////////////////////// *****
                            fila += '<td>' + codigo_lote + lote + '</td>';
                            fila += '<td>' + id_medida_cva + medida_cva_select + '</td>';
                            fila += '<td>' + id_cantidad_maxima + mostrar_saldo + '</td>';
                            fila += '<td class="cantidad_enviar">' + id_cantidad_dee + cantidad_detalle + '</td>';
                            fila += '<td>' + id_producto_dest + text_producto_dest + hidder_sector;
                            fila += '<td>' + acciones_drop + '</td>';
                            fila += '</tr>';

                            $("#body_productos_dee").append(fila);
                            //'<td><</td>'  - fila += td_ocultar_sector + '<select >' + select_sxb + '</select></td>';
                            //'<td>$'+ id_precio_dee + precio_dee + '</td>' +
                            //'<td>$'+ id_costo_total + costo_total + '</td>' +
                            //'<td>'+ id_fecha_dee + fecha_dee + '</td>' +
                                    
                            $("#div_mostrar").fadeIn(300);
                            $("#seleccion" + producto_art+lote).select2();
                            var NC = parseInt($("#contador_producto_dee").val()) + 1;
                            $("#contador_producto_dee").val(NC);

                            $(".dinamic").each(function (index, el) {
                                if ($(el).attr('nid') > 1) {
                                    $(el).parent('div').siblings('label').remove();
                                    $(el).siblings('select').remove();
                                    $(el).parent('div').parent('div').parent('div').parent('div').remove();
                                    $(el).remove();
                                }
                            });

                            // $("#sector_sxb1 option").removeAttr("selected"); ///////////////////////////////// *****
                            // $("#sector_sxb1").select2();  //////////////////////////////////////////////////// *****

                            $("#producto_art").html("<option value=''></option>");
                            $("#medida_cva").html("<option value=''></option>");

                            $("#categoria_tia option").removeAttr("selected");
                            $("#categoria_tia").select2();

                            $("#dtg_producto option").removeAttr("selected");
                            $("#dtg_producto").select2('destroy');
                            $("#dtg_producto").hide();

                            $("#producto_art").select2('data', null);

                            $("#medida_cva option").removeAttr("selected");
                            $("#medida_cva").select2();

                            $("#cantidad_dee").val("");

                            $("#producto_art_error").text('');
                            $("#medida_cva_error").text('');
                            $("#cantidad_dee_error").text('');
                            $("#codigos").text('');
                            $("#show_code").hide();
                            ajustar_border();
                        } else {
                            mensaje = "La cantidad solicitada excede las existencias";
                        }
                    } else {
                        mensaje = "El detalle ya ha sido agregado";
                    }
                } else {
                    if (cantidad_dee <= 0) {
                        $("#cantidad_dee_error").text('La cantidad debe ser mayor a 0');
                    }
                    ajustar_border();
                }
            } else {
                if (usa_sectores > 0) {
                    if (bodega_bod == bodega_bod2 && sector_uno == sector_dos) {
                        $("#sector_sxb2_error").text('Los Sectores no pueden ser iguales');
                    }
                } else {
                    if (bodega_bod == bodega_bod2) {
                        $("#bodega_bod2_error").text('Las Bodegas no pueden ser iguales');
                    }
                }
                ajustar_border();
            }
        } else {
            type_msg = "error";
            mensaje = "Los campos con * requeridos";
            if (producto_art == "" && medida_cva == "" && cantidad_dee == "" && bodega_bod2 == "") {
                $("#producto_art_error").text('Campo requerido');
                $("#medida_cva_error").text('Campo requerido');
                $("#cantidad_dee_error").text('Campo requerido');
                $("#bodega_bod2_error").text('Campo requerido');
                if (!validado_sector) {
                    if (!(sector_uno > 0)) {
                        $("#sector_sxb1_error").text('Campo requerido');
                    }
                    if (!(sector_dos > 0)) {
                        $("#sector_sxb2_error").text('Campo requerido');
                    }
                }
            } else if (producto_art == "") {
                mensaje = "El producto es requerido";
                $("#producto_art_error").text('Campo requerido');
                if (medida_cva == "") {
                    $("#medida_cva_error").text('Campo requerido');
                }
                if (cantidad_dee == "") {
                    $("#cantidad_dee_error").text('Campo requerido');
                }
                if (!validado_sector) {
                    if (!(sector_uno > 0)) {
                        $("#sector_sxb1_error").text('Campo requerido');
                    }
                    if (!(sector_dos > 0)) {
                        $("#sector_sxb2_error").text('Campo requerido');
                    }
                }
            } else if (medida_cva == "") {
                mensaje = "La unidad de medida es requerido";
                $("#medida_cva_error").text('Campo requerido');
                if (producto_art == "") {
                    $("#producto_art_error").text('Campo requerido');
                }
                if (cantidad_dee == "") {
                    $("#cantidad_dee_error").text('Campo requerido');
                }
                if (!validado_sector) {
                    if (!(sector_uno > 0)) {
                        $("#sector_sxb1_error").text('Campo requerido');
                    }
                    if (!(sector_dos > 0)) {
                        $("#sector_sxb2_error").text('Campo requerido');
                    }
                }
            } else if (!validado_sector) {
                if (!(sector_uno > 0)) {
                    $("#sector_sxb1_error").text('Campo requerido');
                }
                if (!(sector_dos > 0)) {
                    $("#sector_sxb2_error").text('Campo requerido');
                }
            }
            ajustar_border();
        }
        if (mensaje != "") {
            $.pnotify({
                type: type_msg,
                title: 'Informaci&oacute;n',
                text: mensaje,
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
        }
    });

    $('#del_doc').live('click', function (event) {
        event.preventDefault();
        //obtenemos los valores del boton de eliminar para eliminar la fila
        var id_fila = $(this).attr("valor");
        var id_head = $(this).attr("thead");
        var id_body = $(this).attr("tbody");
        $("#fila" + id_head + id_fila).remove();
        if ($('#' + id_body).find('tr').length == 0) {
            $("#" + id_head).css('display', 'none');
            //$("#"+id_head).css('display','none');
        }
    });

    $("#slcProdest").select2({
        placeholder:'Buscar productos',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'inventario/gestion_productos/consultar_productos',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                   producto: producto
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.art_id,
                        'text': (item.art_codigo+' - '+item.art_nombre)
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    $("#slcProdest").change(function(){
        var id = $('#slcProdest').val();
        var medida = $('#medida_cva').val();
        var lote = $("#slcLote").val();
        if($.trim(medida) != "" && $.trim(id) != ""){
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj+'inventario/gestion_productos/verificar_medida',
                data: {id:id, medida:medida},
                success: function(data){
                    if(data.resp != 1){
                        reset_bscAjax();
                        //$("#bsc_ajax .select2-search-choice-close").trigger("mousedown");
                        crear_alerta("error", "Alerta", "La unidad de medida del producto no coincide con el producto destino");
                    }
                }
            })
        } else{
            reset_bscAjax();
            crear_alerta("error", "Alerta", "Unidad de medida requerida");
        }        
    });

    function reset_bscAjax(){
        //select2-choice select2-default
        //$("#bsc_ajax .select2-search-choice-close").trigger("mousedown");
        $("#slcProdest").val('');
        $("#slcProdest").select2({
            placeholder:'Buscar productos',
            minimumInputLength: 3,
            ajax: {
                url:urlj+'inventario/gestion_productos/consultar_productos',
                dataType: 'json',
                type: 'POST',
                delay: 250,
                data: function (producto) {
                    return {
                       producto: producto
                    };
                },
                results: function (data) {
                    var myResults = [];
                    $.each(data, function (index, item) {
                        myResults.push({
                            'id': item.art_id,
                            'text': (item.art_codigo+' - '+item.art_nombre)
                        });
                    });
                    return {
                        results: myResults
                    };
                }
            }
        });
    }

});

function limpiarproducto(){
    $("#producto_art").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/gestion_productos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                if (usa_sectores > 0 && !($("#sector_sxb1").val() > 0)) {
                    crear_alerta('error','Información Requerida','Por favor, especifique el sector de origen');
                    return false;
                }
                return {
                    producto: producto,
                    bodega: $("#bodega_bod").val(),
                    sector: $("#sector_sxb1").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });
}
 
$(".fancy_empaque").fancybox({
    width: '80%',
    height: 'auto',
    autoSize: false,
    closeClick: false,
    type: 'inline',
    closeBtn : false,
    keys : {
        close  : null
    },
    helpers: {
        overlay: { closeClick: false } //Disable click outside event
    },
    beforeLoad: function () {            
        var id          = $(this.element[0]).data("articulo");
        var tabla       = $("#tb_empaque_"+id).html();
        var tfoot       = $("#tf_empaque_"+id).html();
        
        var correlativo = $("#txt_contador_empaque_"+id).val();
        var tabla_carac = "#caracTable_" + id + "_" + correlativo;
        
        $("#tbody_empaque_modal").append(tabla);
        $("#tfoot_empaque_modal").append(tfoot);
    
        $("#txt_modal_id").val(id);
        $("#chk_empaque").val(id);
        
        //ocultar los totales
        $("#tfoot_empaque_modal input").hide();
        $("#tfoot_empaque_modal input:last").show();
    },
    beforeClose: function () {
        $("#chk_empaque").val("");
        $("#tbody_empaque_modal").html("");
        $("#tfoot_empaque_modal").html("");            
       
        $("#txt_modal_id").val("");
        $("#txt_empaque_unidades_modal").val("");
        $("#txt_empaque_peso_n_modal").val("");
        $("#txt_empaque_peso_b_modal").val("");

    }
});

function get_productos_empaquetados(bodega,articulo,lote,tipo){
    $.ajax({
        url: urlj + 'inventario/gestion_productos/get_productos_empaquetados',
        type: 'POST',
        dataType: 'json',
        data: {bodega: bodega, articulo: articulo,lote: lote, tipo: tipo},
        success: function (data) {
            $("#txt_correlativo_lote").val(data);
        }
    });
}


$("#table_empaque").on('click', '.chk_empaque', function () {
    var id = $(this).data( "id");  
    if ($(this).is(':checked')) { 
        $(this).attr('checked', true);
    } else {
        $(this).attr('checked', false);
    }
    sumar_empaques(id); 
});


$("body").on('click', '#chk_empaque', function () {
    var id = $(this).val();
    if ($(this).is(':checked')) { 
        $('#table_empaque .chk_empaque_'+id).each(function() {
            $(this).attr('checked', true);
        });
    } else {
        $('#table_empaque .chk_empaque_'+id).each(function() {
            $(this).attr('checked', false);
        });
    }
    sumar_empaques(id);
});

function sumar_empaques(id){
    suma = 0 ;
    $('#table_empaque .chk_empaque_'+id).each(function() {
        if ($(this).is(':checked')) { 
            suma =  suma + parseFloat($(this).data( "cantidad"));
        }
    });
    var total_unidades  = contar_columnas("#table_empaque .unidades_empaque_"+id) ;
    var total_bruto     = contar_columnas("#table_empaque .bruto_empaque_"+id) ;
    var total_neto      = contar_columnas("#table_empaque .neto_empaque_"+id) ;
    $("#table_empaque #foot_unidades_empaque_"+id).attr("value",total_unidades);
    $("#table_empaque #foot_neto_empaque_"+id).attr("value",total_neto);
    $("#table_empaque #foot_bruto_empaque_"+id).attr("value",total_bruto);
    $("#table_empaque #foot_envio_empaque_"+id).attr("value",suma);
}

$("#table_empaque").on('click', '.chk_empaque', function () {
    var id = $(this).data( "id");  
    if ($(this).is(':checked')) { 
        $(this).attr('checked', true);
    } else {
        $(this).attr('checked', false);
    }
    sumar_empaques(id); 
});


$("body").on('click', '#guardar_empaque_modal', function () {
    event.preventDefault();
    var new_tabla   = $("#table_empaque #tbody_empaque_modal").html();
    var new_foot    = $("#tfoot_empaque_modal").html();

    var id          = $("#txt_modal_id").val();
    var total_neto  = $("#table_empaque #foot_envio_empaque_"+id).val();


    $("#tb_empaque_"+id).html(new_tabla);
    $("#tbody_empaque_modal").html("");

    $("#tf_empaque_"+id).html(new_foot);
    $("#tfoot_empaque_modal").html("");
    $("#txt_modal_id").val("");
    $("#txt_empaque_unidades_modal").val("");
    $("#txt_empaque_peso_n_modal").val("");
    $("#txt_empaque_peso_b_modal").val("");

    //actualizar fila

    var resultado_anterior  = $("#lbl_detalle_cantidad_"+id).text();
    var posicion            = resultado_anterior.indexOf("(");
    
    $("#detalle_cantidad_"+id).val(total_neto);

    $("#lbl_detalle_cantidad_"+id).text(total_neto + " " + resultado_anterior.substr(posicion));
    
    $.fancybox.close();
});

function contar_columnas(clase) {
    var calculo = 0;
    $( clase ).each(function( index ) {
        var valor = $(this).val();
        if (valor != "") {
            calculo = calculo + parseFloat(valor);
        }
    });
    return number_format(calculo,2,".","");
}

function validar_paquetes(){
    var resultado = true;
    $( "#datagried .modal_foot_total_empaque" ).each(function( index ) {
        var valor = $(this).val();
        if (valor == 0 || valor == "") {
            resultado = false;
            return false;
        }
    });
    return resultado;
}

/*
314 bodega1.onchange
if (usa_sectores > 0 && $("#sector_sxb1").val() > 0) {
    //disable-false
} else {
    if (usa_sectores > 0) {
        $("#producto_art").attr('disabled', true);
    } else {
        $("#producto_art").attr('disabled', false);
    }
}
364 sector1.onchange
if ($(this).val() > 0) {
    $("#producto_art").attr('disabled', false);
    $("#producto_art").select2('enable');
    + cargar producto
} else {
    $("#producto_art").attr('disabled', true);
    $("#producto_art").select2('disable');
}
*/