jQuery(document).ready(function($) {

    $("#ApS").hide();

    $("#aplicaSerie").iButton({
        labelOn: "SI",
        labelOff: "NO"
    });
    $("#logicaSeries, #tablaSeries, #ver_S").hide();
    $("#cantidad").addClass('soloNumeros');
    $("#aplicaSerie").change(function(event) {
        if ($(this).attr('checked') == 'checked') {
            $("#logicaSeries").show('slow');
        } else {
            $("#logicaSeries").hide('slow');
            $("#nombreSerie, #inicioCorrelativo, #finCorrelativo").removeClass('error');
            $("#v_nombreSerie, #v_inicioCorrelativo, #v_finCorrelativo").text('');
        }
    });

    //VALIDAR EL INGRESO DE LOS CORRRELATIVOS CORRECTAMENTE
    $("#inicioCorrelativo").blur(function(event) {
        if ($(this).val().trim() == '') {
            $("#finCorrelativo").val('');
            //  $("#finCorrelativo").attr('readonly', 'readonly');
        }
    });

   
    $("#cantidad, #inicioCorrelativo").keyup(function(event) {

        if ($('#cantidad').val().trim() != '' && $('#cantidad').val() > 0 && $("#inicioCorrelativo").val().trim() != '' && $("#inicioCorrelativo").val() >= 0) {
            var inicio = $("#inicioCorrelativo").val();
            var Cfinal = parseInt(inicio) + parseInt($('#cantidad').val());
            $("#finCorrelativo").val((Cfinal - 1));
            if ($('#finCorrelativo').val() == '') {
                $('#v_finCorrelativo').text('Campo requerido');
                $('#finCorrelativo').addClass('error');
            }
            $('#v_finCorrelativo').text('');
            $('#finCorrelativo').removeClass('error');
        } else {
            $("#finCorrelativo").val('');

        }
    });

});


function verificarAplicaSerie(id_p) {
    if (id_p > 0 && id_p != null && id_p != '') {
        $.ajax({
            url: window.gSateliteWhite.baseUrl('inventario/gestion_productos/aplicaSerieProducto'),
            type: 'post',
            dataType: 'json',
            data: {
                'producto': id_p
            },
            success: function(data) {
                if (data.aplica == true) { //aplica
                    $("#logicaSeries").show('slow');
                    $("#aplicaSerie").attr('checked', 'checked');
                } else { //no aplica
                    $("#logicaSeries").hide('slow');
                    $("#aplicaSerie").removeAttr('checked');
                    limpiarSerie();
                }
            }
        });
    } else {
        $("#logicaSeries").hide('slow');
        $("#aplicaSerie").removeAttr('checked');
        limpiarSerie();
    }
}

function limpiarSerie() {
    /* $("#aplicaSerie").removeAttr('checked');
       $("#aplicaSerie").iButton('destroy');
       $("#aplicaSerie").iButton({labelOn: "SI", labelOff: "NO"}); 
       $("#logicaSeries").hide('slow');
      */
    $("#nombreSerie, #inicioCorrelativo, #finCorrelativo").val('');
    $("#nombreSerie, #inicioCorrelativo, #finCorrelativo").removeClass('error');
    $("#v_nombreSerie, #v_inicioCorrelativo, #v_finCorrelativo").text('');
}

function validarSerie() {
    if ($('#aplicaSerie').attr('checked') == 'checked') {
        validarNombreSerieUnico();
        var IdP = $("#productos").val();
        if ($.trim($("#nombreSerie").val()) != "" && $("#inicioCorrelativo").val() != "" && $("#finCorrelativo").val() != "") {
            if (existeSerieProducto(IdP, $.trim($("#nombreSerie").val()))) {
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }

    } else {
        return true;
    }
}

function camposRequeridosSerie() {
    var IdP = $("#productos").val();
    if ($.trim($("#nombreSerie").val()) == '') {
        $("#nombreSerie").addClass('error');
        $("#v_nombreSerie").text('campo requerido');
    } else {
        $("#v_nombreSerie").text('');
    }
    if ($.trim($("#nombreSerie").val()) != '' && existeSerieProducto(IdP, $.trim($("#nombreSerie").val()))) {
        $("#nombreSerie").addClass('error');
        $("#v_nombreSerie").text('La serie ya existe para dicho producto');
    } else {
        $("#v_nombreSerie").text('');
    }
    if ($("#inicioCorrelativo").val() == '') {
        $("#inicioCorrelativo").addClass('error');
        $("#v_inicioCorrelativo").text('campo requerido');
    } else {
        $("#v_inicioCorrelativo").text('');
    }
    if ($("#finCorrelativo").val() == '') {
        $("#finCorrelativo").addClass('error');
        $("#v_finCorrelativo").text('campo requerido');
    } else {
        $("#v_finCorrelativo").text('');
    }
}

function guardarSeries() {
    var NombreSerie = $.trim($("#nombreSerie").val());
    var CantidaProd = $.trim($("#cantidad").val());
    var InicioCorrelativo = $("#inicioCorrelativo").val();
    var FinCorrelativo = $("#finCorrelativo").val();
    var IdProducto = $("#productos").val();
    var TextProducto = $("#productos option:selected").text();
    var idTr = $("#datagried tbody tr").length + 'F' + $("#productos").val() + 'S'; //id unico del tr (de la tabla padre)
    var trSerie = '<tr id="' + idTr + '" ><td><input type="hidden" value="'+idTr+'" name="ids_filaS[]" />' + TextProducto;
    trSerie += '<input type="hidden" id="producto_serie" name="producto_serie[]" value="' + IdProducto + '" /></td>';
    trSerie += '<td>' + NombreSerie + '<input type="hidden" id="nombre_serie" name="nombre_serie[]" value="' + NombreSerie + '" /></td>';
    trSerie += '<td>' + CantidaProd + '<input type="hidden" id="cantidad_producto_S" name="cantidad_producto_S[]" value="' + CantidaProd + '" /></td>';
    trSerie += '<td>' + InicioCorrelativo + '<input type="hidden" id="iniC_serie" name="iniC_serie[]" value="' + InicioCorrelativo + '" /></td>';
    trSerie += '<td>' + FinCorrelativo + '<input type="hidden" id="finC_serie" name="finC_serie[]" value="' + FinCorrelativo + '" /></td>'
        //controlar que no se repita la misma serie para el mismo producto
    trSerie += '<input type="hidden" id="control_serie' + IdProducto + NombreSerie + '" name="control_serie[]" value="' + IdProducto + NombreSerie + '" /></tr>';

    if ($("#aplicaSerie").prop("checked")) {
        $("#contenedorSeries").append(trSerie);
    }

    if ($("#contenedorSeries tr").length > 0) {
        // $("#tablaSeries").show('slow');
        $("#ver_S").show('slow');
    }

}

//funcion asincronica con el eliminado del producto
function elimiarSerie(idFila) {
    var idFS = "#" + idFila + "S";
    $(idFS).remove();
    if ($("#contenedorSeries tr").length <= 0) {
        // $("#tablaSeries").hide('slow');
        $("#ver_S").hide('slow');
    }
}
function elimiarPrecio(idFila) {
    var idFS = "#" + idFila + "P";
    $(idFS).remove();
}

function verSeries() {
    var Inf_series = '<div style="padding:10px;" >' + $("#tablaSeries").html() + "</div>";

    $.fancybox(Inf_series, {
        openEffect: 'fade',
        closeEffect: 'fade',
        autoSize: true,
        fitToView: true
    });
}

//verificación si la serie que se desea ingresar ya esta asociada al mismo producto.
function existeSerieProducto(idProducto, nombreSerie) {
    if ($("#control_serie" + idProducto + nombreSerie).length > 0) {
        return true; //ese producto ya posee esa serie
    } else {
        return false; //el producto no posee dicha serie
    }
}


function validarNombreSerieUnico() {
    var IdP = $("#productos").val();
    if ($.trim($("#nombreSerie").val()) != "" && IdP > 0 && IdP != "") {
        $.ajax({
            url: window.gSateliteWhite.baseUrl('inventario/gestion_productos/validaNombreSerieUnico'),
            type: 'post',
            dataType: 'json',
            data: {
                'Nombreserie': $.trim($("#nombreSerie").val()),
                'idP': IdP
            },
            success: function(data) {
                if (data.existe == true) { //no hay disponibilidad para dicho rango
                    $("#nombreSerie").val('');
                    $("#v_nombreSerie").text('La serie ya existe para dicho producto');
                }
            }
        });

    }

}