$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#slcEstado").select2();
    /*Busqueda*/
   $("#btnConsultar").click(function(){
       var estado = $("#slcEstado").val();
       var fecha_ini = $("#txtFechaIni").val();
       var fecha_fin = $("#txtFechaFin").val();
       if(fecha_ini !='' && fecha_fin != ''){
           if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el periodo de las fechas.');
               return false;
           }
       }
       $("#dv_contenedor_entradas").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('inventario/gestion_productos/salida_productos/1'),
                   data:{estado:estado,fecha_ini:fecha_ini,fecha_fin:fecha_fin},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                       wait.close();
                       var oTabla = $("#tblEntradas").dataTable();
                       
                       oTabla.fnDestroy();
                       $("#tbContenedorEntradas").html(result);
                       
                       $("#dv_contenedor_entradas").show("slide", {
			                     direction: 'left'
                        }, 500);
                       aplidarDataTable('tblEntradas');
                   }
                });
            }
        );
   });
   
   
   $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "aaSorting": [[ 2, "desc" ]], //ordena desc
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}