$(document).ready(function () {

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#btnConsultar").click(function(){
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error','Alerta','Ingrese el periodo de fechas.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                $("#txtFechaIni").val('');
                $("#txtFechaFin").val('');
                crear_alerta('error','Alerta','Verifique el periodo de las fechas.');
                return false;
            }
        }
        $.ajax({
            type:'post',
            url:window.gSateliteWhite.baseUrl('inventario/gestion_productos/rutas_entrega/1'),
            data:{
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin
            },
            beforeSend:function(){
                wait.start();
            },
            success:function(result){
                var oTabla = $("#tbl_rutas").dataTable();                       
                oTabla.fnDestroy();
                $("#tbContenedor").html(result);
                aplidarDataTable('tbl_rutas');
                wait.close();
            }
        });
    });

    $("#btnConsultar").click();

    $(".ver_en_modal").live('click', function (e) {
        e.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            href:  url,
            type: 'iframe',//si estuviera ahi el div seria inline
            closeBtn: true
        });
    });
    
});//END DOCUMENT.READY

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "aaSorting": [[ 2, "desc" ]],
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}


function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }
    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}

