$(document).ready(function () {
    $('#datagried1').dataTable({
        "sPaginationType": "full_numbers"
    });

    var urlj = url_base_proyecto;
    
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    
    $(".datePicker").mask("99-99-9999");
    $("#slcProduct").select2();
    $("#slcBodega").select2({placeholder: "Seleccione una opción"});
    $("#slcCategory option[value='0']").text('Todas');
    $("#slcCategory option[value='0']").attr('selected', 'selected');
    $("#slcCategory").select2({placeholder: "Seleccione una opción"});

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var fecha_ini = ($("#fecha_ini").val() != null) ? $("#fecha_ini").val() : "";
        var fecha_fin = ($("#fecha_fin").val() != null) ? $("#fecha_fin").val() : "";
        var productos = ($("#slcProduct").val() != null)  ? $("#slcProduct").val() : "";
        var bodega    = ($("#slcBodega").val() > 0) ? $("#slcBodega").val() : 0;
        var categoria = ($("#slcCategory").val() > 0) ? $("#slcCategory").val() : 0;

        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el rango de fechas.');
               return false;
            }
        }
        if (fecha_ini == "" && fecha_fin == "" && productos == "" && bodega == 0 && categoria == 0) {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('inventario/reportes/filtrar_impresion_traslado/1'),
                data: {
                    fecha_ini:fecha_ini, 
                    fecha_fin:fecha_fin,
                    categoria: categoria,
                    productos: productos,
                    bodega: bodega
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $("#contenido").html(result);
                    aplidarDataTable('datagried1');
                    wait.close();
                }
            });
        } else {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('inventario/reportes/filtrar_impresion_traslado'),
                data: {
                    fecha_ini:fecha_ini, 
                    fecha_fin:fecha_fin,
                    categoria: categoria,
                    productos: productos,
                    bodega: bodega
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $("#contenido").html(result);
                    aplidarDataTable('datagried1');
                    wait.close();
                }
            });
        }
    });


    $('#slcCategory').change(function () {
        var categoria = ($(this).val() > 0) ? $(this).val() : 0;
        if (categoria > 0) {
            $("#slcProduct").html("");
            console.log('cat:'+categoria);
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {categoria: categoria},
                url: urlj + 'inventario/reportes/articles_x_category',
                success: function (data) {                    
                    $("#slcProduct").html(data);
                    $("#slcProduct").select2({placeholder: 'Seleccione productos'});        
                    $('#productos').css('display','');
                }
            });
        } else {
            $("#filtro_categoria").val(0);
            $("#filtro_productos").val("");
            $("#slcProduct").select2('destroy');
            $("#slcProduct").html("<option></option>");
            $("#slcProduct").select2(); 
            $('#productos').css('display','none');
        }
    });
        

});//END .ready


function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": true,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}


function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        return false;
    } else {
        return true;
    }
}