$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    $("#slcBodega").select2();

    $("#frm-requisiciones").validate({
        ignore:"",
        rules: {
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
            //slcCategoria:{ required:true,min:1}
            //slcVendedor:{ required:true,min:1},
            //slcPago:{ required:true,min:1}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $(".generar_pdf").live('click',function(event){
        event.preventDefault();
        var id = $(this).attr('requisicion');        
        $("#rpt_codigo").val(id);
        $("#rpt_tipo").val('pdf');
        $("#frm-requisiciones").submit();
    })

    $("#btnPDF").click(function() {
        event.preventDefault();
        $("#rpt_tipo").val('pdf');
        $('#frm-requisiciones').submit();
    });

    $("#btnEXCEL").click(function() {
        event.preventDefault();
        $("#rpt_tipo").val('excel');
        $('#frm-requisiciones').submit();
    });

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var bodega = $("#slcBodega").val();
        var modulo = $("#modulo").val();

        if(!$("#frm-requisiciones").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique las fechas del período.');
               return false;
            }
        } else{
            return false;
        }

        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('inventario/reportes/inventario_requisiciones/1'),
                   data:{fecha_ini:fecha_ini, fecha_fin:fecha_fin, bodega:bodega, modulo:modulo},
                   beforeSend:function(){
                        wait.start();
                        $("#btnPDF").hide();
                        $("#btnEXCEL").hide();
                   },
                   success:function(result){
                        $('#rpt_txtFechaIni').val(fecha_ini)
                        $('#rpt_txtFechaFin').val(fecha_fin)
                        $('#rpt_slcBodega').val(bodega)

                        $('#encabezado').show();
                        $("#dv_contenedor_reg").html(result);
                        aplidarDataTable('datagried')
                        $("#control").show();
                        wait.close();
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                        $("#btnPDF").show();
                        $("#btnEXCEL").show();
                   }
                });
            }
        );

   });
   
   
   $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

    function aplidarDataTable(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 20,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            $("#txtFechaFin").addClass('error');
            $("#txtFechaFin_error").text("Verifique las fechas del período");
            return false;
        }

        if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
            $("#txtFechaFin").removeClass('error');
            $("#txtFechaFin_error").text('');
            return true;
        }
    }