$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;

    $("#slcProduct").select2();
    $("#slcCategory option[value='0']").text('Todas');
    $("#slcCategory option[value='0']").attr('selected', 'selected');
    $("#slcCategory").select2({placeholder: "Seleccione una opción"});
    $("#proveedor").select2({placeholder: "Seleccione una opción"});
    $("#tipo_producto").select2({placeholder: "Seleccione una opción"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var categoria = ($("#slcCategory").val() > 0) ? $("#slcCategory").val() : 0;
        var proveedor = ($("#proveedor").val() != null) ? $("#proveedor").val() : "";
        var productos = ($("#slcProduct").val() != null)  ? $("#slcProduct").val() : "";
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var tipo_producto = $("#tipo_producto").val();

        if (fecha_ini != '' && fecha_fin != '') {
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Reporte por proveedor', 'Verifique el período de las fechas.');
                return false;
            }
        } else{
            crear_alerta('error', 'Reporte por proveedor', 'Verifique el período de las fechas.');
            return false;
        }

        /*if (proveedor == '') {
            crear_alerta('error', 'Filtros', 'Debe completar los filtros de búsqueda.');
            return false;
        }*/
        rpt_prv = $("#rpt_prv").val();
        $.ajax({
            url: urlj + 'inventario/reportes/consultaxproveedor',
            type: 'POST',
            dataType: 'json',
            data: {
                proveedor: proveedor, 
                rpt: rpt_prv, 
                fecha_ini: fecha_ini, 
                fecha_fin: fecha_fin,
                categoria: categoria,
                productos: productos,
                tipo_producto: tipo_producto,
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                //    $("#datagried").html(data.drop);
                //   $("#checkAll").show('slide');
                // $("#descargar").show();
                $("#depcod").show();
                $("#conten").show();
                $("#conten").html(data.resultado);
                $(".botones_export_print").show('slow');

                var fecha_ini = $("#txtFechaIni").val();
                var fecha_fin = $("#txtFechaFin").val();

                $("#filtro_proveedor").val(proveedor);
                $("#filtro_inicio").val(fecha_ini);
                $("#filtro_fin").val(fecha_fin);
                $("#filtro_category").val(categoria);
                $("#filtro_productos").val(productos.toString());

                setTimeout(function () {
                    $('#checkAll').dataTable();
                }, 100);
                wait.close();

            }
        });
    });

    $('#slcCategory').change(function () {
        var categoria = ($(this).val() > 0) ? $(this).val() : 0;
        if (categoria > 0) {
            $("#slcProduct").html("");
            $("#filtro_productos").val("");
            console.log('cat:'+categoria);
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {categoria: categoria},
                url: urlj + 'inventario/reportes/articles_x_category',
                success: function (data) {                    
                    $("#slcProduct").html(data);
                    $("#slcProduct").select2({placeholder: 'Seleccione productos'});        
                    $('#productos').css('display','');
                    $("#filtro_category").val(categoria);
                }
            });
        } else {
            $("#filtro_category").val(0);
            $("#filtro_productos").val("");
            $("#slcProduct").select2('destroy');
            $("#slcProduct").html("<option></option>");
            $("#slcProduct").select2(); 
            $('#productos').css('display','none');
        }
    });

    $('#slcProduct').change(function () {
        var productos = ($("#slcProduct").val() != null) ? $("#slcProduct").val() : "";
        $("#filtro_productos").val(productos.toString());
    });

    $('#proveedor').change(function () {
        var proveedor = ($("#proveedor").val() != null) ? $("#proveedor").val() : ""; 
        $("#filtro_proveedor").val(proveedor.toString());
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}