$(document).ready(function () {

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $('select').select2();

    $("#producto").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: 0
                    //producto_invent: 1
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#btn_consultar").click(function () {
        event.preventDefault();

        var bodega      = ($("#bodega").val() > 0)?$("#bodega").val():'';
        var producto    = ($("#producto").val() > 0)?$("#producto").val():'';


        if (  bodega == "") {
            
            if ( producto == "" ) {
                crear_alerta("error", "Reporte de Minimo-Mximo por producto", "Debe Seleccionar un campo como minimo para filtrar");
                return false; 
            } else {
                if (!bodega == "") {
                    crear_alerta("error", "Reporte de Minimo-Mximo por producto", "Debe Seleccionar un campo como minimo para filtrar");
                    return false; 
                }
            }  
        } 

        var respuesta       = false;

        $.ajax({
            url: window.gSateliteWhite.baseUrl('inventario/reportes/reporte_minimo_maximo'),
            data: {
                bodega: bodega,
                producto: producto,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });
    });

    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){

            var bodega          = ($("#bodega").val() > 0)?$("#bodega").val():'';
            var producto        = ($("#producto").val() > 0)?$("#producto").val():''; 


            if (  bodega == "") {
                
                if ( producto == "" ) {
                    crear_alerta("error", "Reporte de Minimo-Mximo por producto", "Debe Seleccionar un campo como minimo para filtrar");
                    return false; 
                } else {
                    if (!bodega == "") {
                        crear_alerta("error", "Reporte de Minimo-Mximo por producto", "Debe Seleccionar un campo como minimo para filtrar");
                        return false; 
                    }
                }  
            }          
        
            var respuesta = false;
    
            form.submit();
        }
    });


});