$(document).ready(function () {
    $('.dinamic option[value="0"]').text('');
    $('.dinamic option[value="0"]').val('');
    $("select").select2({placeholder: "Seleccione una opción"});

    $("#txtFechaFin").mask("99-99-9999");

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    $("#chkSinExistencia").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#filtro_sin_ex").val(1);
            } else {
                $("#filtro_sin_ex").val(0);
            }
        }
    });


    $("#slcProductos").select2({
        placeholder: "Buscar producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/gestion_productos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    categoria: $("select[class='dinamic']").last().val(),
                    bodega: $("#slcBodega").val(),
                    tipo: 0,
                    producto:producto
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });


    $("#slcBodega").change(function () {                
        var bodega = $(this).val();
        if (bodega != '') {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/reportes/obtener_categoriaxbodega',
                data: {bodega: bodega},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    //$("#departamento").html(data.drop);
                    wait.close();
                    $("#div-categorias").html(
                            '<div class="span9" style="margin-bottom:10px;">'
                            + '<div class="row-fluid">'
                            + '<label class="form-label span3">Categoría:</label>'
                            + '<div class="span7 controls">'
                            + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                            //+ '<button class="btn plus">+</button>'
                            + '</div></div></div>');
                    $(".dinamic").html(data.resp);
                    $('.dinamic option[value="0"]').text('');
                    $('.dinamic option[value="0"]').val('');
                    $('.dinamic').select2({placeholder: "Seleccione una opción"});
                }
            });
        }
    });


    $(".dinamic").live('change', function () {
        menor = Number($(this).attr('id')) + 2;
        bodega = $('#slcBodega').val();
        padre = $("select[class='dinamic']").last().val();
        $(".dinamic").each(function (index, el) {
            if ($(el).attr('id') > menor) {
                $(el).parent('div').siblings('label').remove();
                $(el).siblings('select').remove();
                $(el).parent('div').parent('div').parent('div').remove();
                $(el).remove();
            }
        });
        $(".plus:last").remove();
        $(this).next().append('<button class="btn plus">+</button>');
    });


    $(".plus").live('click', function (event) {
        event.preventDefault();
        bodega = $('#slcBodega').val();
        padre = $("select[class*='dinamic']").last().val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/reportes/get_dependencias_categoria_reporte_fisico',
            data: {padre: padre, bodega: bodega},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                categoria = data.drop;
                producto = data.producto;
                $i = 0;
                $(".plus").last().remove();
                if (categoria.length > 0) {
                    numero = $('#div-categorias select').last().length + 1;
                    linea = $("#div-categorias").append(''
                            + '<div class="span9" style="margin-bottom: 10px;">'
                            + '<div class="row-fluid">'
                            + '<label class="form-label span3">Categoría:</label>'
                            + '<div class="span6 controls">'
                            + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                            + '</div></div></div>');
                    linea2 = $('select[class="dinamic"]').last().html();
                    nueva = linea2.replace(/#/g, numero);
                    $('#div-categorias').append(nueva);
                    $('select[class="dinamic"]').last().html(categoria);
                    $('select[class="dinamic"] option[value="0"]').last().text('');
                    $('select[class="dinamic"] option[value="0"]').last().val('');
                    $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});

                } else {
                    $("#slcProductos").html(producto);
                    $("#slcMedidas").html('');
                    $("#slcMedidas").select2();
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se encontraron mas dependencias.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }

                $('.dinamic').each(function (index, el) {
                    $(this).attr('id', index);
                });
            }
        });
    });


    $("#slcProductos").on("change", function() {
        var producto = $(this).val();
        var bodega   = $("#slcBodega").val();
        if ($.trim(producto) != "") {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/reportes/obtener_codlote_articulo',
                data: {bodega: bodega, producto:producto},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                $("#txtcodigolote").html(data.codlote); 
                }
            });
        } else {
            $("#txtcodigolote").html("<option value=''></option>");
            $("#txtcodigolote").attr("placeholder", "Seleccione una opción");
            $("#txtcodigolote").val(0);
            $("#txtcodigolote").select2();
        }
    });


    // Validar para obtener la consulta
    $("#btnConsultar").click(function () {                
        event.preventDefault();
        
        var id_ultimo_select_cat = '';//Almacena el id del ultimo select(elemento html)
        var idcat_ultimo_select = '';//Almacenara el id de la ultima categoria seleccionada
        $('select.dinamic').each(function(value, item){            
            if(item.value != ''){
                id_ultimo_select_cat = item.id;
                idcat_ultimo_select = item.value;
            }
        })        

        var slcBodega       = ($("#slcBodega").val() > 0)?$("#slcBodega").val():'';
        var slcSelector     = ($("#slcSector").val() > 0)?$("#slcSector").val():'';
        var slcCategoria    = idcat_ultimo_select;
        var fecha_fin       = $("#txtFechaFin").val();
        var filtro_sin_ex   = $("#filtro_sin_ex").val();
        var respuesta       = false;
        
        console.log('bodega: ' + slcBodega);
        console.log('selector: ' + slcSelector);
        console.log('categoria: ' + slcCategoria);
        console.log('hasta: ' + fecha_fin);
        console.log('a cero: ' + filtro_sin_ex);

        if ( slcBodega == "") {
            crear_alerta('error', 'Reporte Inventario Físico', 'Por favor seleccione una bodega.');
            return false;
        }

        // if ( slcCategoria == "") {
        //     crear_alerta('error', 'Reporte Inventario Físico', 'Por favor seleccione una categoria.');
        //     return false;
        // }
        if ( fecha_fin == "") {
            crear_alerta('error', 'Reporte Inventario Físico', 'Por favor ingrese una fecha.');
            return false;
        }
        

        $.ajax({
            url: window.gSateliteWhite.baseUrl('inventario/reportes/reporte_inventario_fisico'),
            data: {
                slcBodega:      slcBodega,
                slcSelector:    slcSelector,
                slcCategoria:   slcCategoria,
                fecha_fin:      fecha_fin,
                filtro_sin_ex:  filtro_sin_ex,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });
    });

    $("#frm_reporte").validate({
        rules: {
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var id_ultimo_select_cat = '';//Almacena el id del ultimo select(elemento html)
            var idcat_ultimo_select = '';//Almacenara el id de la ultima categoria seleccionada
            $('select.dinamic').each(function(value, item){            
                if(item.value != ''){
                    id_ultimo_select_cat = item.id;
                    idcat_ultimo_select = item.value;
                }
            })
            var slcBodega       = ($("#slcBodega").val() > 0)?$("#slcBodega").val():'';
            var slcSelector     = ($("#slcSector").val() > 0)?$("#slcSector").val():'';
            var slcFecha        = ($("#txtFechaFin").val() != '')?$("#txtFechaFin").val():'';
            var slcCategoria    = idcat_ultimo_select;
            var sin_existencia  = $("#filtro_sin_ex").val();
            var respuesta       = false;

            console.log('bodega: ' + slcBodega);
            console.log('selector: ' + slcSelector);
            console.log('categoria: ' + slcCategoria);
            console.log('hasta: ' + slcFecha);
            console.log('a cero: ' + sin_existencia);

            if ( slcFecha == "") {
                crear_alerta('error', 'Reporte Inventario Físico', 'Por favor ingrese una fecha.');
                return false;
            }   

            /*if ( bodega == "") {
                crear_alerta('error', 'Reporte ', 'Por favor seleccione una bodega.');
                return false;
            }*/

            $("#filtro_bodega").val(slcBodega);
            $("#filtro_categoria").val(slcCategoria);
            $("#filtro_selector").val(slcSelector);
            $("#filtro_fecha").val(slcFecha);
            //$("#filtro_lote").val(codlote);
    
            form.submit();
        }
    });

});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function limpiar_filtro_categorias() {
    menor = Number($(".dinamic:first").attr('id')) + 2;
    $(".dinamic").each(function (index, el) {
        if ($(el).attr('id') > menor) {
            $(el).parent('div').siblings('label').remove();
            $(el).siblings('select').remove();
            $(el).parent('div').parent('div').parent('div').remove();
            $(el).remove();
        }
    });
    $(".plus:last").remove();
    $(".dinamic:first option:selected").removeAttr('selected');
    $(".dinamic:first").next().append('<button class="btn plus">+</button>');
    $(".dinamic:first").select2({placeholder: 'Seleccione una opción'});
}