$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#slcTipo").select2({placeholder: "Seleccione una opción"});
    $("#slcCategory option[value='0']").text('Todas');
    $("#slcCategory option[value='0']").attr('selected', 'selected');
    $("#slcCategory").select2({placeholder: "Seleccione una opción"});
    $("#slcCategory").removeClass('nostyle');

    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var tipo = ($("#slcTipo").val() > 0) ? $("#slcTipo").val() : "";
        if (tipo == '') {
            crear_alerta('error','Filtros','Debe completar los filtros de búsqueda.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique el rango de fechas.');
               return false;
            }
        }
        var documento = ($("#txtDocumento").val() != '') ? $("#txtDocumento").val() : "";
        var categoria = ($("select[class='dinamic']").last().val() > 0) ? $("select[class='dinamic']").last().val() : 0;
        var productos = ($("#slcProduct").val() != null) ? $("#slcProduct").val() : "";
        var tipo_proc = $("#slcTipo option:selected").data('entrada');
        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        }, 400, function () {
                $.ajax({
                    type: 'post',
                    url: window.gSateliteWhite.baseUrl('inventario/reportes/reporte_factura/1'),
                    data: {
                        tipo: tipo, 
                        documento: documento, 
                        txtFechaIni:fecha_ini, 
                        txtFechaFin:fecha_fin,
                        categoria: categoria,
                        productos: productos,
                        tipo_proc: tipo_proc
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (result) {
                        wait.close();

                        var tipo = ($("#slcTipo").val() > 0) ? $("#slcTipo").val() : "";
                        var documento = ($("#txtDocumento").val() != '') ? $("#txtDocumento").val() : "";

                        $("#filtro_tipo").val(tipo);
                        $("#filtro_tipo_entr").val(tipo_proc);
                        $("#filtro_documento").val(documento);
                        $("#filtro_fechIni").val(fecha_ini);
                        $("#filtro_fechFin").val(fecha_fin);

                        $(".btn-info").show(500);
                        $("#tblListado").html(result);
                        $("#dv_contenedor_listado").show("slide", {
                            direction: 'left'
                        }, 500);
                    }
                });
            }
        );
    });

    $(".dinamic").live('change', function () {
        menor = Number($(this).attr('id')) + 2;
        $(".dinamic").each(function (index, el) {
            if ($(el).attr('id') > menor) {
                $(el).parent('div').siblings('label').remove();
                $(el).siblings('select').remove();
                $(el).parent('div').parent('div').parent('div').parent('div').remove();
                $(el).remove();

            }
        });
        $(".plus:last").remove();
        if($(this).val() > 0){
            $(this).next().append('<button class="btn plus">+</button>');    
        }
    });

    $(".plus").live('click', function (event) {
        event.preventDefault();
        bodega = 0;
        padre = $("select[class='dinamic']").last().val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/obtener_hijos_cat',
            data: {padre: padre, bodega: bodega, pantalla: "entrada"},
            beforeSend: function(){
                wait.start();
            },
            success: function (data) {
                categoria = data.drop;
                producto = data.producto;
                $("select[name='categoria']").last().removeAttr('name');
                $i = 0;
                $(".plus").last().remove();
                if (categoria.length > 0) {
                    numero = $('#div-categorias select').last().length + 1;
                    linea = $("#div-categorias").append('<div class="form-row row-fluid">'
                            + '<div class="span12">'
                            + '<div class="row-fluid">'
                            + '<label class="form-label span3">Categoria:</label>'
                            + '<div class="span7 controls">'
                            + '<select class="dinamic" name="categoria" style="width:80%"></select>'
                            //+'<button class="btn plus">+</button>'
                            + '</div></div></div></div>');
                    linea2 = $('select[class="dinamic"]').last().html();
                    nueva = linea2.replace(/#/g, numero);
                    $('#div-categorias').append(nueva);
                    $('select[class="dinamic"]').last().html(categoria);
                    $('select[class="dinamic"]').last().select2();

                } else {
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se encontraron mas dependencias.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }
                wait.close();
                $('.dinamic').each(function (index, el) {
                    $(this).attr('id', index);
                });
            }
        });
    });

    $('.dinamic').live('change', function () {
        var categoria = ($(this).val() > 0) ? $(this).val() : 0;
        if (categoria > 0) {
            $("#slcProduct").html("");
            console.log('cat:'+categoria);
            $.ajax({
                dataType: 'text',
                type: 'post',
                data: {categoria: categoria},
                url: urlj + 'inventario/reportes/articles_x_category',
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {                    
                    $("#slcProduct").html(data);
                    $("#slcProduct").select2({placeholder: 'Seleccione productos'});        
                    $('#productos').css('display','');
                    $("#filtro_categoria").val(categoria);
                    wait.close();
                }
            });
        } else {
            $("#filtro_categoria").val(0);
            $("#filtro_productos").val("");
            $("#slcProduct").select2('destroy');//limpiar
            $("#slcProduct").html("<option></option>");
            $("#slcProduct").select2(); 
            $('#productos').css('display','none');//ocultar
        }
    });

    $('#slcProduct').change(function () {
        var productos = ($("#slcProduct").val() != null) ? $("#slcProduct").val() : "";
        $("#filtro_productos").val(productos.toString());

    });


});//END .ready


function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}