var pathArray = window.location.pathname.split('/');
var urlj = url_base_proyecto;

$(document).ready(function (){    
    var meses = {
        'Enero': '01', 
        'Febrero': '02', 
        'Marzo': '03', 
        'Abril': '04', 
        'Mayo': '05', 
        'Junio': '06', 
        'Julio': '07', 
        'Agosto': '08', 
        'Septiembre': '09', 
        'Octubre': '10',  
        'Noviembre': '11', 
        'Diciembre': '12'};    

    $("#slcBodega").select2();

    $(".datePicker").datepicker({
        closeText: 'Seleccionar',
        prevText: '<Ant',
        nextText: 'Sig>',
        // currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'MM-yy',
        onClose: function(dateText, inst) { 
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    $(".datepicker").mask("mm-yyyy");

    // Ocultar el calendario para solo mostrar el mes
    $(".datePicker").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });    

    // PENDIENTE MEJORA
    // $("#chk_sin_mov").iButton({
    //     'labelOn': 'Si',
    //     'labelOff': 'No',
    //     change: function (element) {
    //         if (element.is(':checked')) {
    //            $("#hdn_chk_sin_mov").val(1);
    //         } else {
    //            $("#hdn_chk_sin_mov").val(0);
    //         }
    //     }
    // });

    $("#consultar").click(function () {
        $("#print_actions").hide();
        var id_bod = $('#slcBodega').val();
        var fecha_txt = $('#txt_mes').val();       
        if (id_bod=='' || fecha_txt=='') {
            crear_alerta('error', 'Kardex', 'Verifique los campos requeridos.');
            return false;
        } else {
            var fecha = fecha_txt.split('-');
            var mes = meses[fecha[0]];
            var ultimo = ult_dia(mes,fecha[1]);
            var fecha_ini = fecha[1] + '-' + mes + '-01';
            var fecha_fin = fecha[1] + '-' + mes + '-' + ultimo;
            $.ajax({
                dataType: 'text',
                type: 'POST',
                url: urlj + 'inventario/reportes/rpt_krdx_resumen/1',
                data: {
                    tipo_reporte: "", 
                    bodega: id_bod, 
                    fecha_ini: fecha_ini, 
                    fecha_fin: fecha_fin
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $('#divContenedor').html(data);
                    $("#hdn_bod_id").val(id_bod);
                    $("#hdn_fe_ini").val(fecha_ini);
                    $("#hdn_fe_fin").val(fecha_fin);
                    $("#html_reporte").val(data);
                    $("#print_actions").show();
                    wait.close();
                }                
            });
        }
    });

});


function ult_dia(mes, anio) {
    if (mes.charAt(0) == '0') {
        mes = mes.charAt(1);
    }
    mes = parseInt(mes);
    anio = parseInt(anio);
    switch (mes) {
        case 1 : case 3 : case 5 : case 7 : case 8 : case 10 : case 12 : return 31;
        case 2 : return (anio % 4 == 0) ? 29 : 28;
    }
    return 30;
}