var pathArray = window.location.pathname.split('/');
var urlj = url_base_proyecto;
//Calculo de la URL PATH
$(document).ready(function (){
    gSateliteWhite.jsDatePicker();
    $("#slcBodega").select2();
    //$("#slcProductos").select2();
    $("#categoria").select2();
    $("#categoria_tia").select2();
    $("#departamento").select2();
    
    $("#txtFechaInicio").mask("99-99-9999");
    $("#txtFechaFin").mask("99-99-9999");

    $("#txtFechaInicio, #txtFechaFin").attr('placeholder', "dd-mm-yyyy");

    $("#txtFechaInicio, #txtFechaFin").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    $("#chkOcultarCosto").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        'resizeHandle': false,
        'resizeContainer': false,
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnOcultarCosto").val(1);
            } else {
                $("#hdnOcultarCosto").val(0);
            }
        }
    });


    //Remueve el option Sin registros
    $(".seleccion").each(function () {
        if ($(this).children().eq(1).text() == "Sin Registros") {
            $(this).children().eq(1).remove();
        }
    })


    $("#producto_art").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,

        ajax: {
            url: urlj + 'inventario/gestion_productos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: 0,
                    bodega : $('#slcBodega').val()
                    //producto_invent: 1
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

/*
    $("#slcBodega").change(function (event) {
        bodega = $('#slcBodega').val();
        if(bodega>0){
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/get_productos_existencia',
                data: {bodega: bodega,reporte:1},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    //$("#producto_art + .select2-container ").hide();
                    //$("#producto_art").select2('data', null);
                    //producto = data.producto;
                    //$("#slcProductos").html(producto);
                    //$('#slcProductos option[value="0"]').text('');
                   // $('#slcProductos option[value="0"]').val('');
                   // $("#slcProductos").select2('destroy').select2({placeholder: "Seleccione una opción"});
                    categoria = data.resp;
                    $("#categoria_tia").html(categoria);
                    $("#categoria_tia").select2('destroy');
                    $("#categoria_tia").select2();
                    wait.close();
                }
            });
        }else{
            $("#producto_art + .select2-container").show();
            //$("#slcProductos").select2('destroy');
            //$("#slcProductos").hide();
            //$("#slcProductos option:selected").removeAttr('selected');
        }
    });
*/
    //validacion
    $('#reporte_kardex').validate({
        ignore: null, ignore: 'input[type="hidden"]', //errorElement: "",
        rules: {
              //slcProductos: {required: true, number: true, min: 1},
             deducible: {required: true}
            , txtFechaInicio: {required: true}
            , txtFechaFin: {required: true}
        }, messages: {
            slcProductos: {
                number: "Seleccione una opción",
                min: "Seleccione una opción"
            },
            slcBodega: {
                required: "Seleccione una opción",
                min: "Seleccione una opción"
            },
        },
        errorPlacement: function (error, element) {

            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        }
    });


    //inicio de consultar
    $("#consultar").click(function (event) {
        event.preventDefault();
        if ($('#reporte_kardex').valid()) {
            if($('#slcProductos').val()>0){
                var id_prod = $('#slcProductos').val();
            }else{
                var id_prod = $('#producto_art').val();
            }
            // console.log('prod: '+id_prod);
            var id_bod = $('#slcBodega').val();
            var fecha_ini = $('#txtFechaInicio').val();
            var fecha_fin = $('#txtFechaFin').val();
            var mostrar_costos = $("#hdnOcultarCosto").val();
            var saldos_cero = $("#hdnSaldosCero").val();
            verifica_fecha(fecha_ini, fecha_fin);
            //por si no llegase a funcionar la validación con validate se convervará la funcion anterior del alert

            if (id_prod >0 && fecha_ini != '' && fecha_fin != '' && id_bod != "" && id_prod != 'Seleccione una opcion') {
                $("#slcProductos_error").text('');
                $("#slcBodega_error").text('');
                req_proceder();
                //Consultando el kardex
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj + 'inventario/reportes/get_kardex_producto',
                    data: {id_prod: id_prod, id_bod: id_bod, fecha_ini: fecha_ini, fecha_fin: fecha_fin, mostrar_costos: mostrar_costos},
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (data) {
                        $('#datos_a_enviar_pdf').val(data.pdf);
                        $('#encabezado').show();
                        $("#datagried").append(data.drop);
                        $("#control").show();
                        $("#imprimir_factura").show();
                        $("#imprimir_factura_pdf").show();
                        wait.close();
                        $(".linker").on('click', function (event) {
                            event.preventDefault();

                            url = $(this).attr('href');
                            $.ajax({
                                url: url
                            }).done(function (html) {
                                $.fancybox(html);
                            });
                        });
                    }
                }).done(function () {
                });
            } else {
                if(id_prod <= 0 ){
                    $("#slcProductos_error").text('Campo requerido');
                }
                if(id_bod <= 0 ){
                    $("#slcBodega_error").text('Campo requerido');
                }
            }

        }
    });//consultar


    function req_proceder() {
        //Preparando encabezados
        $("#datagried").empty();
    }

    $(".botonExcel").click(function (event) {
        $("#datos_a_enviar").val($("<div>").append($("#datagried_excel").eq(0).clone()).html());
        $("#FormularioExportacion").submit();
    });

    $(".botonPDF").click(function (event) {
        $("#datagried").removeAttr('style');
        $("#datagried").attr('style', 'font-size:7px;');
        $("#datos_a_enviar").val($("<div>").append($("#datagried").eq(0).clone()).html());
        $("#datagried").removeAttr('style');
        $("#datagried").attr('style', 'font-size:12.5px;');
        $("#FormularioExportacion").submit();

    });

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if (Date.parse(fecha_ini) == Date.parse(fecha_fin)) {
            $("#fecha2_error").text('');
            return true;
        }

        if (Date.parse(fecha_ini) > Date.parse(fecha_fin)) {

            $("#fecha2").addClass('error');
            $("#fecha2_error").text("Fecha fin no puede ser anterior a fecha inicio");
            return false;
        }

        if (Date.parse(fecha_ini) < Date.parse(fecha_fin)) {
            $("#fecha2").removeClass('error');
            $("#fecha2_error").text('');
            return true;
        }

    }


});