$(document).ready(function () {

    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;

    $('.dinamic option[value="0"]').text('');
    $('.dinamic option[value="0"]').val('');

    $("select").select2({placeholder: "Seleccione una opción"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#slcProductos").select2({
        placeholder: "Buscar producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/gestion_productos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    categoria: $("select[class='dinamic']").last().val(),
                    bodega: $("#slcBodega").val(),
                    tipo: 0,
                    producto:producto
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    // Para obtener las subcategorias 
    $(".dinamic").live('change', function () {
        menor = Number($(this).attr('id')) + 2;
        bodega = $('#slcBodega').val();
        padre = $("select[class='dinamic']").last().val();
        $(".dinamic").each(function (index, el) {
            if ($(el).attr('id') > menor) {
                $(el).parent('div').siblings('label').remove();
                $(el).siblings('select').remove();
                $(el).parent('div').parent('div').parent('div').remove();
                $(el).remove();
            }
        });
        if($.trim(padre) == ''){
            $('#slcProductos').val('');
            aplicar_select_ajax();
        }
        $(".plus:last").remove();
        $(this).next().append('<button class="btn plus">+</button>');
    });

    // Evento clic para obtener las subcategorias
    $(".plus").live('click', function (event) {
        event.preventDefault();

        padre = $("select[class*='dinamic']").last().val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/get_dependencias_categoria',
            data: {padre: padre, bodega: ''},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                categoria = data.drop;
                producto = data.producto;
                $i = 0;
                $(".plus").last().remove();
                if (categoria.length > 0) {
                    numero = $('#div-categorias select').last().length + 1;
                    //<div class="form-row row-fluid"></div>
                    linea = $("#div-categorias").append(''
                            + '<div class="span12" style="margin-bottom: 10px;">'
                            + '<div class="row-fluid">'
                            + '<label class="form-label span3">Categoría:</label>'
                            + '<div class="span7 controls">'
                            + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                            + '</div></div></div>');
                    linea2 = $('select[class="dinamic"]').last().html();
                    nueva = linea2.replace(/#/g, numero);
                    $('#div-categorias').append(nueva);
                    $('select[class="dinamic"]').last().html(categoria);
                    $('select[class="dinamic"] option[value="0"]').last().text('');
                    $('select[class="dinamic"] option[value="0"]').last().val('');
                    $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
                } else {
                    $("#slcProductos").html(producto);
                    $("#slcMedidas").html('');
                    $("#slcMedidas").select2();
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se encontraron mas dependencias.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }

                $('.dinamic').each(function (index, el) {
                    $(this).attr('id', index);
                });
            }
        });
    });

    // Obtener lote
    $("#slcProductos").on("change", function() {
        var producto = $(this).val();
        var bodega   = $("#slcBodega").val();
        if ($.trim(producto) != "") {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/reportes/obtener_codlote_articulo',
                data: {bodega: bodega, producto:producto},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                $("#txtcodigolote").html(data.codlote); 
                }
            });
            // hidden
            $("#_txt_producto").val(producto);
        } else {
            $("#txtcodigolote").html("<option value=''></option>");
            $("#txtcodigolote").attr("placeholder", "Seleccione una opción");
            $("#txtcodigolote").val(0);
            $("#txtcodigolote").select2();
        }
    });

    // Evento click para consultar
    $("#btn_consultar").click(function () {
        event.preventDefault();
    
        var txtFechaIni     = $("#txtFechaIni").val();
        var txtFechaFin     = $("#txtFechaFin").val();
        var categoria       = ($("#slc_categoria").val() > 0)?$("#slc_categoria").val():'';

        var slcProductos    = ($("#slcProductos").val() > 0)?$("#slcProductos").val():'';
        var txtcodigolote   = ($("#txtcodigolote").length > 0)?$("#txtcodigolote").val():'';
        var respuesta       = false;

        if ( categoria == "") {
            crear_alerta('error', 'Impresión de Etiquetas', 'Por favor seleccione una categoria.');
            return false;
        }

        if (slcProductos == "") {
            crear_alerta('error', 'Impresión de Etiquetas', 'Por favor seleccione un producto.');
            return false;
        }

        if ($("#txtcodigolote").val() == "") {
            crear_alerta('error', 'Impresión de Etiquetas', 'Por favor seleccione un código de lote.');
            return false;            
        }

        if ( txtFechaIni == "" || txtFechaFin == "") {
            crear_alerta('error', 'Impresión de Etiquetas', 'Por favor ingrese el rango de fechas.');
            $("#txtFechaIni").val("");
            return false;
        } 

        if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
            crear_alerta('error', 'Impresión de Etiquetas', 'Verifique el período de fechas.');
            return false;
        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('inventario/reportes/impresion_etiquetas_empaques'),
            data: {
                txtFechaIni:   txtFechaIni,
                txtFechaFin:   txtFechaFin,
                slcProductos:  slcProductos,
                txtcodigolote: txtcodigolote,

                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });
    });

    // validacion
    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txtFechaIni     = $("#txtFechaIni").val();
            var txtFechaFin     = $("#txtFechaFin").val();
            var categoria       = ($("#slc_categoria").val() > 0)?$("#slc_categoria").val():'';
            var slcProductos    = ($("#slcProductos").val() > 0)?$("#slcProductos").val():'';
            var txtcodigolote   = ($("#txtcodigolote").length > 0)?$("#txtcodigolote").val():'';

            var respuesta = false;

            if ( categoria == "") {
                crear_alerta('error', 'Impresión de Etiquetas', 'Por favor seleccione una categoria.');
                return false;
            }

            if (slcProductos == "") {
                crear_alerta('error', 'Impresión de Etiquetas', 'Por favor seleccione un producto.');
                return false;
            }

            if ($("#txtcodigolote").val() == "") {
                crear_alerta('error', 'Impresión de Etiquetas', 'Por favor seleccione un código de lote.');
                return false;            
            }

            if ( txtFechaIni == "" || txtFechaFin == "") {
                crear_alerta('error', 'Impresión de Etiquetas', 'Por favor ingrese el rango de fechas.');
                $("#txtFechaIni").val("");
                $("#slc_estado").val("");
                return false;
            } 

            if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
                crear_alerta('error', 'Impresión de Etiquetas', 'Verifique el período de fechas.');
                return false;
            }
    
            form.submit();
        }
    });

    $("#btnRango").on("click", function(e) {
        if ($("#tbl_contenedor").find("tr").length > 0 && !$("#notr").length > 0) {
            realizar_rango_empaques_($(this).attr('href'));
        } else {
            crear_alerta("error", "Impresión de Etiquetas", "Debe haber minimo un registro para imprimir un rango");
        }
    });

    $("#btn_rango_").on("click", function(e) {
        // e.preventDefault();
        // variables
        var desde       = $("#txt_desde_").val();
        var hasta       = $("#txt_hasta_").val();
        var registros   = $("#tbl_contenedor").find("tr").length;

        if (desde != "" && hasta != "") {
            if (desde > hasta && hasta < desde) {
                crear_alerta("error", "Impresión de Etiquetas", "El rango ingresado es incorrecto, Desde debe ser menor que Hasta");
                return false;
            } else {
                if (hasta > registros) {
                    crear_alerta("error", "Impresión de Etiquetas", "El rango ingresado excede los registros consultados");
                    return false;
                } else {
                    $(this).submit();
                    $("#btn_cerrar").trigger("click");
                    $("#dv_contenedor").html("");
                    $("#dv_contenedor").show("slide", {
                        direction: 'left'
                    }, 500);
                }
            }
        } else {
            crear_alerta("error", "Impresión de Etiquetas", "Los campos Desde y Hasta no deben estar vacios.");
            return false;
        }
    });

    $("#txtcodigolote").on("change", function() {
        if ($(this).val() > 0 ) {
            $("#_txt_cod_lote").val($(this).val());
        } else {
            $("#_txt_cod_lote").val();
        }
    });

    $("#txtFechaIni").on("change", function() {
        $("#_txtfecha_desde").val($(this).val());
    });

    $("#txtFechaFin").on("change", function() {
        $("#_txtfecha_hasta").val($(this).val());
    });

});

function aplicar_select_ajax(){
    $("#slcProductos").select2({
        placeholder: "Buscar producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/gestion_productos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    categoria: $("select[class='dinamic']").last().val(),
                    bodega: $("#slcBodega").val(),
                    tipo: 0,
                    producto:producto
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });
}


function realizar_rango_empaques_(link = null) {

    event.preventDefault();        
    if (link != "") {

        var id    = link;

        // reset input
        $("#txt_desde_").val('');
        $("#txt_hasta_").val('');

        setTimeout(function() {
            $("#txt_desde_").focus();
        }, 500)
                    
        $(id).css('width','40%');
        $(id).css('left','55%');        
        $(id).css('padding','10px 10px 10px 10px');       
        $('.box').css('margin-bottom','5px');       
        $(id).css('border-radius','5px');       
        $(id).addClass('modal');
        $(id).modal({
            backdrop: 'static', keyboard: false, show: true
        });
    }        
}