$(document).ready(function () {

    gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#slcBodega").select2();

    $("#frm-historico").validate({
        ignore:"",
        rules: {
            //txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
            //slcCategoria:{ required:true,min:1}
            //slcVendedor:{ required:true,min:1},
            //slcPago:{ required:true,min:1}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $(".print").live('click',function(event){
        var tipo = $(this).val();
        
        $("#rpt_tipo").val(tipo);
        $("#frm-historico").submit();
    })

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var bodega = ($.trim($("#slcBodega").val()) > 0) ? $("#slcBodega").val() : "";
        var categoria = ($('select[class="dinamic"]').last().val() > 0) ? $('select[class="dinamic"]').last().val() : "";
        var producto = ($.trim($("#slcProductos").val()) > 0) ? $("#slcProductos").val() : "";
        var lote = ($.trim($("#txtcodigolote").val()) != "") ? $("#txtcodigolote").val() : "";
        if(!$("#frm-historico").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
               crear_alerta('error','Alerta','Verifique las fechas del período.');
               return false;
            }
        }
        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                    type:'post',
                    url:window.gSateliteWhite.baseUrl('inventario/reportes/historico_existencias/1'),
                    data:{
                        fecha_ini: fecha_ini,
                        fecha_fin: fecha_fin, 
                        bodega: bodega, 
                        categoria: categoria, 
                        producto: producto, 
                        lote: lote
                    },
                    beforeSend:function(){
                        wait.start();
                    },
                    success:function(result){
                        $('#rpt_txtFechaIni').val(fecha_ini);
                        $('#rpt_txtFechaFin').val(fecha_fin);
                        $('#rpt_slcBodega').val(bodega);
                        $('#rpt_categoria').val(categoria);
                        $('#rpt_slcProductos').val(producto);
                        $('#encabezado').show();
                        $("#dv_contenedor_reg").html(result);
                        aplidarDataTable('datagried');
                        $("#control").show();
                        wait.close();
                        $(".btn-info").show(500);
                        $("#dv_contenedor_reg").show("slide", {
                            direction: 'left'
                        }, 500);
                    }
                });
        });
    });

    $("#slcBodega").change(function () {
        var bodega = $(this).val();
        if (bodega != '') {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/obtener_categoriaxbodega',
                data: {bodega: bodega},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    //$("#departamento").html(data.drop);
                    wait.close();
                    $("#div-categorias").html(
                            '<div class="span12" style="margin-bottom:10px;">'
                            + '<div class="row-fluid">'
                            + '<label class="form-label span3">Categoría:</label>'
                            + '<div class="span7 controls">'
                            + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                            //+ '<button class="btn plus">+</button>'
                            + '</div></div></div>');
                    $(".dinamic").html(data.resp);
                    $('.dinamic option[value="0"]').text('');
                    $('.dinamic option[value="0"]').val('');
                    $('.dinamic').select2({placeholder: "Seleccione una opción"});
                }
            });
        } else{
            $("#div-categorias").html(
                    '<div class="span12" style="margin-bottom:10px;">'
                    + '<div class="row-fluid">'
                    + '<label class="form-label span3">Categoría:</label>'
                    + '<div class="span7 controls">'
                    + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                    //+ '<button class="btn plus">+</button>'
                    + '</div></div></div>');
            $(".dinamic").html('<option value=""></option>');
            $('.dinamic option[value="0"]').text('');
            $('.dinamic option[value="0"]').val('');
            $('.dinamic').select2({placeholder: "Seleccione una opción"});
            $('#slcProductos').val('');
            aplicar_select_ajax();
        }
    });

    $(".dinamic").live('change', function () {
        menor = Number($(this).attr('id')) + 2;
        bodega = $('#slcBodega').val();
        padre = $("select[class='dinamic']").last().val();
        $(".dinamic").each(function (index, el) {
            if ($(el).attr('id') > menor) {
                $(el).parent('div').siblings('label').remove();
                $(el).siblings('select').remove();
                $(el).parent('div').parent('div').parent('div').remove();
                $(el).remove();
            }
        });
        if($.trim(padre) == ''){
            $('#slcProductos').val('');
            aplicar_select_ajax();
        }
        $(".plus:last").remove();
        $(this).next().append('<button class="btn plus">+</button>');
    });

    $(".plus").live('click', function (event) {
        event.preventDefault();
        bodega = $('#slcBodega').val();
        padre = $("select[class*='dinamic']").last().val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/get_dependencias_categoria',
            data: {padre: padre, bodega: bodega},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();
                categoria = data.drop;
                producto = data.producto;
                $i = 0;
                $(".plus").last().remove();
                if (categoria.length > 0) {
                    numero = $('#div-categorias select').last().length + 1;
                    //<div class="form-row row-fluid"></div>
                    linea = $("#div-categorias").append(''
                            + '<div class="span12" style="margin-bottom: 10px;">'
                            + '<div class="row-fluid">'
                            + '<label class="form-label span3">Categoría:</label>'
                            + '<div class="span7 controls">'
                            + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                            + '</div></div></div>');
                    linea2 = $('select[class="dinamic"]').last().html();
                    nueva = linea2.replace(/#/g, numero);
                    $('#div-categorias').append(nueva);
                    $('select[class="dinamic"]').last().html(categoria);
                    $('select[class="dinamic"] option[value="0"]').last().text('');
                    $('select[class="dinamic"] option[value="0"]').last().val('');
                    $('select[class="dinamic"]').last().select2({placeholder: 'Seleccione una opción'});
                } else {
                    $("#slcProductos").html(producto);
                    $("#slcMedidas").html('');
                    $("#slcMedidas").select2();
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se encontraron mas dependencias.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }

                $('.dinamic').each(function (index, el) {
                    $(this).attr('id', index);
                });
            }
        });
    });

    function aplicar_select_ajax(){
        $("#slcProductos").select2({
            placeholder: "Buscar producto",
            minimumInputLength: 3,
            ajax: {
                url: urlj + 'inventario/gestion_productos/get_productos_like',
                dataType: 'json',
                type: 'POST',
                delay: 250,
                data: function (producto) {
                    return {
                        categoria: $("select[class='dinamic']").last().val(),
                        bodega: $("#slcBodega").val(),
                        tipo: 0,
                        producto:producto
                    };
                },
                results: function (data) {
                    var myResults = [];                    
                    $.each(data, function (index, item) {
                        myResults.push({
                            'id': item.producto,
                            'text': item.prod_nombre
                        });
                    });
                    return {
                        results: myResults
                    };
                }
            }
        });
    }

    aplicar_select_ajax();
   
    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });

    $("#slcProductos").on("change", function() {
        var producto = $(this).val();
        var bodega   = $("#slcBodega").val();
        if ($.trim(producto) != "") {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/reportes/obtener_codlote_articulo',
                data: {bodega: bodega, producto:producto},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                $("#txtcodigolote").html(data.codlote); 
                }
            });
        } else {
            $("#txtcodigolote").html("<option value=''></option>");
            $("#txtcodigolote").attr("placeholder", "Seleccione una opción");
            $("#txtcodigolote").val(0);
            $("#txtcodigolote").select2();
        }
    });
});

    function aplidarDataTable(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 20,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }

    function verifica_fecha(fecha_ini, fecha_fin) {
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
            // $("#txtFechaFin").addClass('error');
            // $("#txtFechaFin_error").text("Verifique las fechas del período");
            return false;
        }
        if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
            // $("#txtFechaFin").removeClass('error');
            // $("#txtFechaFin_error").text('');
            return true;
        }
    }
    aplidarDataTable('datagried');