$(document).ready(function () {
    $("select").select2();
    
    var meses = {
        'Enero': '01', 
        'Febrero': '02', 
        'Marzo': '03', 
        'Abril': '04', 
        'Mayo': '05', 
        'Junio': '06', 
        'Julio': '07', 
        'Agosto': '08', 
        'Septiembre': '09', 
        'Octubre': '10',  
        'Noviembre': '11', 
        'Diciembre': '12'
    };    

    $(".datePicker").datepicker({
        closeText: 'Seleccionar',
        prevText: '<Ant',
        nextText: 'Sig>',        
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'MM-yy',
        onClose: function(dateText, inst) { 
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    $(".datepicker").mask("mm-yyyy");

    // Ocultar el calendario para solo mostrar el mes
    $(".datePicker").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });  

    $("#producto_art").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: 0
                    //producto_invent: 1
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }        
    });

    $("#btnConsultar").click(function (event){     
        var slcBodega   = $("#slcBodega").val(); 
        var producto_art= $("#producto_art").val(); 
        var txt_mes     = $("#txt_mes").val(); 

        if ( slcBodega == "") {
            crear_alerta('error', 'Bodega', 'Favor seleccionar una bodega');
            return false;
        }

        if ( producto_art == "") {
            crear_alerta('error', 'Período', 'Favor seleccionar un producto');
            return false;
        }
        
        if ( txt_mes == "") {
            crear_alerta('error', 'Período', 'Favor seleccionar un período');
            return false;
        }

        var fecha = txt_mes.split('-');
        var mes = meses[fecha[0]];
        var ultimo = ult_dia(mes,fecha[1]);
        var fecha_ini = fecha[1] + '-' + mes + '-01';
        var fecha_fin = fecha[1] + '-' + mes + '-' + ultimo;

        $("#fecha_ini").val(fecha_ini);
        $("#fecha_fin").val(fecha_fin);

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'inventario/gestion_productos/control_existencia',
            data: { 
                fecha_ini: fecha_ini, 
                fecha_fin: fecha_fin,
                txt_mes:txt_mes,
                slcBodega:slcBodega,
                producto_art:producto_art
            },
            success: function (data) {
                $("#contenedor_consulta").html(data.html);
                $("#contenedor_consulta").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            },
            error: function (xhr, status, error) {
                wait.close();
                crear_alerta('error', 'Error', 'Se interrumpio debido a un problema al realizar la operación');
            }
        });
    });


});//END DOCUMENT.READY

function ult_dia(mes, anio) {
    if (mes.charAt(0) == '0') {
        mes = mes.charAt(1);
    }
    mes = parseInt(mes);
    anio = parseInt(anio);
    switch (mes) {
        case 1 : case 3 : case 5 : case 7 : case 8 : case 10 : case 12 : return 31;
        case 2 : return (anio % 4 == 0) ? 29 : 28;
    }
    return 30;
}