jQuery(document).ready(function($) {
    setTimeout(function(){
        $("#chkAutoriza").iButton({
            'labelOn': ' Si ',
            'labelOff': ' No ',
            change: function (element) {
                if (element.is(':checked')) {
                    $("#txtAutoriza").val(1);
                } else {
                    $("#txtAutoriza").val(0);
                }
            }
        });
    }, 500)

    $("#estado").select2();
    $("#entrada2").select2();
    $("#salida2").select2();
    $("#centro_costo_cec").select2();
    $("#tipo_cuenta_tcn").select2();
    $("#slcBodega").select2();

    if($("#ajuste").prop('checked') || $("#traslado").prop('checked') || $("#facturacion").prop('checked')){    
        $("#div-entrada").show();
        $("#div-salida").show();
        //$("#div-autoriza").show();
    }

    if($("#traslado").prop('checked')){    
        // $("#div-autoriza").show();
    }

    if($("#entrada").prop('checked')){    
        $("#div-entrada").show();
    }

    if($("#salida").prop('checked')){    
        $("#div-salida").show();
    }

    $(document).on('click', '#btn_guardar', function() {
        $("#redireccion").val(1);
    });

    $(document).on('click', '#btn_guardar_volver', function() {
        console.log("entrado");
        $("#redireccion").val(2);
    });

    $("#cuenta_contable_cnt").select2({
        placeholder: "Buscar Cuenta Contable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'utm/cuentas/get_cuentas_contables_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cuenta) {
                return {
                    cuenta: cuenta
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cuenta,
                        'text': item.cuenta_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    //Remueve el option Sin registros
    $(".seleccion").each(function () {
        if ($(this).children().eq(0).text() == "Sin Registros") {
            $(this).children().eq(0).remove();
        }
        if ($(this).children().eq(1).text() == "Sin Registros") {
            $(this).children().eq(1).remove();
        }
    });

    $("#regreso2").click(function (event) {
        event.preventDefault();
        $('#pes-generales').trigger('click');
    });

    // Verificar si ya se rellenaron los campos requeridos
    $(".guardar").click(function (event) {
        event.preventDefault();
        var paso = 0;
        if ($("#nombre").val() == '') {
            $("#nombre").addClass('error');
            $("#nombre_error").html('Campo requerido');
            paso = 1;
        }
        if ($("#entrada").val() == '' || $("#salida").val() == '' || $("#traslado").val() == '' || $("#ajuste").val() == '' || $("#facturacion").val() == '') {
            $("input[name='tipo']").addClass('error');
            $("#tipo_error").html('Campo requerido');
            paso = 1;
        }

        if (paso == 0) {
            $("#frm-tipo_proceso").submit();
        } else {
            $("#pes-generales").addClass("clasecss");
            $("#pes-generales").trigger("click");
        }

    });

    $("#entrada").on('click', function() {
        cargar_entradas_salidas2();
        $("#div-entrada").show('slide');
        $("#div-salida").hide(200);
        $("#div-autoriza").hide(200);
        if($("#chkAutoriza").is(":checked")){
            $("#chkAutoriza").iButton('toggle');
        }
    });

    $("#salida").on('click', function() {
        cargar_entradas_salidas2();
        $("#div-entrada").hide(200);
        $("#div-salida").show('slide');
        $("#div-autoriza").hide(200);
        if($("#chkAutoriza").is(":checked")){
            $("#chkAutoriza").iButton('toggle');
        }
    });

    $("#ajuste").on('click', function() {
        cargar_entradas_salidas2();
        $("#div-entrada").show('slide');
        $("#div-salida").show('slide');
        $("#div-autoriza").hide(200);
        if($("#chkAutoriza").is(":checked")){
            $("#chkAutoriza").iButton('toggle');
        }
    });  

    $("#facturacion").on('click', function() {
        cargar_entradas_salidas2();
        $("#div-entrada").show('slide');
        $("#div-salida").show('slide');
        $("#div-autoriza").hide(200);
        if($("#chkAutoriza").is(":checked")){
            $("#chkAutoriza").iButton('toggle');
        }
    });

    $("#traslado").on('click', function() {
        // Peticion Ajax
        cargar_entradas_salidas2();

        $("#div-entrada").show('slide');
        $("#div-salida").show('slide');
        // $("#div-autoriza").show('slide');
        $("#chkAutoriza").iButton('destroy');
        $("#chkAutoriza").iButton({
            'labelOn': ' Si ',
            'labelOff': ' No ',
            change: function (element) {
                if (element.is(':checked')) {
                    $("#txtAutoriza").val(1);
                } else {
                    $("#txtAutoriza").val(0);
                }
            }
        });
    
    });

    $("#frm-tipo_proceso").validate({
        ignore:"",
    rules: {
        nombre:{ required:true },
        estado:{ required:true },
        tipo:  { required:true }
    }, 
    
    ignore: ".select2-container",
    errorPlacement: function (error, element) {
        var nombre=$(element).attr("id");
        $('#'+nombre+'_error').html(error);
    },
    submitHandler: function(form) {
        form.submit();
    }
    });

    $('#add_finanza').live('click', function (event) {
        event.preventDefault();

        var cantidad_tr = $("#documento_finanza").find("tr").length;

        var centro_costo_cec = $("#centro_costo_cec").val().trim();
        var centro_costo_cec_select = $("#centro_costo_cec option:selected").text();

        //var cuenta_contable_cnt = $("#cuenta_contable_cnt").val().trim();
        //var cuenta_contable_cnt_select = $("#cuenta_contable_cnt").next().text().trim();

        var tipo_cuenta_tcn = $("#tipo_cuenta_tcn").val().trim();
        var tipo_cuenta_tcn_select = $("#tipo_cuenta_tcn option:selected").text();

        var bodega = $("#slcBodega").val().trim();
        var bodega_select = $("#slcBodega option:selected").text();

        var repetido = false;

        var mensaje = "";
        var type_msg = "";
        
        if (tipo_cuenta_tcn != "" && centro_costo_cec != "" ) {
            type_msg = "error";

            var configuracion = centro_costo_cec+"-"+tipo_cuenta_tcn+"-"+bodega;
            
            if ($("#documento_finanza .tr_finanzas").length > 0) {
                $("#documento_finanza .tr_finanzas").each(function () {
                    if ($(this).attr("name") == ("tr_configuracion_" + configuracion)) {
                        repetido = true;
                    }
                });
            }

            if (repetido == true) {
                crear_alerta('info', 'Configuración contable', 'Detalle ya fue agregado');
                return false;
            }
            
            if (cantidad_tr >= 1 && $("#contador_finanza").val() != cantidad_tr) {
                $("#contador_finanza").val((cantidad_tr + 1));
            }
            id_correlativo = $("#contador_finanza").val(); //crear un id unico para anexos de documentos
            id_centro_costo_cec = '<input type="hidden" id="centro_costo_cec' + centro_costo_cec + tipo_cuenta_tcn + '" name="centro_costo_cec[]" value="' + centro_costo_cec + '" />';
            //id_cuenta_contable_cnt = '<input type="hidden" id="cuenta_contable_cnt' + centro_costo_cec + cuenta_contable_cnt + tipo_cuenta_tcn + '" name="cuenta_contable_cnt[]" value="' + cuenta_contable_cnt + '" />';
            id_tipo_cuenta_tcn = '<input type="hidden" id="tipo_cuenta_tcn' + centro_costo_cec + tipo_cuenta_tcn + '" name="tipo_cuenta_tcn[]" value="' + tipo_cuenta_tcn + '" />';
            id_bodega = '<input type="hidden" id="bodega' + bodega + '" name="bodega[]" value="' + bodega + '" />';
            
            eliminar = '<a id="del_doc" valor="' + id_correlativo + '" thead="titlefinanza" tbody="documento_finanza" class="btn btn-borrar btn-danger btn-mini minia-icon-trashcan white"> Eliminar</a>';

            var oTable = $('#tblCuentasContables').dataTable();
            //Se destruye el datatable para luego volver a crearla
            oTable.fnDestroy();

            $("#documento_finanza").append(
                    '<tr id="filatitlefinanza' + id_correlativo + '" name="tr_configuracion_'+configuracion+'" class="tr_finanzas">' +
                    '<td>' + id_centro_costo_cec + centro_costo_cec_select + '</td>' +
                    '<td>' + id_tipo_cuenta_tcn + tipo_cuenta_tcn_select + '</td>' +
                    //'<td>' + id_cuenta_contable_cnt + cuenta_contable_cnt_select + '</td>' +
                    '<td>' + id_bodega + bodega_select + '</td>' +
                    '<td>' + eliminar + '</td>' +
                    '</tr>');

            aplicarDataTable('#tblCuentasContables');
            $('#tblCuentasContables').css('width', '100%');
            
            var NC = parseInt($("#contador_finanza").val()) + 1;
            $("#contador_finanza").val(NC);

            $("#centro_costo_cec option").removeAttr("selected");
            $("#centro_costo_cec").select2();

            //$("#cuenta_contable_cnt").select2('data', null);

            $("#tipo_cuenta_tcn option").removeAttr("selected");
            $("#tipo_cuenta_tcn").select2();

            $("#slcBodega option").removeAttr("selected");
            $("#slcBodega").select2();

            $("#centro_costo_cec_error").text('');
            $("#cuenta_contable_cnt_error").text('');
            $("#tipo_cuenta_tcn_error").text('');
            $("#slcbodega_error").text('');

        } else {
            type_msg = "error";
            mensaje = "Los campos son requeridos";
            if (tipo_cuenta_tcn == "") {
                $("#tipo_cuenta_tcn_error").text('Campo requerido');
                /*if (cuenta_contable_cnt == "") {
                    $("#cuenta_contable_cnt_error").text('Campo requerido');
                }*/
                if (centro_costo_cec == "") {
                    $("#centro_costo_cec_error").text('Campo requerido');
                }
            } /*else if (cuenta_contable_cnt == "") {
                $("#cuenta_contable_cnt_error").text('Campo requerido');
                if (tipo_cuenta_tcn == "") {
                    $("#tipo_cuenta_tcn_error").text('Campo requerido');
                }
                if (centro_costo_cec == "") {
                    $("#centro_costo_cec_error").text('Campo requerido');
                }
            }*/ else if (centro_costo_cec == "") {
                $("#centro_costo_cec_error").text('Campo requerido');
                if (tipo_cuenta_tcn == "") {
                    $("#tipo_cuenta_tcn_error").text('Campo requerido');
                }
                /*if (cuenta_contable_cnt == "") {
                    $("#cuenta_contable_cnt_error").text('Campo requerido');
                }*/
            }
        }
        if (mensaje != "") {
            $.pnotify({
                type: type_msg,
                title: 'Informaci&oacute;n',
                text: mensaje,
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
        }
        //}
    });

    $('.btn-borrar').live('click', function (event) {
        event.preventDefault();
        //Eliminar Gasto Indirectos
        var parent = $(this).parent().parent();
        var oTable = $('#tblCuentasContables').dataTable();
        oTable.fnDeleteRow(parent[0]);
    });
              
});

function cargar_entradas_salidas2(){
    $.ajax({
        url: urlj+"inventario/mantenimiento/entradas2",
        data: {
        }
    }).done(function(html){
        var datos = html.split('|');
        $("#entrada2").html($.trim(datos[0]));
    });
    $.ajax({
        url: urlj+"inventario/mantenimiento/salidas2",
        data: {
        }
    }).done(function(html){
        var datos = html.split('|');
        $("#salida2").html(datos[0]);
    });
}

$('#entrada2').change(function() {
if ($('#traslado').is(':checked')) {
                }else{
                    $("#div-salida").hide(200);
                }
});

$('#salida2').change(function() {
    if ($('#traslado').is(':checked')) {
                }else{
$("#div-entrada").hide(200);
}
});


function cargar_entradas(registro){
    // id que sea cabal el nombre del que lo llama
    
    $.ajax({
            type: "POST",
            url: urlj+"inventario/mantenimiento/entradas",
            data: {
                valor: registro,
            }
        }).done(function(html){
            var datos = html.split('|');
            //alert("All Nice dude, your data :" + datos[0]);
            $("#entrada2").html(datos[0]);
            $("#salida2").html(datos[1]);
        });
}

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}