$(document).ready(function () {
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');
    $('select').select2({placeholder: 'Seleccione una opción'});
    
    $('.select-edit').select2('destroy');
    $('.select-edit').hide();

    $(".soloNumeros").numeric();

    $(".btn-close").live('click', function () {

        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    $("#chkAfectaCantidad").iButton({
        'labelOn': 'Si',
        'labelOff': 'No',
        change: function (element) {
            if (element.is(':checked')) {
                $("#hdnAfectaCant").val(1);
            } else {
                $("#hdnAfectaCant").val(0);
            }
        }
    });

    $("#frm-formula").validate({
        ignore: [],
        rules: {
            txtNombre: {required: true},
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#tbCaracteristicas').length == 0) {
                crear_alerta('error', 'Fórmula', 'Debe ingresar al menos una operación');
                return false;
            }

            var lastRow = $('#tbCaracteristicas tr:last').attr('id');

            var dataId = $("#" + lastRow).attr('data-id');

            if ($("#slcOperador_" + dataId).val() != "") {
                crear_alerta('info', 'Fórmula', 'Debe finalizar la fórmula. Ingresé una característica sin operador.');
                return false;
            }
            form.submit();
        }
    });

    var row = 0;
    if ($('#tbCaracteristicas tr').length > 0) {
        row = $("#tbCaracteristicas tr").length;
    }
    $("#btnAgregar").click(function () {
        $("#cabezera").show();

        var caracteristica = $('#slcCaracteristica').val();
        var caracteristica_nombre = $('#slcCaracteristica option:selected').text();
        var operador = $('#slcOperador').val();
        var operador_nombre = $('#slcOperador option:selected').text();
        var txtValorDefecto = $('#txtValorDefecto').val();


        var numRegistros = $('#tbCaracteristicas .trOperador').length;


        //Se realizan las validaciones en base al tipo de Orden
        if (numRegistros == 0) {
            if (caracteristica == '' || operador == '') {
                crear_alerta('info', 'Fórmula', 'Debe completar la información de la operación');
                return false;
            }
        } else if (numRegistros >= 2) {
            var lastRow = $('#tbCaracteristicas tr:last').attr('id');

            var dataId = $("#" + lastRow).attr('data-id');

            if ($("#slcOperador_" + dataId).val() == "") {
                crear_alerta('info', 'Fórmula', 'Fórmula finalizada. No se permite agregar más operadores.');
                return false;
            }
        } else {
            if (caracteristica == '') {
                crear_alerta('info', 'Fórmula', 'Debe seleccionar una característica.');
                return false;
            }
        }


        /*if ($("#tr_" + producto).length > 0) {
         crear_alerta('error', 'Cotización', 'El producto ya fue ingresado.');
         return false;
         }*/

        var slcCaracteristicasHtml = getOpcionesSelect("slcCaracteristica");
        var slcOperadorHtml = getOpcionesSelect("slcOperador");

        slcCaracteristicasHtml = slcCaracteristicasHtml.replace(/"/g, "'");
        slcOperadorHtml = slcOperadorHtml.replace(/"/g, "'");
        var html = '';
        html += '<tr class="trOperador" id="tr_' + row + '" data-id="' + row + '">';
        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" id="txtCaracteristica_' + row + '" name="caracteristicasNombre[]" value="' + caracteristica_nombre + '" readonly="readonly"/>';
        html += '<select id="slcCaracteristica_' + row + '" name="caracteristicas[]" data-id="' + row + '" style="display:none;" class="select-edit">' + slcCaracteristicasHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + operador_nombre + '" readonly="readonly"/>';
        html += '<select id="slcOperador_' + row + '" data-id="' + row + '" name="operadores[]" style="display:none;" class=" select-edit">' + slcOperadorHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtValorDefecto_' + row + '" name="valoresDefecto[]" class="text tables-input-show tables-input valorDefecto" value="' + txtValorDefecto + '" readonly="readonly"/>';
        html += '</td>';


        html += '<td>';
        //html += '<button type="button" class="btn btn-primary btn-mini btnGuardarCarac" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;">Guardar</button>'
        //html += '<button type="button" class="btn btn-primary btn-mini btnEditCarac" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelCarac" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;">Eliminar</button>';
        html += '</td>';



        var oTable = $('#datagried').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbCaracteristicas").append(html);
        aplidarDataTable('#datagried');

        $("#txtValorDefecto").val('');
        $('#slcCaracteristica option:selected').removeAttr('selected');
        $('#slcCaracteristica').select2({placeholder: 'Seleccione una opción'});
        $('#slcOperador option:selected').removeAttr('selected');
        $('#slcOperador').select2({placeholder: 'Seleccione una opción'});

        row = row + 1;
    });//En of function agregar

    $(".btnEditProd").live('click', function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarProd").show();
    });

    //Guardar Email
    $(".btnGuardarProd").live('click', function () {
        var parent = $(this).parent().parent();

        var id_parent = $("#" + parent[0].id).data('id');

        var txtCantidad = $("#txtCantidad_" + id_parent).val().replace(/,/g, "");
        var txtPrecio = $("#txtPrecioUnitario_" + id_parent).val().replace(/,/g, "");
        var txtDescuento = $("#txtDescuento_" + id_parent).val().replace(/,/g, "");

        if (txtCantidad == '' || txtCantidad == 0) {
            crear_alerta('error', 'Cotización', 'Debe ingresar una cantidad válida');
            return false;
        }

        if (txtPrecio == '' || txtPrecio == 0) {
            crear_alerta('error', 'Cotización', 'Debe ingresar un precio válido');
            return false;
        }

        if (txtDescuento > 100) {
            crear_alerta('error', 'Cotización', 'El descuento no puede superar al 100%');
            return false;
        }

        var descuentos = parseFloat($("#" + parent[0].id).find('.descuentosProducto').val());

        var montoDescuento = (descuentos / 100) * txtPrecio;
        var subtotalNeto = txtCantidad * txtPrecio;
        var subTotal = (txtCantidad * (txtPrecio - montoDescuento));
        var htmlImpuestos = $("#lnkImpuestos_" + id_parent).data('html');

        $("#slcMultiCargos").html(htmlImpuestos);

        var montoImpuestos = calcularGastosMultiSelect("slcMultiCargos", 'data-porcentaje', subtotalNeto);

        montoImpuestos = parseFloat(montoImpuestos.replace(/,/g, ""));


        parseFloat($("#" + parent[0].id).find('.impuestosProducto ').val(number_format(montoImpuestos, 2)));

        $("#slcMultiCargos").html('');

        $("#txtCantidad_" + id_parent).val(txtCantidad);
        $("#txtPrecioUnitario_" + id_parent).val(number_format(txtPrecio, 2));
        $("#txtDescuento_" + id_parent).val(number_format(txtDescuento, 2));

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditProd").show();
    });


    //Eliminar Fila
    $(".btnDelCarac").live("click", function () {
        var parent = $(this).parent().parent();

        var oTable = $('#datagried').dataTable();

        oTable.fnDeleteRow(parent[0]);
    });
});

function cerrar_modal() {
    //alert('asdasd');
    jQuery.fancybox.close();
}

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function aplidarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}
