$(document).ready(function () {
    //window.gSateliteWhite.jsSelect();

    //$("select option[value='0']").text('');
    //$("select option[value='0']").val('');
    $("select").select2({placeholder:"Seleccione una opción"});
    
    $(".datePicker").mask('99-99-9999');
    $(".datePicker").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });

    $("#btnConsultar").click(function () {

        var estado      = $("#slcEstado").val();
        var fecha_ini   = $("#txtFechaIni").val();
        var fecha_fin   = $("#txtFechaFin").val();

        if (fecha_ini != '' && fecha_fin != '') {
            if (!validarPeriodo(fecha_ini, fecha_fin)) {
                crear_alerta('error', 'Requisiciones', 'Verifique el período de las fechas.');
                return false;
            }
        }

        $("#dv_contenedor_requisiciones").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('inventario/inicio/tareas_pendientes/1'),
                        data: {estado: estado, fecha_ini: fecha_ini, fecha_fin: fecha_fin},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            var oTabla = $("#tblRequisiciones").dataTable();

                            oTabla.fnDestroy();
                            $("#tbContenedorRequisiciones").html(result);

                            $("#dv_contenedor_requisiciones").show("slide", {
                                direction: 'left'
                            }, 500);
                            aplidarDataTable('tblRequisiciones');
                        }
                    });
                }
        );
    });

    $("#btnConsultar").trigger("click");

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}