$(document).ready(function () {
    var limite = 1000;
    $('select').select2();

    $("#slc_categoria").change(function () {
        $("#txt_producto").select2('data', null);
        var categoria   = $("#slc_categoria option:selected").text();
        $("#categoria").val(categoria);
    });

    $("#txt_producto").change(function () {        
        var producto        = ( $('#txt_producto').val() != "")? $('#txt_producto').select2('data').text:"";
        $("#producto").val(producto);
    });

    $("#txt_producto").select2({
        placeholder:'Buscar productos',
        minimumInputLength: 3,
        ajax: {
            url:urlj+'inventario/gestion_productos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    categoria: $("#slc_categoria").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre_simple,
                    });
                });
                return {
                    results: myResults
                };
		    } 
        }
    });  

    $("#btn_consultar").click(function () {
        event.preventDefault();

        var slc_categoria   = ($("#slc_categoria").val() > 0)?$("#slc_categoria").val():'';
        var categoria       = $("#slc_categoria option:selected").text();
        var txt_producto    = ($("#txt_producto").val() > 0)?$("#txt_producto").val():'';
        var producto        = ( $('#txt_producto').val() != "")? $('#txt_producto').select2('data').text:"";
        var txt_cantidad    = $("#txt_cantidad").val();

        if ( slc_categoria == "" &&  txt_producto == "") {
            crear_alerta('info', 'Generador de códigos de barra', 'Debe seleccionar un filtro.');
            return false;
        }

        if ( txt_cantidad == "" ) {
            crear_alerta('error', 'Generador de códigos de barra', 'Debe agregar una cantidad.');
            return false;
        }
        
        if ( parseInt(txt_cantidad) < 1 ) {
            crear_alerta('error', 'Generador de códigos de barra', 'Cantidad debe ser mayor a cero.');
            return false;
        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('inventario/gestion_productos/generardor_codigos_barra'),
            data: {
                slc_categoria: slc_categoria,
                txt_producto: txt_producto,
                categoria:categoria,
                producto:producto,
                txt_cantidad:txt_cantidad,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {                
                var obj = jQuery.parseJSON(result);
                var oTabla = $("#tbl_codigo").dataTable();
                oTabla.fnDestroy();
                $("#tbl_contenedor_codigos").html(obj.html);
                $("#div_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                aplicarDataTable('tbl_codigo');
                $("#tbl_codigo").removeAttr('checked');
                wait.close();
            }
        });
    });

    $("#frm_impresion").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var error = false;
            var total = 0;
            if ( $(".tr_codigos").length == 0) {
                crear_alerta('error', 'Generador de códigos de barra', 'No se han encontrado resultados en la búsqueda.');
                return false;
            }

            if (  $('.codigo_check:checked:checked:').length == 0) {
                crear_alerta('error', 'Generador de códigos de barra', 'Debe seleccionar almenos un producto.');
                return false;
            }

            $( ".codigo_check:checked:checked:" ).each(function( index ) {
                var cantidad = $( this ).parent().next().children().val();
                if ( cantidad == "" ||  cantidad == 0 ) {
                    crear_alerta('error', 'Generador de códigos de barra', 'Cantidad debe ser mayor a 0');
                    $( this ).parent().next().children().focus();
                    error = true;
                    return false;
                } else {
                    total += parseInt(cantidad);
                }
            });

            if ( error == true ) {
                return false;
            }

            if ( total > limite) {
                crear_alerta('error', 'Generador de códigos de barra', 'Solo se pueden generar mil codigos.');
                return false;
            }
    
            form.submit();
        }
    });

    $("#div_contenedor").on('change', '#seleccionar_todo', function(event) {
        event.preventDefault();
        if ( $(this).attr('checked') ) {
            $(".codigo_check").attr('checked', true);
        } else {
            $(".codigo_check").removeAttr('checked');
        }
    });

    $("#div_contenedor").on('change', '.codigo_check', function(event) {
        event.preventDefault();
        if ( $(this).attr('checked') ) {
            $(this).attr('checked', true);
        } else {
            $(this).removeAttr('checked');
        }
    });

    $("#div_contenedor").on('click', '.imprimir', function(event) {
        event.preventDefault();
        var id              = $(this).attr('id');
        var tipo_reporte    = "pdf";
        var chk_codigo      = $(this).attr('id')
        var cantidad        = $("#cantidad_"+id).val();
        var codigo          = $("#codigo_"+id).val();
        var articulo        = $("#articulo_"+id).val();
        var nombre          = $("#nombre_"+id).val();

        if (  cantidad == "" || cantidad == 0 ) {
            crear_alerta('error', 'Generador de códigos de barra', 'Cantidad debe ser mayor a 0.');
            return false;
        }

        if ( cantidad > limite) {
            crear_alerta('error', 'Generador de códigos de barra', 'Solo se pueden generar mil codigos.');
            return false;
        }
        
        $("#dv_impresion_individual #tipo_reporte").val(tipo_reporte);
        $("#dv_impresion_individual #chk_codigo").val(chk_codigo);
        $("#dv_impresion_individual #cantidad").val(cantidad);        
        $("#dv_impresion_individual #codigo").val(codigo);
        $("#dv_impresion_individual #articulo").val(articulo);
        $("#dv_impresion_individual #nombre").val(nombre);        
        $( "#frm_impresion_individual" ).submit();
    });
    
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "bAutoWidth": false,
        "bPaginate": false,
        "aoColumnDefs": [
            { 'bSortable': false, 'aTargets': [ 0 ] } //que no se pueda ordenar por la columna que posee el checkboX ( 0 )
          ],
        "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                  /* Disable initial sort */
        "aaSorting": [], //quitar el orden por defecto
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true
    });

}