jQuery(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;

    function encabezado() {
        $("#datagried").empty();
        $("#datagried").append('<thead>'
                + '<tr>'
                + '<th style="">'
                + 'Furgón'
                + '</th>'
                + '<th>'
                + 'Número de caja'
                + '</th>'
                + '<th style="">'
                + 'Entradas'
                + '</th>'
                + '<th style="">'
                + 'Acciones'
                + '</th>'
                + '<th style="">'
                + 'Salidas'
                + '</th>'
                + '<th style="">'
                + 'Acciones'
                + '</th>'
                + '<th style="">'
                + 'Saldos'
                + '</th>'
                + '<th style="">'
                + 'Acciones'
                + '</th>'
                + '</tr>'
                + '</thead>'
                );

    }

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $('#buscarxcodigo').click(function () {
        if ($('#codigo').val() != '') {
            $("#codigo").removeClass('error');
            $("#validar_codigo").hide();
            codigo = $.trim($("#codigo").val());
            var fecha_ini = $("#txtFechaIni").val();
            var fecha_fin = $("#txtFechaFin").val();
            if (fecha_ini != '' && fecha_fin != '') {
                if (!validarPeriodo(fecha_ini, fecha_fin)) {
                    crear_alerta('error', 'Consulta por nombre y código', 'Verifique el período de las fechas.');
                    return false;
                }
            }else{
                crear_alerta('error', 'Período', 'Ambas fechas son requeridas.');
                return false;
            }


            //encabezado();
            wait.start();
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/consultas/busqueda_codigo',
                data: {codigo_buscar: codigo, fecha_ini:fecha_ini,fecha_fin:fecha_fin},
                success: function (data) {
                    $("#encabezado").empty();
                    $("#datagried").empty();
                    indice1 = data.drop2;
                    $("#encabezado").append(indice1);
                    indice = data.drop;
                    $("#datagried").append(indice);
                    if (!$("#datagried").text()) {
                        crear_alerta("info", "Aviso", "No existen datos para mostrar.");
                    }
                    $(".linker").on('click', function (event) {
                        event.preventDefault();

                        url = $(this).attr('href');
                        $.ajax({
                            url: url
                        }).done(function (html) {
                            $.fancybox(html);
                        });
                    });
                    
                    wait.close();
                }
            }).done(function () {

            });
        } else {
            $("#codigo").addClass('error');
            $("#validar_codigo").show();
            $("#validar_codigo").text('Ingrese el nombre o código del artículo');
            crear_alerta('error', 'Producto', 'Verifique el nombre o código del artículo.');
            return false;
        }

    });
    // Buscar producto por codigo
    $("#codigo").select2({
        placeholder: "Nombre o código del Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/mantenimiento/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: $("#tipo_general_combo").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
                
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });
});