var pathArray = window.location.pathname.split('/');
var urlj = url_base_proyecto;
$(document).ready(function () {
    $(".seleccion").select2();
    $(".numerico").numeric();
    $(".fecha_general").attr('placeholder', "dd-mm-yyyy");
    $(".fecha_general").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $("#producto_art").attr('disabled', true);

    var cantidad_decimales = parseInt($("#cantidad_decimales_txt").val());

    //Remueve el option Sin registros
    $(".seleccion").each(function () {
        if ($(this).children().eq(1).text() == "Sin Registros") {
            $(this).children().eq(1).remove();
        }
    })

    /*$(".positive").numeric({ negative: false }, function() { alert("No negative values"); this.value = ""; this.focus(); });
     
     $(".positive").live("focusout", function(){
     if($(this).attr('id')=='cantidad' && $(this).hasClass('validar_on')){
     if($(this).val() <= 0.0 ){
     campo=$(this).attr("id");
     $(this).addClass('error');
     $('#validar_'+campo).text('La cantidad debe ser mayor a uno');
     }
     }
     });*/


    $("#producto_art").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/gestion_productos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    bodega: $("#bodega_bod").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

     $('body').on('blur', '.validar_cantidad', function (){
        $('#body_productos_dee > tr').each(function () {
            var cantidad = parseFloat($(this).find('.validar_cantidad').val());
            var costo = parseFloat($(this).find('.costos_unit').val());
            var total = number_format((costo * cantidad), $("#decimales").val(), '.','');
            $(this).find('.costos_produc').val(total);
            $(this).find('.cto_lbl').html(number_format(total, $("#decimales").val()));
        });
        recalcular_costo();
    });

    $("#frm-entrada_producto").validate({
        ignore: "",
        rules: {
            bodega_bod: {required: true, min: 1},
            tip_salida: {required: true, min: 1},
            fecha_registro: {required: true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').text('Campo requerido');
            ajustar_border();
        },
        submitHandler: function (form) {

            var error = 0;
            $(".validar_cantidad").each(function () {
                art_id = $(this).attr("id");
                cantidad = parseFloat($(this).val());
                cantidad_defecto = parseFloat($(this).attr("cant_def"));
                cantidad_maxima = parseFloat($("#cantidad_req_" + art_id).val());
                //  $(this).val(number_format($(this).val(), 2));
                if (!(cantidad < 0)) {
                    if (!(cantidad <= cantidad_maxima) || !(cantidad <= cantidad_defecto)) {
                        if ($("#bodega_bod").val() == "") {
                            if (cantidad_defecto > cantidad_maxima) {
                                $(this).val(cantidad_defecto);
                            }
                            error++;
                        } else {
                            if (cantidad_maxima > cantidad_defecto) {
                                if (!(cantidad <= cantidad_defecto)) {
                                    mensaje = 'La cantidad solicitada excede la peticion.';
                                    //$(this).val(number_format(cantidad_defecto,2));
                                    error++;
                                }
                            } else if (cantidad_maxima <= cantidad_defecto) {
                                if ((!(cantidad <= cantidad_maxima))) {
                                    mensaje = 'La cantidad solicitada excede las existencias.';
                                    // $(this).val(number_format(cantidad_maxima,2));
                                    error++;
                                }
                            }

                        }
                    }
                }
            });

            if (error > 0) {
                crear_alerta('info', 'Avisos', mensaje);
                return false;
            }

            //var 
            $('#body_productos_dee .id_art_rxi').each(function(index, fila) {
                var articulo        = $(fila).val();
                var fila_actual     = $(fila).data("fila");
                var saldo_actual    = $("#"+fila_actual+" #cantidad_req_"+articulo).val() ;
                saldo_actual        = (saldo_actual != "")?saldo_actual:0;
                var valor_articulo  = ($("#"+articulo).val() !="")? parseFloat($("#"+articulo).val()):0;
                var texto           = $(fila).next().text();
                $('#body_productos_dee .id_art_rxi').each(function(index2, fila2) {
                    var fila_actual2    = $(fila2).data("fila");
                    var articulo2       = $(fila2).val();
                    if ( articulo == articulo2 && fila_actual != fila_actual2 ) {
                        var valor_articulo2  = ($("#"+articulo2).val() !="")? parseFloat($("#"+articulo2).val()):0;
                        valor_articulo      += valor_articulo2;
                    }
                });

                if (valor_articulo > saldo_actual ) {
                    mensaje = 'La cantidad total solicitada de ' + texto +  ' excede las existencias.';
                    error++;
                    return false;
                }
            });

            if (error > 0) {
                crear_alerta('error', 'Avisos', mensaje);
                return false;
            }
       
            wait.start();            
            form.submit();
        }
    });

    $('#guardar').live('click', function (event) {
        $("#redireccion").val(0);
    })
    $('#guardar_volver').live('click', function (event) {
        $("#redireccion").val(1);
    })
    //envia el formulario
    $('.enviar_formulario').live('click', function (event) {
        //Se verifican antes los saldos

    //
        var detalle_productos = $("#body_productos_dee").find("tr").length;
        if (detalle_productos != 0 && $("#frm-entrada_producto").valid() != false) {
            if ($("#requisicion_rxi").val() == "") {
                $("#frm-entrada_producto").submit();
            } else {
                if (validar_requisicion()) {
                    $("#frm-entrada_producto").submit();
                }
            }
        } else {
            if (!$("#frm-entrada_producto").valid()) {
                crear_alerta("error", "Alerta", "Campos con * requeridos");
            } else if (detalle_productos == 0) {
                $.pnotify({
                    type: 'error',
                    title: 'Aviso',
                    text: 'Debe agregar al menos un detalle.',
                    icon: 'ui-icon ui-icon-info white',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
            }
        }

    });

    $('#doc_cliente').change(function(){
        var cliente = $(this).val();
        if($.trim(cliente) != ''){
            $.ajax({
                url: urlj + 'inventario/gestion_productos/cargar_documento_cliente',
                type: 'POST',
                dataType: 'json',
                data: {cliente: cliente},
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $('#doc_document_cliente').html(data.resp);
                        $("#doc_document_cliente").select2();
                    } else {
                        $("#doc_document_cliente").html('<option value=""></option>');
                        $("#doc_document_cliente").select2();
                    }
                }
            });
        } else{
            $("#doc_document_cliente").html('<option value=""></option>');
            $("#doc_document_cliente").select2();
        }
    });


    $('#slc_proveedor').change(function(){
        var proveedor   = $(this).val();
        var bodega      = $("#bodega_bod").val();
        if($.trim(proveedor) != '' && $.trim(bodega) != '' ){
            get_compra_documento_proveedor(proveedor, bodega);
        } else{
            $("#slc_documento_proveedor").html('<option value=""></option>');
            $("#slc_documento_proveedor").select2();
        }
    });

    function get_compra_documento_proveedor(proveedor, bodega){
        $.ajax({
            url: urlj + 'inventario/gestion_productos/get_compra_documento_proveedor',
            type: 'POST',
            dataType: 'json',
            data: {
                    proveedor: proveedor,
                    precargado: 1,
                    bodega:bodega
                },
            success: function (data) {
                if ($.trim(data.resp) != "") {
                    $('#slc_documento_proveedor').html(data.resp);
                    $("#slc_documento_proveedor").select2();
                } else {
                    $("#slc_documento_proveedor").html('<option value=""></option>');
                    $("#slc_documento_proveedor").select2();
                }
            }
        });
    }

    $("#slc_documento_proveedor").change(function() {
        if ( $(this).val() != ""){
            ocultar_datos_producto();
            get_productos_documento_proveedor( $(this).val() );
        } else {
            $("#doc_referencia").val('');
            mostrar_datos_producto();
            $("#body_productos_dee").html("");
        }
    });

    function ocultar_datos_producto() {
        $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #slcLote, #medida_cva, #bodega_bod").select2("disable");
        $('#accion_columns').hide();
        $("#cantidad_dee").attr("readonly", true);
        $("#add_producto_dee").css("display", "none");
    }

    function mostrar_datos_producto() {
        $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #medida_cva, #bodega_bod").select2("enable");
        $('#accion_columns').show();
        $("#cantidad_dee").attr("readonly", false);
        $("#add_producto_dee").css("display", "block");
    }

    function get_productos_documento_proveedor(documento){
        var bodega = $("#bodega_bod").val();
        $.ajax({
            url: urlj + 'inventario/gestion_productos/get_productos_documento_proveedor',
            type: 'POST',
            dataType: 'json',
            data: {
                    documento: documento,
                    bodega:bodega
                },
            success: function (data) {
                console.log(data);
                // console.log(data.select);
                $("#body_productos_dee").html("");
                $("#body_productos_dee").append(data.html);
                if (data.dpv_numero != '') {
                    $("#doc_referencia").val(data.dpv_numero);
                }
                $("#div_mostrar").fadeIn(300);
                recalcular_costo();
            }
        });
    }

    $("#doc_document_cliente").change(function () {
        doc_client = $(this).val();
        if ($.trim(doc_client) != "") {
            $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #medida_cva").select2("disable");
            $("#cantidad_dee").attr("readonly", true)
            $("#add_producto_dee").css("display", "none");
            $("#body_productos_dee").html("");
            $.ajax({
                url: urlj + 'inventario/gestion_productos/cargar_detalle_facturacion',
                type: 'POST',
                dataType: 'json',
                data: {documento_cliente: doc_client}, 
                success: function (data) {
                    // console.log(data);
                    if ($.trim(data.resp) != "") {
                        $("#bodega_bod").val(data.bodega);
                        $('#accion_columns').hide();
                        $("#bodega_bod").select2();
                        $("#bodega_bod").select2("disable");
                        //  console.log(data.bodega);
                        
                        if ($.trim($("#bodega_bod").val()) != "") {
                            $("#body_productos_dee").append(data.resp);
                            $("#div_mostrar").fadeIn(300);
                            $('.id_art_rxi').each(function () {
                                var id_art = $(this).val();
                                $("#seleccion" + id_art).select2();
                                $("#" + id_art).numeric();
                                cargar_cantidades_rxi(id_art);
                            })
                            $("#bodega_bod_error").text("");
                        } else {
                            //si la bodega no pertecene al usuario mostrar estemensaje
                            $("#bodega_bod_error").text("La bodega no pertenece al usuario");
                            $("#div_mostrar").css('display', 'none');
                            $("#body_productos_dee").html("");
                            $("#doc_proveedor").val("");
                            $.pnotify({
                                type: 'info',
                                title: 'Aviso',
                                text: 'La bodega no asignada, comunicarse con un administrador',
                                icon: 'ui-icon ui-icon-info',
                                opacity: 0.95,
                                history: false,
                                sticker: false
                            });
                        }
                    }
                }
            });
        } else {
            $('#accion_columns').show();
            $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #medida_cva, #bodega_bod").select2("enable");
            $("#cantidad_dee").attr("readonly", false);
            $("#add_producto_dee").css("display", "");
            $("#div_mostrar").css('display', 'none');
            $("#body_productos_dee").html("");
            $("#bodega_bod_error").text("");
            $("#bodega_bod option").removeAttr("selected");
            $("#bodega_bod").select2();
        }
    })

    var cargar_sector = function (bod) {
        if ($.trim(bod) != "") {

            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_sector_bodega',
                type: 'POST',
                dataType: 'json',
                data: {bodega: bod},
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $("#sector_sxb").html(data.resp);
                        $("#sector_sxb").select2();
                    } else {
                        $("#sector_sxb").html('<option value=""></option>');
                        $("#sector_sxb").select2();
                    }
                }
            });
        }
    }

    $('#bodega_bod').change(function () {
        if ($.trim($(this).val()) != "") {
            $("#producto_art").attr('disabled', false);
            limpiarproducto();
            $("#producto_art").select2('data', null);

            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/obtener_categoriaxbodega',
                data: {bodega: $(this).val()},
                success: function (data) {
                    categoria = data.resp;
                    $("#categoria_tia").html(categoria);
                    $("#categoria_tia").select2('destroy');
                    $("#categoria_tia").select2();
                }
            });

            if ($("#requisicion_rxi").val() == "") {
                if ($("#body_productos_dee").find('tr').length > 0) {
                    if ($(this).val() != $("#select_bodega").val()) {
                        alerta_confirm_ajax(borrar_grid, $(this).val(), "Alerta confirmación", "Si cambia de bodega, se eliminaran los productos agregados.<br> ¿Éstas seguro que quieres cambiar de bodega?");
                    }
                    $('#bodega_bod option[value=' + $("#select_bodega").val() + ']').attr('selected', 'selected');
                    $('#bodega_bod').select2();
                }
                $("#select_bodega").val($(this).val());
            } else {
                $('.id_art_rxi').each(function () {
                    var id_art = $(this).val();
                    cargar_cantidades_rxi(id_art);
                })

            }
            bod = $(this).val();
            cargar_sector(bod);
            cargar_producto();

            if ( $("#slc_proveedor").val() != ""){
                var bodega      = $(this).val();
                var proveedor   = $("#slc_proveedor").val();
                get_compra_documento_proveedor(proveedor, bodega);
            }
        } else {
            $("#sector_sxb").html("<option value=''></option>");
            $("#producto_art").attr('disabled', true);
        }

        if ( $("#bodega_bod").val() != "" && $("#slcLote").val() != "" && $("#producto_art").val() != ""){
            get_productos_empaquetados($("#bodega_bod").val(), $("#producto_art").val(), $("#slcLote").val(), 2);
        } else {
            $("#txt_correlativo_lote").val("");
        }

    });

    $('#sector_sxb').change(function () {
        cargar_producto();
    });

    function cargar_cantidades_rxi(art_id,fila) {
        //var producto = $("#cantidad_req_"+art_id).find("input").val();
        bodega = $("#bodega_bod").val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/get_cantidad_producto',
            data: {bodega: bodega, producto: art_id},
            success: function (data) {
                if ( fila != null) {                    
                    $("#"+fila+" #cantidad_req_" + art_id).val(data.cantidad);
                    $("#"+fila+" #cantidad_req_" + art_id).next().text(number_format(data.cantidad,2,".",""));
                } else {
                    $("#cantidad_req_" + art_id).val(data.cantidad);
                    $("#cantidad_req_" + art_id).next().text(number_format(data.cantidad,2,".",""));
                }
            }
        });
    }

    function borrar_grid(valor) {
        $("#select_bodega").val(valor);
        $('#bodega_bod option[value=' + $("#select_bodega").val() + ']').attr('selected', 'selected');
        $('#bodega_bod').select2();
        cargar_sector(valor);
        cargar_producto();
        $("#body_productos_dee").find("tr").remove();
        $("#div_mostrar").css('display', 'none');
    }

    /*======================================================================================================================================
     =											FILTRA LAS CARACTERISTICA PADRE/HIJO
     ========================================================================================================================================
     */
    var cargar_producto = function () {
        categoria_tia = $("select[id='categoria_tia']").last().val();
        bodega = $("#bodega_bod").val();
        sector = $("#sector_sxb").val();
        $("#codigos").text('');
        $("#show_code").hide();

        if ($.trim(categoria_tia) != "") {
            $("#producto_art + .select2-container ").hide();
            $("#producto_art").select2('data', null);
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/obtener_productos_tia',
                data: {categoria: categoria_tia, tipo: 2, bodega: bodega, sector: sector},
                success: function (data) {
                    producto = data.producto;

                    $("#dtg_producto").html(producto);
                    $("#dtg_producto").show();
                    $("#dtg_producto").select2('destroy').select2();
                    $("#medida_cva").html("<option value=''></option>");
                    $("#medida_cva").select2('destroy').select2();
                    $('.dinamic').each(function (index, el) {
                        $(this).attr('nid', index);
                    });
                    if(data.bodega==1){
                        crear_alerta('info', 'Cargar productos', 'Debe seleccionar una bodega.');
                    }
                }
            });
        } else {
            wait.start();
            $("#producto_art + .select2-container").show();
            $("#dtg_producto").select2('destroy');
            $("#dtg_producto").hide();
            $("#dtg_producto option:selected").removeAttr('selected');
            wait.close();
        }
    }

    $("#categoria_tia").live('change', function () {
        menor = Number($(this).attr('nid')) + 2;
         $("#codigos").text('');
        $("#show_code").hide();
        $(".dinamic").each(function (index, el) {
            if ($(el).attr('nid') > menor) {
                $(el).parent('div').siblings('label').remove();
                $(el).siblings('select').remove();
                $(el).parent('div').parent('div').parent('div').parent('div').remove();
                $(el).remove();
            }
        });
        $(".plus:last").remove();
        $(this).next().append('<button class="btn plus">+</button>');
        cargar_producto();
    });

    $(".plus").live('click', function (event) {
        event.preventDefault();
         $("#codigos").text('');
        $("#show_code").hide();
        categoria_tia = $("select[id='categoria_tia']").last().val();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/obtener_productos_tia',
            data: {categoria: categoria_tia},
            success: function (data) {
                categoria = data.categoria;
                producto = data.producto;
                n_cat = data.cat_hijo;

                $i = 0;
                $(".plus").last().remove();
                if (n_cat == 1) {
                    numero = $('#div-categorias select').last().length + 1;

                    linea = $("#div-categorias").append('<div class="form-row row-fluid">'
                            + '<div class="span12">'
                            + '<div class="row-fluid">'
                            + '<label class="span4">Categoria:</label>'
                            + '<div class="span7 controls">'
                            + '<select id="categoria_tia" class="nostyle seleccion dinamic" name="filtro" style="width:100%" placeholder="Seleccione"></select>'
                            + '</div></div></div></div>');
                    linea2 = $('select[id="categoria_tia"]').last().html();
                    nueva = linea2.replace(/#/g, numero);
                    $('#div-categorias').append(nueva);
                    $('select[id="categoria_tia"]').last().html(categoria);
                    $('select[id="categoria_tia"]').last().select2();
                    $("#dtg_producto").html(producto);
                } else {
                    //$("#producto_art").html(producto);
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se encontraron mas dependencias.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }

                $('.dinamic').each(function (index, el) {
                    $(this).attr('nid', index);
                });
            }
        });
    });

    /*====================================================================================================================================
     =											FILTRAR DEFECTO
     ======================================================================================================================================
     */

    $('#producto_art, #dtg_producto').change(function () {
        art = $(this).val();
        bodega = $("#bodega_bod").val();
        $("#producto_art").val(art);

        if ($.trim(art) != "") {
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_medida_defecto',
                type: 'POST',
                dataType: 'json',
                data: {producto: art},
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $("#medida_cva").html(data.resp);
                        $("#medida_cva").select2();
                    } else {
                        $("#medida_cva").html('<option value=""></option>');
                        $("#medida_cva").select2();
                    }
                }
            });

            // Se obtiene código(s) de productos y lote.
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_codigos_pro',
                type: 'POST',
                dataType: 'json',
                data: {producto: art, bodega: bodega},
                success: function (data) {
                    if ($.trim(data) != "") {
                        $("#codigos").text(data.mostrar);
                        $("#hdnexistencia").val(data.existencia);
                        $("#slcLote").html(data.lotes);
                        $("#slcLote").select2();

                        if($.trim(data.mostrar) != ""){
                            $("#show_code").show();
                        }else{
                             $("#show_code").hide();
                        }
                        
                        $("#txt_aplica_empaque").val(data.aplica_empaque);
                        
                        if ( data.aplica_empaque > 0){
                            var cantidad_defecto = $("#cantidad_dee").data("cantidaddefecto");
                            $("#cantidad_dee").val(cantidad_defecto);
                        }else {
                            $("#cantidad_dee").val("");
                        }         

                    } else {
                        $("#txt_aplica_empaque").val('');
                        $("#codigos").text('');
                        $("#show_code").hide();
                        $("#hdnexistencia").val();
                        $("#cantidad_dee").val("");
                    }
                }
            });

            //Costo promedio de la SAR
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_costo_sar',
                type: 'POST',
                data: {
                    producto: art, 
                    bodega: bodega
                },
                success: function (data) {
                    // console.log(data);
                    if ($.trim(data) != "") {
                        $("#costo_sar").val(data);
                    } 
                }
            });
       
        } else {
            $("#medida_cva").html('<option value=""></option>');
            $("#medida_cva").select2();
            $("#codigos").text('');
            $("#costo_sar").val('');
            $("#show_code").hide();
        }
    })

    /*====================================================================================================================================
     =												AGREGAR REQUISICION
     ======================================================================================================================================
     */

    $("#requisicion_rxi").change(function () {
        rxi = $(this).val();
        if ($.trim(rxi) != "") {
            $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #medida_cva").select2("disable");
            $("#cantidad_dee").attr("readonly", true)
            $("#add_producto_dee").css("display", "none");
            $("#body_productos_dee").html("");
            $.ajax({
                url: urlj + 'inventario/gestion_productos/cargar_requisicion',
                type: 'POST',
                dataType: 'json',
                data: {requisicion_rxi: rxi},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $("#bodega_bod").val(data.bodega);
                        $('#accion_columns').hide();
                        $("#bodega_bod").select2();
                        $("#bodega_bod").select2("disable");
                        if ($.trim(data.orden) != "") {
                            $("#orden_numero").val(data.orden);
                        }
                        if ($.trim(data.art_orden) != "") {
                            $("#articulos_orden").val(data.art_orden);
                        }
                        if ($.trim(data.orden) != "" && $.trim(data.art_orden) != "") {
                            $('#datos_rxi').show();
                        }
                        if ($.trim($("#bodega_bod").val()) != "") {
                            $("#body_productos_dee").append(data.resp);
                            $("#div_mostrar").fadeIn(300);
                            $('.id_art_rxi').each(function () {
                                var id_art  = $(this).val();
                                var fila    = $(this).data("fila");
                                $("#seleccion" + id_art).select2();
                                $("#" + id_art).numeric();
                                cargar_cantidades_rxi(id_art,fila);
                            });
                            $("select").select2();
                            $("#bodega_bod_error").text("");
                            recalcular_costo();
                            wait.close();
                        } else {
                            //si la bodega no pertecene al usuario mostrar estemensaje
                            $("#bodega_bod_error").text("La bodega no pertenece al usuario");
                            $("#div_mostrar").css('display', 'none');
                            $("#body_productos_dee").html("");
                            $("#doc_proveedor").val("");
                            $.pnotify({
                                type: 'info',
                                title: 'Aviso',
                                text: 'La bodega no asignada, comunicarse con un administrador',
                                icon: 'ui-icon ui-icon-info',
                                opacity: 0.95,
                                history: false,
                                sticker: false
                            });
                            wait.close();
                        }
                        ocultar_datos_producto();
                        ajustar_border();
                    }else{
                        crear_alerta('error', 'Verifique los datos de la requisición');
                        wait.close();
                    }
                }
            });
        } else {
            $('#accion_columns').show();
            $('#datos_rxi').hide();
            $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto,#medida_cva, #bodega_bod").select2("enable");
            $("#cantidad_dee").attr("readonly", false)
            $("#add_producto_dee").css("display", "")
            $("#div_mostrar").css('display', 'none');
            $("#body_productos_dee").html("");
            $("#bodega_bod_error").text("");
            $("#bodega_bod option").removeAttr("selected");
            $("#bodega_bod").select2();
        }
    })

    $(".grid_select").live('change', function () {
        var sector  = $(this).val();
        var id      = $(this).attr('valor');
        var bodega  = $("#bodega_bod").val();
        var fila    = $(this).parent().parent().attr("id"); 
        console.log();
        $.ajax({
            url: urlj + 'inventario/gestion_productos/obtener_sectores_producto',
            type: 'POST',
            dataType: 'json',
            data: {bodega: bodega, sector: sector, id: id},
            success: function (data) {
                if ($.trim(data.resp) != "") {
                    if (fila != null){
                        $("#body_productos_dee #" + fila + " #cantidad_req_" + id).val(data.resp);
                        $("#body_productos_dee #" + fila + " #cantidad_req_" + id).next().text(data.resp);
                    } else {
                        $("#cantidad_req_" + id).val(data.resp);
                        $("#cantidad_req_" + id).next().text(data.resp);
                    }
                }
            }
        });
    });

    $(".validar_cantidads").live('change', function () {
        art_id = $(this).attr("id");
        cantidad = parseFloat($(this).val());
        cantidad_defecto = parseFloat($(this).attr("cant_def"));
        cantidad_maxima = parseFloat($("#cantidad_req_" + art_id).val());
        $(this).val(number_format($(this).val(), 2));
        if (!(cantidad < 0)) {
            if (!(cantidad <= cantidad_maxima) || !(cantidad <= cantidad_defecto)) {
                if ($("#bodega_bod").val() == "") {
                    if (cantidad_defecto > cantidad_maxima) {
                        $(this).val(cantidad_defecto);
                    }
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se a seleccionado la bodega.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                } else {
                    if (cantidad_maxima > cantidad_defecto) {
                        if (!(cantidad <= cantidad_defecto)) {
                            mensaje = 'La cantidad solicitada excede la peticion.';
                            $(this).val(number_format(cantidad_defecto, 2));
                        }
                    } else if (cantidad_maxima <= cantidad_defecto) {
                        if ((!(cantidad <= cantidad_maxima))) {
                            mensaje = 'La cantidad solicitada excede las existencias.';
                            $(this).val(number_format(cantidad_maxima, 2));
                        }
                    }
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: mensaje,
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }
            }
        } else {
            if (cantidad_maxima > cantidad_defecto) {
                $(this).val(number_format(cantidad_defecto, 2));
            } else if (cantidad_maxima <= cantidad_defecto) {
                $(this).val(number_format(cantidad_maxima, 2));
            }
        }
    });

    function validar_requisicion() {
        var cantidad_req = 0;
        var cantidad_req_def = 0;
        $('.validar_cantidad').each(function () {
            art_id = $(this).attr("id");
            cantidad = parseFloat($(this).val());
            cantidad_defecto = parseFloat($(this).attr("cant_def"));
            cantidad_maxima = parseFloat($("#cantidad_req_" + art_id).val());
            if (!(cantidad <= cantidad_maxima)) {
                cantidad_req = 1;
            } else if (!(cantidad <= cantidad_defecto)) {
                cantidad_req_def = 1;
            }
        })
        if (cantidad_req == 1) {
            $.pnotify({
                type: 'info',
                title: 'Aviso',
                text: 'La cantidad solicitada excede las existencias.',
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
            return false;
        }
        if (cantidad_req_def == 1) {
            $.pnotify({
                type: 'info',
                title: 'Aviso',
                text: 'La cantidad solicitada excede la peticion.',
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
            return false;
        }
        return true;

    }
    /*====================================================================================================================================
     =											AGREGA LOS CAMPOS A LA GRID
     ======================================================================================================================================
     */

    function get_codigo_cva(art_id, cva_id) {
        var respuesta = $.ajax({
            url: urlj + 'inventario/gestion_productos/get_codigo_cva',
            type: 'POST',
            async: false,
            dataType: 'json',
            data: {producto: art_id, medida: cva_id},
            success: function (data) {
                return data;
            }
        }).responseText;
        return respuesta;
    }

    function get_sectores(bod_id, sxb_id, producto) {
        var respuesta = $.ajax({
            url: urlj + 'inventario/gestion_productos/cargar_sector_selected',
            type: 'POST',
            async: false,
            dataType: 'json',
            data: {bodega: bod_id, sector: sxb_id, producto: producto},
            success: function (data) {
                return data;
            }
        }).responseText;
        return respuesta;
    }

    $('#add_producto_dee').live('click', function (event) {
        event.preventDefault();
        if($("#dtg_producto").val()>0){ 
            var producto_art = $("#dtg_producto").val().trim();
            var producto_art_select = $("#dtg_producto option:selected").text();
            var cantidad_maxima =  $("#dtg_producto option:selected").attr("cant");
        }else{
            var producto_art = $("#producto_art").val();
            var producto_art_select = $("#producto_art").next('div').text();
            var cantidad_maxima =  $("#hdnexistencia").val();
        }

        var medida_cva = $("#medida_cva").val().trim();
        var medida_cva_select = $("#medida_cva option:selected").text();
        var lote = $("#slcLote").val();
        var cant_lote = $("#slcLote option:selected").data('cant');
        var costo_prom = $("#costo_promedio").val(); 
        var cantidad_dee = $("#cantidad_dee").val();
        var costo_sar = $("#costo_sar").val();
        var sector_sxb = $("#sector_sxb").val();
        var bodega_bod = $("#bodega_bod").val();
        
        var aplica_empaque = $("#txt_aplica_empaque").val();

        var cantidad_lote = $("#txt_correlativo_lote").val() != undefined ? $("#txt_correlativo_lote").val() : "";
     
        //variables para el mensaje
        var mensaje = "";
        var type_msg = "";
        if (producto_art != "" && medida_cva != "" && cantidad_dee != "") {
            type_msg = "error";
            if (cantidad_dee > 0) {
                if (($("#producto_art" + producto_art).length <= 0 && $("#producto_art" + producto_art+lote).length <= 0 )) {
                    var sectores_sxb = get_sectores(bodega_bod, sector_sxb, producto_art);
                    var obj_sxb = jQuery.parseJSON(sectores_sxb);
                    var select_sxb = obj_sxb.resp;

                    var codigo_medida = get_codigo_cva(producto_art, medida_cva);
                    var obj = jQuery.parseJSON(codigo_medida);
                    var nombre = obj.nombre;
                    var codigo = obj.codigo;
                    var medida = obj.conversion;
                    var defecto = obj.defecto;
                    var defecto_nom = obj.defecto_nom;

                    var cantidad_medida = cantidad_dee * (medida / defecto);
                    var cantidad_maxima_conver = cantidad_maxima / (medida / defecto);

                    var conversion_def = (medida / defecto);
                    var decimales = ((cantidad_maxima_conver - parseInt(cantidad_maxima_conver)) * medida);
                    var decimal = "";
                    if (conversion_def != 1) {
                        decimal = decimales.toFixed(0) + " " + defecto_nom;
                    }

                    var mostrar_saldo = number_format(cantidad_maxima_conver, $("#decimales").val(), ".", "") + " " + medida_cva_select + " " + decimal;

                    if ( (cantidad_medida <= cantidad_maxima && lote=='') || (lote!='' && cantidad_medida <= cant_lote) ) {
                        id_correlativo = $("#contador_producto_dee").val(); //crear un id unico para anexos de documentos

                        costo_option = '<a class="fancy_costo" style="margin-right: 12px;font-size:15px;cursor:pointer;" href="#costos_producto' + producto_art + '_'+id_correlativo+'">';
                        costo_option += '<span class="icon16 icomoon-icon-puzzle"></span>Centro costos';
                        costo_option += '</a>';

                        eliminar = '<a id="del_doc" style="margin-right: 12px;font-size:15px;cursor:pointer;" valor="' + id_correlativo + '" thead="div_mostrar" tbody="body_productos_dee">';
                        eliminar += '<span class="icon16 icomoon-icon-remove"></span>Eliminar';
                        eliminar += '</a>';

                        empaque = '<a  class="fancy_empaque" id="empaque_'+producto_art+'" style="margin-right: 12px;font-size:15px;cursor:pointer;" href="#div_empaque"  data-articulo="' + producto_art + '" >';
                        empaque += '<span class="icon16 icomoon-icon-box"></span>Empaque';
                        empaque += '</a>';                       

                        var acciones_drop = '';
                        acciones_drop += '<div class="tools">';
                        acciones_drop +=    '<div class="btn-group">';
                        acciones_drop +=        '<button type="button" class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>';
                        acciones_drop +=        '<button type="button" class="btn dropdown-toggle" data-toggle="dropdown">';
                        acciones_drop +=            '<span class="caret"></span>';
                        acciones_drop +=        '</button>';
                        acciones_drop +=        '<ul class="dropdown-menu">';

                        if ( aplica_empaque == 1){

                            acciones_drop +=            '<li style="text-align:left;"> ';
                            acciones_drop +=                empaque;
                            acciones_drop +=            '</li>';

                            var tabla_empaque = cantidad_lote != undefined ? cantidad_lote : "";
                            if(tabla_empaque == undefined || tabla_empaque !== "" || tabla_empaque !== null) {
                                tabla_empaque = "";
                            }
                            
                            cantidad_detalle = '<label id="lbl_detalle_cantidad_'+producto_art+'">0.00 ('+ number_format(cantidad_dee,$("#decimales").val(), ".", "")+')</label>';
                        } else{
                            cantidad_detalle = '<label id="lbl_detalle_cantidad_'+producto_art+'">'+ number_format(cantidad_dee,$("#decimales").val(), ".", "")+'</label>';    
                        }

                        acciones_drop +=            '<li style="text-align:left;"> ';
                        acciones_drop +=                costo_option;
                        acciones_drop +=            '</li>';

                        acciones_drop +=            '<li style="text-align:left;"> ';
                        acciones_drop +=                eliminar;
                        acciones_drop +=            '</li>';

                        acciones_drop +=        '</ul>';
                        acciones_drop +=    '</div>';
                        acciones_drop += '</div>';

                        id_correlativo_reg = '<input type="hidden" name="correlativo[]" value="' + id_correlativo + '" />';
                        id_producto_art = '<input type="hidden" id="producto_art'+ producto_art + lote +'" name="producto_art[]" value="' + producto_art + '" />';
                        codigo_lote = '<input type="hidden" name="codigo_lote[]" value="' + lote + '" />';
                        id_medida_cva = '<input type="hidden" name="medida_cva[]" value="' + medida_cva + '" />';
                        id_cantidad_maxima = '<input type="hidden" name="cantidad_maxima[]" value="' + number_format(cantidad_maxima, $("#decimales").val(), ".", "") + '" />';
                        id_cantidad_dee = '<input type="hidden" id="detalle_cantidad_'+producto_art+'" name="cantidad_dee[]" value="' + cantidad_medida + '" />';
                        //id_precio_dee = '<input type="hidden" name="precio_dee[]" value="'+precio_dee+'" />';
                        //id_costo_total = '<input type="hidden" class="costos_produc" name="costo_total[]" value="'+costo_total+'" />';
                        //id_fecha_dee = '<input type="hidden" name="fecha_dee[]" value="'+fecha_dee+'" />';

                        var td_first = codigo + tabla_empaque;
                        //siempre llegaba tabla_empaque como undefined, ais que hacemos split para eliminar si en dado caso viene indefinido
                        td_first = td_first.split("undefined");
                        $("#body_productos_dee").append(
                                '<tr id="filadiv_mostrar' + id_correlativo + '" >' +
                                '<td>' + td_first[0] +'</td>' +
                                '<td>' + id_correlativo_reg + id_producto_art + nombre + '</td>' +
                                '<td>' + codigo_lote + lote + '</td>' +
                                '<td>' + id_medida_cva + medida_cva_select + '</td>' +
                                '<td>' + id_cantidad_maxima +  mostrar_saldo + '</td>' +
                                '<td style="text-align: right;">$' + number_format(costo_sar, $("#decimales").val()) + '</td>' +
                                '<td style="text-align: right;">' + id_cantidad_dee + cantidad_detalle + '</td>' +
                                '<td style="text-align: right;"><input type="hidden" class="costos_produc" value="' + number_format((costo_sar * cantidad_dee), $("#decimales").val(), '.','') + '" />$' + number_format((costo_sar * cantidad_dee), $("#decimales").val()) + '</td>' +
                                '<td><select name="sector_sxb[]" class="seleccion grid_select" id="seleccion' + producto_art + lote+'" style="width: 100%;" placeholder="Seleccione">' + select_sxb + '</select></td>' +
                                //'<td>$'+ id_precio_dee + precio_dee + '</td>' +
                                //'<td>$'+ id_costo_total + costo_total + '</td>' +
                                //'<td>'+ id_fecha_dee + fecha_dee + '</td>' +
                                '<td><div>' + acciones_drop +'<div id="costos_producto' + producto_art + '_'+id_correlativo+'" style="display:none"></div></div></td>' +
                                '</tr>');
                        $("#div_mostrar").fadeIn(300);
                        $("#seleccion" + producto_art + lote).select2();
                        var NC = parseInt($("#contador_producto_dee").val()) + 1;
                        $("#contador_producto_dee").val(NC);

                        $(".dinamic").each(function (index, el) {
                            if ($(el).attr('nid') > 1) {
                                $(el).parent('div').siblings('label').remove();
                                $(el).siblings('select').remove();
                                $(el).parent('div').parent('div').parent('div').parent('div').remove();
                                $(el).remove();
                            }
                        });
                        cargar_centro_costo(producto_art, id_correlativo, '', 0); //centro de costos
                        var suma_costos = 0;
                        $('.costos_produc').each(function () {
                            suma_costos += parseFloat($(this).val());
                        })
                        $("#total_product").html("$" + number_format(suma_costos, $("#decimales").val()));

                        $("#producto_art").html("<option value=''></option>");
                        $("#medida_cva").html("<option value=''></option>");

                        $("#categoria_tia option").removeAttr("selected");
                        $("#categoria_tia").select2();

                        $("#dtg_producto option").removeAttr("selected");
                        $("#dtg_producto").select2('destroy');
                        $("#dtg_producto").hide();

                         $("#producto_art").select2('data', null);
                        //limpiarproducto();

                        $("#medida_cva option").removeAttr("selected");
                        $("#medida_cva").select2();

                        $("#cantidad_dee").val("");

                        $("#producto_art_error").text('');
                        $("#medida_cva_error").text('');
                        $("#cantidad_dee_error").text('');

                    } else {
                        mensaje = "La cantidad solicitada excede las existencias";
                    }
                } else {
                    mensaje = "El detalle ya ha sido agregado";
                }
            } else {
                if (cantidad_dee <= 0) {
                    $("#cantidad_dee_error").text('La cantidad debe ser mayor a 0');
                }
            }
        } else {
            type_msg = "error";
            mensaje = "Los campos con * requeridos";
            if (producto_art == "" && medida_cva == "") {
                $("#producto_art_error").text('Campo requerido');
                $("#medida_cva_error").text('Campo requerido');
                $("#cantidad_dee_error").text('Campo requerido');

            } else if (producto_art == "") {
                mensaje = "El producto es requerido";
                $("#producto_art_error").text('Campo requerido');
                if (medida_cva == "") {
                    $("#medida_cva_error").text('Campo requerido');
                }
                if (cantidad_dee == "") {
                    $("#cantidad_dee_error").text('Campo requerido');
                }

            } else if (medida_cva == "") {
                mensaje = "La unidad de medida es requerido";
                $("#medida_cva_error").text('Campo requerido');
                if (producto_art == "") {
                    $("#producto_art_error").text('Campo requerido');
                }
                if (cantidad_dee == "") {
                    $("#cantidad_dee_error").text('Campo requerido');
                }

            }
        }
        if (mensaje != "") {
            $.pnotify({
                type: type_msg,
                title: 'Informaci&oacute;n',
                text: mensaje,
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
        }

    });

    $("body").on('change', '#slcLote', function () {
        if ( $("#bodega_bod").val() != "" && $("#slcLote").val() != "" && $("#producto_art").val() != ""){
            get_productos_empaquetados($("#bodega_bod").val(), $("#producto_art").val(), $("#slcLote").val(), 2);
        } else {
            $("#txt_correlativo_lote").val("");
        }
    });


/* =====================================================================================================================================
                                        CENTRO COSTO
========================================================================================================================================
*/

    function cargar_centro_costo(producto, correlativo, centro_costo, subtotal){ //nos carga el div de los centros de costo
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'facturacion/facturar/obtener_costos',
            data: {producto: producto,correlativo:correlativo, costo: centro_costo, subtotal: subtotal, tipo: 1},
            success: function (data) {
                if(data.error == 1){
                    crear_alerta("info", "Aviso", "Hubo un error al cargar los componentes.");
                } else{
                    var identificador = producto+'_'+correlativo;
                    $("#costos_producto"+identificador).html(data.html);
                }
            }
        })
    }

    $(".agregar_det_costo").live('click', function(){ //nos agrega el componente a la grid
        var producto = $(this).data('idp');
        var correlativo = $(this).data('corr');
        var ident = $(this).data('iden');

        var subtotal_costo = $("#subtotal_producto"+ident).val(); //centro de costo

        //centro costo
        var select_costo = $("#centro_costo"+ident).val(); //centro de costo id
        var select_text_costo = $("#centro_costo"+ident+" option:selected").text(); //nombre de centro y tipo cuenta
        var select_tcuenta_costo = $("#centro_costo"+ident+" option:selected").data('tcuenta');//id
        var select_cuenta_costo = $("#centro_costo"+ident+" option:selected").data('cuenta');//id

        var select_costo_array = select_text_costo.split(' - ');

        var nombre_centro_costo = select_costo_array[0];
        var nombre_tipo_cuenta = select_costo_array[1];
        var nombre_cuenta_costo = $("#centro_costo"+ident+" option:selected").data('cuenta_nomb'); //nombre de cuenta


        //porcentaje
        var porcentaje = parseFloat($("#porcentaje_costo_modal"+ident).val());

        var campos_requeridos = '';
        if($("#centro_costo_costo"+select_costo+ident).length > 0){
            crear_alerta("info", "Aviso", "El costo ya ha sido ingresado.");
            return false;
        }

        var porcentaje_actual = obtener_porcentajes($(this).closest('.slCobrs'));

        if((porcentaje_actual+porcentaje) > 100){
            crear_alerta("info", "Aviso", "El porcentaje supera el 100%.");
            return false;
        }

        if((select_costo>0 || select_costo!='') && porcentaje>0.00){
            var subtotal_porcentaje = subtotal_costo*(porcentaje/100);
            var contador = parseInt($("#contador_costo"+ident).val());
            //var ident2 = '_'+select_producto+'_'+contador;
            if($("#grid_costo"+ident).find(".grid_empty").length > 0){
                $("#grid_costo"+ident).html('');
            }
            
            caj_centro_costo = '<input type="hidden" id="centro_costo_costo'+select_costo+ident+'" name="centro_costo_costo'+ident+'[]" class="centro_costov" value="'+select_costo+'">'+
                            '<label style="padding: 6px 4px;">'+nombre_centro_costo+'</label>';

            caj_tipo_cuenta = '<input type="hidden" id="tipo_cuenta_costo'+ident+'" name="tipo_cuenta_costo'+ident+'[]" class="tipo_cuentav" value="'+select_tcuenta_costo+'">'+ //a guardar
                            '<label style="padding: 6px 4px;">'+nombre_tipo_cuenta+'</label>';

            caj_cuenta = '<input type="hidden" id="cuenta_contable_costo'+ident+'" name="cuenta_contable_costo'+ident+'[]" class="cuenta_contablev" value="'+select_cuenta_costo+'">'+
                            '<label style="padding: 6px 4px;">'+nombre_cuenta_costo+'</label>';

            caj_porcentaje = '<input type="hidden" class="porcentaje_costo_temp" value="'+porcentaje+'">'+
                            '<input type="text" name="porcentaje_costo'+ident+'[]" class="soloDecimales porcentaje_costo edit" data-tip="0" value="'+porcentaje+'" style="margin-bottom: 0px;width: 100%;display:none;">'+
                            '<label style="padding: 6px 4px;">'+porcentaje+'%</label>';

            caj_subtotal = '<input type="hidden" name="subtotal_costo'+ident+'[]" class="subtotal_costo" value="'+subtotal_porcentaje+'">'+
                            '<label style="padding: 6px 4px;">$'+number_format(subtotal_porcentaje, cantidad_decimales)+'</label>';
            

            editar = '<a class="icon12 icomoon-icon-pencil-5 editar_costo action" est="0" idn="'+ident+'" correlativo="'+correlativo+'" title="Editar costo" style="margin-right: 10px;font-size:15px;cursor:pointer;"></a>';
            eliminar = '<a class="icon-remove white remove_costo action" title="Eliminar costo" style="margin-right: 5px;cursor:pointer;font-size:15px;">&nbsp;</a>';
            
            caj_acciones = editar+eliminar;
            //$("#grid_componente"+ident).find(".grid_empty").length;
            //console.log(ident);
            $("#grid_costo"+ident).append('<tr id="body_costo_'+contador+ident+'" class="tr_body_costo">'+
                '<td width="25%">'+caj_centro_costo+'</td>'+
                '<td width="14%">'+caj_tipo_cuenta+'</td>'+
                '<td width="25%">'+caj_cuenta+'</td>'+
                '<td width="14%">'+caj_porcentaje+'</td>'+
                '<td width="14%" style="display:none">'+caj_subtotal+'</td>'+
                '<td width="8%">'+caj_acciones+'</td></tr>');
            contador += 1;
            var ident_div = $(this).closest('.slCobrs');
            //actualizar_precio(ident_div);
            //Reinicio de cajas
            $("#centro_costo"+ident+" option").removeAttr('selected');
            $("#centro_costo"+ident).select2();
            $("#porcentaje_costo_modal"+ident).val('');
            actualizar_totales($(this).closest('.slCobrs'));
            $("#contador_componente"+ident).val(contador);
        } else{
            if((!select_costo>0) || select_costo==''){
                campos_requeridos += 'costo, ';
            } 
            if((!porcentaje>0) || porcentaje!=''){
                campos_requeridos += 'porcentaje, ';
            }
            if($.trim(campos_requeridos) != ''){
                var requerido_array = campos_requeridos.split(', ');
                requerido_array = requerido_array.filter(Boolean); //nos quita las posiciones vacias de un arreglo
                campos_requeridos = (requerido_array.length == 1)?'El campo: ' + campos_requeridos.replace(/,/g,'') + ' es requerido':'Los campos: ' + campos_requeridos + ' son requeridos';
                crear_alerta("info", "Aviso", campos_requeridos)
            }
        }
    })

    function actualizar_totales(modal){
        var total_porcentaje = 0;
        var subtotal_costo = parseFloat(modal.find(".subtotal_producto").val());
        modal.find('.tr_body_costo').each(function(){
            total_porcentaje += parseFloat($(this).find('.porcentaje_costo').val());
        })
        modal.find('.foot_porcentaje').text(number_format(total_porcentaje,2)+'%');
        //modal.find('.foot_subtotal').text('$'+number_format((subtotal_costo*(total_porcentaje/100)),cantidad_decimales))
    }

    function obtener_porcentajes(modal){
        var total_porcentaje = 0;
        modal.find('.tr_body_costo').each(function(){
            total_porcentaje += parseFloat($(this).find('.porcentaje_costo').val());
        })
        return total_porcentaje
    }

    $(".editar_costo").live('click', function(){
        var est = $(this).attr('est');
        var tr = $(this).closest('tr');
        var ident = $(this).closest('.slCobrs');
        var porcentaje_actual = obtener_porcentajes(ident);
        var subtotal_costo = parseFloat(ident.find(".subtotal_producto").val());
        if(est == 0){
            $(this).attr('est',1);
            tr.find('.edit').show();
            tr.find('.edit').each(function(){
                $(this).next('label').hide();
            })
        } else{
            var error = 0;
            tr.find('.edit').each(function(){
                var val_temp = ($(this).data('tip')==1)?number_format($(this).val(),cantidad_decimales):parseFloat($(this).val());
                if($(this).data('tip')!=1){
                    if((porcentaje_actual - (parseFloat($(this).after().val())) + val_temp) > 100){
                        crear_alerta("info", "Aviso", "El porcentaje supera el 100%.");
                        error = 1;
                    } else{
                        $(this).after().val(val_temp);
                        $(this).next('label').text(val_temp+'%');
                        $(this).next('label').show();
                        tr.find('.subtotal_costo').val((subtotal_costo*(parseFloat(val_temp)/100)));
                        tr.find('.subtotal_costo').next().text('$'+number_format((subtotal_costo*(parseFloat(val_temp)/100)),cantidad_decimales));
                    }
                }
                
            })
            if(error == 0){
                $(this).attr('est',0);
                tr.find('.edit').hide();
                actualizar_totales(ident);
            }
            
        }
    })

    $(".porcentaje_costo ").live('blur', function(){
        var tr = $(this).closest('tr');
        var valor = parseFloat($(this).val());
        var div_costos = $(this).closest('.slCobrs');
        var porcentaje_actual = obtener_porcentajes(div_costos);
        if(isNaN(valor)){
            $(this).val(1);
            crear_alerta("info", "Aviso", 'El precio no puede contener letras.');
        } else if(valor == parseFloat(0.00)){
            $(this).val(1);
            crear_alerta("info", "Aviso", 'La cantidad no puede ser 0.');
        } else if( (porcentaje_actual - (parseFloat($(this).after().val())) + valor) > 100 ){
            $(this).val(1);
            crear_alerta("info", "Aviso", 'El porcentaje no puede ser mayor a 100%.');
        }
        actualizar_sub_total_costo(tr);
    })

    function actualizar_sub_total_costo(tr_fila){
        var div_costos = tr_fila.closest('.slCobrs');
        var subtotal_costo = parseFloat(div_costos.find(".subtotal_producto").val());

        tr_fila.find('.edit').each(function(){
            if($(this).data('tip')==0){
                var val_temp = parseFloat($(this).val());
                console.log(val_temp);
                console.log(subtotal_costo);
                $(this).after().val(val_temp);
                $(this).next('label').text(val_temp+'%');
                tr_fila.find('.subtotal_costo').val((subtotal_costo*(parseFloat(val_temp)/100)));
                tr_fila.find('.subtotal_costo').next().text('$'+number_format((subtotal_costo*(parseFloat(val_temp)/100)),cantidad_decimales));
            }
            
        })
        actualizar_totales(div_costos);
    }

    function actualizar_porcentaje_principal(modal, precio){
        modal.find(".subtotal_producto").val(precio);
        modal.find(".tr_body_costo").each(function(){
            actualizar_sub_total_costo($(this));
        })
    }

    $(".remove_costo").live('click', function(){ //elimina el componente agregado
        var tr = $(this).closest('tr');
        var body = $(this).closest('tbody');
        var ident = $(this).closest('.slCobrs');
        tr.remove();
        actualizar_totales(ident);
        if(!(body.find('tr.tr_body_costo').length > 0)){
            body.html('<td style="text-align: center;" colspan="6" class="grid_empty">No se encontraron registros</td>');
        }
    })

    function actualizar_centro_costo_select(valor){
        $(".slCobrs").each(function(){
            var ident = $(this).data('ident');
            var correlativo = $(this).data('corr');
            var existe = $('#centro_costo'+ident+' option[value="'+valor+'"]');
            if(existe.length > 0){
                if($("#grid_costo"+ident).find(".grid_empty").length > 0){
                    $("#grid_costo"+ident).html('');

                    // es copia del de agregar "literalmente" con porcentaje 100%
                    var subtotal_costo = $("#subtotal_producto"+ident).val(); //centro de costo

///////////////////////////////////////////////////no cambia
                    //centro costo
                    var select_costo = existe.val(); //centro de costo id
                    var select_text_costo = existe.text(); //nombre de centro y tipo cuenta
                    var select_tcuenta_costo = existe.data('tcuenta');//id
                    var select_cuenta_costo = existe.data('cuenta');//id

                    var select_costo_array = select_text_costo.split(' - ');

                    var nombre_centro_costo = select_costo_array[0];
                    var nombre_tipo_cuenta = select_costo_array[1];
                    var nombre_cuenta_costo = existe.data('cuenta_nomb'); //nombre de cuenta
/////////////////////////////////////////////////no cambia

////////////////////////////////////////////////copiar y pegar
                    //porcentaje
                    var porcentaje = parseFloat(100);

                    var subtotal_porcentaje = subtotal_costo*(porcentaje/100);
                    var contador = parseInt($("#contador_costo"+ident).val());
                    //var ident2 = '_'+select_producto+'_'+contador;
                    if($("#grid_costo"+ident).find(".grid_empty").length > 0){
                        $("#grid_costo"+ident).html('');
                    }
                    
                    caj_centro_costo = '<input type="hidden" id="centro_costo_costo'+select_costo+ident+'" name="centro_costo_costo'+ident+'[]" class="centro_costov" value="'+select_costo+'">'+
                                    '<label style="padding: 6px 4px;">'+nombre_centro_costo+'</label>';

                    caj_tipo_cuenta = '<input type="hidden" id="tipo_cuenta_costo'+ident+'" name="tipo_cuenta_costo'+ident+'[]" class="tipo_cuentav" value="'+select_tcuenta_costo+'">'+ //a guardar
                                    '<label style="padding: 6px 4px;">'+nombre_tipo_cuenta+'</label>';

                    caj_cuenta = '<input type="hidden" id="cuenta_contable_costo'+ident+'" name="cuenta_contable_costo'+ident+'[]" class="cuenta_contablev" value="'+select_cuenta_costo+'">'+
                                    '<label style="padding: 6px 4px;">'+nombre_cuenta_costo+'</label>';

                    caj_porcentaje = '<input type="hidden" class="porcentaje_costo_temp" value="'+porcentaje+'">'+
                                    '<input type="text" name="porcentaje_costo'+ident+'[]" class="soloDecimales porcentaje_costo edit" data-tip="0" value="'+porcentaje+'" style="margin-bottom: 0px;width: 100%;display:none;">'+
                                    '<label style="padding: 6px 4px;">'+porcentaje+'%</label>';

                    caj_subtotal = '<input type="hidden" name="subtotal_costo'+ident+'[]" class="subtotal_costo" value="'+subtotal_porcentaje+'">'+
                                    '<label style="padding: 6px 4px;">$'+number_format(subtotal_porcentaje, cantidad_decimales)+'</label>';
                    

                    editar = '<a class="icon12 icomoon-icon-pencil-5 editar_costo action" est="0" idn="'+ident+'" correlativo="'+correlativo+'" title="Editar costo" style="margin-right: 10px;font-size:15px;cursor:pointer;"></a>';
                    eliminar = '<a class="icon-remove white remove_costo action" title="Eliminar costo" style="margin-right: 5px;cursor:pointer;font-size:15px;">&nbsp;</a>';
                    
                    caj_acciones = editar+eliminar;
                    //$("#grid_componente"+ident).find(".grid_empty").length;
                    $("#grid_costo"+ident).append('<tr id="body_costo_'+contador+ident+'" class="tr_body_costo">'+
                        '<td width="25%">'+caj_centro_costo+'</td>'+
                        '<td width="14%">'+caj_tipo_cuenta+'</td>'+
                        '<td width="25%">'+caj_cuenta+'</td>'+
                        '<td width="14%">'+caj_porcentaje+'</td>'+
                        '<td width="14%">'+caj_subtotal+'</td>'+
                        '<td width="8%">'+caj_acciones+'</td></tr>');
                    contador += 1;
                    var ident_div = $(this).closest('.slCobrs');
                    //actualizar_precio(ident_div);
                    //Reinicio de cajas
                    $("#centro_costo"+ident+" option").removeAttr('selected');
                    $("#centro_costo"+ident).select2();
                    $("#porcentaje_costo_modal"+ident).val('');
                    actualizar_totales($(this).closest('.slCobrs'));
                    $("#contador_componente"+ident).val(contador);
                }
            }
        })
    }

/*
                    FIN DE COSTO
*/

    $('#del_doc').live('click', function (event) {
        event.preventDefault();
        //obtenemos los valores del boton de eliminar para eliminar la fila
        var id_fila = $(this).attr("valor");
        var id_head = $(this).attr("thead");
        var id_body = $(this).attr("tbody");
        $("#fila" + id_head + id_fila).remove();
        recalcular_costo();
        if ($('#' + id_body).find('tr').length == 0) {
            $("#" + id_head).css('display', 'none');
            //$("#"+id_head).css('display','none');
        }
    });

    function aplicar_fancy() {
        $(".fancy_costo").fancybox({
            width: '70%',
            height: 'auto',
            autoSize: false,
            closeClick: false,
            type: 'inline',
            /*closeBtn : false,
            keys : {
                close  : null
            },
            helpers: {
                overlay: { closeClick: false } //Disable click outside event
            },*/
            beforeLoad: function () {

            },
            beforeClose: function () {
                var modal_id = $(this).attr('href');
                var modal = $(modal_id).find('.slCobrs');
                var porcentaje_modal = obtener_porcentajes(modal);
                if(!(porcentaje_modal == 0 || porcentaje_modal == 100)){
                    crear_alerta("info", "Aviso", "El porcentaje debe ser 100%.");
                    return false;
                }
            }
        })
    }
    aplicar_fancy();

})

function limpiarproducto(){
   $("#producto_art").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/gestion_productos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    bodega: $("#bodega_bod").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });
}
 
$(".fancy_empaque").fancybox({
    width: '80%',
    height: 'auto',
    autoSize: false,
    closeClick: false,
    type: 'inline',
    closeBtn : false,
    keys : {
        close  : null
    },
    helpers: {
        overlay: { closeClick: false } //Disable click outside event
    },
    beforeLoad: function () {            
        var id          = $(this.element[0]).data("articulo");
        var tabla       = $("#tb_empaque_"+id).html();
        var tfoot       = $("#tf_empaque_"+id).html();
        
        var correlativo = $("#txt_contador_empaque_"+id).val();
        var tabla_carac = "#caracTable_" + id + "_" + correlativo;
        
        $("#tbody_empaque_modal").append(tabla);
        $("#tfoot_empaque_modal").append(tfoot);
    
        $("#txt_modal_id").val(id);
        $("#chk_empaque").val(id);
        
        //ocultar los totales
        $("#tfoot_empaque_modal input").hide();
        $("#tfoot_empaque_modal input:last").show();
    },
    beforeClose: function () {
        $("#chk_empaque").val("");
        $("#tbody_empaque_modal").html("");
        $("#tfoot_empaque_modal").html("");            
       
        $("#txt_modal_id").val("");
        $("#txt_empaque_unidades_modal").val("");
        $("#txt_empaque_peso_n_modal").val("");
        $("#txt_empaque_peso_b_modal").val("");

    }
});

function get_productos_empaquetados(bodega,articulo,lote,tipo){
    $.ajax({
        url: urlj + 'inventario/gestion_productos/get_productos_empaquetados',
        type: 'POST',
        dataType: 'json',
        data: {bodega: bodega, articulo: articulo,lote: lote, tipo: tipo},
        success: function (data) {
            $("#txt_correlativo_lote").val(data);
        }
    });
 }


 
 $("body").on('click', '#chk_empaque', function () {
   
    var id = $(this).val();
    if ($(this).is(':checked')) { 
        $('#table_empaque .chk_empaque_'+id).each(function() {
            $(this).attr('checked', true);
        });
    } else {
        $('#table_empaque .chk_empaque_'+id).each(function() {
            $(this).attr('checked', false);
        });
    }
    sumar_empaques(id);
});

function sumar_empaques(id){
    suma = 0 ;
    $('#table_empaque .chk_empaque_'+id).each(function() {
        if ($(this).is(':checked')) { 
            suma =  suma + parseFloat($(this).data( "cantidad"));
        }
    });

    var total_unidades  = contar_columnas("#table_empaque .unidades_empaque_"+id) ;
    var total_bruto     = contar_columnas("#table_empaque .bruto_empaque_"+id) ;
    var total_neto      = contar_columnas("#table_empaque .neto_empaque_"+id) ;

    $("#table_empaque #foot_unidades_empaque_"+id).attr("value",total_unidades);
    $("#table_empaque #foot_neto_empaque_"+id).attr("value",total_neto);
    $("#table_empaque #foot_bruto_empaque_"+id).attr("value",total_bruto);
    $("#table_empaque #foot_envio_empaque_"+id).attr("value",suma);
}

$("#table_empaque").on('click', '.chk_empaque', function () {
    var id = $(this).data( "id");  
    if ($(this).is(':checked')) { 
        $(this).attr('checked', true);
    } else {
        $(this).attr('checked', false);
    }
    sumar_empaques(id); 
});


$("body").on('click', '#guardar_empaque_modal', function () {
    event.preventDefault();
   
    var new_tabla   = $("#table_empaque #tbody_empaque_modal").html();
    var new_foot    = $("#tfoot_empaque_modal").html();

    var id          = $("#txt_modal_id").val();
    var total_neto  = $("#table_empaque #foot_envio_empaque_"+id).val();
    
    $("#tb_empaque_"+id).html(new_tabla);
    $("#tbody_empaque_modal").html("");

    $("#tf_empaque_"+id).html(new_foot);
    $("#tfoot_empaque_modal").html("");

    $("#txt_modal_id").val("");
    $("#txt_empaque_unidades_modal").val("");
    $("#txt_empaque_peso_n_modal").val("");
    $("#txt_empaque_peso_b_modal").val("");

    $("#detalle_cantidad_"+id).val(total_neto);

    $("#lbl_detalle_cantidad_"+id).text(total_neto);
    
    $.fancybox.close();
});

function contar_columnas(clase) {
    var calculo = 0;
    $( clase ).each(function( index ) {
        var valor = $(this).val();
        if (valor != "") {
            calculo = calculo + parseFloat(valor);
        }
    });
    return number_format(calculo,2,".","");
}

function recalcular_costo() {
    var suma_costos = 0;
    $('.costos_produc').each(function () {
        suma_costos += parseFloat($(this).val());
    })
    $("#total_product").html("$" + number_format(suma_costos, $("#decimales").val()));
}