$(document).ready(function () {
    $("select").select2({placeholder: 'Seleccione'});

    get_facturas();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        minDate: 0,//Evita fechas pasadas
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#slcMotorista").change(function () {
        var mot_id = $("#slcMotorista").val();
        if (mot_id != '' && mot_id > 0) {
            $.ajax({
                dataType: 'text',
                type: 'POST',
                data: {
                    mot_id: mot_id
                },
                url: urlj + 'inventario/gestion_productos/get_vehiculos_motorista',
                beforeSend:function(){
                    wait.start();
                },
                success:function(data){
                    $('#txtVehiculo').val(data);
                    wait.close();
                }
            });
        } else {
            $('#txtVehiculo').val('');
        }
    });

    $('#agregar_fact').click(function() {        
        $('#slcFactura').val('').trigger('change');
        $.fancybox({
            href: $(this).attr("href"),
            'scrolling': 'no',
            'titleShow': false,
            'width' : '60%'
        });
    });

    $('#btncancel').click(function() {
        parent.$.fancybox.close();
    });

    $('#slcFactura').change(function() {
        var fac_id = $(this).val();
        if (fac_id) {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                data: {
                    fac_id: fac_id
                },
                url: urlj + 'inventario/gestion_productos/get_datos_factura',
                beforeSend:function(){
                    wait.start();
                },
                success:function(data){
                    $('#fac_num').val(data.numero);
                    $('#fac_val').val(data.monto);
                    $('#fac_cli').val(data.cliente);
                    $('#cli_dir').val(data.direccion);
                    $('#fac_com').val(data.comentarios);
                    wait.close();
                }
            });
        } else {
            $('#fac_num').val('');
            $('#fac_val').val('');
            $('#fac_cli').val('');
            $('#cli_dir').val('');
            $('#fac_com').val('');
        }
    });

    $('#btnguardar').click(function() {
        var fila = '';
        var fac_id = $('#slcFactura').val();
        if (fac_id != '') {
            if ($("#fila_" + fac_id).length > 0) {
                crear_alerta('error', 'Atención', 'Ese registro ya fue ingresado.');
                return false;
            }
            var numer = $('#fac_num').val();
            var monto = $('#fac_val').val();
            var clien = $('#fac_cli').val();
            var direc = $('#cli_dir').val();
            var comen = $('#fac_com').val();
            fila += '<tr id="fila_' + fac_id + '">';
            fila += '<td><input type="hidden" name="facturas[]" id="factura_' + fac_id + '" value="' + fac_id + '" /><label id="text_num_fac_' + fac_id + '">' + numer + '</label></td>';
            fila += '<td><label id="text_mon_fac_' + fac_id + '">' + monto + '</label></td>';
            fila += '<td><label id="text_cli_fac_' + fac_id + '">' + clien + '</label></td>';
            fila += '<td><label id="text_dir_fac_' + fac_id + '">' + direc + '</label></td>';
            fila += '<td><input type="hidden" name="comentarios[]" id="comentario_' + fac_id + '" value="' + comen + '" /><label id="text_com_fac_' + fac_id + '">' + comen + '</label></td>';
            fila += '<td><button type="button" class="btn btn-mini del_row" data-row="' + fac_id + '"><span class="cut-icon-trashcan"></span></button></td>';
            fila += '</tr>';
            $('#contenedor').append(fila);
            i++;
            parent.$.fancybox.close();
        } else {
            crear_alerta('error','Atención','Debe seleccionar una factura.');
            return false;
        }        
    });

    $("body").on("click", ".del_row", function(){
        var fac_id = $(this).data('row');
        $("#fila_" + fac_id).remove();
    })

    $('.enviar_formulario').click(function() {
        var nFilas = $("#contenedor tr").length;
        if (!(nFilas > 0)) {
            crear_alerta('error','Alerta','Debe Ingresar al menos un detalle.');
            return false;
        }
        if ($("#txtFecha").val() == '') {
            crear_alerta('error','Alerta','Especifique la Fecha de la Ruta.');
            return false;
        }
        if ($("#slcMotorista").val() == '' || $("#slcMotorista").val() == 0) {
            crear_alerta('error','Alerta','Debe Especificar un Motorista.');
            return false;
        }
        if ($("#slcRuta").val() == '' || $("#slcRuta").val() == 0) {
            crear_alerta('error','Alerta','Debe Especificar una Ruta.');
            return false;
        }
    });

});//END DOCUMENT.READY

function get_facturas() {
    $.ajax({
        dataType: 'text',
        type: 'POST',
        data: {},
        url: urlj + 'inventario/gestion_productos/get_facturas_disp',
        beforeSend:function(){
            wait.start();
        },
        success:function(data){
            $('#slcFactura').html(data);
            wait.close();
        }
    });
}

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "aaSorting": [[ 2, "desc" ]], //ordena desc
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        $("#fecha_fin_error").text('');
        return true;
    }
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#fecha_fin").addClass('error');
        $("#fecha_fin_error").text("Verifique las fechas del período");
        return false;
    }
    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
        return true;
    }
}