var urlj = url_base_proyecto;
$(document).ready(function () {
    $("select").select2({placeholder: 'Seleccione'});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $('#slcCliente').change(function() {
        $('#slcVendedor').select2('enable');
        $('#slcVendedor').val('').trigger('change');        
        var cliente = $('#slcCliente').val();
        if (cliente > 0) {
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_info_cli_pkl',
                dataType: 'json',
                type: 'POST',
                data: {
                    cliente: cliente
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#slcOrden").html(data.ordenes);
                    if (data.ven_id != null) {
                        $("#slcVendedor").val(data.ven_id).change();
                        $("#slcVendedor").select2('disable');
                    }                
                    wait.close();
                }
            });
        }else{
            $("#slcOrden").html('');
        }
    });

    $("#slcOrden").change(function() {
        var orden = ($(this).val());
       $.ajax({
            url: urlj + 'inventario/gestion_productos/get_info_bod_pkl',
            dataType: 'json',
            type: 'POST',
            data: {orden: orden},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#slcBodega").html(data.bodegas);
                $("#fecha_orden").val(data.fecha_orden);
                wait.close();
            }
        }); 
    });

    /*Busqueda*/
    $("#btnAgregar").click(function(){
        var codigo = $('#code_pick').val();
        var cliente = $('#slcCliente').val();
        var vendedor = $('#slcVendedor').val();
        var orden = $('#slcOrden').val();
        var bodega = $('#slcBodega').val();
        if (cliente == '' || orden == '' || bodega =='' || bodega < 1) {
            crear_alerta('error','Alerta','Campos requeridos vacios.');
            return false;
        }
        if ($("#tr_"+cliente+"_"+orden+"_"+bodega).length > 0) {
            crear_alerta('error','Alerta','Ya se consultó en esta bodega.');
            return false;
        }
        $.ajax({
            type:'post',
            dataType: 'json',
            url:window.gSateliteWhite.baseUrl('inventario/gestion_productos/validar_saldos_orden'),
            data:{
                codigo:   codigo,
                cliente:  cliente,
                vendedor: vendedor,
                orden:    orden,
                bodega:   bodega
            },
            beforeSend:function(){
                wait.start();
            },
            success:function(result){                       
                $("#contenedor").html(result.filas);
                wait.close();
            }
        });
    });


    $("body").on('click', '.remover_tr', function(e){ //elimina el componente agregado
        e.preventDefault();
        var tr = $(this).closest('tr');
        tr.remove();
    });


    $(".ver_en_modal").live('click', function (e) {
        e.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            href:  url,
            type: 'inline',
            closeBtn: true
        });
    });

    $(".enviar_formulario").live("click", function () {
        if ($("#contenedor").find('tr').length > 0) {
            $("#frm-picking").submit();
        } else {
            crear_alerta('error','Atención','Debe existir al menos un detalle');
            return false;
        }
    });



});//END DOCUMENT.READY
