var pathArray = window.location.pathname.split('/');
var urlj = url_base_proyecto;
var usa_sector = $("#usara_sectores").val();

$(document).ready(function () {
    $(".seleccion").select2();
    $(".numerico").numeric();
    $(".fecha_general").attr('placeholder', "dd-mm-yyyy");
    $(".fecha_general").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $(".fecha_general").mask('99-99-9999');

    var cantidad_decimales = parseInt($("#cantidad_decimales_txt").val());

    //Remueve el option Sin registros
    $(".seleccion").each(function () {
        if ($(this).children().eq(1).text() == "Sin Registros") {
            $(this).children().eq(1).remove();
        }
    })

    /*$(".positive").numeric({ negative: false }, function() { alert("No negative values"); this.value = ""; this.focus(); });
    $(".positive").live("focusout", function(){
    if($(this).attr('id')=='cantidad' && $(this).hasClass('validar_on')){
    if($(this).val() <= 0.0 ){
    campo=$(this).attr("id");
    $(this).addClass('error');
    $('#validar_'+campo).text('La cantidad debe ser mayor a uno');
    }
    }
    });*/

    $("#producto_art").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: 0
                    //producto_invent: 1
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    //SI USARA SECTORES CADA ENTRADA DEBE TENER ESPECIFICADO SU SECTOR  
    $("#frm-entrada_producto").validate({
        ignore: "",
        rules: {
            bodega_bod: {required: true, min: 1},
            tip_entrada: {required: true, min: 1},
            fecha_registro_mov:{required:true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').text('Campo requerido');
            ajustar_border();
        },
        submitHandler: function (form) {
            wait.start();
            var empaquetado = true;
            var a_cero = 0;
            $( ".total_neto_empaque" ).each(function( index ) {
                var valor = $(this).val();
                if (valor == "" || valor == 0) {
                    empaquetado = false;
                    return false;
                }
            });
            $( ".costos_produc" ).each(function( index ) {
                var valor = $(this).val();
                if (!(valor > 0)) {
                    a_cero++;
                }
            });
            if (usa_sector > 0) {
                var vacios = 0;
                $("select.grid_select").each(function () {
                    if (!$(this).val() > 0) {
                        vacios++;
                    }
                });
                if (vacios > 0) {
                    crear_alerta("error", "Sectores", "Debe definir el sector a todos los productos.");
                    wait.close();
                    return false;
                }
            }
            if (empaquetado == false){
                crear_alerta("error", "Empaque", "Faltan productos por empaquetar.");
                wait.close();
                return false;
            }
            if (a_cero > 0) {
                wait.close();
                alerta_confirm_ajax(enviarForm,1,'Existen artículos con costo cero','¿Está seguro que desea procesar esta entrada de inventarios incluyendo detalles con costo cero?<br>Recuerde que si hay existencias adicionales de estos artículos podrían verse afectados');
            } else {
                form.submit();
            }            
        }
    });

    function enviarForm(val) {
        wait.start();
        if (val > 0) {
            $("#frm-entrada_producto")[0].submit();
        }
    }

    $('#guardar').live('click', function (event) {
        $("#redireccion").val(0);
    })
    $('#guardar_volver').live('click', function (event) {
        $("#redireccion").val(1);
    })

    $("body").on("click", ".nuevo_producto", function() {
        event.preventDefault();
        var mNuevoProducto = $(this);
        var Invalida = 0;
        //Se obtienen los detalles del producto
        $.ajax({
            dataType: 'json',
            type: 'post',
            url: urlj + 'inventario/gestion_productos/get_permisos_padre_prod',
            async: false,
            success: function (data) {
                if (data.permiso == 1) {
                    Invalida = 1;
                }
            }
        });
        if (Invalida === 1) {
            var url = mNuevoProducto.attr('href');
            $.fancybox({
                'href': url,
                type: 'iframe',
                width:'100%',
                closeBtn: true,
                height: '100%'
            });
        } else {
            crear_alerta('error', 'Permiso', 'Debe tener permiso de Agregar Nuevo Producto');
        }
    });

    $("body").on("click", ".nuevo_proveedor", function (event) {
        event.preventDefault();
        var permitido = 0;        
        $.ajax({
            dataType: 'json',
            type: 'post',
            url: urlj + 'modulo_compras/procesos/get_permisos',
            async: false,
            data: {
                url: "inventario/mantenimiento/proveedores"
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                if (data.permiso == 1) {
                    permitido = 1;
                }
                wait.close();
            }
        });
        if (permitido === 1) {
            var url = $(this).attr('href');
            $.fancybox({
                'href': url,
                type: 'iframe',
                width: '100%',
                closeBtn: true,
                height: '100%'
            });
        } else {
            crear_alerta('error', 'Permiso', 'Debe tener permiso de Agregar Nuevo Proveedor');
        }
    });

    //envia el formulario
    $('.enviar_formulario').live('click', function (event) {
        var detalle_productos = $("#body_productos_dee").find("tr").length;
        if (detalle_productos != 0 && $("#frm-entrada_producto").valid() != false) {
            if ($("#orden_compra_orc").val() == "") {
                $("#frm-entrada_producto").submit();
            } else if (validar_orden()) {
                $("#frm-entrada_producto").submit();
            }
        } else {
            if (!$("#frm-entrada_producto").valid()) {
                crear_alerta("error", "Alerta", "Campos con * requeridos");
            } else if (detalle_productos == 0) {
                $.pnotify({
                    type: 'error',
                    title: 'Aviso',
                    text: 'Debe agregar al menos un detalle.',
                    icon: 'ui-icon ui-icon-info white',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
            }
        }
    })

    $('#proveedor_prv').change(function () {
        prv = $(this).val();
        var orden_slc = $("#orden_compra_orc").val();
        if ($.trim(prv) != "") {
            if($.trim(orden_slc) == ''){
                $.ajax({
                    url: urlj+'inventario/gestion_productos/get_documento_proveedor',
                    type: 'POST',
                    dataType: 'json',
                    data: {proveedor: prv},
                    success: function(data){                    
                        if($.trim(data.resp) != ""){
                            $("#doc_proveedor_dcp").html(data.resp);
                            $("#doc_proveedor_dcp").select2();
                        } else{
                            $("#doc_proveedor_dcp").html('<option value=""></option>');
                            $("#doc_proveedor_dcp").select2();
                        }
                    }
                });
            }
        } else {
            $.ajax({
                url: urlj+'inventario/gestion_productos/get_documento_proveedor',
                type: 'POST',
                dataType: 'json',
                data: {proveedor: 0},
                success: function(data){
                    $("#doc_proveedor_dcp").html(data.resp);
                    $("#doc_proveedor_dcp").select2();
                    $("#orden_compra_orc").select2("val", "");
                    $("#body_productos_dee").html("");
                    $("#div_mostrar").css('display', 'none');
                    $("#doc_referencia").val("");
                    $("#bodega_bod option").removeAttr("selected");
                    $("#nota_remision").select2("enable");
                    $("#bodega_bod").select2();
                }
            });
        }
    })

    $('#bodega_bod').change(function () {
        bod = $(this).val();
        cambiar_bodega(bod);
        if ( $("#bodega_bod").val() != "" && $("#txtCodigoLote").val() != "" && $("#producto_art").val() != ""){
            get_productos_empaquetados($("#bodega_bod").val(), $("#producto_art").val(), $("#txtCodigoLote").val(), 0);
        } else {
            $("#txt_correlativo_lote").val("0");
        }
    });

    function cambiar_bodega(bod, tipo = 0) {
        if ($.trim(bod) != "") {
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_sector_bodega',
                type: 'POST',
                dataType: 'json',
                data: {bodega: bod},
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $("#sector_sxb").html(data.resp);
                        if (tipo == 0 && $("#orden_compra_orc").val() == "") {
                            $("#sector_sxb").select2();
                        }
                        $(".grid_select").each(function () {
                            var sector = $(this).data("sector");
                            $(this).html(data.resp);
                            $("#" + $(this).attr("id")).select2();
                            if (sector != undefined && sector != ""){
                                $(this).val(sector).select2();
                            }
                        });
                    }
                }
            });
        } else {
            if (tipo == 0) {
                $("#sector_sxb").html('<option value=""></option>');
                $("#sector_sxb").select2();
            }
        }
    } 

    /*======================================================================================================================================
     =											FILTRA LAS CARACTERISTICA PADRE/HIJO
     ========================================================================================================================================
     */
    $("#categoria_tia").live('change', function () {
        menor = Number($(this).attr('nid')) + 2;
        $("#codigos").text('');
        $("#show_code").hide();
        $(".dinamic").each(function (index, el) {
            if ($(el).attr('nid') > menor) {
                $(el).parent('div').siblings('label').remove();
                $(el).siblings('select').remove();
                $(el).parent('div').parent('div').parent('div').parent('div').remove();
                $(el).remove();
            }
        });
        categoria_tia = $("select[id='categoria_tia']").last().val();
        bodega = $("#bodega_bod").val();
        $(".plus:last").remove();
        $(this).next().append('<button class="btn plus">+</button>');
         if (categoria_tia > 0) {
            $("#producto_art + .select2-container ").hide();
            $("#producto_art").select2('data', null);
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/obtener_productos_tia',
                data: {categoria: categoria_tia, tipo: 1, bodega: 0},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    producto = data.producto;
                    $("#dtg_producto").html(producto);
                    $("#dtg_producto").show();
                    $("#dtg_producto").select2('destroy').select2();
                    $('.dinamic').each(function (index, el) {
                        $(this).attr('nid', index);
                    });
                }
            });
        }else {
            wait.start();
            $("#producto_art + .select2-container").show();
            $("#dtg_producto").select2('destroy');
            $("#dtg_producto").hide();
            $("#dtg_producto option:selected").removeAttr('selected');
            wait.close();
        }
    });

    $(".plus").live('click', function (event) {
        event.preventDefault();
        categoria_tia = $("select[id='categoria_tia']").last().val();
        //console.log(categoria_tia);
        $("#codigos").text('');
        $("#show_code").hide();
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/obtener_productos_tia',
            data: {categoria: categoria_tia},
            success: function (data) {
                categoria = data.categoria;
                producto = data.producto;
                n_cat = data.cat_hijo;

                $i = 0;
                $(".plus").last().remove();
                if (n_cat == 1) {
                    numero = $('#div-categorias select').last().length + 1;

                    linea = $("#div-categorias").append('<div class="form-row row-fluid">'
                            + '<div class="span12">'
                            + '<div class="row-fluid">'
                            + '<label class="span4">Categoria:</label>'
                            + '<div class="span7 controls">'
                            + '<select id="categoria_tia" class="nostyle seleccion dinamic" name="filtro" style="width:100%" placeholder="Seleccione"></select>'
                            + '</div></div></div></div>');
                    linea2 = $('select[id="categoria_tia"]').last().html();
                    nueva = linea2.replace(/#/g, numero);
                    $('#div-categorias').append(nueva);
                    $('select[id="categoria_tia"]').last().html(categoria);
                    $('select[id="categoria_tia"]').last().select2();
                    $("#dtg_producto").html(producto);
                } else {
                    //$("#producto_art").html(producto);
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se encontraron mas dependencias.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }

                $('.dinamic').each(function (index, el) {
                    $(this).attr('nid', index);
                });
            }
        });
    });

    /*====================================================================================================================================
     =											ORDEN DE COMPRA
     ======================================================================================================================================
     */

    $("#orden_compra_orc").change(function () {
        orc = $(this).val();
        bod = $('#bodega_bod').val();
        $("#doc_proveedor").val("");
        if ($.trim(orc) != "") {
            var select_id = $(this).attr('id');
            var tipo = $('#' + select_id + ' option[value="' + orc + '"]').attr('tipo');
            var bodega = $('#' + select_id + ' option[value="' + orc + '"]').attr('bodega');
            $("#bodega_bod option").removeAttr("selected");
            $("#bodega_bod").select2();
            $("#bodega_bod").select2("enable");
            if (bodega != 0) {
                $("#bodega_bod").val(bodega);
                $("#bodega_bod").select2();
                $("#bodega_bod").select2("disable");
                $("#bodega_bod_error").text('');
            }
            $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #medida_cva").select2("disable");
            $("#cantidad_dee, #precio_dee, #fecha_dee").attr("readonly", true)
            $("#add_producto_dee").css("display", "none");
            $("#body_productos_dee").html("");
            $("#proveedor_prv").val('');
            $("#proveedor_prv").select2();
            if (tipo == "orc") {
                $.ajax({
                    url: urlj + 'inventario/gestion_productos/cargar_orden_compra',
                    type: 'POST',
                    dataType: 'json',
                    data: {orden_compra_orc: orc, tipo: tipo},
                    success: function (data) {
                        //console.log(data);
                        if ($.trim(data.resp) != "") {
                            $('#id_total_cols').attr('colspan', 2);
                            $('#accion_columns').hide();
                            //console.log("si");
                            $("#doc_proveedor_dcp").html('<option value=""></option>');
                            $("#doc_proveedor_dcp").select2();
                            $("#body_productos_dee").append(data.resp);
                            $("#div_mostrar").fadeIn(300);
                            $("#total_product").text("$" + data.total);
                            if (data.id_prv != null) {
                              $("#proveedor_prv").val(data.id_prv);
                              $("#proveedor_prv").select2();
                            }else {
                              $("#proveedor_prv").val('');
                              $("#proveedor_prv").select2();
                            }


                            $(".grid_select").each(function () {
                                $(this).select2();
                            });
                            cambiar_bodega(bod, 1);
                            $('.error_div').text('');
                            ajustar_border();
                            $("#doc_proveedor_dcp").select2("disable");
                            $("#nota_remision").select2("disable");
                            $(".fecha_general").attr('placeholder', "dd-mm-yyyy");
                            $(".fecha_general").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
                            //cargar_bodegar(data.sucursal_id, '2', data.bodega);
                            /*$("#sucursal_suc2").val(data.sucursal_id);
                             $("#sucursal_suc2").select2();
                             $("#sucursal_suc2, #sector_sxb").select2("disable");
                             $('.id_art_rxi').each(function(){
                             var id_art = $(this).val();
                             var cantidad = $("#rxi_mep"+id_art).attr("cva");
                             var nombre = $("#rxi_mep"+id_art).parent().text();
                             cargar_cantidades_rxi(id_art, cantidad, nombre);
                             })*/
                        }
                    }
                });
            } else {
                $("#div_mostrar").css('display', 'none');

                $.ajax({
                    url: urlj + 'inventario/gestion_productos/cargar_documento',
                    type: 'POST',
                    dataType: 'json',
                    data: {orden_compra_orc: orc},
                    success: function (data) {
                        //console.log(data);
                        $('.error_div').text('');
                        ajustar_border();
                        if ($.trim(data.resp) != "") {
                            $("#doc_proveedor_dcp").html(data.resp);
                            $("#doc_proveedor_dcp").select2();
                        }
                    }
                });
            }
        } else {
            $('#id_total_cols').attr('colspan', 3);
            $('#accion_columns').show();
            $("#bodega_bod option").removeAttr("selected");
            $("#bodega_bod").select2();
            $("#doc_proveedor_dcp").select2("enable");
            $("#nota_remision").select2("enable");
            $("#doc_proveedor_dcp").html('<option value=""></option>');
            $("#doc_proveedor_dcp").select2();
            $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #medida_cva, #bodega_bod").select2("enable");
            $("#cantidad_dee, #precio_dee, #fecha_dee").attr("readonly", false)
            $("#add_producto_dee").css("display", "")
            $("#div_mostrar").css('display', 'none');
            $("#body_productos_dee").html("");
            $("#proveedor_prv").trigger('change');
        }
    })

    $("#doc_proveedor_dcp").change(function () {
        bodegas_dcp = $(this).val();
        bod = $('#bodega_bod').val();

        if ($.trim(bodegas_dcp) != "") {
            var select_id = $(this).attr('id');
            var bodega = $('#' + select_id + ' option:selected').attr('bodega');
            var documentos_dcp = $('#' + select_id + ' option:selected').attr('doc_pro');
            var documentos_orc = $('#' + select_id + ' option:selected').attr('doc_orc');            
            $("#bodega_bod").select2("enable");
            if (bodega != 0) {
                $("#bodega_bod").val(bodega);
                $("#bodega_bod").select2();
                $("#bodega_bod").select2("disable");
                $("#nota_remision").select2("disable");
            }
            $("#add_producto_dee").css("display", "none");
            $("#body_productos_dee").html("");
            $.ajax({
                url: urlj + 'inventario/gestion_productos/cargar_orden_compra_dpv',
                type: 'POST',
                dataType: 'json',
                data: {bodegas_dcp: bodega, documentos_dcp: documentos_dcp},
                success: function (data) {
                    if (data.id_prv != null) {
                      $("#proveedor_prv").val(data.id_prv);
                      $("#proveedor_prv").select2();
                    }else {
                      $("#proveedor_prv").val('');
                      $("#proveedor_prv").select2();
                    }
                    //si la bodegano pertenece al usuario actual
                    if ($.trim($("#bodega_bod").val()) != "") {
                        if ($.trim(data.resp) != "") {
                            //console.log(documentos_dcp);
                            $("#doc_proveedor").val(documentos_dcp);
                            $("#body_productos_dee").append(data.resp);
                            $("#div_mostrar").fadeIn(300);
                            $("#total_product").text("$" + data.total);
                            $("#doc_referencia").val(data.dpv_numero);
                            $(".grid_select").each(function () {
                                $(this).select2();
                            });
                            cambiar_bodega(bodega, 1);
                            $(".fecha_general").attr('placeholder', "dd-mm-yyyy");
                            $(".fecha_general").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
                            $('#id_total_cols').attr('colspan', 2);
                            $('#accion_columns').hide();
                            if (documentos_orc > 0) {
                                $("#orden_compra_orc").select2("val", documentos_orc);
                            }
                        }
                        $("#bodega_bod_error").text("");
                    } else {
                        //si la bodega no pertecene al usuario mostrar estemensaje
                        $("#bodega_bod_error").text("La bodega no pertenece al usuario");
                        $("#div_mostrar").css('display', 'none');
                        $("#body_productos_dee").html("");
                        $("#doc_proveedor").val("");
                        $.pnotify({
                            type: 'info',
                            title: 'Aviso',
                            text: 'La bodega no asignada, comunicarse con un administrador',
                            icon: 'ui-icon ui-icon-info',
                            opacity: 0.95,
                            history: false,
                            sticker: false
                        });
                    }
                }
            });
        } else {
            $("#doc_referencia").val("");
            $('#id_total_cols').attr('colspan', 3);
            $('#accion_columns').show();
            $("#orden_compra_orc").select2("val", "");
            $("#bodega_bod option").removeAttr("selected");
            $("#bodega_bod").select2();
            $("#div_mostrar").css('display', 'none');
            $("#body_productos_dee").html("");
            $("#doc_proveedor").val("");
            $("#nota_remision").select2("enable");
        }
    })

    $("#nota_remision").change(function () {
        var id_moi = $(this).val();
        if ($.trim(id_moi) != "") {
            var fac_rem = $("#nota_remision option:selected").data('fac');
            var doc_ref = $("#nota_remision option:selected").text();
            $.ajax({
                url: urlj + 'inventario/gestion_productos/cargar_nota_remision',
                type: 'POST',
                dataType: 'json',
                data: {
                    id_moi: id_moi
                },
                beforeSend: function() {
                    wait.start();
                },
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $("#proveedor_prv, #orden_compra_orc, #doc_proveedor_dcp, #doc_cliente_dcc").select2("val", "");
                        $("#proveedor_prv, #orden_compra_orc, #doc_proveedor_dcp, #doc_cliente_dcc").select2("disable");
                        $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #medida_cva").select2("disable");
                        $("#add_producto_dee, #accion_columns").hide();
                        $('#id_total_cols').attr('colspan', 2);
                        $("#div_mostrar").fadeIn(300);
                        $("#body_productos_dee").html(data.resp);
                        $("#total_product").text("$" + data.total);
                        $(".grid_select").each(function () {
                            $(this).select2();
                        });
                        $('.error_div').text('');
                        ajustar_border();
                        $("#fac_rem").val(fac_rem);
                        $("#doc_referencia").val(doc_ref);
                        $(".fecha_general").attr('placeholder', "dd-mm-yyyy");
                        $(".fecha_general").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
                    } else {
                        $("#proveedor_prv, #orden_compra_orc, #doc_proveedor_dcp, #doc_cliente_dcc").select2("enable");
                        $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #medida_cva").select2("enable");
                        $("#add_producto_dee, #accion_columns").show();
                        $('#id_total_cols').attr('colspan', 3);
                        $("#div_mostrar").fadeOut(300);
                        $("#body_productos_dee").html("");
                        $("#total_product").text("");
                        $("#fac_rem").val("");
                        $("#doc_referencia").val("");
                        $("#nota_remision").select2("val", "");
                        crear_alerta('warning', 'error', 'Ocurrió un error inesperado');
                    }
                    wait.close();
                }
            });            
        } else {
            $("#proveedor_prv, #orden_compra_orc, #doc_proveedor_dcp, #doc_cliente_dcc").select2("enable");
            $("#sector_sxb, #categoria_tia, #producto_art, #dtg_producto, #medida_cva").select2("enable");
            $("#fac_rem, #doc_referencia").val("");
            $("#add_producto_dee, #accion_columns").show();
            $('#id_total_cols').attr('colspan', 3);
            $("#div_mostrar").fadeOut(300);
            
            // $("#orden_compra_orc").select2("val", "");
            // $("#bodega_bod option").removeAttr("selected");
            // $("#bodega_bod").select2();
            // $("#div_mostrar").css('display', 'none');
            $("#body_productos_dee").html("");
            // $("#doc_proveedor").val("");            
        }
    });

    $(".validar_cantidad").live('change', function () {
        art_id = $(this).attr("id");
        cantidad = parseFloat($(this).val());
        cantidad_defecto = parseFloat($(this).attr("cant_def"));
        var cantidad_cva = $("#rxi_mep" + art_id).attr("cva");
        var cantidad_cva_defecto = $("#rxi_mep" + art_id).attr("cva_defecto");
        var precio_unitario = parseFloat($("#dor_unitario" + art_id).val());

        //cantidad_maxima = parseFloat($("#cantidad_req_"+art_id).val()/cantidad_cva);
        if (!(cantidad <= cantidad_defecto)) {
            if ($("#bodega_bod").val() == "") {
                $(this).val(cantidad_defecto);
                var total = cantidad_defecto * precio_unitario;
                var precio_total = $("#dor_total" + art_id).val(total);

                var total_defecto = (cantidad_defecto * (cantidad_cva / cantidad_cva_defecto));
                $(this).parent().find("input:hidden").val(total_defecto);

                $("#dor_total" + art_id).next().text("$" + number_format(total, 2));
                var suma_costos = 0;
                $('.costos_produc').each(function () {
                    suma_costos += parseFloat($(this).val());
                })
                $(this).val(number_format($(this).val(), 2));
                $("#total_product").html("$" + number_format(suma_costos, 2));

                $.pnotify({
                    type: 'info',
                    title: 'Aviso',
                    text: 'No se ha seleccionado la bodega.',
                    icon: 'ui-icon ui-icon-info',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
            } else {
                mensaje = 'La cantidad ingresada excede a las solicitadas.';

                $(this).val(number_format(cantidad_defecto, 2));

                var total = cantidad_defecto * precio_unitario;
                var precio_total = $("#dor_total" + art_id).val(total);
                $("#dor_total" + art_id).next().text("$" + number_format(total, 2));

                var total_defecto = (cantidad_defecto * (cantidad_cva / cantidad_cva_defecto));
                $(this).parent().find("input:hidden").val(total_defecto);

                var suma_costos = 0;
                $('.costos_produc').each(function () {
                    suma_costos += parseFloat($(this).val());
                })
                $("#total_product").html("$" + number_format(suma_costos, 2));

                $.pnotify({
                    type: 'info',
                    title: 'Aviso',
                    text: mensaje,
                    icon: 'ui-icon ui-icon-info',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
            }
        } else {
            if($(".validar_cantidad").length == 1){
                if(! cantidad > parseFloat(0.00)){
                    mensaje = 'La cantidad ingresada no puede ser 0.';
                    $(this).val(number_format(cantidad_defecto, 2));
                    var total = cantidad_defecto * precio_unitario;
                    var precio_total = $("#dor_total" + art_id).val(total);
                    $("#dor_total" + art_id).next().text("$" + number_format(total, 2));

                    var total_defecto = (cantidad_defecto * (cantidad_cva / cantidad_cva_defecto));
                    $(this).parent().find("input:hidden").val(total_defecto);

                    var suma_costos = 0;
                    $('.costos_produc').each(function () {
                        suma_costos += parseFloat($(this).val());
                    })
                    $("#total_product").html("$" + number_format(suma_costos, 2));

                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: mensaje,
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                } else{
                    var total = cantidad * precio_unitario;
                    var precio_total = $("#dor_total" + art_id).val(total);
                    $("#dor_total" + art_id).next().text("$" + number_format(total, 2));

                    var total_defecto = cantidad * (cantidad_cva / cantidad_cva_defecto);
                    $(this).parent().find("input:hidden").val(total_defecto);

                    var suma_costos = 0;
                    $('.costos_produc').each(function () {
                        suma_costos += parseFloat($(this).val());
                    })
                    $(this).val(number_format($(this).val(), 2));
                    $("#total_product").html("$" + number_format(suma_costos, 2));
                }
            } else{
                var validar_cantidades_zero = 0;
                $(".validar_cantidad").each(function(){
                    if(parseFloat($(this).val()) != parseFloat(0.00)){
                        validar_cantidades_zero = 1;
                    }
                })
                if(validar_cantidades_zero == 1){
                    var total = cantidad * precio_unitario;
                    var precio_total = $("#dor_total" + art_id).val(total);
                    $("#dor_total" + art_id).next().text("$" + number_format(total, 2));

                    var total_defecto = cantidad * (cantidad_cva / cantidad_cva_defecto);
                    $(this).parent().find("input:hidden").val(total_defecto);

                    var suma_costos = 0;
                    $('.costos_produc').each(function () {
                        suma_costos += parseFloat($(this).val());
                    })
                    $(this).val(number_format($(this).val(), 2));
                    $("#total_product").html("$" + number_format(suma_costos, 2));
                } else{
                    mensaje = 'Al menos un producto debe tener cantidad.';
                    $(this).val(number_format(cantidad_defecto, 2));
                    var total = cantidad_defecto * precio_unitario;
                    var precio_total = $("#dor_total" + art_id).val(total);
                    $("#dor_total" + art_id).next().text("$" + number_format(total, 2));

                    var total_defecto = (cantidad_defecto * (cantidad_cva / cantidad_cva_defecto));
                    $(this).parent().find("input:hidden").val(total_defecto);

                    var suma_costos = 0;
                    $('.costos_produc').each(function () {
                        suma_costos += parseFloat($(this).val());
                    })
                    $("#total_product").html("$" + number_format(suma_costos, 2));

                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: mensaje,
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }
            }

        }
    })

    function validar_orden() {
        var cantidad_req_def = 0;
        $('.validar_cantidad').each(function () {
            art_id = $(this).attr("id");
            cantidad = parseFloat($(this).val());
            cantidad_defecto = parseFloat($(this).attr("cant_def"));
            var cantidad_cva = $("#rxi_mep" + art_id).attr("cva");

            var precio_unitario = parseFloat($("#dor_unitario" + art_id).val());
            if (!(cantidad <= cantidad_defecto)) {
                cantidad_req_def = 1;
            }
        })
        if (cantidad_req_def == 1) {
            $.pnotify({
                type: 'info',
                title: 'Aviso',
                text: 'La cantidad solicitada excede la peticion.',
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
            return false;
        }
        return true;
    }
    /*====================================================================================================================================
     =											FILTRAR DEFECTO
     ======================================================================================================================================
     */

    $('#producto_art, #dtg_producto').change(function () {
        art = $(this).val();
        $("#producto_art").val(art);

        var precio_defecto = $("#precio_dee").data("preciodefecto");
        $("#precio_dee").val(precio_defecto);

        if ($.trim(art) != "") {
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_medida_defecto',
                async:true,
                type: 'POST',
                dataType: 'json',
                data: {producto: art},
                success: function (data) {
                    if ($.trim(data.resp) != "") {
                        $("#medida_cva").html(data.resp);
                        $("#medida_cva").select2();
                        $("#medida_cva_error").text('');
                        $("#precio_dee").val(data.ultima);
                        ajustar_border();
                    } else {
                        $("#medida_cva").html('<option value=""></option>');
                        $("#medida_cva").select2();
                    }
                }
            });

            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_codigos_pro',
                async:true,
                type: 'POST',
                dataType: 'json',
                data: {producto: art},
                success: function (data) {
                    if ($.trim(data) != "") {
                        $("#codigos").text(data.mostrar);
                        if(data.mostrar!=''){
                            $("#show_code").show();
                        }else{
                           $("#show_code").hide();
                        }
                        $("#txt_aplica_empaque").val(data.aplica_empaque);

                        if ( data.aplica_empaque > 0){
                            var cantidad_defecto = $("#cantidad_dee").data("cantidaddefecto");
                            $("#cantidad_dee").val(cantidad_defecto);
                        }else {
                            $("#cantidad_dee").val("");
                        }

                    } else {
                        $("#txt_aplica_empaque").val('');
                        $("#codigos").text('');
                        $("#show_code").hide();
                        $("#cantidad_dee").val("");
                    }
                }
            });

        }else{
            $("#txt_aplica_empaque").val('');
            $("#codigos").text('');
            $("#show_code").hide();
        }

        if ( $("#bodega_bod").val() != "" && $("#txtCodigoLote").val() != "" && $("#producto_art").val() != ""){
            get_productos_empaquetados($("#bodega_bod").val(), $("#producto_art").val(), $("#txtCodigoLote").val(), 0);
        } else {
            $("#txt_correlativo_lote").val("0");
        }

    });

    $("#medida_cva").change(function () {
        var producto = $("#producto_art").val();
        var medida = $(this).val();
        if (producto > 0  && medida > 0){
            url_ajax = window.satelite.base_url('facturacion/entradas/get_valor_ultima_entrada');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    precio_lista: 1,
                    id_articulo: producto,
                    unidad_medida: 0,
                    id_cva: medida
                },
                success: function (json) {
                    $("#precio_dee").val(json.ultima_compra);
                }
            });
        }
    });

    /*====================================================================================================================================
     =											AGREGA LOS CAMPOS A LA GRID
     ======================================================================================================================================
     */

    function get_codigo_cva(art_id, cva_id) {
        var respuesta = $.ajax({
            url: urlj + 'inventario/gestion_productos/get_codigo_cva',
            type: 'POST',
            async: false,
            dataType: 'json',
            data: {producto: art_id, medida: cva_id},
            success: function (data) {
                return data;
            }
        }).responseText;
        return respuesta;
    }

    function get_sectores(bod_id, sxb_id) {
        var respuesta = $.ajax({
            url: urlj + 'inventario/gestion_productos/cargar_sector_selected',
            type: 'POST',
            async: false,
            dataType: 'json',
            data: {bodega: bod_id, sector: sxb_id},
            success: function (data) {
                return data;
            }
        }).responseText;
        return respuesta;
    }

    $('#add_producto_dee').live('click', function (event) {
        event.preventDefault();
        if($("#dtg_producto").val()>0){
            var producto_art = $("#dtg_producto").val().trim();
            var producto_art_select = $("#dtg_producto option:selected").text();
        }else{
            var producto_art = $("#producto_art").val();
            var producto_art_select = $("#producto_art").next('div').text();
        }
        var lote = $("#txtCodigoLote").val();
        var cant_lote = $("#slcLote option:selected").data('cant');
        var medida_cva = $("#medida_cva").val().trim();
        var medida_cva_select = $("#medida_cva option:selected").text();
        var cantidad_dee    = $("#cantidad_dee").val();
        var precio_dee      = $("#precio_dee").val();
        var fecha_dee       = $("#fecha_dee").val();
        var sector_sxb      = $("#sector_sxb").val();
        var bodega_bod      = $("#bodega_bod").val();
        var aplica_empaque  = $("#txt_aplica_empaque").val();
        var validado_sector = true;
        var validar_fecha   = false;
        if (fecha_dee == "" && $("#costo_promedio").val() == 2) {
            validar_fecha   = true;
        }
        if (usa_sector > 0) {
            validado_sector = (sector_sxb > 0) ? true : false;
        }
         

        //variables para el mensaje
        var mensaje = "";
        var type_msg = "";
        if (producto_art != "" && medida_cva != "" && precio_dee != "" && cantidad_dee != "" && bodega_bod != "" && validar_fecha == false && validado_sector == true ) {
            type_msg = "error";
            if ( ($("#precio_dee").data('cero')!=1 && precio_dee > 0 && cantidad_dee > 0) ||  ($("#precio_dee").data('cero')==1 && precio_dee >= 0 && cantidad_dee > 0)  ) {
                if (($("#producto_art" + producto_art).length <= 0 && $("#producto_art" + producto_art+lote).length <= 0 )) {
                    var sectores_sxb = get_sectores(bodega_bod, sector_sxb);
                    var obj_sxb = jQuery.parseJSON(sectores_sxb);
                    var select_sxb = obj_sxb.resp;

                    var codigo_medida = get_codigo_cva(producto_art, medida_cva);
                    var obj = jQuery.parseJSON(codigo_medida);
                    var codigo = obj.codigo;
                    var medida = obj.conversion;
                    var defecto = obj.defecto;

                    var cantidad_medida = cantidad_dee * (medida / defecto);
                    var conversion_def = (medida / defecto);
                    var costo_total = cantidad_dee * precio_dee;
                    var costo_unitario = parseFloat(precio_dee / (medida / defecto));
                    var fila = '';
                    if (conversion_def == 1) {
                        costo_unitario = parseFloat(precio_dee);
                    }

                    id_correlativo = $("#contador_producto_dee").val(); //crear un id unico para anexos de documentos

                    costo_option = '<a class="fancy_costo" style="margin-right: 12px;font-size:15px;cursor:pointer;" href="#costos_producto' + producto_art + '_'+id_correlativo+'">';
                    costo_option += '<span class="icon16 icomoon-icon-puzzle"></span>Centro costos';
                    costo_option += '</a>';

                    //eliminar = '<a id="del_doc" valor="' + id_correlativo + '" thead="div_mostrar" tbody="body_productos_dee" class="btn btn-danger btn-mini minia-icon-trashcan white">Eliminar</a>';
                    eliminar = '<a id="del_doc" style="margin-right: 12px;font-size:15px;cursor:pointer;" valor="' + id_correlativo + '" thead="div_mostrar" tbody="body_productos_dee">';
                    eliminar += '<span class="icon16 icomoon-icon-remove"></span>Eliminar';
                    eliminar += '</a>';

                    empaque = '<a  class="fancy_empaque" id="empaque_'+producto_art+'" style="margin-right: 12px;font-size:15px;cursor:pointer;" href="#div_empaque"  data-articulo="' + producto_art + '" >';
                    empaque += '<span class="icon16 icomoon-icon-box"></span>Empaque';
                    empaque += '</a>';

                    caracteristicas = '<a class="detalle_fanc" style="margin-right: 12px;font-size:15px;cursor:pointer;" id="agregar_caracteristica" href="#caracteristica_producto' + producto_art + '_'+id_correlativo+'">';
                    caracteristicas += '<span class="icon16 icomoon-icon-list-view-2"></span>Características';
                    caracteristicas += '</a>';

                    var acciones_drop = '';
                    acciones_drop += '<div class="tools">';
                    acciones_drop +=    '<div class="btn-group">';
                    acciones_drop +=        '<button type="button" class="btn"><span class="icon16 icomoon-icon-cog-2"></span></button>';
                    acciones_drop +=        '<button type="button" class="btn dropdown-toggle" data-toggle="dropdown">';
                    acciones_drop +=            '<span class="caret"></span>';
                    acciones_drop +=        '</button>';
                    acciones_drop +=        '<ul class="dropdown-menu">';

                    tabla_empaque           = "";
                    contador                = "";
                    correlativo_empaque     = $("#txt_correlativo_lote").val();
                    correlativo_empaque_tb  = "";

                    acciones_drop +=            '<li style="text-align:left;"> ';
                    acciones_drop +=                caracteristicas;
                    acciones_drop +=            '</li>';

                    if ( aplica_empaque == 1){
                        acciones_drop +=            '<li style="text-align:left;"> ';
                        acciones_drop +=                empaque;
                        acciones_drop +=            '</li>';

                        tabla_empaque  =  '<table style="display:none;">';
                        tabla_empaque +=  '<tbody id="tb_empaque_'+producto_art+'">';
                        tabla_empaque +=  '<tr><td colspan="6">No se encontraron registros</td></tr>'
                        tabla_empaque +=  '</tbody>';
                        tabla_empaque +=  '<tfoot id="tf_empaque_'+producto_art+'">';
                        tabla_empaque +=  '<tr>';
                        tabla_empaque +=  '<td colspan="2" align="right">Totales</td>';
                        tabla_empaque +=  '<td><input type="text" id="foot_unidades_empaque_'+producto_art+'" readonly value="0"></td>';
                        tabla_empaque +=  '<td><input type="text" id="foot_neto_empaque_'+producto_art+'" readonly value="0" class="total_neto_empaque"></td>';
                        tabla_empaque +=  '<td><input type="text" id="foot_bruto_empaque_'+producto_art+'" readonly value="0"></td>';
                        tabla_empaque +=  '<td></td>';
                        tabla_empaque +=  '</tr>';
                        tabla_empaque +=  '</tfoot>';
                        tabla_empaque +=  '</table>';
                        contador                = '<input type hidden id="txt_contador_empaque_'+producto_art+'" value="'+id_correlativo+'">';
                        correlativo_empaque_tb  = '<input type hidden id="txt_correlativo_empaque_'+producto_art+'" value="'+correlativo_empaque+'">';
                    }

                    acciones_drop +=            '<li style="text-align:left;"> ';
                    acciones_drop +=                costo_option;
                    acciones_drop +=            '</li>';


                    acciones_drop +=            '<li style="text-align:left;"> ';
                    acciones_drop +=                eliminar;
                    acciones_drop +=            '</li>';

                    acciones_drop +=        '</ul>';
                    acciones_drop +=    '</div>';
                    acciones_drop += '</div>';

                    id_producto_art = '<input type="hidden" id="producto_art' + producto_art + lote + '" name="producto_art[]" value="' + producto_art + '" />';
                    id_medida_cva = '<input type="hidden" name="medida_cva[]" value="' + medida_cva + '" />';
                    codigo_lote = '<input type="hidden" id="codigo_lote_'+producto_art+'" name="codigo_lote[]" value="' + lote + '" />';
                    id_correlativo_reg = '<input type="hidden" name="correlativo[]" value="' + id_correlativo + '" />';
                    id_cantidad_dee = '<input id="detalle_cantidad_'+producto_art+'"  type="hidden" name="cantidad_dee[]" value="' + cantidad_medida + '" />';
                    id_precio_dee = '<input type="hidden" name="precio_dee[]" value="' + costo_unitario + '" />';
                    id_costo_total = '<input type="hidden" class="costos_produc" name="costo_total[]" value="' + costo_total + '" />';
                    id_fecha_dee = '<input type="hidden" name="fecha_dee[]" value="' + fecha_dee + '" />';
                    fila += '<tr id="filadiv_mostrar' + id_correlativo + '" >' +
                        '<td>' + codigo + tabla_empaque + contador + correlativo_empaque_tb +'</td>' +
                        '<td>' + id_correlativo_reg + id_producto_art + producto_art_select + '</td>' +
                        '<td>' + codigo_lote + lote + '</td>' +
                        '<td>' + id_medida_cva + medida_cva_select + '</td>' +
                        '<td>' + id_cantidad_dee + '<label id="lbl_detalle_cantidad_'+producto_art+'">'+ number_format(cantidad_dee,$("#decimales").val(), ".", "")+'</label></td>' +
                        '<td>$' + id_precio_dee + number_format(precio_dee, $("#decimales").val(), ".", "") + '</td>' +
                        '<td>$' + id_costo_total + number_format(costo_total, $("#decimales").val(), ".", "") + '</td>' +
                        '<td>' + id_fecha_dee + fecha_dee + '</td>';
                    fila += (usa_sector > 0) ? '<td>' : '<td style="display:none">';
                    fila += '<select name="sector_sxb[]" class="seleccion grid_select" id="seleccion' + producto_art + lote + '" style="width: 100%;" placeholder="Seleccione">' + select_sxb + '</select></td>';
                    fila += '<td><div>' + acciones_drop +'<div id="costos_producto' + producto_art + '_'+id_correlativo+'" style="display:none"></div></div> <div id="caracteristica_producto' + producto_art + '_'+id_correlativo+'" style="display:none"></div></td>' +
                        '</tr>';
                    $("#body_productos_dee").append(fila);
                    $("#div_mostrar").fadeIn(300);
                    $("#seleccion" + producto_art+lote).select2();
                    var NC = parseInt($("#contador_producto_dee").val()) + 1;
                    $("#contador_producto_dee").val(NC);

                    /********** Características del producto ************/
                  //  console.log(producto_art+'/'+id_correlativo);
                    cargar_caracteristicas(producto_art, id_correlativo);

                    var suma_costos = 0;
                    $('.costos_produc').each(function () {
                        suma_costos += parseFloat($(this).val());
                    })

                    $("#total_product").html("$" + number_format(suma_costos, $("#decimales").val(), ".", ""));

                    $("#categoria_tia option").removeAttr("selected");
                    $("#categoria_tia").select2();

                    $("#dtg_producto option").removeAttr("selected");
                    $("#dtg_producto").select2('destroy');
                    $("#dtg_producto").hide();
                    //$("#dtg_producto").select2();

                    $("#producto_art").select2('destroy');
                    limpiarproducto();

                    $("#medida_cva option").removeAttr("selected");
                    $("#medida_cva").select2();

                    $("#sector_sxb option").removeAttr("selected");
                    $("#sector_sxb").select2();


                    $(".dinamic").each(function (index, el) {
                        if ($(el).attr('nid') > 0) {
                            $(el).parent('div').siblings('label').remove();
                            $(el).siblings('select').remove();
                            $(el).parent('div').parent('div').parent('div').parent('div').remove();
                            $(el).remove();
                        }
                    });
                    $("#cantidad_dee").val("");
                    $("#precio_dee").val("");
                    $("#fecha_dee").val("");
                    $("#producto_art_error").text('');
                    $("#medida_cva_error").text('');
                    $("#cantidad_dee_error").text('');
                    $("#precio_dee_error").text('');
                    $("#bodega_bod_error").text('');
                    $("#sector_sxb_error").text('');
                    $("#codigos").text('');
                    cargar_centro_costo(producto_art, id_correlativo, '', costo_total); //centro de costos
                    ajustar_border();
                } else {
                    mensaje = "El detalle ya ha sido agregado";
                }
            } else {
                if (precio_dee <= 0 && $("#precio_dee").data('cero')!=1) {
                    $("#precio_dee_error").text('El precio debe ser mayor a 0');
                }
                if (cantidad_dee <= 0) {
                    $("#cantidad_dee_error").text('La cantidad debe ser mayor a 0');
                }
            }
        } else {
            type_msg = "error";
            mensaje = "Los campos con * son requeridos";
            if (producto_art == "" && medida_cva == "" && precio_dee == "" && cantidad_dee == "" && bodega_bod == "") {
                $("#producto_art_error").text('Campo requerido');
                $("#medida_cva_error").text('Campo requerido');
                $("#cantidad_dee_error").text('Campo requerido');
                $("#precio_dee_error").text('Campo requerido');
                $("#bodega_bod_error").text('Campo requerido');
            } else if (producto_art == "") {
                mensaje = "El producto es requerido";
                $("#producto_art_error").text('Campo requerido');
                if (medida_cva == "") {
                    $("#medida_cva_error").text('Campo requerido');
                }
                if (precio_dee == "") {
                    $("#precio_dee_error").text('Campo requerido');
                }
                if (cantidad_dee == "") {
                    $("#cantidad_dee_error").text('Campo requerido');
                }
                if (!validado_sector) {
                    $("#sector_sxb_error").text('Campo requerido');
                }
            } else if (medida_cva == "") {
                mensaje = "La unidad de medida es requerido";
                $("#medida_cva_error").text('Campo requerido');
                if (producto_art == "") {
                    $("#producto_art_error").text('Campo requerido');
                }
                if (precio_dee == "") {
                    $("#precio_dee_error").text('Campo requerido');
                }
                if (cantidad_dee == "") {
                    $("#cantidad_dee_error").text('Campo requerido');
                }
                if (!validado_sector) {
                    $("#sector_sxb_error").text('Campo requerido');
                }
            } else if (precio_dee == "") {
                mensaje = "El precio es requerido";
                $("#precio_dee_error").text('Campo requerido');
                if (producto_art == "") {
                    $("#producto_art_error").text('Campo requerido');
                }
                if (medida_cva == "") {
                    $("#medida_cva_error").text('Campo requerido');
                }
                if (cantidad_dee == "") {
                    $("#cantidad_dee_error").text('Campo requerido');
                } else if (cantidad_dee <= 0) {
                    $("#cantidad_dee_error").text('La cantidad debe ser mayor a 0');
                }
                if (!validado_sector) {
                    $("#sector_sxb_error").text('Campo requerido');
                }
            } else if (cantidad_dee == "") {
                mensaje = "La cantidad es requerida";
                $("#cantidad_dee_error").text('Campo requerido');
                if (producto_art == "") {
                    $("#producto_art_error").text('Campo requerido');
                }
                if (medida_cva == "") {
                    $("#medida_cva_error").text('Campo requerido');
                }
                if (precio_dee == "") {
                    $("#precio_dee_error").text('Campo requerido');
                } else if (precio_dee <= 0) {
                    $("#precio_dee_error").text('El precio debe ser mayor a 0');
                }
                if (!validado_sector) {
                    $("#sector_sxb_error").text('Campo requerido');
                }
            } else if (bodega_bod == "") {
                mensaje = "La bodega es requerida";
                $("#bodega_bod_error").text('Campo requerido');
                if (!validado_sector) {
                    $("#sector_sxb_error").text('Campo requerido');
                }
            } else if (!validado_sector) {
                mensaje = "El Sector es requerido";
                $("#sector_sxb_error").text('Campo requerido');
            }
            if (fecha_dee == "" && $("#costo_promedio").val() == 2 ) {
                crear_alerta("error", "Fecha de vencimiento", "Fecha de vencimiento es requerida.");
                $("#fecha_dee_error").text("Campo requerido");
                return false;
            }
        }
        if (mensaje != "") {
            $.pnotify({
                type: type_msg,
                title: 'Informaci&oacute;n',
                text: mensaje,
                icon: 'ui-icon ui-icon-info',
                opacity: 0.95,
                history: false,
                sticker: false
            });
            ajustar_border();
        }
        $("#txt_correlativo_lote").val("0");
    });

    function cargar_centro_costo(producto, correlativo, centro_costo, subtotal){
        //nos carga el div de los centros de costo
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'facturacion/facturar/obtener_costos',
            data: {producto: producto,correlativo:correlativo, costo: centro_costo, subtotal: subtotal},
            success: function (data) {
                if(data.error == 1){
                    crear_alerta("info", "Aviso", "Hubo un error al cargar los componentes.");
                } else{
                    var identificador = producto+'_'+correlativo;
                    $("#costos_producto"+identificador).html(data.html);
                    //console.log(data);
                }
            }
        })
    }

/* =====================================================================================================================================
                                        CENTRO COSTO
========================================================================================================================================
*/

    function cargar_centro_costo(producto, correlativo, centro_costo, subtotal){ 
        //nos carga el div de los centros de costo
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'facturacion/facturar/obtener_costos',
            data: {producto: producto,correlativo:correlativo, costo: centro_costo, subtotal: subtotal},
            success: function (data) {
                if(data.error == 1){
                    crear_alerta("info", "Aviso", "Hubo un error al cargar los componentes.");
                } else{
                    var identificador = producto+'_'+correlativo;
                    $("#costos_producto"+identificador).html(data.html);
                }
            }
        })
    }

    $(".agregar_det_costo").live('click', function(){ //nos agrega el componente a la grid
        var producto = $(this).data('idp');
        var correlativo = $(this).data('corr');
        var ident = $(this).data('iden');

        var subtotal_costo = $("#subtotal_producto"+ident).val(); //centro de costo

        //centro costo
        var select_costo = $("#centro_costo"+ident).val(); //centro de costo id
        var select_text_costo = $("#centro_costo"+ident+" option:selected").text(); //nombre de centro y tipo cuenta
        var select_tcuenta_costo = $("#centro_costo"+ident+" option:selected").data('tcuenta');//id
        var select_cuenta_costo = $("#centro_costo"+ident+" option:selected").data('cuenta');//id

        var select_costo_array = select_text_costo.split(' - ');

        var nombre_centro_costo = select_costo_array[0];
        var nombre_tipo_cuenta = select_costo_array[1];
        var nombre_cuenta_costo = $("#centro_costo"+ident+" option:selected").data('cuenta_nomb'); //nombre de cuenta


        //porcentaje
        var porcentaje = parseFloat($("#porcentaje_costo_modal"+ident).val());

        var campos_requeridos = '';
        if($("#centro_costo_costo"+select_costo+ident).length > 0){
            crear_alerta("info", "Aviso", "El costo ya ha sido ingresado.");
            return false;
        }

        var porcentaje_actual = obtener_porcentajes($(this).closest('.slCobrs'));

        if((porcentaje_actual+porcentaje) > 100){
            crear_alerta("info", "Aviso", "El porcentaje supera el 100%.");
            return false;
        }

        if((select_costo>0 || select_costo!='') && porcentaje>0.00){
            var subtotal_porcentaje = subtotal_costo*(porcentaje/100);
            var contador = parseInt($("#contador_costo"+ident).val());
            //var ident2 = '_'+select_producto+'_'+contador;
            if($("#grid_costo"+ident).find(".grid_empty").length > 0){
                $("#grid_costo"+ident).html('');
            }

            caj_centro_costo = '<input type="hidden" id="centro_costo_costo'+select_costo+ident+'" name="centro_costo_costo'+ident+'[]" class="centro_costov" value="'+select_costo+'">'+
                            '<label style="padding: 6px 4px;">'+nombre_centro_costo+'</label>';

            caj_tipo_cuenta = '<input type="hidden" id="tipo_cuenta_costo'+ident+'" name="tipo_cuenta_costo'+ident+'[]" class="tipo_cuentav" value="'+select_tcuenta_costo+'">'+ //a guardar
                            '<label style="padding: 6px 4px;">'+nombre_tipo_cuenta+'</label>';

            caj_cuenta = '<input type="hidden" id="cuenta_contable_costo'+ident+'" name="cuenta_contable_costo'+ident+'[]" class="cuenta_contablev" value="'+select_cuenta_costo+'">'+
                            '<label style="padding: 6px 4px;">'+nombre_cuenta_costo+'</label>';

            caj_porcentaje = '<input type="hidden" class="porcentaje_costo_temp" value="'+porcentaje+'">'+
                            '<input type="text" name="porcentaje_costo'+ident+'[]" class="soloDecimales porcentaje_costo edit" data-tip="0" value="'+porcentaje+'" style="margin-bottom: 0px;width: 100%;display:none;">'+
                            '<label style="padding: 6px 4px;">'+porcentaje+'%</label>';

            caj_subtotal = '<input type="hidden" name="subtotal_costo'+ident+'[]" class="subtotal_costo" value="'+subtotal_porcentaje+'">'+
                            '<label style="padding: 6px 4px;">$'+number_format(subtotal_porcentaje, cantidad_decimales)+'</label>';


            editar = '<a class="icon12 icomoon-icon-pencil-5 editar_costo action" est="0" idn="'+ident+'" correlativo="'+correlativo+'" title="Editar costo" style="margin-right: 10px;font-size:15px;cursor:pointer;"></a>';
            eliminar = '<a class="icon-remove white remove_costo action" title="Eliminar costo" style="margin-right: 5px;cursor:pointer;font-size:15px;">&nbsp;</a>';

            caj_acciones = editar+eliminar;
            //$("#grid_componente"+ident).find(".grid_empty").length;
            //            console.log(ident);
            $("#grid_costo"+ident).append('<tr id="body_costo_'+contador+ident+'" class="tr_body_costo">'+
                '<td width="25%">'+caj_centro_costo+'</td>'+
                '<td width="14%">'+caj_tipo_cuenta+'</td>'+
                '<td width="25%">'+caj_cuenta+'</td>'+
                '<td width="14%">'+caj_porcentaje+'</td>'+
                '<td width="14%">'+caj_subtotal+'</td>'+
                '<td width="8%">'+caj_acciones+'</td></tr>');
            contador += 1;
            var ident_div = $(this).closest('.slCobrs');
            //actualizar_precio(ident_div);
            //Reinicio de cajas
            $("#centro_costo"+ident+" option").removeAttr('selected');
            $("#centro_costo"+ident).select2();
            $("#porcentaje_costo_modal"+ident).val('');
            actualizar_totales($(this).closest('.slCobrs'));
            $("#contador_componente"+ident).val(contador);
        } else{
            if((!select_costo>0) || select_costo==''){
                campos_requeridos += 'costo, ';
            }
            if((!porcentaje>0) || porcentaje!=''){
                campos_requeridos += 'porcentaje, ';
            }
            if($.trim(campos_requeridos) != ''){
                var requerido_array = campos_requeridos.split(', ');
                requerido_array = requerido_array.filter(Boolean); //nos quita las posiciones vacias de un arreglo
                campos_requeridos = (requerido_array.length == 1)?'El campo: ' + campos_requeridos.replace(/,/g,'') + ' es requerido':'Los campos: ' + campos_requeridos + ' son requeridos';
                crear_alerta("info", "Aviso", campos_requeridos)
            }
        }
    })

    function actualizar_totales(modal){
        var total_porcentaje = 0;
        var subtotal_costo = parseFloat(modal.find(".subtotal_producto").val());
        modal.find('.tr_body_costo').each(function(){
            total_porcentaje += parseFloat($(this).find('.porcentaje_costo').val());
        })
        modal.find('.foot_porcentaje').text(number_format(total_porcentaje,2)+'%');
        modal.find('.foot_subtotal').text('$'+number_format((subtotal_costo*(total_porcentaje/100)),cantidad_decimales))
    }

    function obtener_porcentajes(modal){
        var total_porcentaje = 0;
        modal.find('.tr_body_costo').each(function(){
            total_porcentaje += parseFloat($(this).find('.porcentaje_costo').val());
        })
        return total_porcentaje
    }

    $(".editar_costo").live('click', function(){
        var est = $(this).attr('est');
        var tr = $(this).closest('tr');
        var ident = $(this).closest('.slCobrs');
        var porcentaje_actual = obtener_porcentajes(ident);
        var subtotal_costo = parseFloat(ident.find(".subtotal_producto").val());
        if(est == 0){
            $(this).attr('est',1);
            tr.find('.edit').show();
            tr.find('.edit').each(function(){
                $(this).next('label').hide();
            })
        } else{
            var error = 0;
            tr.find('.edit').each(function(){
                var val_temp = ($(this).data('tip')==1)?number_format($(this).val(),cantidad_decimales):parseFloat($(this).val());
                if($(this).data('tip')!=1){
                    if((porcentaje_actual - (parseFloat($(this).after().val())) + val_temp) > 100){
                        crear_alerta("info", "Aviso", "El porcentaje supera el 100%.");
                        error = 1;
                    } else{
                        $(this).after().val(val_temp);
                        $(this).next('label').text(val_temp+'%');
                        $(this).next('label').show();
                        tr.find('.subtotal_costo').val((subtotal_costo*(parseFloat(val_temp)/100)));
                        tr.find('.subtotal_costo').next().text('$'+number_format((subtotal_costo*(parseFloat(val_temp)/100)),cantidad_decimales));
                    }
                }

            })
            if(error == 0){
                $(this).attr('est',0);
                tr.find('.edit').hide();
                actualizar_totales(ident);
            }

        }
    })

    $(".porcentaje_costo ").live('blur', function(){
        var tr = $(this).closest('tr');
        var valor = parseFloat($(this).val());
        var div_costos = $(this).closest('.slCobrs');
        var porcentaje_actual = obtener_porcentajes(div_costos);
        if(isNaN(valor)){
            $(this).val(1);
            crear_alerta("info", "Aviso", 'El precio no puede contener letras.');
        } else if(valor == parseFloat(0.00)){
            $(this).val(1);
            crear_alerta("info", "Aviso", 'La cantidad no puede ser 0.');
        } else if( (porcentaje_actual - (parseFloat($(this).after().val())) + valor) > 100 ){
            $(this).val(1);
            crear_alerta("info", "Aviso", 'El porcentaje no puede ser mayor a 100%.');
        }
        actualizar_sub_total_costo(tr);
    })

    function actualizar_sub_total_costo(tr_fila){
        var div_costos = tr_fila.closest('.slCobrs');
        var subtotal_costo = parseFloat(div_costos.find(".subtotal_producto").val());

        tr_fila.find('.edit').each(function(){
            if($(this).data('tip')==0){
                var val_temp = parseFloat($(this).val());
                //console.log(val_temp);
                //console.log(subtotal_costo);
                $(this).after().val(val_temp);
                $(this).next('label').text(val_temp+'%');
                tr_fila.find('.subtotal_costo').val((subtotal_costo*(parseFloat(val_temp)/100)));
                tr_fila.find('.subtotal_costo').next().text('$'+number_format((subtotal_costo*(parseFloat(val_temp)/100)),cantidad_decimales));
            }

        })
        actualizar_totales(div_costos);
    }

    function actualizar_porcentaje_principal(modal, precio){
        modal.find(".subtotal_producto").val(precio);
        modal.find(".tr_body_costo").each(function(){
            actualizar_sub_total_costo($(this));
        })
    }

    $(".remove_costo").live('click', function(){ //elimina el componente agregado
        var tr = $(this).closest('tr');
        var body = $(this).closest('tbody');
        var ident = $(this).closest('.slCobrs');
        tr.remove();
        actualizar_totales(ident);
        if(!(body.find('tr.tr_body_costo').length > 0)){
            body.html('<td style="text-align: center;" colspan="6" class="grid_empty">No se encontraron registros</td>');
        }
    })

    function actualizar_centro_costo_select(valor){
        $(".slCobrs").each(function(){
            var ident = $(this).data('ident');
            var correlativo = $(this).data('corr');
            var existe = $('#centro_costo'+ident+' option[value="'+valor+'"]');
            if(existe.length > 0){
                if($("#grid_costo"+ident).find(".grid_empty").length > 0){
                    $("#grid_costo"+ident).html('');

                    // es copia del de agregar "literalmente" con porcentaje 100%
                    var subtotal_costo = $("#subtotal_producto"+ident).val(); //centro de costo

                    ///////////////////////////////////////////////////no cambia
                    //centro costo
                    var select_costo = existe.val(); //centro de costo id
                    var select_text_costo = existe.text(); //nombre de centro y tipo cuenta
                    var select_tcuenta_costo = existe.data('tcuenta');//id
                    var select_cuenta_costo = existe.data('cuenta');//id

                    var select_costo_array = select_text_costo.split(' - ');

                    var nombre_centro_costo = select_costo_array[0];
                    var nombre_tipo_cuenta = select_costo_array[1];
                    var nombre_cuenta_costo = existe.data('cuenta_nomb'); //nombre de cuenta
                    /////////////////////////////////////////////////no cambia

                    ////////////////////////////////////////////////copiar y pegar
                    //porcentaje
                    var porcentaje = parseFloat(100);

                    var subtotal_porcentaje = subtotal_costo*(porcentaje/100);
                    var contador = parseInt($("#contador_costo"+ident).val());
                    //var ident2 = '_'+select_producto+'_'+contador;
                    if($("#grid_costo"+ident).find(".grid_empty").length > 0){
                        $("#grid_costo"+ident).html('');
                    }

                    caj_centro_costo = '<input type="hidden" id="centro_costo_costo'+select_costo+ident+'" name="centro_costo_costo'+ident+'[]" class="centro_costov" value="'+select_costo+'">'+
                                    '<label style="padding: 6px 4px;">'+nombre_centro_costo+'</label>';

                    caj_tipo_cuenta = '<input type="hidden" id="tipo_cuenta_costo'+ident+'" name="tipo_cuenta_costo'+ident+'[]" class="tipo_cuentav" value="'+select_tcuenta_costo+'">'+ //a guardar
                                    '<label style="padding: 6px 4px;">'+nombre_tipo_cuenta+'</label>';

                    caj_cuenta = '<input type="hidden" id="cuenta_contable_costo'+ident+'" name="cuenta_contable_costo'+ident+'[]" class="cuenta_contablev" value="'+select_cuenta_costo+'">'+
                                    '<label style="padding: 6px 4px;">'+nombre_cuenta_costo+'</label>';

                    caj_porcentaje = '<input type="hidden" class="porcentaje_costo_temp" value="'+porcentaje+'">'+
                                    '<input type="text" name="porcentaje_costo'+ident+'[]" class="soloDecimales porcentaje_costo edit" data-tip="0" value="'+porcentaje+'" style="margin-bottom: 0px;width: 100%;display:none;">'+
                                    '<label style="padding: 6px 4px;">'+porcentaje+'%</label>';

                    caj_subtotal = '<input type="hidden" name="subtotal_costo'+ident+'[]" class="subtotal_costo" value="'+subtotal_porcentaje+'">'+
                                    '<label style="padding: 6px 4px;">$'+number_format(subtotal_porcentaje, cantidad_decimales)+'</label>';


                    editar = '<a class="icon12 icomoon-icon-pencil-5 editar_costo action" est="0" idn="'+ident+'" correlativo="'+correlativo+'" title="Editar costo" style="margin-right: 10px;font-size:15px;cursor:pointer;"></a>';
                    eliminar = '<a class="icon-remove white remove_costo action" title="Eliminar costo" style="margin-right: 5px;cursor:pointer;font-size:15px;">&nbsp;</a>';

                    caj_acciones = editar+eliminar;
                    //$("#grid_componente"+ident).find(".grid_empty").length;
                    $("#grid_costo"+ident).append('<tr id="body_costo_'+contador+ident+'" class="tr_body_costo">'+
                        '<td width="25%">'+caj_centro_costo+'</td>'+
                        '<td width="14%">'+caj_tipo_cuenta+'</td>'+
                        '<td width="25%">'+caj_cuenta+'</td>'+
                        '<td width="14%">'+caj_porcentaje+'</td>'+
                        '<td width="14%">'+caj_subtotal+'</td>'+
                        '<td width="8%">'+caj_acciones+'</td></tr>');
                    contador += 1;
                    var ident_div = $(this).closest('.slCobrs');
                    //actualizar_precio(ident_div);
                    //Reinicio de cajas
                    $("#centro_costo"+ident+" option").removeAttr('selected');
                    $("#centro_costo"+ident).select2();
                    $("#porcentaje_costo_modal"+ident).val('');
                    actualizar_totales($(this).closest('.slCobrs'));
                    $("#contador_componente"+ident).val(contador);
                }
            }
        })
    }

    $('#del_doc').live('click', function (event) {
        event.preventDefault();
        //obtenemos los valores del boton de eliminar para eliminar la fila
        var id_fila = $(this).attr("valor");
        var id_head = $(this).attr("thead");
        var id_body = $(this).attr("tbody");
        $("#fila" + id_head + id_fila).remove();
        if ($('#' + id_body).find('tr').length == 0) {
            $("#" + id_head).css('display', 'none');
            $("#" + id_head).css('display', 'none');
        }
    });

    $(".detalle_fanc").fancybox({
        width: '50%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        helpers: {
            overlay: { closeClick: false } //Disable click outside event
        }
    });

    /****************************** AGREGAR DETALLES DE CARACTERÍSTICAS ******************************************/
    $('.agregar_caract_btn').live('click', function () {
        var mensaje = '';
        var producto = $(this).attr('producto');
        var correlativo = $(this).attr('correlativo');
        var slcCaract = $('#slcCaract_' + producto + '_' + correlativo).val();
        var slcCaract_text = $('#slcCaract_' + producto + '_' + correlativo + ' option:selected').text();
        var slcCaractArt = $('#slcCaract_' + producto + '_' + correlativo + ' option:selected').attr('car_art');

        /***************Dependiendo el tipo input form**************************/
        var impCaract = '';
        var ticar = $('.valorprin_' + producto + '_' + correlativo).attr('id');
        switch (ticar) {
            case '1_'+correlativo://Lista multiple
                $('.valorprin_' + producto + '_' + correlativo + ' :selected').each(function (i, selected) {
                    if (i == 0) {
                        impCaract = impCaract + $(selected).text();
                    } else {
                        impCaract = impCaract + "," + $(selected).text();
                    }
                });
                break;
            case '2_'+correlativo://Lista desplegable
                impCaract = $('.valorprin_' + producto + '_' + correlativo + ' option:selected').text();
                break;
            case '3_'+correlativo://Numerico
                impCaract = $('.valorprin_' + producto + '_' + correlativo).val();
                break;
            case '4_'+correlativo://Decimal
                impCaract = $('.valorprin_' + producto + '_' + correlativo).val();
                break;
            case '5_'+correlativo://Texto
                impCaract = $('.valorprin_' + producto + '_' + correlativo).val();
                break;
            case '6_'+correlativo://Checbox
                if ($('.valorprin_' + producto + '_' + correlativo).is(':checked'))
                    impCaract = 'Si';  // checked
                else
                    impCaract = 'No';  // unchecked
                break;
            default:
                impCaract = $('.valorprin_' + producto + '_' + correlativo).val();  // valor principal cuando ya existe valor
        }
        $('#element_' + producto + '_' + correlativo).html('<input type="text" value="" class="valorprin valorCaracteristica" readonly>');
        /******************************************************/
        var contador = $('#caracTable_contador' + producto + '_' + correlativo).val();
        if ($.trim(slcCaract) != '' && $.trim(impCaract) != '' && $('#slcCaract_' + slcCaract + '_' + correlativo).length == 0) {
            id_slcCaract = '<input type="hidden" id="slcCaract_' + slcCaract + '_' + correlativo + '" name="fam_nombre[]" value="' + slcCaract + '" />';
            id_impCaract = '<input type="hidden" name="valorcaja_' + producto + '_' + slcCaractArt + '_' + correlativo + '" value="' + impCaract + '" id="valor_' + producto + '_' + slcCaractArt + '_' + correlativo + '" />';
            id_impCaract_car = '<input type="hidden" name="caracteristica_' + producto + '_' + correlativo + '[]" value="' + slcCaractArt + '" />';
            id_impCaract_val = '<input type="hidden" name="valor_' + producto + '_' + slcCaractArt + '_' + correlativo + '" value="' + impCaract + '" id="valorreg_' + producto + '_' + slcCaractArt + '_' + correlativo + '"  />';
            id_impCaract_des = '<input type="hidden" name="descripcion_' + producto + '_' + slcCaractArt + '_' + correlativo +'" value="' + slcCaractArt + '" value="' + slcCaract_text + '"  />';

            eliminar = '<a class="btn btn-danger btn-mini minia-icon-trashcan white borrar_caract" valor="' + contador + '_' + correlativo + '" correlativo = "'+correlativo+'" producto="' + producto + '" thead="caracTable_" tbody="bdcarat"> Eliminar</a>';
            if ($('#col_def' + producto + '_' + correlativo).lenght != 0) {
                $("#col_def" + producto + '_' + correlativo).remove();
            }
            $("#caracTable_" + producto + '_' + correlativo).append(
                    '<tr id="bdcarat' + producto + contador + '_' + correlativo + '" >' +
                    '<td>' + id_slcCaract + slcCaract_text + '</td>' +
                    '<td>' + id_impCaract + id_impCaract_car + id_impCaract_val + id_impCaract_des + impCaract + '</td>' +
                    '<td>' + eliminar + '</td>' +
                    '</tr>');
            contador++;
            $('#caracTable_contador' + producto).val(contador);

            $('#slcCaract_' + producto + '_' + correlativo + ' option').removeAttr("selected");
            $('#slcCaract_' + producto + '_' + correlativo).select2();
            $('.valorprin_' + producto + '_' + correlativo + ' option').removeAttr("selected");
            $('.valorprin_' + producto + '_' + correlativo).select2({width: '100%'});

            $('.valorprin_' + producto + '_' + correlativo).val('');

        } else {
            if ($.trim(slcCaract) == '' || $.trim(impCaract) == '') {
                mensaje = 'Campos requeridos';
            } else if ($('#slcCaract_' + slcCaract + '_' + correlativo).length > 0) {
                mensaje = "El detalle ya ha sido agregado";
            }
            if ($.trim(slcCaract) == '') {
                $('#slcCaract_' + producto + '_' + correlativo + '_error').text('Campo requerido');
                if ($.trim(impCaract) == '') {
                    $('.valorprin_' + producto + '_' + correlativo + '_error').text('Campo requerido');
                }
            } else if ($.trim(impCaract) == '') {
                $('.valorprin_' + producto + '_' + correlativo + '_error').text('Campo requerido');
                if ($.trim(slcCaract) == '') {
                    $('#slcCaract_' + producto + '_' + correlativo + '_error').text('Campo requerido');
                }
            }
            $('#slcCaract_' + producto + '_' + correlativo).select2("val", "");
        }

        if ($.trim(mensaje) != "") {
            $.pnotify({
                type: 'error',
                title: 'Aviso',
                text: mensaje,
                icon: 'ui-icon ui-icon-info white',
                opacity: 0.95,
                history: false,
                sticker: false
            });
        }

    });

    $('.borrar_caract').live('click', function (event) {
        event.preventDefault();

        //obtenemos los valores del boton de eliminar para eliminar la fila
        var id_producto = $(this).attr("producto");
        var id_fila = $(this).attr("valor");
        var id_head = $(this).attr("thead");
        var id_body = $(this).attr("tbody");
        var correlativo = $(this).attr("correlativo");

        $('#' + id_body + id_producto + id_fila).remove();
        if ($('#' + id_head + id_producto + '_' + correlativo).find('tr').length == 0) {
            $("#caracTable_" + id_producto + '_' + correlativo).append('<tr id="col_def' + id_producto + '_' + correlativo + '"><td colspan="3" style="text-align: center;">Sin registros</td></tr>');
        }
    });

    function aplicar_fancy() {
        $(".fancy_costo").fancybox({
            width: '70%',
            height: 'auto',
            autoSize: false,
            closeClick: false,
            type: 'inline',
            /*closeBtn : false,
            keys : {
                close  : null
            },
            helpers: {
                overlay: { closeClick: false } //Disable click outside event
            },*/
            beforeLoad: function () {

            },
            beforeClose: function () {
                var modal_id = $(this).attr('href');
                var modal = $(modal_id).find('.slCobrs');
                var porcentaje_modal = obtener_porcentajes(modal);
                if(!(porcentaje_modal == 0 || porcentaje_modal == 100)){
                    crear_alerta("info", "Aviso", "El porcentaje debe ser 100%.");
                    return false;
                }
            }
        })
    }
    aplicar_fancy();


    /**********Generar el input en base tipo de caracteristica**************/
    $('.valorCaracteristica').live('blur', function (event) {
        var valor = $(this).val();
        var producto = $(this).attr('producto');
        var cxu = $(this).attr('cxu');
        var corr = $(this).attr('correlativo');

        $("#valor_"+producto+"_"+cxu+"_"+corr).val(valor);
    });


    $("body").on('click', '#btn_empaque_agregar_modal', function () {
        event.preventDefault();

        var caracteristicas = $("#slc_empaque_carac_modal").val();
        var id_carac        = "";
        var unidades        = parseFloat($("#txt_empaque_unidades_modal").val());
        var peso_n          = parseFloat($("#txt_empaque_peso_n_modal").val());
        var peso_b          = parseFloat($("#txt_empaque_peso_b_modal").val());
        var id              = $("#txt_modal_id").val();
        var codigo          = "";
        var lote            = $("#codigo_lote_"+id).val();
        var rows_old        = parseInt( $("#txt_correlativo_empaque_"+id).val() );
        var n_empaques      = $("#txt_numero_empaques_modal").val();

        if ( caracteristicas == "" ){
            crear_alerta('error', 'Caracteristicas', 'Seleccione una característica.');
            return false;
        }

        id_carac = $("#slc_empaque_carac_modal option:selected").attr('data-id');

        if ( unidades  <= 0 || isNaN(unidades) ){
            crear_alerta('error', 'Unidades', 'Unidades debe ser mayor a cero.');
            return false;
        }

        if ( peso_n  <= 0 || isNaN(peso_n) ){
            crear_alerta('error', 'Peso neto', 'Peso neto debe ser mayor a cero.');
            return false;
        }

        if ( peso_b  <= 0 || isNaN(peso_b) ){
            crear_alerta('error', 'Peso bruto', 'Peso bruto debe ser mayor a cero.');
            return false;
        }

        var rows = $('#table_empaque tbody tr.tabla_modal').length;

        var date    = new Date();
        var dia     = date.getDate();
        var yy      = date.getFullYear();
        var year    = yy.toString().substr(-2);

        var month = new Array();
        month[0] = "EN";
        month[1] = "FE";
        month[2] = "MA";
        month[3] = "AB";
        month[4] = "MA";
        month[5] = "JN";
        month[6] = "Ju";
        month[7] = "AG";
        month[8] = "SE";
        month[9] = "OC";
        month[10] = "NO";
        month[11] = "DE";

        var mes = month[date.getMonth()];

        if ( rows == 0) {
            $("#tbody_empaque_modal").html("");
        }

        rows    = rows + 1 + rows_old;

        var tabla   = "";

        for (var i=0; i < n_empaques; i++) {
        codigo  = rows+lote+dia+mes+year+caracteristicas;

        tabla       += '<tr class="tabla_modal">';
            tabla       += '<td>';
                tabla       += rows;
                tabla       += '<input type="hidden" class="nostyle"  id="empaque_orden_'+id+'" name="empaque_orden_'+id+'[]" value="'+rows+'">';
                tabla       += '<input type="hidden" class="nostyle "  id="empaque_carac_'+id+'" name="empaque_carac_'+id+'[]" value="'+id_carac+'">';
            tabla       += '</td>';
            tabla       += '<td>';
                tabla       += codigo;
                tabla       += '<input type="hidden" class="nostyle "  id="empaque_codigo_'+id+'" name="empaque_codigo_'+id+'[]" value="'+codigo+'">';
            tabla       += '</td>';
            tabla       += '<td>';
                tabla       += unidades;
                tabla       += '<input type="hidden" class="nostyle unidades_empaque_'+id+'"  id="empaque_unidades_'+id+'" name="empaque_unidades_'+id+'[]" value="'+unidades+'">';
            tabla       += '</td>';
            tabla       += '<td>';
                tabla       += peso_n;
                tabla       += '<input type="hidden" class="nostyle neto_empaque_'+id+'"  id="empaque_peso_n_'+id+'" name="empaque_peso_n_'+id+'[]" value="'+peso_n+'">';
            tabla       += '</td>';
            tabla       += '<td>';
                tabla       += peso_b;
                tabla       += '<input type="hidden" class="nostyle bruto_empaque_'+id+'"  id="empaque_peso_b_'+id+'" name="empaque_peso_b_'+id+'[]" value="'+peso_b+'">';
            tabla       += '</td>';
            tabla       += '<td>';
                tabla       += '<button type="button" class="btn btn-danger btn-mini btnDelEmpaque" style="float:center; /*margin-left:5%;*/ height:30px;width:50px;" value="'+id+'">Eliminar</button>';
            tabla       += '</td>';
        tabla       += '</tr>';
        rows++;
        }

        $("#tbody_empaque_modal").append(tabla);


        $("#txt_empaque_unidades_modal").val("");
        $("#txt_empaque_peso_n_modal").val("");
        $("#txt_empaque_peso_b_modal").val("");

        $("#slc_empaque_carac_modal").removeAttr('selected');

        $("#slcBodega option:selected").removeAttr('selected');
        $("#slc_empaque_carac_modal").select2();

        var total_unidades  = contar_columnas("#table_empaque .unidades_empaque_"+id) ;
        var total_bruto     = contar_columnas("#table_empaque .bruto_empaque_"+id) ;
        var total_neto      = contar_columnas("#table_empaque .neto_empaque_"+id) ;

        var tfoot   = "";
        $("#tfoot_empaque_modal").html(tfoot);

        tfoot +=  '<tr>';
        tfoot +=  '<td colspan="2" align="right">Totales</td>';
        tfoot +=  '<td><input type="text" id="foot_unidades_empaque_'+producto_art+'" readonly value="'+total_unidades+'"></td>';
        tfoot +=  '<td><input class="total_neto_empaque" type="text" id="foot_neto_empaque_'+producto_art+'" readonly value="'+total_neto+'"></td>';
        tfoot +=  '<td><input type="text" id="foot_bruto_empaque_'+producto_art+'" readonly value="'+total_bruto+'"></td>';
        tfoot +=  '<td></td>';
        tfoot +=  '</tr>';

        $("#tfoot_empaque_modal").html(tfoot);

        $("#txt_numero_empaques_modal").val(1);
    });

    $("body").on('click', '#guardar_empaque_modal', function () {
        event.preventDefault();

        var rows = $('#table_empaque tbody tr.tabla_modal').length;

        if ( rows == 0 ){
            crear_alerta('error', 'Entrada de empaque', 'Se debe agregar alemenos un producto.');
            return false;
        }

        var new_tabla   = $("#tbody_empaque_modal").html();
        var new_foot    = $("#tfoot_empaque_modal").html();
        var id          = $("#txt_modal_id").val();

        $("#tb_empaque_"+id).html(new_tabla);
        $("#tbody_empaque_modal").html("");

        $("#tf_empaque_"+id).html(new_foot);
        $("#tfoot_empaque_modal").html("");

        $("#txt_modal_id").val("");
        $("#txt_empaque_unidades_modal").val("");
        $("#txt_empaque_peso_n_modal").val("");
        $("#txt_empaque_peso_b_modal").val("");

        var total_neto      = contar_columnas(".neto_empaque_"+id) ;
        $("#detalle_cantidad_"+id).val(total_neto);
        $("#lbl_detalle_cantidad_"+id).text(total_neto);

        $.fancybox.close();
    });

    //Eliminar un prorrateo
    $("#table_empaque tbody").on('click', '.btnDelEmpaque', function () {
        var id = $(this).val();

        $(this).parent().parent().remove();

        var total_unidades  = contar_columnas(".unidades_empaque_"+id) ;
        var total_bruto     = contar_columnas(".bruto_empaque_"+id) ;
        var total_neto      = contar_columnas(".neto_empaque_"+id) ;

        var tfoot   = "";
        $("#tfoot_empaque_modal").html(tfoot);

        tfoot +=  '<tr>';
        tfoot +=  '<td colspan="2" align="right">Totales</td>';
        tfoot +=  '<td><input type="text" id="foot_unidades_empaque_'+id+'" readonly value="'+total_unidades+'"></td>';
        tfoot +=  '<td><input class="total_neto_empaque" type="text" id="foot_neto_empaque_'+id+'" readonly value="'+total_neto+'"></td>';
        tfoot +=  '<td><input type="text" id="foot_bruto_empaque_'+id+'" readonly value="'+total_bruto+'"></td>';
        tfoot +=  '<td></td>';
        tfoot +=  '</tr>';

        $("#tfoot_empaque_modal").html(tfoot);

    });

    $("body").on('change', '#txtCodigoLote', function () {
        if ( $("#bodega_bod").val() != "" && $("#txtCodigoLote").val() != "" && $("#producto_art").val() != ""){
            get_productos_empaquetados($("#bodega_bod").val(), $("#producto_art").val(), $("#txtCodigoLote").val(), 0);
        } else {
            $("#txt_correlativo_lote").val("0");
        }
    });

    /*$("body").on('keyup', '#txt_empaque_peso_n_modal', function () {
        if ($(this).val() != ""){
            var neto    = parseFloat( $(this).val() );
            neto        = neto * 1.18;
            neto        = number_format(neto,2,".","");
            $("#txt_empaque_peso_b_modal").val( neto );
        }
    });*/

    $(".valorCaracteristica").live('change', function(event) {
        var producto = $(this).attr('producto');
        var corr = $(this).attr('correlativo');
        var cxu = $(this).attr('cxu');
        var valor = $(this).val();

        $("#valor_"+producto+"_"+cxu+"_"+corr).val(valor);

    });

});

function limpiarproducto(){
    $("#producto_art").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });
}


function cargar_caracteristicas(id_producto, correlativo) {
    $.ajax({
        dataType: 'json',
        type: 'POST',
        url: urlj + 'facturacion/facturar/obtener_caracteristica',
        data: {producto: id_producto,correlativo:correlativo},
        success: function (data) {
                div_caracteristica = '<div class="box">' +
                        '    <div class="title">' +
                        '        <h4><span>Características del producto</span></h4>' +
                        '    </div>' +
                        '    <div class="content">' +
                        '        <div class="form-row row-fluid">' +
                        '            <input type="hidden" value="' + data.tipo + '" name="tipo_caracteristica[]">' +
                        '            <div>' + data.tabla +
                        '            </div>' +
                        '        </div>';
                if ($.trim(data.select) != "") {
                    div_caracteristica += '<div class="form-row row-fluid">' +
                            '            <label class="span3">Fórmulas:</label>' +
                            '            <div class="span5">' +
                            '            ' + data.select +
                            '            </div>' +
                            '            <div class="span4">' +
                            '               <button type="button" class="btn btn-success aplicar_formula_btn" producto="' + id_producto + '" correlativo="'+correlativo+'">Aplicar fórmula</button>' +
                            '           </div>' +
                            '        </div>' +
                            '        <div class="form-row row-fluid">' +
                            '            <label class="span4 offset3">Resultado:</label>' +
                            '            <div class="span4">' +
                            '               <label id="resultado_formula_label' + id_producto + '_'+correlativo+'" >0.00</label>' +
                            '               <div id="resmod_' + id_producto + '_'+correlativo+'" style="width: 130%"></div>' +
                            '               <input type="hidden" name="resultado_formula_input' + id_producto + '_'+correlativo+'" id="resultado_formula_input' + id_producto + '_'+correlativo+'">' +
                            '               <input type="hidden" name="resultado_formula_select' + id_producto + '_'+correlativo+'" id="resultado_formula_select' + id_producto + '_'+correlativo+'">' +
                            '            </div>' +
                            '        </div>';
                }

                div_caracteristica += '<div class="form-row row-fluid">' +
                        '            <div class="span12">' +
                        '                <div class="form-actions" style="text-align:center;">' +
                        '                   <button type="button" class="btn btn-success" onclick="javascript:$.fancybox.close();"><span class="icon16 icomoon-icon-checkmark white"></span>Guardar</button>' +
                        '                   <a onclick="javascript:$.fancybox.close();" class="btn btn-danger btn-close" id="btnCancelarSelect"><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</a>' +
                        '               </div>' +
                        '           </div>' +
                        '        </div>' +
                        '    </div>' +
                        '</div>';

                $("#caracteristica_producto" + id_producto + '_' + correlativo).html(div_caracteristica);
                $("#select_formula_" + id_producto+'_'+correlativo).select2();
                $("#slcCaract_" + id_producto+'_'+correlativo).select2();

                $('.aplicar_select').each(function(){
                    var tipo = $(this).attr('id');
                    if (tipo == 1 || tipo == 2) {
                        $(this).select2({width: '100%'});
                    }
                    if (tipo == 6) {
                        $(this).removeAttr("checked");
                        $(this).iButton('repaint');
                    }
                })


        }
    })
}

     /**********Generar el input en base tipo de caracteristica**************/
    $(document).live('change', '.slcCaract_chang', function (event) {

        var idselect = $('.slcCaract_chang').attr('id');
        var correlativo = $('.slcCaract_chang').attr('correlativo');
        var idart = $('#' + idselect + ' option:selected').attr('producto');
        //console.log('id producto:' + $('.slcCaract_chang').val());
        //console.log('id producto:' + idart);
        //console.log('id del select:' + idselect);

        //Limpiar valor de la caja valor principal
        if (!$('.slcCaract_chang').val()) {
            $('#element').html('<input type="text" value="" class="valorprin valorCaracteristica " readonly>');
        }
        var cxr_id = $('#' + idselect + ' option:selected').attr('data-cxr');
        //console.log('este el cxr: ' + cxr_id);
        var div = $(this).parent().next().children();

        $.ajax({
            url: urlj + 'inventario/agregar_articulos2/get_tipocaracteristica2',
            async: true,
            type: 'POST',
            dataType: 'json',
            data: {cxr_id: cxr_id, idart: idart, correlativo:correlativo},
            success: function (data) {
                //console.log(data);
                //console.log('Esta es la div2: ' + '#element_' +idart+'_'+correlativo);
                $('#element_' + idart+'_'+correlativo).html(data.tag);
                if (data.tipo == 1 || data.tipo == 2) {
                    $(".valorprin_" + idart + '_' + correlativo).select2({width: '100%'});
                }
                if (data.tipo == 6) {
                    $("#6").removeAttr("checked");
                    $("#6").iButton('repaint');
                }
            }
        });
    });
    /***********************************************************************/


    $(".fancy_empaque").fancybox({
        width: '80%',
        height: 'auto',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        closeBtn : false,
        keys : {
            close  : null
        },
        helpers: {
            overlay: { closeClick: false } //Disable click outside event
        },
        beforeLoad: function () {
            var id          = $(this.element[0]).data("articulo");
            var tabla       = $("#tb_empaque_"+id).html();
            var tfoot       = $("#tf_empaque_"+id).html();

            var correlativo = $("#txt_contador_empaque_"+id).val(); // el cero
            var tabla_carac = "#caracTable_" + id + "_" + correlativo;
            var option      = "<option></option>";
            var i           = 0;
            var cono        = 1;
            var caja        = 0;

            $(tabla_carac +' > tr').each(function() {
                var nombre      = $(this).find('td:first').text();
                var valor       = "";
                var select      = $(this).find('td:first').next().find('select').length;

                if ( select == 1){
                        valor = $(this).find('td:first').next().find('.select2-container').text();
                } else {
                        valor = $(this).find('td:first').next().text();
                }

                valor           = valor.trim();
                var arr         = valor.split(' ');
                valor           = arr[0];

                if ( $(this).find('td:first').children().val() == 24 ){
                    caja = valor;
                }

                if ( $(this).find('td:first').children().val() == 19 ) {
                    cono = ( isNaN(valor) )?1:valor;
                }

                var carac_id    = $(".carac_empaquetado_"+i).val();

                if (jQuery.type(nombre) === "undefined" ){

                } else {
                    if ( valor != "" && valor != "Seleccione"){
                        option += '<option value="'+valor+'" data-id="'+carac_id+'">'+nombre+'('+valor+')</option>';
                    }
                }

                i++;
            });

            $("#slc_empaque_carac_modal").html(option);
            $("#slc_empaque_carac_modal").select2();

            $("#tbody_empaque_modal").append(tabla);
            $("#tfoot_empaque_modal").append(tfoot);

            $("#txt_modal_id").val(id);

            $("#txt_modal_peso_cono").val(cono);
            $("#txt_modal_peso_caja").val(caja);

            $("#txt_numero_empaques_modal").val(1);
        },
        beforeClose: function () {
            $("#tbody_empaque_modal").html("");
            $("#tfoot_empaque_modal").html("");

            $("#slc_empaque_carac_modal").html("");
            $("#slc_empaque_carac_modal").select2();


            $("#txt_modal_id").val("");
            $("#txt_empaque_unidades_modal").val("");
            $("#txt_empaque_peso_n_modal").val("");
            $("#txt_empaque_peso_b_modal").val("");

            $("#txt_modal_peso_cono").val("1");
            $("#txt_modal_peso_caja").val("0");
        }
    });

    function contar_columnas(clase) {
        var calculo = 0;
        $( clase ).each(function( index ) {
            var valor = $(this).val();
            if (valor != "") {
                calculo = calculo + parseFloat(valor);
            }
        });
        return number_format(calculo,2,".","");
    }

    function get_productos_empaquetados(bodega,articulo,lote,tipo){
        $.ajax({
            url: urlj + 'inventario/gestion_productos/get_productos_empaquetados',
            type: 'POST',
            dataType: 'json',
            data: {bodega: bodega, articulo: articulo,lote: lote, tipo: tipo},
            success: function (data) {
                if (tipo == 0) {
                    $("#txt_correlativo_lote").val(data);
                }
            }
        });
     }

    $( ".calculo" ).keyup(function() {
        var peso_cono       = ( $('#txt_modal_peso_cono').val() != "" )? parseFloat( $('#txt_modal_peso_cono').val() ) : 1;
        var peso_caja       = ( $('#txt_modal_peso_caja').val() != "" )? parseFloat( $('#txt_modal_peso_caja').val() ) : 0;
        var unidades        = ( $('#txt_empaque_unidades_modal').val() != "" )? parseFloat( $('#txt_empaque_unidades_modal').val() ) : 0;
        var peso_bruto      = ( $('#txt_empaque_peso_b_modal').val() != "" )? parseFloat( $('#txt_empaque_peso_b_modal').val() ) : 0;
        var peso_n          = peso_bruto-(peso_caja+(unidades*peso_cono));
        $('#txt_empaque_peso_n_modal').val(peso_n);
    });
