window.gSateliteWhite.jsDatePicker();
var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;
var i = 0;
var medida_defecto = "";

$(document).ready(function(){
	
	$(".seleccion").select2();
	$(".numerico").numeric();
	$(".ibutton").iButton();	

	/* PULIR PARA PASAR AL UTILS*/
	$("#codigo, #txtCodPrd").live('keypress',function(e) {
		key = e.keyCode || e.which;
		tecla = String.fromCharCode(key).toLowerCase();
		letras = "áéíóúabcdefghijklmnñopqrstuvwxyz0123456789-_";
		if (tecla == '\'' || tecla == '%' || tecla == '^' || tecla == '&' || tecla == '@'  || tecla == '#'  || tecla == '!'  || tecla == '$' || tecla == '"' ) { return false;} 
		especiales = [8,9,13,16,17,20,27,35,36,37,39,46];
		tecla_especial = false
		for (var i in especiales) {
			if (key == especiales[i]) {
				tecla_especial = true;
				break;
			}
		}
		if (letras.indexOf(tecla) == -1 && !tecla_especial) { return false; }
	});


	//verifica si el codigo existe o no
	$("#codigo").change(function() {
		val_codigo();//validacion de codigo
	});

	calcular_stock();

	$("#producto_datos_combo_ajax").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'inventario/mantenimiento/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: $("#tipo_general_combo").val()
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
                
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

	$('#bodega_bod').change(function(){
		bod = $(this).val();
		if($.trim(bod)!=""){
			$.ajax({
				url: urlj+'inventario/gestion_productos/get_sector_bodega',
				type: 'POST',
				dataType: 'json',
				data: {bodega: bod},
				success: function(data){
					if($.trim(data.resp) != ""){
						$("#sector_sxb").html(data.resp);
						$("#sector_sxb").select2();
					} else{
						$("#sector_sxb").html('<option value=""></option>');
						$("#sector_sxb").select2();
					}
				}
			});
		} else{
			$("#sector_sxb").html('<option value=""></option>');
			$("#sector_sxb").select2();
		}
	});

	$('#tipo_producto').change(function(event) {
		var tipo = $(this).val();
		var maximo = $("#maximo").val();
		var minimo = $("#minimo").val();
		if(tipo==1){
			if(minimo!='' || maximo!='' || $("#serie").is(':checked')){ //
				crear_alerta('info', 'Campos asociados', 'Los campos Mínimo, Máximo y Aplica serie no aplican para este tipo de producto.');
			}
			$("#maximo").val('');
			$("#minimo").val('');
			$("#maximo").attr('readonly', 'readonly');
			$("#minimo").attr('readonly', 'readonly');
			$('#txtbod_min_max').select2('disable');
			$("#serie").removeAttr( "checked" );
            $("#serie").iButton('repaint');
			$("#serie").iButton("disable", true);
			$("#activo_fijo, #aplica_empaque, #prod_materiap, #prod_inventario").removeAttr( "checked" );
			$("#activo_fijo, #aplica_empaque, #prod_materiap, #prod_inventario").iButton( "repaint" );
			$("#activo_fijo, #aplica_empaque, #prod_materiap, #prod_inventario").iButton("disable");			
		}else{
			$("#maximo").removeAttr('readonly', 'readonly');
			$("#minimo").removeAttr('readonly', 'readonly');
			$('#txtbod_min_max').select2('enable');
			$("#serie").iButton("disable", false);
			$("#activo_fijo, #aplica_empaque, #prod_materiap, #prod_inventario").iButton("disable", false);
			
		}
	});

	var url = $(location).attr('href');
	var parts = url.split("/");
	var last_part = parts[parts.length-1];
	if(last_part>0){
		var tipo = $('#tipo_producto').val();
		if(tipo==1){
			$("#maximo").attr('readonly', 'readonly');
			$("#minimo").attr('readonly', 'readonly');
			$("#serie").iButton("disable", true);
		}else{
			$("#maximo").removeAttr('readonly', 'readonly');
			$("#minimo").removeAttr('readonly', 'readonly');
			$("#serie").iButton("disable", false);
		}
	
	}


	/*======================================================================================================================================
	=											FILTRA LAS CARACTERISTICA PADRE/HIJO
	========================================================================================================================================
	*/
		//carga las caracteristica de la tab 1/////////////categoria
	function codigo_producto(){
		var corre = $("#codigo").val();
		var marca = $("#slcMarca").val();
		var categ = $("#categoria_seleccionada").val();
		$.ajax({
			url: urlj+'inventario/mantenimiento/caracteristicasxtipoarticulo',
			type: 'POST',
			dataType: 'json',
			data: {
				marca: marca,
				codigo: corre,
				categoria: categ
			},
			success:function(data){
				$("#tipo_caracteristica option").removeAttr("selected");
    			$("#tipo_caracteristica").select2();
				$("#tipo_caracteristica").html(data.drop);
				if (data.generado > 0) {
					$("#codigo").val(data.code_genera);
				} else {
					$("#codigo").val(data.categoria_cod + data.correlativo);
				}
				if($("#codigo").val() != ""){
					$('#codigo_error').text('');
					$('#codigo').removeClass('error');
				}
			}
		});
	}
	

	$("#categoria").live('change',function() {
		categoria = $("select[id='categoria']").last().val();
		menor=Number($(this).attr('nid'))+2;
		$(".dinamic").each(function(index, el) {
			if($(el).attr('nid')>menor){
				$(el).parent('div').siblings('label').remove();
				$(el).siblings('select').remove();
				$(el).parent('div').parent('div').parent('div').parent('div').remove();
				$(el).remove();
			}
		});
		$(".plus:last").remove();
		$(this).next().append('<button class="btn plus">+</button>');
		$('.dinamic').each(function(index, el) {
			$(this).attr('nid', index);
		});
		if(categoria != ""){
			categoria_tia = $("select[id='categoria']").last().val();
			$('#categoria_seleccionada').val(categoria_tia);
			codigo_producto();///////////categoria			
		} else{
			var last_cat = "";
			$('.dinamic').each(function(index, el) {
				if($(this).val() != "" ){
					last_cat = $(this).val();
					//console.log($(this).val());
				}
			});
			if(last_cat != ""){
	        	$('#categoria_seleccionada').val(last_cat);
				codigo_producto();/////last_cat
	        } else{
	        	$('#categoria_seleccionada').val("");
	        	$('#codigo').val("");
	        	codigo_producto();
	        }
		}		
    });

	$(".plus").live('click',function(event) {
	    event.preventDefault();
	    categoria_tia = $("select[id='categoria']").last().val();
	    $.ajax({
	        dataType: 'json',
	        type: 'POST',
	        url: urlj+'inventario/gestion_productos/obtener_productos_tia',
	        data: {categoria:categoria_tia},
	        success: function(data){
	            categoria=data.categoria;
	            //producto=data.producto;
	            n_cat=data.cat_hijo;

	            $i=0;
	            $(".plus").last().remove();
	            if(n_cat == 1){
	                numero = $('#div-categorias select').last().length + 1;

	                linea = $("#div-categorias").append('<div class="form-row row-fluid">'
	                    +'<div class="span12">'
	                    +'<div class="row-fluid">'
	                    +'<label class="form-label span3">Categoría:</label>'
	                    +'<div class="span9 controls">'
	                    +'<select id="categoria" class="nostyle seleccion dinamic" name="filtro" style="width:100%" placeholder="Seleccione"></select>'
	                    +'</div></div></div></div>'); 
	                linea2 = $('select[id="categoria"]').last().html(); 
	                nueva = linea2.replace(/#/g, numero);
	                $('#div-categorias').append(nueva);
	                $('select[id="categoria"]').last().html(categoria);
	                $('select[id="categoria"]').last().select2();
	               //$("#producto_art").html(producto);
	            }else{
	                //$("#producto_art").html(producto);
	                $.pnotify({
	                    type: 'info',
	                    title: 'Aviso',
	                    text: 'No se encontraron más dependencias.',
	                    icon: 'ui-icon ui-icon-info',
	                    opacity: 0.95,
	                    history: false,
	                    sticker: false
	                });
	            }

	            $('.dinamic').each(function(index, el) {
	                $(this).attr('nid', index);
	            });
	        }
	    });
	});

	$(".verAnexo").fancybox({
		width:800,
        height:800,
        autoSize : false,
      	openEffect  : 'elastic',
      	closeEffect : 'elastic',
      	href: $(this).attr('href'),
      	type: 'iframe',
      	helpers : {
        	title : {
        		type : 'inside'
        	}
        }
    });

	//Remueve el option Sin registros
	$(".seleccion").each(function(){
		if($(this).children().eq(1).text() == "Sin Registros"){
			$(this).children().eq(1).remove();
		}
	})

	$("#slcMarca").live('change',function() {
		// codigo_producto();  /* TEMPORALMENTE.... VALIDAR SI DEBE HACERLO O NO*/
	});

	//deshabilita el select de caracteristicas cuando existen registros en la tabla cma
	var caract_tr = $("#add_caracteristica_produc").find("tr").length;
	if(caract_tr > 0 && $("#edit_caracteristica").val() == 1){
		$("#categoria").select2("disable");
	}
	//muestra una alerta de que debe eliminar los registros antes de poder agregar otra caracteristica
	if(caract_tr > 0 && $("#edit_caracteristica").val() == 1){
		$.pnotify({
            type: 'info',
            title: 'Alerta',
            text: 'Si desea modificar la categoría del producto debe eliminar las características',
            icon: 'picon icon16 brocco-icon-info white',
            opacity: 0.95,
            history: false,
            sticker: false
        });
	}
	//valida los campos requeridos del form nuevo articulo
	$("#frm-nuevo_articulo").validate({
		ignore:"",
		rules: {
			categoria:{ required:true,min:1},
			tipo_producto:{ required:true,min:0},
			nombre: { required:true},
			codigo: { required:true}
		}, 
		
		ignore: ".select2-container",
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			//$('#'+nombre+'_error').html(error);
			$('#'+nombre+'_error').text('Campo requerido');
		},
		submitHandler: function(form) {			
			
			if ($("#combo").is(':checked') && $("#list_serviproduc tr").length == 0) {
				$( "#pes-combos" ).trigger( "click" );
				crear_alerta('error','Alerta','Debe agregar almenos una agrupación.');
				return false;
			 };
			 	
			form.submit();
		}
	});
	//valida los campos requeridos del form editar articulo
	$("#frm-editar_articulo").validate({
		ignore:"",
		rules: {
			categoria:{ required:true,min:1},
			tipo_producto:{ required:true,min:0},
			estado:{ required:true,min:0},
			nombre: { required:true},
			codigo: { required:true}
		}, 
		
		ignore: ".select2-container",
		errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			//$('#'+nombre+'_error').html(error);
			$('#'+nombre+'_error').text('Campo requerido');
		},
		submitHandler: function(form) {			
			//$('.slcedit').select2('enable');

			if ($("#combo").is(':checked') && $("#list_serviproduc tr").length == 0) {
				$( "#pes-combos" ).trigger( "click" );
				crear_alerta('error','Alerta','Debe agregar almenos una agrupación.');
				return false;
			 };
			 
			form.submit();
		}
	});

	//filtra producto/servicios tab 4
	$('#tipo_general_combo').change(function(event) {
		tipo_combo = $(this).val();
		categoria = $("#categoria_datos_combo").val();
		filtro_articulo_combo(tipo_combo, categoria);
	});
	$('#categoria_datos_combo').change(function(event) {
		tipo_combo = $("#tipo_general_combo").val();
		categoria = $(this).val();
		filtro_articulo_combo(tipo_combo, categoria);
	});

	//filtra el combo de la tab 4 para cuando se cambie el tiop o la categoria cambie
	function filtro_articulo_combo(tipo,categoria){
		$.ajax({
			url: urlj+'inventario/mantenimiento/articulo_tipoxcategoria',
			type: 'POST',
			dataType: 'json',
			data: {categoria: categoria,tipo: tipo},
			success:function(data){
				$("#producto_datos_combo option").removeAttr("selected");
    			$("#producto_datos_combo").select2();
				$("#producto_datos_combo").html(data.drop);
			}
		});
	}
	//cambia los label de la tab2,3,4
	$('#nombre').keyup(function(){
		$('#conversiones_arti, #conversiones_confi, .lbl_product_name, .lbl_nombre_producto').text($(this).val()); //,#conversiones_combo
	});
	//cambia el label la tab 2 para mostrar la medida
	$('#medida_conversion').change(function(){
	    var medida_conversion_select = $("#medida_conversion option:selected").text();
	    if (medida_defecto == "") {
    		medida_defecto = medida_conversion_select;
	    }
		//$("#unidad_conversion").text(medida_defecto);
		//$("#unidad_conversion").text($('#medida_conversion option:selected').text());
	});

	/*
		valida las tabs
		regresar = 1 para validar envio del formulario
		regresar = 2 para validar al dar siguiente
	*/
	function validar_tabs(regresar){
		if($('#nombre').val() == '' || $('#nombre').val() == '' || $('#codigo').val() == '' || $('#tipo_producto').val() == '' || $('#estado').val() == ''){
			validar_conversion(2);
			if(regresar==1){
				$("#pes-general").addClass("clasecss");
				if($("#edit_caracteristica").val() == 1){
					$("#frm-editar_articulo").valid();
				} else{
					$("#frm-nuevo_articulo").valid();
				}
				$("#pes-general").trigger('click');
				return true;
			}
			if(regresar==2){
				$("#pes-general").addClass("clasecss");
				if($("#edit_caracteristica").val() == 1){
					$("#frm-editar_articulo").valid();
				} else{
					$("#frm-nuevo_articulo").valid();
					if($('#codigo').val() != ''){
						$('#codigo_error').text('');
					}
				}
				$("#toTopHover").trigger("click");
				return true;
			}
		} else{
			$("#pes-general").removeClass("clasecss");
			validar_conversion(2);
		}
	}
	//cambia el valor de redireccionar para guardar o guardar y  volver a la lista
	$('#agregar_articulo').live('click',function(event){
		$("#redireccion").val(0);
	})
	$('#agregar_articulo_volver').live('click',function(event){
		$("#redireccion").val(1);
	})
	//envia el formulario
	$('.enviar_formulario').live('click',function(event){
		val_codigo();
		if(validar_tabs(1)){
			validar_conversion(0);
		} else{
			validar_conversion(1);
		}
	})
	/*
		valida si en las conversiones no hay un valor por defecto
		opc = 0 para verificar si hay uno por defecto y agrega la clase a la pestaña
		opc = 1 para verificar y hacer focus a la tab y mostrar un mensaje
		opc != n para verificar cuando se cambia de tab y quita la clase de la pestaña
	*/
	function validar_conversion(opc){
		var conversion_tr = $("#add_conversion_list").find("tr").length;
		
		var defecto = 0;
		$(".defect").each(function(){
			if($(this).attr("value") == 1){
				defecto = 1;
				// console.log($(this));
			}
		})
		if(opc == 1){
			if(conversion_tr != 0){
				if(defecto == 1){
					if($("#edit_caracteristica").val() == 1){
						$("#frm-editar_articulo").submit();
					} else{
						$("#frm-nuevo_articulo").submit();
					}
				} else{
					$("#pes-conversiones").addClass("clasecss");
					$("#pes-conversiones").trigger("click");
					$.pnotify({
	                    type: 'info',
	                    title: 'Alerta',
	                    text: 'Debe existir una conversión por defecto',
	                    icon: 'picon icon16 brocco-icon-info white',
	                    opacity: 0.95,
	                    history: false,
	                    sticker: false
	                });
				}
			} else{
				$("#pes-conversiones").addClass("clasecss");
				$("#pes-conversiones").trigger("click");
				$.pnotify({
                    type: 'info',
                    title: 'Alerta',
                    text: 'Debe existir una conversión',
                    icon: 'picon icon16 brocco-icon-info white',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
			}
			
		} else if(opc == 0){
			if(defecto != 1){
				$("#pes-conversiones").addClass("clasecss");
			}
		} else if(opc == 3){
			if(conversion_tr == 0){
				$("#pes-conversiones").addClass("clasecss");
				$("#pes-conversiones").trigger("click");
				$.pnotify({
                    type: 'info',
                    title: 'Alerta',
                    text: 'Debe existir una conversión',
                    icon: 'picon icon16 brocco-icon-info white',
                    opacity: 0.95,
                    history: false,
                    sticker: false
                });
                return false;
			} else{
				if(defecto != 1){
					$("#pes-conversiones").addClass("clasecss");
					$.pnotify({
	                    type: 'info',
	                    title: 'Alerta',
	                    text: 'Debe existir una conversión por defecto',
	                    icon: 'picon icon16 brocco-icon-info white',
	                    opacity: 0.95,
	                    history: false,
	                    sticker: false
	                });
	                return false;
				}
			}
		}else{
			if(defecto == 1 && conversion_tr != 0){
				$("#pes-conversiones").removeClass("clasecss");
			} else{

			}
			// console.log(conversion_tr);
		}
	}

	//valida al cambiar de tab para quitar la clase a la pestaña y muestra una alerta en editar para recordarle que debe eliminar las caracteristicas
	$('#mytab a').click(function(){
		var caract_tr = $("#add_caracteristica_produc").find("tr").length;
		if($(this).attr("id") == "pes-general" ){
			if(caract_tr > 0 && $("#edit_caracteristica").val() == 1){
				crear_alerta("info","Alerta","Si desea modificar la categoría del producto debe eliminar las características");
			}
		}
	    validar_tabs(0);
	})

	//botones para regresar de tab
	$(".pasar-anterior").click(function(){
		var numero_tab = $(this).attr("id").split("-");
		switch(numero_tab[1]){
			case "1":
				$("#pes-general").trigger('click');
		        break;
		    case "2":
		    	$("#pes-conversiones").trigger('click');
		        break;
	       	case "3":
	       		$("#pes-configuracion").trigger('click');
		        break;
		}
	});
	//botones para siguiente
	$(".pasar-siguiente").click(function(){
		var numero_tab = $(this).attr("id").split("-");
		switch(numero_tab[1]){
			case "2":
				if(!(validar_tabs(2))){
					$("#pes-conversiones").trigger('click');
				}
		        break;
		    case "3":
		    	if(validar_conversion(3) != false){
		    		$("#pes-configuracion").trigger('click');
		    	}
		        break;
	       	case "4":
	       		$("#pes-combos").trigger('click');
		        break;
		}
	});

	//agrega a la grid de caracteristicas de la tab 1
	$('#add_caracteristica').live('click',function(event){
	    event.preventDefault();
	    //var prod = $(this).data('prod');
	    //console.log(prod);
	    var cantidad_tr = $("#add_caracteristica_produc").find("tr").length;//longitud de la tabla con los datos
	    var tipo_caracteristica = $("#tipo_caracteristica").val().trim();//id de la caracteristica
	    var tipo_caracteristica_select = $("#tipo_caracteristica option:selected").text();//texto  de la caracteristica seleccionada
	    //var nombre_caracteristica = $(".valorprin option:selected").text();
	    /*************************************************************************/
	    var nombre_caracteristica = '';
	    var ticar = $('.valorprin_').attr('id');
	    // console.log('ticar: ' + ticar);
	    switch(ticar) {
	        case '1'://Lista multiple		        	
	        	//nombre_caracteristica = $(".valorprin").val();
	        	$('.valorprin_ :selected').each(function (i, selected) {
	        		if(i==0){
	        			nombre_caracteristica = nombre_caracteristica + $(selected).text();	
	        		}else{
	        			nombre_caracteristica = nombre_caracteristica + "," + $(selected).text();	
	        		}		            
		            //porcentaje = porcentaje + $(selected).data("valor");
		            //porcentaje_tabla = porcentaje_tabla + $(selected).data("valor") + ",";
		            //cantidad_seleccionados++;
		        });	        		        	
	            break;
	        case '2'://Lista desplegable	        	
	        	nombre_caracteristica = $('.valorprin_ option:selected').text();
	            break;
	        case '3'://Numerico
	        	nombre_caracteristica = $('.valorprin_').val();
	        	nombre_caracteristica = numberWithCommas(nombre_caracteristica);
	            break;
	        case '4'://Decimal   
	        	nombre_caracteristica = $('.valorprin_').val();
	        	nombre_caracteristica = numberWithCommas(nombre_caracteristica);
	            break;
	        case '5'://Texto    
	        	nombre_caracteristica = $('.valorprin_').val();
	        	//nombre_caracteristica = numberWithCommas(nombre_caracteristica);
	            break;
	        case '6'://Checbox
	        	if($('.valorprin_').is(':checked'))
	        	    nombre_caracteristica = 'Si';  // checked
	        	else
	        	    nombre_caracteristica = 'No';  // unchecked	        	
	            break;
            // Opcion por defecto que viene del controlador
	        case '9':
                // console.log("has entrado aqui");
                texto = $('.valorprin_').val();
                nombre_caracteristica = numberWithCommas(texto);
                break;
	            
	    }
	    $('#element_').html('<input type="text" value="" class="valorprin valorCaracteristica" readonly>');
	    /*************************************************************************/	    
	    //variables para el mensaje
	    var mensaje = "";
	    var type_msg = "";
	    // console.log('tipo car: ' + tipo_caracteristica);
	    // console.log('nombre: ' + nombre_caracteristica);
	    if (tipo_caracteristica != "") {
	    //if (tipo_caracteristica != "" && nombre_caracteristica != "") {
	      type_msg = "error";
	      if( ($("#tipo_caracteristica"+tipo_caracteristica).length <= 0) && ($("#nombre_caracteristica"+tipo_caracteristica).length <= 0) ){
	      	i++;
	        if(cantidad_tr >= 1 && $("#contadorcaract").val() != cantidad_tr){
	          	$("#contadorcaract").val((cantidad_tr + 1));
	          	i = cantidad_tr + 1;
	        }
	        id_correlativo = $("#contadorcaract").val(); //crear un id unico para anexos de documentos
	        id_tipo_caracteristica =  '<input type="hidden" id="tipo_caracteristica'+tipo_caracteristica+'" name="tipo_caracteristica[]" value="'+tipo_caracteristica+'" />';
	        id_nombre_caracteristica = '<textarea style="display : none;" id="nombre_caracteristica'+tipo_caracteristica+nombre_caracteristica+'" name="nombre_caracteristica[]">'+ nombre_caracteristica +'</textarea>';
	        eliminar = '<a id="del_doc" valor="'+i+'" thead="titleCarac_prod" tbody="add_caracteristica_produc" class="btn btn-danger btn-mini minia-icon-trashcan white"> Eliminar</a>';
	        editar = '<a id="editar_'+i+'" data-ticar="'+ticar+'" data-carac="'+tipo_caracteristica+'" valor="'+i+'" data-previo="'+nombre_caracteristica+'" class="btn btn-info btn-mini minia-icon-pencil white edit_doc" data-new="1"> Editar</a>';
	        guardar = '<a id="guardar_'+i+'" data-ticar="'+ticar+'" data-carac="'+tipo_caracteristica+'" valor="'+i+'" data-previo="'+nombre_caracteristica+'" class="btn btn-info btn-mini minia-icon-checkmark white guardar_doc" style="display: none;"> Guardar</a>';
	        if($("#edit_caracteristica").val() == 1){
	        	$("#categoria").select2("disable");
	        	eliminar = '<a id="del_doc_carac" valor="'+id_correlativo+'" thead="titleCarac_prod" tbody="add_caracteristica_produc" class="btn btn-danger btn-mini minia-icon-trashcan white"> Eliminar</a>';
	        }
	        $("#add_caracteristica_produc").append(
	                        '<tr id="filatitleCarac_prod'+i+'" >' +
	                            '<td>'+ id_tipo_caracteristica + tipo_caracteristica_select + '</td>'+
	                            '<td id="info_'+i+'">'+ id_nombre_caracteristica + nombre_caracteristica.replace(/\n/g, "<br />") + '</td>' +
	                            '<td style="text-align:center;">' + editar + guardar + ' ' + eliminar+'</td>'+
	                        '</tr>');
	        $("#titleCarac_prod").fadeIn(300);
	        var NC = parseInt($("#contadorcaract").val()) + 1;
	        $("#contadorcaract").val(NC);

	        $("#tipo_caracteristica option").removeAttr("selected");
	        $("#tipo_caracteristica").select2();

	        $("#nombre_caracteristica").val('');

	        
	        $("#tipo_caracteristica_error").text('');
	        $("#nombre_caracteristica_error").text('');

	      } else{
	        mensaje = "El detalle ya ha sido agregado";
	      }
	      $('#element').html('');
	    } else{
	      type_msg = "error";
	      mensaje = "Los campos con * requeridos";
	      if (tipo_caracteristica == "") {
	      //if (tipo_caracteristica == "" && nombre_caracteristica == "") {
	      	$("#tipo_caracteristica_error").text('Campo requerido');
	        $("#nombre_caracteristica_error").text('Campo requerido');
	      } else if(tipo_caracteristica == ""){
	      	mensaje = "Descripción requerida";
	      	$("#tipo_caracteristica_error").text('Campo requerido');
	      	if(nombre_caracteristica == ""){$("#tipo_caracteristica_error").text('Campo requerido');}
	      } else if(nombre_caracteristica == ""){
	      	mensaje = "Nombre requerido";
	      	$("#nombre_caracteristica_error").text('Campo requerido');
	      	if(tipo_caracteristica == ""){$("#tipo_caracteristica_error").text('Campo requerido');}
	      }
	    }
	    if(mensaje != ""){
	        $.pnotify({
	            type: type_msg,
	            title: 'Informaci&oacute;n',
	            text: mensaje,
	            icon: 'ui-icon ui-icon-info',
	            opacity: 0.95,
	            history: false,
	            sticker: false
	        });
	    }
	});

	function validarConversionListaDefecto() {
		let tbodylist = document.getElementById('add_conversion_list');
	}


	function comprobarDefectoEnLista(){
		let table_list = document.getElementById('add_conversion_list').querySelectorAll('tr');
		let object_defecto = false;
		for (let i = 0; i < table_list.length; i++) {
			let obj = { name: table_list[i].children[0].innerText, value_defecto: table_list[i].children[2].children[0].value };
			if (object_defecto == false && obj.value_defecto == 1) {
				object_defecto = obj;
			}
		}
		return object_defecto;
	}

	function medida_defecto_set() {
		setTimeout(function(){ 
		    let unidad_conversion_label = document.getElementById('unidad_conversion');
		    let medidadefecto = comprobarDefectoEnLista();
		    if (medidadefecto) {
	    		unidad_conversion_label.innerText = medidadefecto.name;
		    }else{
	    		unidad_conversion_label.innerText = '';
		    }
		}, 500);
	}
	//agrega datos a la grid de conversiones de la tab 2
	$('#add_conversion').live('click',function(event){
		medida_defecto_set();
	    event.preventDefault();

	    var cantidad_tr = $("#add_conversion_list").find("tr").length;

	    var medida_conversion = $("#medida_conversion").val().trim();
	    var medida_conversion_select = $("#medida_conversion option:selected").text();

	    var unico_defecto = 0;
	    var defecto = 0;
	    var mostrardefecto = "NO";
	    if ($("#defecto").prop("checked")) defecto = 1;
	    if ($("#defecto").prop("checked")) mostrardefecto = "SI";

	    var conversion = $("#conversion").val();
	    //var equivalente = $("#equivalente").val();

	    //variables para el mensaje
	    var mensaje = "";
	    var type_msg = "";
	    if (medida_conversion != "" && conversion != "") {
	      type_msg = "error";
	      if(($("#medida_conversion"+medida_conversion).length <= 0)){
	      	if(defecto == 1){
	      		if(!($("#valordefecto"+defecto).length <= 0)){
	      			unico_defecto = 1;
	      		}
	      	}
	      	if(unico_defecto == 0){

	        	if(cantidad_tr >= 1 && $("#contadorconversion").val() != cantidad_tr){
		          $("#contadorconversion").val((cantidad_tr+1));
		        }
		        id_correlativo = $("#contadorconversion").val(); //crear un id unico para anexos de documentos
		        id_medida_conversion =  '<input type="hidden" id="medida_conversion'+medida_conversion+'" name="medida_conversion[]" value="'+medida_conversion+'" />';
		        id_valordefecto = '<input type="hidden" id="valordefecto'+defecto+'" name="defecto[]" value="'+defecto+'" class="defect" />';
		        id_conversion = '<input type="hidden" value="'+conversion+'" name="conversion[]" />';
		        //id_equivalente = '<input type="hidden" value="'+equivalente+'" name="equivalente[]" />';
		        eliminar = '<a id="del_doc" valor="'+id_correlativo+'" thead="titleconversion" tbody="add_conversion_list" class="btn btn-danger btn-mini minia-icon-trashcan white">Eliminar</a>';
		        $("#add_conversion_list").append(
		                        '<tr id="filatitleconversion'+id_correlativo+'" >' +
		                            '<td>'+ id_medida_conversion + medida_conversion_select + '</td>'+
		                            '<td>'+ id_conversion + conversion + '</td>' +
		                            '<td>'+ id_valordefecto + mostrardefecto + '</td>' +
		                            '<td style="text-align:center;">'+ eliminar+'</td>'+
		                        '</tr>');
		        $("#titleconversion").fadeIn(300);
		        var NC = parseInt($("#contadorconversion").val()) + 1;
		        $("#contadorconversion").val(NC);

		        $("#medida_conversion option").removeAttr("selected");
		        $("#medida_conversion").select2();
		        if(defecto == 1){
		        	$("#defecto").iButton('toggle');
		        	if($("#edit_caracteristica").val() == 1){
		        		$(".edit_defecto").iButton("disable");
		        	}
		        }
		        
		        $("#conversion").val('');
		        $("#equivalente").val('');

		        $("#unidad_conversion").text('');

		        $("#conversion_error").text('');
		        $("#medida_conversion_error").text('');
	        } else{
	        	mensaje = "Solo se permite una unidad por defecto";
	        }
	      } else{
	        mensaje = "El detalle ya ha sido agregado";
	      }
	    } else{
	      type_msg = "error";
	      mensaje = "Los campos con * requeridos";
	      if (medida_conversion == "" && conversion == "") {
	      	$("#conversion_error").text('Campo requerido');
	        $("#medida_conversion_error").text('Campo requerido');
	      } else if(medida_conversion == ""){
	      	mensaje = "Unidad de medida requerida";
	      	$("#medida_conversion_error").text('Campo requerido');
	      	if(conversion == ""){$("#conversion_error").text('Campo requerido');}
	      } else if(conversion == ""){
	      	mensaje = "Conversión requerida";
	      	$("#conversion_error").text('Campo requerido');
	      	if(medida_conversion == ""){$("#medida_conversion_error").text('Campo requerido');}
	      }
	      
	    }
	    if(mensaje != ""){
	        $.pnotify({
	            type: type_msg,
	            title: 'Informaci&oacute;n',
	            text: mensaje,
	            icon: 'ui-icon ui-icon-info',
	            opacity: 0.95,
	            history: false,
	            sticker: false
	        });
	    }
	});
	//agrega datos a la grid de combo de la tab 4
	$('#add_serviproduc').live('click',function(event){
	    event.preventDefault();

	    var cantidad_tr = $("#list_serviproduc").find("tr").length;

	    var producto_datos_combo = ($("#producto_datos_combo_ajax").val() > 0) ? $("#producto_datos_combo_ajax").val() : $("#producto_datos_combo").val();
	    var producto_datos_combo_select = ($("#producto_datos_combo_ajax").val() > 0)?$("#producto_datos_combo_ajax").closest('div').find('.select2-container span').text():$("#producto_datos_combo option:selected").text();

		var medida_datos_combo = ($("#medida_datos_combo").val() > 0) ? $("#medida_datos_combo").val() : '';
	    var medida_datos_combo_select = ($("#medida_datos_combo").val() > 0) ? $("#medida_datos_combo option:selected").text() : '';

	    var cantidad_datos_combo = $("#cantidad_datos_combo").val();

	    //variables para el mensaje
	    var mensaje = "";
	    var type_msg = "";
	    if (producto_datos_combo != "" && cantidad_datos_combo != "" && medida_datos_combo != "") {
	      	type_msg = "error";
	      	if(($("#producto_datos_combo"+producto_datos_combo).length <= 0)){

        		if(cantidad_tr >= 1 && $("#contadorserviproduc").val() != cantidad_tr){
	          		$("#contadorserviproduc").val((cantidad_tr+1));
	        	}

	        	id_correlativo = $("#contadorserviproduc").val(); //crear un id unico para anexos de documentos
	        	id_producto_datos_combo =  '<input type="hidden" id="producto_datos_combo'+producto_datos_combo+'" name="producto_datos_combo[]" value="'+producto_datos_combo+'" />';
	        	id_medida_datos_combo = '<input type="hidden" name="medida_datos_combo[]" value="'+medida_datos_combo+'" />';
	        	id_cantidad_datos_combo = '<input type="hidden" name="cantidad_datos_combo[]" value="'+cantidad_datos_combo+'" />';
	        	eliminar = '<a id="del_doc" valor="'+id_correlativo+'" thead="titleservi_pro" tbody="list_serviproduc" class="btn btn-danger btn-mini minia-icon-trashcan white">Eliminar</a>';
	        	$("#list_serviproduc").append(
	                        '<tr id="filatitleservi_pro'+id_correlativo+'" >' +
	                            '<td>'+ id_producto_datos_combo + producto_datos_combo_select + '</td>'+
	                            '<td>'+ id_medida_datos_combo + medida_datos_combo_select + '</td>'+
	                            '<td>'+ id_cantidad_datos_combo + cantidad_datos_combo + '</td>' +
	                            '<td>'+ eliminar+'</td>'+
	                        '</tr>');
	        	$("#titleservi_pro").fadeIn(300);
	        	var NC = parseInt($("#contadorserviproduc").val()) + 1;
	        	$("#contadorserviproduc").val(NC);

	        	if($("#producto_datos_combo_ajax").val() > 0){
	        		$("#producto_datos_combo_ajax").select2("val", "");
	        	} else{
		        	$("#producto_datos_combo option").removeAttr("selected");
		        	$("#producto_datos_combo").select2();
	        	}

		        $("#medida_datos_combo").html('<option value=""></option>');
		        $("#medida_datos_combo").select2();
		        
		        $("#cantidad_datos_combo").val('');

		        $("#producto_datos_combo_error").text('');
		        $("#cantidad_datos_combo_error").text('');
	      	} else{
	        	mensaje = "El detalle ya ha sido agregado";
      		}
	    } else{
	      	type_msg = "error";
	      	mensaje = "Los campos con * requeridos";
	      	if (producto_datos_combo == "" && cantidad_datos_combo == "" && medida_datos_combo == "") {
	      		$("#producto_datos_combo_error").text('Campo requerido');
	        	$("#cantidad_datos_combo_error").text('Campo requerido');
	        	$("#medida_datos_combo_error").text('Campo requerido');
	      	} else if(producto_datos_combo == ""){
	      		mensaje = "El articulo es requerido";
	      		$("#producto_datos_combo_error").text('Campo requerido');
	      		if($cantidad_datos_combo == ""){$("#cantidad_datos_combo_error").text('Campo requerido');}
	      		if(medida_datos_combo == ""){$("#medida_datos_combo_error").text('Campo requerido');}

	      	} else if(medida_datos_combo == ""){
	      		mensaje = "La cantidad es requerido";
	      		$("#medida_datos_combo_error").text('Campo requerido');
	      		if($cantidad_datos_combo == ""){$("#cantidad_datos_combo_error").text('Campo requerido');}
	      		if(producto_datos_combo == ""){$("#producto_datos_combo_error").text('Campo requerido');}

	      	} else if(cantidad_datos_combo == ""){
	      		mensaje = "La cantidad es requerido";
	      		$("#cantidad_datos_combo_error").text('Campo requerido');
	      		if(producto_datos_combo == ""){$("#producto_datos_combo_error").text('Campo requerido');}
	      		if(medida_datos_combo == ""){$("#medida_datos_combo_error").text('Campo requerido');}
	      	}
	    }
	    if(mensaje != ""){
	        $.pnotify({
	            type: type_msg,
	            title: 'Informaci&oacute;n',
	            text: mensaje,
	            icon: 'ui-icon ui-icon-info',
	            opacity: 0.95,
	            history: false,
	            sticker: false
	        });
	    }
	});
	
	//Al cambiar los controles Ibutton de la tab conversiones, cambia el valor de input hidden para validar que solo 1 sea defecto
	$(".edit_defecto").change(function(){
		var id = $(this).attr("id");
		var defecto_statico = 0;
		if(id == "valordefecto1"){
			$(this).attr("id","valordefecto0");
			$(this).parent().next().val("0")
		} else{
			$(".edit_defecto").each(function(){
				if($(this).val() != 1){
					if($(this).attr("id") == "valordefecto1"){
						$(this).iButton('toggle');
					}
					$(this).attr("id","valordefecto0");
				} else{
					defecto_statico = 1;
				}
			})
			if(defecto_statico == 0){
				$(this).attr("id","valordefecto1");
				$(this).parent().next().val("1")
			}
		}
	})

	//Elimina la fila 
	$('#del_doc').live('click',function(event){
		medida_defecto_set();
	    event.preventDefault();
	    //obtenemos los valores del boton de eliminar para eliminar la fila
	    var id_fila = $(this).attr("valor");
	    var id_head = $(this).attr("thead");
	    var id_body = $(this).attr("tbody");
	    if($("#edit_caracteristica").val() == 1){
	    	if(id_body == "add_conversion_list"){
	    		if($("#fila" + id_head + id_fila).find("#valordefecto1").val() == 1){
	    			$(".edit_defecto").iButton("disable");
	    		}
	    		$("#fila" + id_head + id_fila).remove();
	    	} else{
	    		$("#fila" + id_head + id_fila).remove();
	    	}
	    } else{
	    	$("#fila" + id_head + id_fila).remove();
	    }
	});
	
	$('.edit_doc').live('click',function(event){
	    event.preventDefault();
	    var id_fila = $(this).attr("valor");
	    var tipo_carac = $(this).data("carac");
	    var previo = $(this).data("previo");
	    var es_nvo = $(this).data("new");
	    var articulo = ($("#articulo_id").length > 0) ? $('#articulo_id').val() : 0;
	    var url = (es_nvo > 0) ? 'get_tipocaracteristica' : 'get_caracteristicas_edit';
		$.ajax({
			url: urlj+'inventario/agregar_articulos/'+url,
			type: 'POST',
			dataType: 'json',
			data: {
				cxr_id: tipo_carac,
				id_art: articulo
			},
			success: function(data){
				console.log(data);
				if (data.tipo == 1 || data.tipo == 2) {
					var div = '<div id="element" class="span12 controls" >'+data.tag+'</div>';
					$('#info_'+id_fila).html(div);
					$('#info_'+id_fila+' .lista').select2({placeholder: 'Seleccione'});
				} else {
					$('#info_'+id_fila).html(data.tag);
				}
				if(data.tipo == 6){
					$("#6").iButton('repaint');	
				}				
			}
		});
		$('#guardar_'+id_fila).show();
	    $('#editar_'+id_fila).hide();
	});

	$('.guardar_doc').live('click',function(event){
		var id_fila = $(this).attr("valor");
	    var tipo_input = $(this).data("ticar");
	    var tipo_carac = $(this).data("carac");
	    var nombre_caracteristica = '';
	    var dato =  $(this).closest('tr').find('td .valorCaracteristica').val();
	    if ($.trim(dato) == '') {
	    	var previo = $(this).data("previo");
	    	nombre_caracteristica = previo;
	    } else {
	    	switch(tipo_input) {
	        	case 1://Lista multiple		        	
	        		$('#info_'+id_fila+' .valorCaracteristica :selected').each(function (i, selected) {
	        			nombre_caracteristica += (i==0) ? $(selected).text() : "," + $(selected).text();
	        		});	        		        	
	        		break;
	        	case 2://Lista desplegable	        	
	        		nombre_caracteristica = $('#info_'+id_fila+' .valorCaracteristica option:selected').text();
	        		break;
	        	case 3://Numerico
	        		nombre_caracteristica = $('#info_'+id_fila+' .valorCaracteristica').val();
	        		nombre_caracteristica = numberWithCommas(nombre_caracteristica);
	        		break;
	        	case 4://Decimal   
	        		nombre_caracteristica = $('#info_'+id_fila+' .valorCaracteristica').val();
	        		nombre_caracteristica = numberWithCommas(nombre_caracteristica);
	        		break;
	        	case 5://Texto    
		        	nombre_caracteristica = $('#info_'+id_fila+' .valorCaracteristica').val();
		        	break;
	        	case 6://Checbox
	        		nombre_caracteristica = ($('.valorCaracteristica').is(':checked')) ? 'Si' : 'No';
	        		break;
	        	default:
                	texto = $('#info_'+id_fila+' .valorCaracteristica').val();
                	nombre_caracteristica = numberWithCommas(texto);
                	break;
			}
	    }
		$('#info_'+id_fila).html('<textarea style="display: none;" id="nombre_caracteristica'+tipo_carac+nombre_caracteristica+'" name="nombre_caracteristica[]">'+ nombre_caracteristica +'</textarea>' + nombre_caracteristica.replace(/\n/g, "<br />"));
		$('#guardar_'+id_fila).hide();
	    $('#editar_'+id_fila).show();

	});
	

	//elimina las caracteristicas y habilita el boton para cambiar categorias
	$('#del_doc_carac').live('click',function(event){
	    event.preventDefault();
	    //obtenemos los valores del boton de eliminar para eliminar la fila
	    var id_fila = $(this).attr("valor");
	    var id_head = $(this).attr("thead");
	    var id_body = $(this).attr("tbody");
	    $("#fila" + id_head + id_fila).remove();
	    if($('#'+id_body).find('tr').length == 0 ){
	        $("#"+id_head).css('display','none');
	        $("#categoria").select2("enable");
	    }
	});
	//valida que el maximo no sea menor al minimo
	$("#minimo").change(function(){
		var maximo = $("#maximo").val();
                var minimo = $(this).val();
		if(minimo != ""){
                    maximo = parseFloat(maximo);
                    minimo = parseFloat(minimo);
			if(minimo >= maximo){
				$(this).val("");
                                crear_alerta("info","Alerta","El mínimo debe ser menor que el máximo");
				
			}
		}
	});
        
	$("#maximo").change(function(){
		var minimo= $("#minimo").val();
                var maximo  = $(this).val();
		if(maximo != ""){
                    maximo = parseFloat(maximo);
                    minimo = parseFloat(minimo);
			if(maximo <= minimo){
				$(this).val("");
				crear_alerta("info","Alerta","El máximo debe ser mayor que el mínimo");
			}
		}
	});

	// Agrega datos a la grid de comisiones de la tab 5
	$('#add_comision').live('click',function(event){
	    event.preventDefault();

	    var tipo_pago = $("#tipo_pago").val();
	    var comision = $("#tipo_comision").val();
	    var desde = $("#desde").val();
	    var hasta = $("#hasta").val();

	    texttp=$('#tipo_pago option:selected').text();
		textcomision=$('#tipo_comision option:selected').text();

	    // Variables para el mensaje
	    if(($("#medida_conversion"+medida_conversion).length <= 0)){

		    correlativo = $("#contadorcomision").val(); 
		    id_tipo_pago =  '<input type="hidden" id="tipo_pago'+tipo_pago+'" name="tipo_pago[]" value="'+medida_conversion+'" />';
		    id_comision = '<input type="hidden" id="comision'+defecto+'" name="comision[]" value="'+comision+'" class="defect" />';
		    desde = '<input type="hidden" value="'+desde+'" name="desde[]" />';
		    hasta = '<input type="hidden" value="'+hasta+'" name="hasta[]" />';
		    eliminar = '<a id="del_doc" valor="'+correlativo+'" thead="titlecomision" tbody="add_comision_list" class="btn btn-danger btn-mini minia-icon-trashcan white">Eliminar</a>';

		        $("#add_comision_list").append(
		            '<tr id="medida_conversion'+correlativo+'" >' +
		                '<td>'+ id_tipo_pago + texttp + '</td>'+
		                '<td>'+ id_comision + comision + '</td>' +
		                '<td>'+ desde + desde + '</td>' +
		                '<td>'+ hasta + hasta + '</td>' +
		                '<td style="text-align:center;">'+ eliminar+'</td>'+
		            '</tr>');

		        $("#titleconversion").fadeIn(300);
		        var cont = parseInt($("#contadorcomision").val()) + 1;
		        $("#contadorcomision").val(cont);

		        $("#tipo_comision option").removeAttr("selected");
		        $("#tipo_pago option").removeAttr("selected");

		        $("#tipo_comision").select2();
		        $("#desde").val('');
		        $("#hasta").val('');
	        } else{
	        	mensaje = "Solo se permite una unidad por defecto";
	        }	     
	  
	});
	// End comisiones

	//si el ibutton esta deshabilitado bloquea los controles de la pestaña de combo
	if(!$("#combo").prop("checked")){
		$("#agrupacion_general_combo, #tipo_general_combo, #categoria_datos_combo, #producto_datos_combo").select2("disable");
		$("#cantidad_datos_combo").attr("disabled","true");
    	$("#producto_datos_combo_ajax").select2('disable');
	}
	//al cambiar el ibutton de combo de la tab 1 habilita los controles de la pestaña combo
	$("#combo").change(function(){
		var valor = 0;
		if($("#combo").prop("checked")){valor = 1;}
		if(valor == 0){
			$("#prod_componente").iButton('disable');
			$("#agrupacion_general_combo, #tipo_general_combo, #categoria_datos_combo, #producto_datos_combo").select2("disable");
			$("#cantidad_datos_combo").attr("disabled","true");
			$("#producto_datos_combo_ajax").select2('disable');
		} else{
			//($("#prod_componente").prop("checked"))?1:0;
			$("#prod_componente").iButton('disable');
			$("#agrupacion_general_combo, #tipo_general_combo, #categoria_datos_combo, #producto_datos_combo").select2("enable");
			$("#cantidad_datos_combo").removeAttr("disabled");
			$("#producto_datos_combo_ajax").select2('enable');
		}
	})
	$("#prod_componente").change(function(){
		var valor = 0;
		if($("#prod_componente").prop("checked")){valor = 1;}
		if(valor == 0){
			$("#combo").iButton('disable');
		} else{
			$("#combo").iButton('disable');
		}
	})

	//Si el ibutton esta habilitado muestra 
	if($("#cuota").prop("checked")){
    	$("#cant_cuotas").slideDown('fast');
	}else{
		$("#txtCantidadCta").val('');
		$("#cant_cuotas").hide('fast');
	}

	// Al cambiar el ibutton cuota se muestra o se oculta el campo Cantidad de cuotas
	$("#cuota").change(function(){
		var valor = 0;
		if($("#cuota").prop("checked")){valor = 1;}

		if(valor == 0){
			$("#txtCantidadCta").val('');
			$("#cant_cuotas").hide('fast');
		} else{
			$("#cant_cuotas").slideDown('fast');
		}
	})


    $("#producto_datos_combo_ajax").change(function(){
    	var producto = $(this).val();
    	$.ajax({
			url: urlj+'inventario/mantenimiento/get_medida',
			type: 'POST',
			dataType: 'json',
			data: {producto: producto},
			success:function(data){
				console.log(data);
				$("#medida_datos_combo").html(data.productos);
				if(data.cantidad > 1){
					$("#medida_datos_combo").select2();
					$("#medida_datos_combo").select2('enable');
				} else{
					$("#medida_datos_combo").select2();
				}
				// $("#producto_datos_combo option").removeAttr("selected");
    // 			$("#producto_datos_combo").select2();
				// $("#producto_datos_combo").html(data.drop);
			}
		});

    })
	

	//////////////////////////////////////////////////
	//PARA SUBIR LA FOTO DEL INVENTARIO
	/////////////////////////////////////////////////
  	carpeta= $('#foto_add').attr('value');
  	var ruta=urlj+'personal/empleado/guardar_gral/'+carpeta;  
	new FUload('btn_foto_inventario',ruta, {
	  	start:function(file){
		    wait.start();
	  	},sucess:function(data){
	    	wait.close();
	    	if($.trim(data)!="") { 
		     	//obtener la extención
		     	a_exten= $.trim(data).split('.');
		     	exten = a_exten[(a_exten.length - 1)].toLowerCase();
		     	if(exten=='jpg' || exten=='jpeg' || exten=='png' ) { 
		    		$("#previews_foto").empty();
		    		var preview="<tr id='previewruta_foto_empleado' style='display:none;' class='preview_documento'>";
		    		preview += "<td>";
		    		preview += '<a class="fancybox-buttons" href="'+urlj+'assets/uploads/images/'+$.trim(data)+'">';
		    		preview += "<img id='img_pre' src='"+urlj+"assets/uploads/images/"+$.trim(data)+"' width='220' height='220' style='display:block;margin:0 auto 0 auto;' class='imagen_documento'>";
		    		preview += "</a><br />";
		    		preview += "<div style='background:#E1E7F0!important;width:10%!important;'><a class='eliminar_imagen_foto' custom='"+$.trim(data)+"' custom_id='ruta_foto_empleado'><span><img class='quitar_documento' src='"+urlj+"media/eliminar_documento.png"+"' title='Eliminar documento'></a></div>";
		    		preview += "<input type='hidden' name='foto_empleado' id='ruta_foto_empleado'  value='"+$.trim(data)+"' readonly><input class='titulo_documento' type='hidden' name='titulo_foto_empleado' value='"+$.trim(data).replace('.','_')+"'></td></tr>";
		   			$("#previews_foto").append(preview).show(300);
		    		$("#previewruta_foto_empleado").fadeIn(400);
		    		$(".fancybox-buttons").fancybox();
		    	}
		    	else {
		      		crear_alerta('error','Formato Incorrecto', 'El archivo es inválido');
		    	}
	    	}
	    	else { //el formato es incorrecto
	      		crear_alerta('error','Formato Incorrecto', 'El archivo es inválido');
	   		}
	  	}
  	});

	/*/$("#edit_imagen").submit( function (event) {
	  event.preventDefault();
	  url = urlj+"uatm/solucions/datos_imagen_gral";
	  valor_nombre = $("#nombre_i").val();
	  ruta = $("#ruta").val();
	  if(valor_nombre != "" && ruta!= ""){
	    $.ajax({
	      type: 'POST',
	      url: url,
	      data: $("#edit_imagen").serialize(),
	      success: function(data){
	        $.fancybox(data);
	      }
	    });
	  }else{
	    if(valor_nombre ==""){
	      $("#ingrese_nombre").html("<label style='color:red;'>Ingrese titulo de documento</label>");
	      $("#f").fadeIn(500);
	    }else{
	      $("#ingrese_nombre").fadeOut(500);
	    }
	    if(ruta ==""){
	      $("#ingrese_imagen").html("<label style='color:red;'>Ingrese un documento</label>");
	      $("#ingrese_imagen").fadeIn(500);
	    }else{
	      $("#ingrese_imagen").fadeOut(500);
	    }
	  }
	} );*/

	$(".eliminar_imagen").live("click", function(event){
	  	event.preventDefault(); 
	  	url= this.custom;
	  	id_key= this.custom_id;
	  	id= this.id;

	  	$.ajax({
	   		type: 'POST',
	    	url: urlj+'personal/empleado/eliminar_imagen_gral',
	    	data: {url:url},
	    	success: function(data){
	      		$("#ruta"+id_key).val("");
	      		$("#"+id).parent().parent().remove().delay(300);
	    	}
	  	});
	});

	///////////////////////////////
	//ELMINAR LA FOTO DEL EMPLEADO
	//////////////////////////////
	$(".eliminar_imagen_foto").live("click", function(event){
	  	event.preventDefault(); 
	  	url= this.custom;
	  	id_key= this.custom_id;
	  	id= this.id;

	  	$.ajax({
	    	type: 'POST',
	    	url: urlj+'personal/empleado/eliminar_imagen_gral',
	    	data: {url:url},
	    	success: function(data){
	      		$("#"+id_key).val("");
	      		$("#previews_foto").empty();
	     		// $("#"+id).parent().parent().remove().delay(300);
	    	}
	  	});
	});

	$('.titulo_documento').on('blur',function(event) {
	  	var nombre=$(this).val();
	  	if(nombre==''){
	    	create("note_error", {
		     	title:'Error.',
		      	text:'Debe proporcionar un nombre para el documento' }, {
		        expires: 6000
	      	});
	    	$(this).focus();
	  	}else{
	    	$(this).hide();
	    	var ocultar=$(this).attr('name');
	    	$('span[id='+ocultar+']').html(nombre);
	    	$('span[id='+ocultar+']').show();
	  	}
	});

	$('.editar_documento').click(function(event) {
	  	var mostrar=$(this).attr('value');
	  	$('span[id='+mostrar+']').hide();
	 	$('input[name='+mostrar+']').show();
	  	$('input[name='+mostrar+']').focus();
	});

	$(".fancybox-buttons").click(function(event){
	  	event.preventDefault(); 
	  	var url=$(this).attr('href');
	  	$.fancybox({
	    	'href': url,
	    	'height': '600',
	    	width  : '88%',
	    	type   :'iframe',
	    	closeBtn  : true
	  	});
	});

	//Cambio estado entre costo y gasto para agregar                                                             
	$('#prod_costo').prop('checked', true);
	$("#prod_costo").iButton("repaint");

	$("#prod_gasto").change(function(event){
		if($('#prod_gasto').prop('checked')){			
			$('#prod_costo').prop('checked', false);
			$("#prod_costo").iButton("repaint");			
		}else{
			$('#prod_costo').prop('checked', true);			
			$("#prod_costo").iButton("repaint");
		}		
	})

	$("#prod_costo").change(function(event){
		if($('#prod_costo').prop('checked')){			
			$('#prod_gasto').prop('checked', false);
			$("#prod_gasto").iButton("repaint")			
		}else{
			$('#prod_gasto').prop('checked', true);			
			$("#prod_gasto").iButton("repaint")
		}	
	})

	//Cambio estado entre costo y gasto para editar	
	$("#prod_gasto_edit").change(function(event){
		if($('#prod_gasto_edit').prop('checked')){			
			$('#prod_costo_edit').prop('checked', false);
			$("#prod_costo_edit").iButton("repaint");			
		}else{
			$('#prod_costo_edit').prop('checked', true);			
			$("#prod_costo_edit").iButton("repaint");
		}		
	})

	$("#prod_costo_edit").change(function(event){
		if($('#prod_costo_edit').prop('checked')){			
			$('#prod_gasto_edit').prop('checked', false);
			$("#prod_gasto_edit").iButton("repaint")			
		}else{
			$('#prod_gasto_edit').prop('checked', true);			
			$("#prod_gasto_edit").iButton("repaint")
		}	
	})

	$(document).on('change','#tipo_caracteristica',function(event){
		var cxr_id = $('#tipo_caracteristica').val();		
		var div = $(this).parent().next().children();
		
		$.ajax({
			url: urlj+'inventario/agregar_articulos/get_tipocaracteristica',
			async:true,
			type: 'POST',
			dataType: 'json',
			data: {cxr_id: cxr_id },
			success: function(data){
				console.log(data);
				$('#element').html(data.tag);
				if(data.tipo == 1 || data.tipo == 2){
					$(".valorprin_").select2();
				}
				if(data.tipo == 6){
					$("#6").removeAttr( "checked" );
		            $("#6").iButton('repaint');
					//$("#6").iButton("disable", true);
				}				
			}
		});
	})

	$('.slcedit').select2('disable');

	function numberWithCommas(x) {
	    return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
	}

	function numberRemoveCommas(x) {	    
	    a = x.replace(/\,/g,'');
	    a = parseInt(a,10);
		return a; 
	}

	$('#btnAgregarCodigo').click(function(event) {
		if ( $("#txtCodPrd").val().trim() !='' ) {
			var valor_codigo =  $("#txtCodPrd").val().trim();
			var code_limpio = valor_codigo.replace(/[\%\^\&\@\"\#\$\'\!]/g, '').replace(/\s+/g, '');
			if ($("#contenedor_detalle_codigo input[value='"+valor_codigo+"']").length > 0 ){
				crear_alerta('error', '* Código ya asignado.', '');
			} else {
				var tr_html;
				tr_html += "<tr><td align='center'><input value='"+code_limpio+"' type='hidden' name='ncodigo_producto[]'>" + code_limpio + "</td>";
				tr_html += '<td style="text-align: center;" ><a  class="btn btn-danger btn-mini minia-icon-trashcan white eliminar_cod"> Eliminar</a></td>';
				tr_html += '</tr>';
			
				/* VALIDAR CODIGO DE PRODUCTO*/
				url_ajax = window.satelite.base_url('inventario/mantenimiento/validar_codigo_producto');
				$.ajax({
					url: url_ajax,
					type: 'POST',
					dataType: 'json',
					data: {
						txtCodigo: code_limpio,
						txtIdProd: $("#txtIdProd").val()
					},
					beforeSend: function () {
						wait.start('validando código... Espere unos segundos');
					},
					error: function (xhr, status, error){
						exportarError(xhr.responseText);
						wait.close();
					},
					success: function (json) {
						if (json.exito == 1 ) { //el código ya existe
							crear_alerta('error', '* Código ingresado ya existe', '');
						} else {
							$("#contenedor_detalle_codigo").append(tr_html);
							$("#txtCodPrd").val('');
							if ($("#contenedor_detalle_codigo tr").length > 0 ) {
								$("#datagried_detalle_codigo").show();
							}
						}
						wait.close();
					}
				});
			}
		} else {
			crear_alerta('error', '* Código requerido', '');
		}
	});


	$('#btnAddCodeCompra').click(function(event) {
		event.preventDefault();
		var slcProveedor = $("#prvCodeCompra").val();
		var slcUniMedida = $("#mepCodeCompra").val();
		var valor_codigo = $("#txtCodPrdCompras").val().trim();
		if (valor_codigo != '' && slcUniMedida > 0 && slcProveedor > 0) {
			if ($("#contenedor_det_code_compra tr.p"+slcProveedor+"_m"+slcUniMedida+" input[value='"+valor_codigo+"']").length > 0){
				crear_alerta('error', 'Código ya ingresado.', '');
			} else {
				var nameMedida = $('#mepCodeCompra option:selected').text();
				var nameProveedor = $('#prvCodeCompra option:selected').text();
				var tr_html = '<tr class="p' + slcProveedor + '_m' + slcUniMedida + '">';
				tr_html += '<td><input value="' + slcProveedor + '" type="hidden" name="id_proveedor_compra[]">' + nameProveedor + '</td>';
				tr_html += '<td><input value="' + valor_codigo + '" type="hidden" name="code_producto_compra[]">' + valor_codigo + '</td>';
				tr_html += '<td><input value="' + slcUniMedida + '" type="hidden" name="id_medida_compra[]">' + nameMedida + '</td>';
				tr_html += '<td style="text-align: center;"><a class="btn btn-danger btn-mini minia-icon-trashcan white eliminar_codCompra"> Eliminar</a>';
				tr_html += '<input value="0" type="hidden" name="id_cpc[]"></td>';
				tr_html += '</tr>';			
				/* VALIDAR CODIGO DE PRODUCTO*/
				$.ajax({
					url: urlj + 'inventario/mantenimiento/valida_code_producto_compra',
					type: 'POST',
					dataType: 'json',
					data: {
						txtProv: slcProveedor,
						txtMedi: slcUniMedida,
						txtCodigo: valor_codigo,
						txtIdProd: 0
					},
					beforeSend: function () {
						wait.start('validando código... Espere unos segundos');
					},
					error: function (xhr, status, error){
						exportarError(xhr.responseText);
						wait.close();
					},
					success: function (json) {
						if (json.codigo == 1 ) { //el código ya existe
							crear_alerta('error', 'Código ingresado ya existe', '');
						} else {
							$("#contenedor_det_code_compra").append(tr_html);
							$("#txtCodPrdCompras").val('');
							$("#prvCodeCompra option").removeAttr("selected");
							$("#mepCodeCompra option").removeAttr("selected");
							$("#prvCodeCompra, #mepCodeCompra").select2();
							
						}
						wait.close();
					}
				});
			}
		} else {
			crear_alerta('error', 'Verifique los campos requeridos', '');
		}
	});

	$("body").on('click', '.eliminar_cod', function(event) {
		event.preventDefault();
		$(this).parent().parent().remove();
		if ($("#contenedor_detalle_codigo tr").length <= 0 ) {
			$("#datagried_detalle_codigo").hide();
		}
	});

	$("body").on('click', '.eliminar_codCompra', function(event) {
		event.preventDefault();
		$(this).parent().parent().remove();
	});

    $("#btnMinMax").on("click", function() {
    	$("#minimo_error, #maximo_error").text("");
        var bodega       = $("#txtbod_min_max").val();
        var bodega_text  = $("#txtbod_min_max option:selected").text();
        var minimo       = $("#minimo").val();
        var maximo       = $("#maximo").val();
        var cantidad_tr  = $("#contenedor_detalle_min_max").find("tr").length;
        var error        = 0;
        var html         = "";
        var repetido     = false;

        if (bodega == "") {
            $("#txtbod_min_max_error").text("Campo requerido");
            error = 1;
        }
        if (!(minimo > 0 || maximo > 0)) {
        	if (!minimo > 0) {
        		$("#minimo_error").text("Campo requerido");
        		error = 1;
        	}
        	if (!maximo > 0) {
        		$("#maximo_error").text("Campo requerido");
        		error = 1;
        	}
        }
        
        if (error > 0) {
            return false;
        }
        if ($("#datagried_detalle_min_max .tr_min_max").length > 0) {
        	$("#datagried_detalle_min_max .tr_min_max").each(function () {
        		if ($(this).attr("name") == ("tr_configuracion_" + bodega)) {
        			repetido = true;
        		}
        	});
        }

        if (repetido == true) {
            crear_alerta('info', 'Bodega Minimo-Maximo', 'Detalle ya fue agregado');
            return false;
        }
        // ************************ \\
        // variables para la tabla
        var id_bodega = '<input type="hidden" id="bodega_min_max' + bodega + '" name="bodega_min_max[]" value="' + bodega + '" />';
        var min_val   = '<input type="hidden" id="min_val' + bodega + '" name="min_val[]" value="' + minimo + '" />';
        var max_val   = '<input type="hidden" id="max_val' + bodega + '" name="max_val[]" value="' + maximo + '" />';
        var eliminar  = '<a id="del_doc" valor="' + bodega + '" thead="titlefinanza" tbody="contenedor_detalle_min_max" class="btn btn-borrar-min-max btn-danger btn-mini minia-icon-trashcan white"> Eliminar</a>';

        $("#contenedor_detalle_min_max").append(
        '<tr id="filatitlemaxmin' + bodega + '" name="tr_configuracion_'+bodega+'" class="tr_min_max">' +
        '<td style="text-align:center;">' + id_bodega + bodega_text + '</td>' +
        '<td style="text-align:center;">' + min_val + minimo + '</td>' +
        '<td style="text-align:center;">' + max_val + maximo + '</td>' +
        '<td style="text-align:center;">' + eliminar + '</td>' +
        '</tr>');

        // Resetear
        $("#txtbod_min_max option").removeAttr("selected");
        $("#txtbod_min_max").select2();

        $("#minimo").val('');
        $("#maximo").val('');

    });

    $('.btn-borrar-min-max').live('click', function (event) {
        event.preventDefault();
        $(this).parent().parent().remove();        
        // var oTable = $('#datagried_detalle_min_max').dataTable();
        // oTable.fnDeleteRow(parent[0]);
    });

    //////////////////////////////////////////////////
    //Subir archivo 
    /////////////////////////////////////////////////
    //Anexo por documento
       //Carpeta de Anexos
       var anx = contador_anexos;
       var folder_anx_temp= 'anx_galeria_articulo';
       var ruta_anx = urlj+'inicio/guardar_gral/'+folder_anx_temp; 
       //console.log(ruta_anx);

       new FUload('btnAnexo', ruta_anx, {
           start: function (file) {
               wait.start();
           },
           sucess: function (data) {
               wait.close();

               if ($.trim(data) !== "") {

                   var a_exten = $.trim(data).split('.');

                   var exten = "." + a_exten[(a_exten.length - 1)];
                   // verifica existencia del mismo documento en la carpeta.
                   var preview = "<tr id='preview" + anx + "' style='display:none;' class='preview_documento'>";
                   if (a_exten[(a_exten.length - 1)] === 'png' || a_exten[(a_exten.length - 1)] === 'jpg' || a_exten[(a_exten.length - 1)] === 'jpeg' || a_exten[(a_exten.length - 1)] === 'pdf') {
                       preview += "<td><a  title=\"Ver Anexo\" class='ver_en_modal fancybox-buttons' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                   } else {
                       preview += "<td><a target='_blank' title=\"Ver Anexo\" class='' data-fancybox-group='button' href='" + urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data) + "'>";
                   }

                   preview += "<img id='pre" + anx + "' src='' width='88' height='88' class='imagen_documento'></a></td>";
                   preview += "<td><input maxlength='75' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc[]' required value='" + $.trim(data).replace(exten, '') + "'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc" + anx + "'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                   preview += "<td><input maxlength='75' style=\"width:50%;\" class='rgb' type='text' name='rgb[]' value=''><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='rgb_imagen" + anx + "'></span><br><small style='text-align:left;'>RGB</small></td>";
                   //preview+="<td><input maxlength='50' readonly='readonly' style=\"width:50%;\" class='titulo_documento' type='text' name='titulo_doc"+i+"' value='"+$.trim(data).replace(exten,'')+"'><span style='display:none;font-size:11px;color:red;margin-top:-10%' class='texto' id='titulo_doc"+i+"'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                   preview += "<td style='vertical-align:middle !important; width:30px !important;'><img  style='display:none;' src='" + urlj + "media/editar_documento.png" + "' title='Editar' value='titulo_doc" + anx + "' class='editar_documento'/></td>";                                      
                   preview += "<td style='background:#E1E7F0!important; text-align:center'><a href=\"javascript: void(0);\" title=\"Eliminar Anexo\" class='eliminar_imagen' id='delete" + anx + "' custom='' custom_id=''><img class='quitar_documento' src='" + urlj + "media/eliminar_documento.png" + "' title='Eliminar documento'></a></div>";
                   preview += "<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></td></tr>";
                   
                   $("#previews_galeria").append(preview).show(300);
                   $("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></div>");

                   $("#preview" + anx).fadeIn(400);

                   //document.getElementById('pre'+i).src=base+"media/imagenes/sistema/pdf.png";
                   document.getElementById('pre' + anx).src = urlj + "public/temp/" + folder_anx_temp + "/" + $.trim(data);
                   document.getElementById('ruta' + anx).value = $.trim(data);
                   document.getElementById('delete' + anx).custom = $.trim(data);
                   document.getElementById('delete' + anx).custom_id = i;
                   valor = document.getElementById('pre' + anx).src;

                   // $('input[name=titulo_doc'+i+']').focus();
                   // nombre_doc=$('input[name=titulo_doc'+i+']').val();

                   anx++;
                   $(".eliminar_imagen, .verAnexo").tooltip();
               } else { //el formato es incorrecto
                   crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
               }
           }
       });
       
       $(".eliminar_imagen").live("click", function (event) {
           event.preventDefault();

           url = this.custom;
           id_key = this.custom_id;
           id = this.id;
           ruta_archivo = "public____temp";
           folder_anx = folder_anx_temp;
           id_anexo = 0;
           if ($(this).data("idgia") > 0) {
            ruta_archivo = "uploads";
            folder_anx = "anx_galeria_articulo";
            id_anexo = $(this).data("idgia");
            console.log('idanexo :'+id_anexo);
            elminar_anexo_evento(id_anexo);
           };
           $.ajax({
               type: 'POST',
               url: urlj + 'inicio/eliminar_imagen_gral/' + folder_anx + "/" + ruta_archivo,
               data: {url: url},
               success: function (data) {
                   $("#ruta" + id_key).val("");
                   $("#" + id).parent().parent().remove().delay(300);
               }
           });
       });


       //usado en el editar
       $(".editar_nombre_anexo").live("blur", function (event) {
          id_anexo = $(this).data("idgia");
          nombre_anx = $(this).val().trim();
          if (id_anexo > 0 && nombre_anx !="") 
          {
            actualizar_nombre_anexo(id_anexo,nombre_anx);
          }
        });

       //usado en el editar 
       $(".editar_rgb_anexo").live("blur", function (event) {       	  
          id_anexo = $(this).data("idgia");
          nombre_anx = ($(this).val().trim() != '') ? $(this).val().trim(): ' ';          
          if (id_anexo > 0 /*&& nombre_anx !=""*/) 
          {
            
            actualizar_rgb_anexo(id_anexo,nombre_anx);
          }
        });

       
    //////////////////////////////////////////////////
    //Fin subir archivo 
    /////////////////////////////////////////////////

    $(".stock").live("keyup", function() {
    	calcular_stock();
    });



});//Fin document ready

function calcular_stock() {
	var consumo = $('#max_consumo').val();
	var dia_pla = $('#dias_stock').val();
	var dia_mes = $('#dias_mes').val();
	var stock = 0;
	if (consumo != "" && dia_pla != "") {
		stock = ((consumo * dia_pla) / dia_mes);
	}
	$('#stock_seguridad').val(parseFloat(stock));
}

//Inicio funciones para galeria de imagenes
function elminar_anexo_evento(id_anexo) {
    if (id_anexo > 0) 
    {      
      url_ajax = window.satelite.base_url('inventario/mantenimiento/eliminar_imagen_galeria');
       $.ajax({
           url: url_ajax,
           type: 'POST',
           dataType: 'json',
           data: {
               id_anexo: id_anexo
           },
           beforeSend: function () {
               wait.start();
           },
           error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            wait.close();
            if (json.exito == 1) {
              crear_alerta("success","Anexo elminado","");
            }
        }
    });
  }
}

function actualizar_nombre_anexo(id_anexo, nombre_anexo) {
    if (id_anexo > 0 && nombre_anexo !="") 
    {      
      url_ajax = window.satelite.base_url('inventario/mantenimiento/editar_nombre_anexo');
       $.ajax({
           url: url_ajax,
           type: 'POST',
           dataType: 'json',
           data: {
               nombre_anexo: nombre_anexo,
               id_anexo: id_anexo
           },
           beforeSend: function () {
               //wait.start();
           },
           error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            
        }
    });
  }
}

//Actualizar el codigo rgb
function actualizar_rgb_anexo(id_anexo, nombre_anexo) {
    if (id_anexo > 0 && nombre_anexo !="") 
    {      
      url_ajax = window.satelite.base_url('inventario/mantenimiento/editar_codigo_rgb_anexo');
       $.ajax({
           url: url_ajax,
           type: 'POST',
           dataType: 'json',
           data: {
               nombre_anexo: nombre_anexo,
               id_anexo: id_anexo
           },
           beforeSend: function () {
               //wait.start();
           },
           error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            
        }
    });
  }
}

function confirmar_evento(id_invitacion) {
    if (id_invitacion > 0) 
    {      
      url_ajax = window.satelite.base_url('modulo_eventos/procesos/confirmar_evento');
       $.ajax({
           url: url_ajax,
           type: 'POST',
           dataType: 'json',
           data: {
               id_invitacion: id_invitacion
           },
           beforeSend: function () {
               wait.start();
           },
           error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            wait.close();
            if (json.exito == 1) {
              parent.crear_alerta("success","Evento confirmado","");
              parent.$.fancybox.close();
            }
        }
    });
  }
}

function val_codigo(){
	codigo=$("#codigo").val();
	this_id = ($("#articulo_id").length > 0) ? $("#articulo_id").val() : 0;
	var code_limpio = codigo.replace(/[\%\^\&\@\"\#\$\'\!]/g, '').replace(/\s+/g, '');
	if($.trim(codigo)!="") { 
		$.ajax({
			url: urlj+'inventario/mantenimiento/verificar_codigo',
			type: 'POST',
			dataType: 'json',
			data: {
				codigo: codigo, 
				id_edit: this_id
			},
			success: function(data){
				if(data.drop > 0) {
					$.pnotify({
						type: 'info',
						title: 'Aviso',
						text: 'El código ingresado ya existe.',
						icon: 'ui-icon ui-icon-info',
						opacity: 0.95,
						history: false,
						sticker: false
					});
					$("#codigo").val('');
				} else {
					$("#codigo").val(code_limpio);
				}
			}
		});
	}
}

//Fin funciones para galeria de imagenes