var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;
$(document).ready(function(){
  
  $('select option[value="0"]').text('');
  $('select option[value="0"]').val('');
  $('select').select2({placeholder: 'Seleccione'});

  $("input[name^='fecha']").datepicker({
    dateFormat: 'dd-mm-yy',
    changeMonth: true, 
    changeYear: true,
    showButtonPanel: true,
    changeMonth: true,
    changeYear: true,
    dateFormat: 'dd-mm-yy',
    monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
    dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
    nextText: "Siguiente",
    prevText: "Anterior"});
  $("input[name^='fecha']").mask("99-99-9999");
  $("input[name^='fecha']").attr('placeholder',"dd-mm-yyyy");
  

  $("#filtro").click(function(){
    event.preventDefault();
    // Datos a enviar para POST
    var fecha_ini = $("#fecha_inicio").val();
    var fecha_fin = $("#fecha_fin").val();
    var hora_ini  = $("#txtHoraIni").val();
    var hora_fin  = $("#txtHoraFin").val();
    var sucursal  = $("#slc_sucursal").val();
    var caja      = $("#slc_cajas").val();
    var tipo = $("#slc_tipo").val();

    if (fecha_ini == "" || fecha_fin == "" || hora_ini == "" || hora_fin =="") {
        crear_alerta('error','Período','Campos de períodos son requeridos.');        
        return false;
    }
    
    if(fecha_ini!='' && fecha_fin!=''){
        if(!verifica_fecha(fecha_ini,fecha_fin)){
            crear_alerta('error','Período','Verificar período de fechas.');       
            return false; 
        }
    }

    wait.start();
    $.ajax({
        url: urlj+'facturacion/reportes/ventas_hora',
        type: 'POST',
        data: {tipo: tipo, fecha_ini: fecha_ini, fecha_fin: fecha_fin, hora_ini: hora_ini, hora_fin: hora_fin, sucursal: sucursal, caja: caja},
        success:function(data) {
            wait.close();
            $("#carga_datos").html(data);
            $("#descargar").show();
            $(".form-actions").show('slow');
            $(".botones_export_print").show('slow');
        }
    });

  });

 $("#fecha_inicio").focus(function(event){
      $("#fecha_inicio").removeClass('error');
      $("#fecha_inicio_error").text('');
  });

 $("#fecha_fin").focus(function(event){
      $("#fecha_fin").removeClass('error');
      $("#fecha_fin_error").text('');
  });

 $("#caja").change(function(event){
      $("#caja").removeClass('error');
      $("#cliente_error").text('');
  });

  function verifica_fecha(fecha_ini, fecha_fin){
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          crear_alerta('error','Error','Verifique las fechas del período');
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin_error").text('');
          return true;
        }
    }

    // Procesar horas
    $('.hora').timeEntry({
      show24Hours: false,
      ampmPrefix: ' ',
      spinnerImage: urlj+'media/images/spinner.png',
      spinnerSize: [40, 40, 0],
      spinnerBigSize: [70, 50, 0],
      spinnerIncDecOnly: true,
      spinnerTexts: ['', '', '', 'Incrementar', 'Disminuir']
         
    });
    $('.hora').css({'margin-bottom':'25px', 'width':'85px', 'height':'28px'});
    $(".hora").attr('placeholder','00:00 AM');
});