$(document).ready(function () {
    $("select").select2();

    $("#chk_incluir").iButton({
        'labelOn':  '  Solo con existencias  ',
        'labelOff': '  Con / Sin existencia  ',
        change: function (element) {
            if (element.is(':checked')) {
                $("#incluir_agotados").val(1);
            } else {
                $("#incluir_agotados").val(0);
            }
        }
    });

    $("#slcBodega").change(function() {
        var bod = $(this).val();
        if (bod > 0) {
            $.ajax({
                url: urlj + 'inventario/gestion_productos/get_sector_bodega',
                type: 'POST',
                dataType: 'json',
                data: {
                    bodega: bod
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#sector_sxb").html(data.resp);
                    $("#sector_sxb").select2();
                    wait.close();
                }
            });
        } else {
            $("#sector_sxb").html('<option value=""></option>');
            $("#sector_sxb").select2();
        }
    });

    $("#slcProductos").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'facturacion/facturar/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    anticipo: 2
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    var marca = ($.trim(item.mrp_nombre) != "") ? " ( " + item.mrp_nombre +" )" : "";
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre + marca
                    });
                });
                return {
                    results: myResults
                };

            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });
    
    $("#btnConsultar").click(function () {
        var bodega = ($("#slcBodega").val() > 0) ? $("#slcBodega").val() : "";
        var categoria = ($("#slcCateg").val() > 0) ? $("#slcCateg").val() : "";
        var producto = ($("#slcProductos").val() > 0) ? $("#slcProductos").val() : "";
        var sector = ($("#sector_sxb").val() > 0) ? $("#sector_sxb").val() : "";
        var agotados = $("#incluir_agotados").val();
        if (bodega != "" || categoria != "" || producto != "") {
            $.ajax({
                type: 'post',
                url:urlj + 'facturacion/facturar/get_ubicacion_producto',
                data: {
                    bod_id: bodega,
                    cat_id: categoria,
                    art_id: producto,
                    sxb_id: sector,
                    a_cero: agotados
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    var oTable = $('#tblListado').dataTable();
                    oTable.fnDestroy();
                    $("#tbContenedorListado").html(result);
                    aplicarDataTable('#tblListado');
                    wait.close();
                }
            });
        } else {
            crear_alerta('error','', 'Por favor, utilice al menos un filtro');
            return false;
        }
    });

});

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": true,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "aoColumns": [
            null,
            null,
            null,
            null,
            null,
            { "sType": "numeric" },
            null
        ],
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}