jQuery(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $('select option[value=0]').val('');
    $('select').select2();

    $(".datePicker").datepicker({
        dateFormat: 'dd-mm-yy',
        changeMonth: true, 
        changeYear: true,
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior"});
    $(".datePicker").mask("99-99-9999");
    $(".datePicker").attr('placeholder',"dd-mm-yyyy");

    $("#ver_detalle").click(function (event){
        var inicio = $("#txtFechaIni").val();
        var fin = $("#txtFechaFin").val();
        var estado = $("#slcEstado").val();
        
        if(inicio != '' && fin != ''){  
            if( (inicio != '' && fin != '') || estado>0 ){
                consultarAjax(inicio, fin, estado);
            }else{
                crear_alerta('error','Error', 'Debe seleccionar la información a filtrar');
            }
        }else{
            crear_alerta('error', 'Campos requeridos', 'Los campos con asterisco (*) en rojo son requeridos.')
        }
    }); // Fin if consultar_datos

   
    $("#excel_en").click(function(event){
        event.preventDefault();
        tipo=$(this).attr('value');
        $("#tipo_reporte").val(tipo)
        $("#excel").trigger('click');
    });

    $("#exportar").val(0);

    $(".exportar").click(function(event){
        event.preventDefault();
        if($("#exportar").val()==1){
        console.log($(this).val());
            $("#frm-report").submit();
        }else{
            crear_alerta('error','Información', 'Debe filtrar la información a buscar');
        }
    });

}); // End jQuery

function consultarAjax(inicio=null, fin=null, estado=null) {
    wait.start();
    
    $("#contenedor_consulta").hide("slide", {
        direction: 'right'
    }, 400, function () { // Después de ocultar div enviar el ajax

        if(inicio!='' && fin!=''){
            if(!verifica_fecha(inicio,fin)){  
            wait.close();    
                return false; 
            }
        }

        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'facturacion/reportes/ordenes_venta',
            data: {inicio: inicio, fin: fin, estado: estado},
            success: function (data) {
                $("#contenedor_consulta").html(data.resultado);
                wait.close();
                $("#ver_detalle").removeAttr('disabled');
                $("#exportar").val(1);
                $("#filtro_inicio").val(data.inicio);
                $("#filtro_fin").val(data.fin);
                $("#filtro_estado").val(data.estado);
                $("#contenedor_consulta").show("slide", {
                    direction: 'left'
                }, 500);
            },
            error: function (xhr, status, error) {
                wait.close();
                console.log(xhr);
                console.log(status);
                console.log(error);
                crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
            }
        });
    });
}

function verifica_fecha(fecha_ini, fecha_fin){
        //Se convierte la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
          crear_alerta('error','Error','Verifique las fechas del período');
          return false;
        }

        if(Date.parse(fecha_i) < Date.parse(fecha_f)){
          $("#fecha_fin_error").text('');
          return true;
        }
}