jQuery(document).ready(function () {
   
    $('#categoria_tia, #slcLista').select2();

    $("#producto_art").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                    tipo: 0
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#dtg_cliente").select2({
        placeholder:'Seleccione',
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo + " - " + item.nombre,
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#dtg_cliente").change(function() {
        let valor = $(this).val();
        let otros = $("#slcLista").val();
        if (valor > 0) {
            $("#lista_req").html("");
        } else {
            $("#lista_req").html("*");
            if (otros == null) {
                $("#client_req").html("*");
            }
        }
    });

    $("#slcLista").change(function() {
        let valor = $(this).val();
        let otros = $("#dtg_cliente").val();
        if (valor == null) {
            $("#client_req").html("*");
            if (!(otros > 0)) {
                $("#lista_req").html("*");
            }
        } else {
            $("#client_req").html("");
        }
    });
    /*======================================================================================================================================
     =                                          FILTRA LAS CARACTERISTICA PADRE/HIJO
     ========================================================================================================================================
     */
    $("#categoria_tia").live('change', function () {
        menor = Number($(this).attr('nid')) + 2;
        $(".dinamic").each(function (index, el) {
            if ($(el).attr('nid') > menor) {
                $(el).parent('div').siblings('label').remove();
                $(el).siblings('select').remove();
                $(el).parent('div').parent('div').parent('div').parent('div').remove();
                $(el).remove();
            }
        });
        categoria_tia = $("select[id='categoria_tia']").last().val();
        $("#id_tia").val(categoria_tia);
        $(".plus:last").remove();
        $(this).next().append('<button class="btn plus">+</button>');
         if (categoria_tia > 0) {
            $("#producto_art + .select2-container ").hide();
            $("#producto_art").select2('data', null);
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'inventario/gestion_productos/obtener_productos_tia',
                data: {categoria: categoria_tia, tipo: 1, bodega: 0},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    producto = data.producto;
                    $("#dtg_producto").html(producto);
                    $("#dtg_producto").show();
                    $("#dtg_producto").select2('destroy').select2();
                    $('.dinamic').each(function (index, el) {
                        $(this).attr('nid', index);
                    });
                }
            });
        }else {
            wait.start();
            $("#producto_art + .select2-container").show();
            $("#dtg_producto").select2('destroy');
            $("#dtg_producto").hide();
            $("#dtg_producto option:selected").removeAttr('selected');
            wait.close();
        }
    });

    $(".plus").live('click', function (event) {
        event.preventDefault();
        categoria_tia = $("select[id='categoria_tia']").last().val();
        
        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'inventario/gestion_productos/obtener_productos_tia',
            data: {categoria: categoria_tia},
            success: function (data) {
                categoria = data.categoria;
                producto = data.producto;
                n_cat = data.cat_hijo;

                $i = 0;
                $(".plus").last().remove();
                if (n_cat == 1) {
                    numero = $('#div-categorias select').last().length + 1;

                    linea = $("#div-categorias").append(''
                            + '<div class="row-fluid">'
                            + '<label class="form-label span3">Categoria:</label>'
                            + '<div class="span7 controls">'
                            + '<select id="categoria_tia" class="nostyle seleccion dinamic" name="filtro" style="width:100%" placeholder="Seleccione"></select>'
                            + '</div></div>');
                    linea2 = $('select[id="categoria_tia"]').last().html();
                    nueva = linea2.replace(/#/g, numero);
                    $('#div-categorias').append(nueva);
                    $('select[id="categoria_tia"]').last().html(categoria);
                    $('select[id="categoria_tia"]').last().select2();
                    $("#dtg_producto").html(producto);
                } else {
                    //$("#producto_art").html(producto);
                    $.pnotify({
                        type: 'info',
                        title: 'Aviso',
                        text: 'No se encontraron mas dependencias.',
                        icon: 'ui-icon ui-icon-info',
                        opacity: 0.95,
                        history: false,
                        sticker: false
                    });
                }

                $('.dinamic').each(function (index, el) {
                    $(this).attr('nid', index);
                });
            }
        });
    });

    $("#dtg_producto, #producto_art").change(function(event) {
        producto = $(this).val();
        $("#id_art").val(producto);
    });


    $("#ver_detalle").click(function (event){
        var lista = $("#slcLista").val();
        var producto = $("#id_art").val();
        var categoria = $("#id_tia").val();
        var cliente = $("#dtg_cliente").val();
        var ready = false;
        if (lista != null) {
            ready = true;
        } else {
            if (cliente > 0) {
                ready = true;
            }
        }
        if(ready){
            consultarAjax(categoria, producto, lista, cliente);
        }else{
            crear_alerta('error','Error', 'Debe seleccionar la información a filtrar');
        }
    });
   
    $("#excel_en").click(function(event){
        event.preventDefault();
        tipo=$(this).attr('value');
        $("#tipo_reporte").val(tipo)
        $("#excel").trigger('click');
    });

    $("#exportar").val(0);
    $(".exportar").click(function(event){
        event.preventDefault();
        if($("#exportar").val()==1){
            $("#frm-report").submit();
        }else{
            crear_alerta('error','Información', 'Debe seleccionar la información a filtrar');
        }
    });

}); // End jQuery

function consultarAjax(categoria = null, producto = null, lista = null, cliente = null) {
    wait.start();
    $("#botones").hide();
    $("#contenedor_consulta").hide("slide", {
        direction: 'right'
    }, 400, function () {
        // Después de ocultar div enviar el ajax
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: urlj+'facturacion/reportes/rpt_listas_precios',
            data: {
                categoria: categoria,
                producto: producto,
                cliente: cliente,
                lista: lista
            },
            success: function (data) {                
                $("#contenedor_consulta").html(data.resultado);
                wait.close();
                $("#ver_detalle").removeAttr('disabled');
                $("#exportar").val(1);
                $("#filtro_categoria").val(data.categoria);
                $("#filtro_producto").val(data.producto);
                $("#filtro_lista").val(data.lista);
                $("#filtro_cliente").val(data.cliente);
                if (data.numfila > 0) {
                    $("#botones").show();
                }
                $("#contenedor_consulta").show("slide", {
                    direction: 'left'
                }, 500);
            },
            error: function (xhr, status, error) {
                wait.close();
                console.log(xhr);
                console.log(status);
                console.log(error);
                crear_alerta('error', 'Error', 'Hubo un problema al realizar la operación');
            }
        });
    });
}
