$(document).ready(function () {

    $('select').select2();

    $(".datePicker").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'dd-mm-yy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#btn_consultar").click(function () {
        $("#exportar").hide();
        var fecha_inicio = $("#txt_fecha_ini").val();
        var fecha_finale = $("#txt_fecha_fin").val();
        var slc_vendedor = $("#slc_vendedor").val();
        if (fecha_inicio != "" && fecha_finale != "") {
            if (!verifica_fecha(fecha_inicio, fecha_finale)) {
                return false;
            }
            $.ajax({
                type: "post",
                dataType: 'json',
                url: window.gSateliteWhite.baseUrl('facturacion/reportes/ventas_vendedor/1'),
                data: {
                    fecha_ini: fecha_inicio,
                    fecha_fin: fecha_finale,
                    vendedor: slc_vendedor,
                    tipo_reporte: ""    
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    $("#dv_contenedor").html(result.html);
                    if (result.filas > 0) {
                        $("#fecha_ini").val(fecha_inicio);
                        $("#fecha_fin").val(fecha_finale);
                        $("#vendedor").val(slc_vendedor);
                        $("#exportar").show();
                    }
                    wait.close();
                }
            });
        } else {
            crear_alerta('error', 'Atención', 'Fechas son requeridas');
            return false;
        }

    });

    
    $("body").on("change", ".datePicker", function(e) {
        if ($("#txt_fecha_ini").val() != "" && $("#txt_fecha_fin").val()) {
            verifica_fecha($("#txt_fecha_ini").val(), $("#txt_fecha_fin").val());
        }
    });

    
});

function verifica_fecha(fecha_ini, fecha_fin){
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
        crear_alerta('error', 'Atención', 'Verifique las fechas del período');
        return false;
    } else {
        return true;
    }
}