$(document).ready(function () {

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $('select').select2();


    $("#btn_consultar").click(function () {
        event.preventDefault();
    
        var txtFechaIni     = $("#txtFechaIni").val();
        var txtFechaFin     = $("#txtFechaFin").val();
        var slc_categoria   = ($("#slc_categoria").val() != "")?$("#slc_categoria").val():'';

        if ( txtFechaIni == "" || txtFechaFin == "") {
            crear_alerta('error', 'Reporte de venta por categoría', 'Por favor ingrese el rango de fechas.');
            $("#txtFechaIni").val("");
            return false;
        } 

        if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
            crear_alerta('error', 'Reporte de venta por categoría', 'Verifique el período de fechas.');
            return false;
        }

        $.ajax({
            url: window.gSateliteWhite.baseUrl('facturacion/reportes/ventas_categorias'),
            data: {
                txtFechaIni: txtFechaIni,
                txtFechaFin: txtFechaFin,
                slc_categoria: slc_categoria,
                tipo_reporte: ""    
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor").html(obj.html);
                $("#dv_contenedor").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });
    });

    $("#frm_reporte").validate({
        rules: {

        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txtFechaIni     = $("#txtFechaIni").val();
            var txtFechaFin     = $("#txtFechaFin").val();
    
            if ( txtFechaIni == "" || txtFechaFin == "") {
                crear_alerta('error', 'Reporte de venta por categoría', 'Por favor ingrese el rango de fechas.');
                $("#txtFechaIni").val("");
                return false;
            } 
    
            if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
                crear_alerta('error', 'Reporte de venta por categoría', 'Verifique el período de fechas.');
                return false;
            }
    
            form.submit();
        }
    });


});