$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $(".datePicker").datepicker({
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
        maxDate: 0,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});
    
	$(".datePicker").mask("99-99-9999");
    $("#reporte_botones").hide();

    /*Busqueda*/
    $("#btnConsultar").click(function(){
        event.preventDefault();
        var fecha_inicio = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var tipo = $("#tipo_filtro").val();
        if (tipo != "" && fecha_inicio != "" && fecha_fin != "") {
            $.ajax({
                url: window.gSateliteWhite.baseUrl('facturacion/reportes/transmision_documentos'),
                type: "post",
                dataType: 'json',
                data: {
                    fecha_inicio: fecha_inicio,
                    fecha_fin: fecha_fin,
                    tipo_filtro: tipo,
                    tipo_reporte: "" 
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (obj) {
                    $("#dv_contenedor").html(obj.html);
                    $("#dv_contenedor").show("slide", {
                        direction: 'left'
                    }, 500);
                    $("#reporte_botones").show();
                    wait.close();
                }
            });
        } else {
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
    });

    $("#imprimir_factura").live("click", function(){
        $("#frm_reporte_transmision_documentos").attr('action','imprimir_transmision_documentos/')
        var tipo = 'excel';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();  
        if(!$("#frm_reporte_transmision_documentos").valid()){
          crear_alerta('error','Alerta','Campos con * son requeridos.');
          return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }  
        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_transmision_documentos").submit();  
    });

    $("#imprimir_factura_pdf").live("click", function(){
        $("#frm_reporte_transmision_documentos").attr('action','imprimir_transmision_documentos/')
        var tipo = 'pdf';
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();  
        if(!$("#frm_reporte_transmision_documentos").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
        if(fecha_ini !='' && fecha_fin != ''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
                crear_alerta('error','Alerta','Verifique el período de fechas.');
                return false;
            }
        }        
        $("#tipo_reporte").val(tipo);
        $("#frm_reporte_transmision_documentos").submit();
    });

    $("#frm_reporte_transmision_documentos").validate({
        rules: {
            tipo_filtro:{ required:true},
            txtFechaIni:{ required:true},
            txtFechaFin:{ required:true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            form.submit();
        }
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    }

    if (Date.parse(fecha_i) <= Date.parse(fecha_f)) {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;
    }
}