$(document).ready(function () {
    $("select").select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        maxDate: 0,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");

    $("#btnConsultar").click(function(){
        $("#exportbtn").hide();
        var tipo      = $("#tipo_flt").val();
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        if (tipo != "" && fecha_ini != "" && fecha_fin != "") {
            $.ajax({
                url: urlj + "facturacion/reportes/totales_facturacion/1",
                type: "POST",
                dataType: 'json',
                data: {
                    fecha_inicio: fecha_ini,
                    fecha_final: fecha_fin,
                    tipo_filtro: tipo,
                    tipo_reporte: "" 
                },
                beforeSend: function () {
                    wait.start();
                },
                success: function (obj) {
                    $("#dv_contenedor").html(obj.html);
                    aplicarDataTable("tbl_documentos");
                    if (obj.filas > 0) {
                        $("#fecha_inicio").val(fecha_ini);
                        $("#fecha_final").val(fecha_fin);
                        $("#tipo_filtro").val(tipo);
                        $("#exportbtn").show();
                    }
                    wait.close();
                }
            });
        } else {
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }
    });    

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        $("#txtFechaFin").addClass('error');
        $("#txtFechaFin_error").text("Verifique las fechas del período");
        return false;
    } else {
        $("#txtFechaFin").removeClass('error');
        $("#txtFechaFin_error").text('');
        return true;        
    }
}