$(document).ready(function () {

    $('select').select2();

    $(".calendario").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".calendario").mask("99-99-9999");
    
    $("#txt_fecha_inicio").on('change', function(){
        var txt_fecha_inicio    = $("#txt_fecha_inicio").val();

        if ( txt_fecha_inicio != ""){
            $("#txt_fecha_inicio_error").html("");
            error   = true;
        }
    });

   $("#txt_fecha_fin").on('change', function(){
    var txt_fecha_fin    = $("#txt_fecha_fin").val();

    if ( txt_fecha_fin != ""){
        $("#txt_fecha_fin_error").html("");
        error   = true;
    }
});
   
   $("#slc_cliente").on('change', function(){
       select = $("#slc_factura").html();
        if($(this).val()>0){
            $("#slc_factura").attr('placeholder', 'Cargando...').trigger('change');
            $('#slc_factura').val(null).trigger('change');
            $('#slc_factura').select2('disable');
            setTimeout(function() {
                $('#slc_factura').select2('enable');
                $("#slc_factura").attr('placeholder', 'Buscar Factura').trigger('change');
                $("#slc_factura").html(select);
              }, 1000);
        }else{
            $('#slc_factura').val(null).trigger('change');
            $('#slc_factura').select2('disable');
        }
    });
    

    $("#slc_factura").select2({
        placeholder: "Buscar Factura",
        ajax: {
            url: urlj + 'facturacion/reportes/facturas_enttregas_inventario',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (factura) {
                var cliente = $('#slc_cliente').val();
                if (!(cliente != '')) {
                    $('#slc_factura').select2('close');
                    crear_alerta('error','Atención','Primero debe seleccionar el cliente');
                    return false;
                }
                return {
                    factura: factura,
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                console.log(data);
                $.each(data, function (index, item) {
                    var formattedDate = new Date(item.fac_fecha_fact);
                    var d = formattedDate.getDate();
                    var m =  formattedDate.getMonth();
                    m += 1;  
                    var y = formattedDate.getFullYear();
                    var fecha = d + "-" + m + "-" + y;
                    myResults.push({
                        'id': item.fac_id,
                        'text': item.tif_nombre + ' - Doc #' + item.fac_numero + ' - Fecha Doc : ' + fecha
                    });
                });
                return {
                    results: myResults
                };

            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $("#btn_consultar").click(function () {
        event.preventDefault();
        var slc_cliente         = $("#slc_cliente").val();
        var slc_factura         = $("#slc_factura").val();
        var txt_fecha_inicio    = $("#txt_fecha_inicio").val();
        var txt_fecha_fin       = $("#txt_fecha_fin").val();
        var error_text          = "<b style='color:red;'>Campo requerido *</b>";
        var text_clientes       = $("#text_clientes").val();
        var error               = false;
        var fecha_inicio = txt_fecha_inicio;
        var fecha_fin = txt_fecha_fin;
        if (fecha_mayor(fecha_inicio, fecha_fin) == false) {
            crear_alerta('error', 'Aviso', 'El campo "Desde" no puede ser mayor al campo "Hasta"');
            return false;
        }
        if ( txt_fecha_inicio == "" ){
            $("#txt_fecha_inicio_error").html(error_text);
            error   = true;
        }
        if ( txt_fecha_fin == "" ){
            $("#txt_fecha_fin_error").html(error_text);
            error   = true;
        }
        
        if ( error == true ) {
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
            return false;
        }

        if (!validarPeriodo(fecha_inicio, fecha_fin)) {
            crear_alerta('info', 'Aviso', 'Verifique el período seleccionado.');
            return false;
        }
        var meses = verificar_diferencia_meses(fecha_inicio, fecha_fin);
        // if (meses > 11 ){
        //     crear_alerta('info', 'Aviso', 'Deben de ser menos de 12 meses de diferencia.');
        //     return false;
        // }
        $("#txt_meses_diferencia").val(meses);
        var txt_meses_diferencia = $("#txt_meses_diferencia").val();
        $.ajax({
            url: window.gSateliteWhite.baseUrl('facturacion/reportes/reportes_facturas_entregas_inventarios'),
            data: {
                slc_cliente: slc_cliente,
                slc_factura: slc_factura,
                txt_fecha_inicio: txt_fecha_inicio,
                txt_fecha_fin: txt_fecha_fin,
                txt_meses_diferencia: txt_meses_diferencia,
                text_clientes: text_clientes
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#datagried").dataTable().fnDestroy();
                $("#dv_contenedor_reportes").html("");
                $("#dv_contenedor_reportes").html(obj.drop);
                
                $("#cliente").val(slc_cliente);
                $("#factura").val(slc_factura);
                $("#fecha_desde").val(txt_fecha_inicio);
                $("#fecha_fin").val(txt_fecha_fin);
                
                aplidarDataTable('datagried');
                $("#table").show("slide", {
                    direction: 'left'
                }, 500);
                
                $("#tipo_reporte_pdf").show('slow');
                $("#tipo_reporte_excel").show('slow');

                wait.close();
            }
        });
    });

    function verificar_diferencia_meses(fecha_inico,fecha_fin){
        var meses = 0; 
        var fecha_inicio_array  = fecha_inico.split("-");
        var fecha_fin_array     = fecha_fin.split("-");
        var mes_inicio          = fecha_inicio_array[1];
        var mes_fin             = fecha_fin_array[1];
        var year_inicio         = fecha_inicio_array[2];
        var year_fin            = fecha_fin_array[2];
        meses = (parseInt(mes_fin) - parseInt(mes_inicio))  + (( parseInt(year_fin) - parseInt(year_inicio)) * 12 );
        return meses;
    }

    function fecha_mayor(fecha_inicio, fecha_fin) {
        var fecha_inicio = fecha_inicio.split('-').reverse().join(', ');
        var fecha_fin = fecha_fin.split('-').reverse().join(', ');

        var f1 = new Date(fecha_inicio); 
        var f2 = new Date(fecha_fin);

        if(f1 > f2){
            return false;
        }else{
            return true;
        }
    }


    function aplidarDataTable() {
        $('#datagried').dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 20,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }    
    aplidarDataTable('datagried');

});