$(document).ready(function () {

    $(".calendario").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'mm-yy',
        onClose: function(dateText, inst) { 
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });
    // Ocultar el calendario para solo mostrar el mes
    $(".calendario").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });

    // $(".txtFechas").datepicker({
    //     showButtonPanel: true,
    //     changeMonth: true,
    //     changeYear: true,
    //     dateFormat: 'dd-mm-yy',
    //     monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
    //     dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
    //     nextText: "Siguiente",
    //     prevText: "Anterior",
    //     closeText: 'Cerrar',
    //     currentText: 'Hoy'
    // });

    $("#slc_cliente").select2({
        placeholder:'Buscar clientes',
        minimumInputLength: 3,
        multiple:true,
        ajax: {
            url:urlj+'facturacion/reportes/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente,
                    evaluar_plan:0
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo+" - "+item.nombre,
                    });
                });
                return {
                    results: myResults
                };
		    } 
        }
    });  

    $("#btn_consultar").click(function () {
        event.preventDefault();
        var slc_cliente         = $("#slc_cliente").val();
        var txt_fecha_inicio    = $("#txt_fecha_inicio").val();
        var txt_fecha_fin       = $("#txt_fecha_fin").val();
        var error_text          = "Campo requerido";
        var text_clientes       = $("#text_clientes").val();
        var error               = false;
        var fecha_inicio = '01-'+txt_fecha_inicio;
        var fecha_fin = '01-'+txt_fecha_fin;
        if ( txt_fecha_inicio == "" ){
            $("#txt_fecha_inicio_error").html(error_text);
            error   = true;
        }
        if ( txt_fecha_fin == "" ){
            $("#txt_fecha_fin_error").html(error_text);
            error   = true;
        }
        if (!validarPeriodo(fecha_inicio, fecha_fin)) {
            crear_alerta('info', 'Aviso', 'Verifique el período seleccionado.');
            return false;
        }
        var meses = verificar_diferencia_meses(fecha_inicio, fecha_fin);
        if (meses > 11 ){
            crear_alerta('info', 'Aviso', 'Deben de ser menos de 12 meses de diferencia.');
            return false;
        }
        if ( error == true ) {
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
            return false;
        }
        $("#txt_meses_diferencia").val(meses);
        var txt_meses_diferencia = $("#txt_meses_diferencia").val();
        $.ajax({
            url: window.gSateliteWhite.baseUrl('facturacion/reportes/comparativo_clientes'),
            data: {
                slc_cliente: slc_cliente,
                txt_fecha_inicio: txt_fecha_inicio,
                txt_fecha_fin: txt_fecha_fin,
                txt_meses_diferencia: txt_meses_diferencia,
                text_clientes: text_clientes
            },
            type: "post",
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                var obj = jQuery.parseJSON(result);
                $("#dv_contenedor_reportes").html(obj.html);
                $("#dv_contenedor_reportes").show("slide", {
                    direction: 'left'
                }, 500);
                wait.close();
            }
        });
    });

    $("#frm_reporte").validate({
        ignore: [],
        rules: {
            //slc_cliente: {required: true},
            txt_fecha_inicio: {required: true},
            txt_fecha_fin: {required: true},
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var txt_fecha_inicio = $("#txt_fecha_inicio").val();
            var txt_fecha_fin    = $("#txt_fecha_fin").val();
            var fecha_inicio     = '01-'+txt_fecha_inicio;
            var fecha_fin        = '01-'+txt_fecha_fin;
            var error            = false;
            if (!validarPeriodo(fecha_inicio, fecha_fin)) {
                crear_alerta('info', 'Aviso', 'Verifique el período seleccionado.');
                return false;
            }    
            var meses = verificar_diferencia_meses(fecha_inicio, fecha_fin);    
            if ( meses > 11 ){
                crear_alerta('info', 'Aviso', 'Deben de ser menos de 12 meses de diferencia.');
                return false;
            }    
            if ( error == true ) {
                crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
                return false;
            }
            $("#txt_meses_diferencia").val(meses);
            form.submit();
        }
    });

    function verificar_diferencia_meses(fecha_inico,fecha_fin){
        var meses = 0; 
        var fecha_inicio_array  = fecha_inico.split("-");
        var fecha_fin_array     = fecha_fin.split("-");
        var mes_inicio          = fecha_inicio_array[1];
        var mes_fin             = fecha_fin_array[1];
        var year_inicio         = fecha_inicio_array[2];
        var year_fin            = fecha_fin_array[2];
        meses = (parseInt(mes_fin) - parseInt(mes_inicio))  + (( parseInt(year_fin) - parseInt(year_inicio)) * 12 );
        return meses;
    }

    $("#slc_cliente").on('change',function() {         
        var array_clientes_comas = "";
        $("#slc_cliente").next().children().children().each(function() {
            array_clientes_comas = array_clientes_comas + $(this).children().first().text() + ",";
        });
        var array_clientes = array_clientes_comas.substr(0, array_clientes_comas.length-1) ;
        $("#text_clientes").val(array_clientes);
    });

});